/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@SystemApi
public class OemNetworkPreferences
implements Parcelable {
    public static final int OEM_NETWORK_PREFERENCE_TEST_ONLY = -2;
    public static final int OEM_NETWORK_PREFERENCE_TEST = -1;
    public static final int OEM_NETWORK_PREFERENCE_UNINITIALIZED = 0;
    public static final int OEM_NETWORK_PREFERENCE_OEM_PAID = 1;
    public static final int OEM_NETWORK_PREFERENCE_OEM_PAID_NO_FALLBACK = 2;
    public static final int OEM_NETWORK_PREFERENCE_OEM_PAID_ONLY = 3;
    public static final int OEM_NETWORK_PREFERENCE_OEM_PRIVATE_ONLY = 4;
    public static final int OEM_NETWORK_PREFERENCE_MAX = 4;
    private final Bundle mNetworkMappings;
    public static final Parcelable.Creator<OemNetworkPreferences> CREATOR = new Parcelable.Creator<OemNetworkPreferences>(){

        public OemNetworkPreferences[] newArray(int size) {
            return new OemNetworkPreferences[size];
        }

        @Override
        public OemNetworkPreferences createFromParcel(Parcel in) {
            return new OemNetworkPreferences(in.readBundle(this.getClass().getClassLoader()));
        }
    };

    public boolean isEmpty() {
        return this.mNetworkMappings.keySet().size() == 0;
    }

    public Map<String, Integer> getNetworkPreferences() {
        return OemNetworkPreferences.convertToUnmodifiableMap(this.mNetworkMappings);
    }

    private OemNetworkPreferences(Bundle networkMappings) {
        Objects.requireNonNull(networkMappings);
        this.mNetworkMappings = (Bundle)networkMappings.clone();
    }

    public String toString() {
        return "OemNetworkPreferences{mNetworkMappings=" + this.getNetworkPreferences() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OemNetworkPreferences that = (OemNetworkPreferences)o;
        return this.mNetworkMappings.size() == that.mNetworkMappings.size() && this.mNetworkMappings.toString().equals(that.mNetworkMappings.toString());
    }

    public int hashCode() {
        return Objects.hash(this.mNetworkMappings);
    }

    private static Map<String, Integer> convertToUnmodifiableMap(Bundle bundle) {
        HashMap<String, Integer> networkPreferences = new HashMap<String, Integer>();
        for (String key : bundle.keySet()) {
            networkPreferences.put(key, bundle.getInt(key));
        }
        return Collections.unmodifiableMap(networkPreferences);
    }

    public static String oemNetworkPreferenceToString(int value2) {
        switch (value2) {
            case -2: {
                return "OEM_NETWORK_PREFERENCE_TEST_ONLY";
            }
            case -1: {
                return "OEM_NETWORK_PREFERENCE_TEST";
            }
            case 0: {
                return "OEM_NETWORK_PREFERENCE_UNINITIALIZED";
            }
            case 1: {
                return "OEM_NETWORK_PREFERENCE_OEM_PAID";
            }
            case 2: {
                return "OEM_NETWORK_PREFERENCE_OEM_PAID_NO_FALLBACK";
            }
            case 3: {
                return "OEM_NETWORK_PREFERENCE_OEM_PAID_ONLY";
            }
            case 4: {
                return "OEM_NETWORK_PREFERENCE_OEM_PRIVATE_ONLY";
            }
        }
        return Integer.toHexString(value2);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.mNetworkMappings);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OemNetworkPreference {
    }

    public static class Builder {
        private final Bundle mNetworkMappings;

        public Builder() {
            this.mNetworkMappings = new Bundle();
        }

        public Builder(OemNetworkPreferences preferences) {
            Objects.requireNonNull(preferences);
            this.mNetworkMappings = (Bundle)preferences.mNetworkMappings.clone();
        }

        public Builder addNetworkPreference(String packageName, int preference) {
            Objects.requireNonNull(packageName);
            this.mNetworkMappings.putInt(packageName, preference);
            return this;
        }

        public Builder clearNetworkPreference(String packageName) {
            Objects.requireNonNull(packageName);
            this.mNetworkMappings.remove(packageName);
            return this;
        }

        public OemNetworkPreferences build() {
            return new OemNetworkPreferences(this.mNetworkMappings);
        }
    }
}

