/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.NetworkIdentity;
import android.net.NetworkStats;
import android.net.wifi.WifiInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.BackupUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.net.module.util.NetworkIdentityUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class NetworkTemplate
implements Parcelable {
    private static final String TAG = "NetworkTemplate";
    private static final int BACKUP_VERSION = 1;
    public static final int MATCH_MOBILE = 1;
    public static final int MATCH_WIFI = 4;
    public static final int MATCH_ETHERNET = 5;
    public static final int MATCH_MOBILE_WILDCARD = 6;
    public static final int MATCH_WIFI_WILDCARD = 7;
    public static final int MATCH_BLUETOOTH = 8;
    public static final int MATCH_PROXY = 9;
    public static final int MATCH_CARRIER = 10;
    public static final int SUBSCRIBER_ID_MATCH_RULE_EXACT = 0;
    public static final int SUBSCRIBER_ID_MATCH_RULE_ALL = 1;
    public static final String WIFI_NETWORKID_ALL = null;
    public static final int NETWORK_TYPE_ALL = -1;
    public static final int NETWORK_TYPE_5G_NSA = -2;
    public static final int OEM_MANAGED_ALL = -1;
    public static final int OEM_MANAGED_NO = 0;
    public static final int OEM_MANAGED_YES = -2;
    private static boolean sForceAllNetworkTypes = false;
    private final int mMatchRule;
    private final String mSubscriberId;
    private final String[] mMatchSubscriberIds;
    private final String mNetworkId;
    private final int mMetered;
    private final int mRoaming;
    private final int mDefaultNetwork;
    private final int mSubType;
    private final int mSubscriberIdMatchRule;
    private final int mOemManaged;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<NetworkTemplate> CREATOR = new Parcelable.Creator<NetworkTemplate>(){

        @Override
        public NetworkTemplate createFromParcel(Parcel in) {
            return new NetworkTemplate(in);
        }

        public NetworkTemplate[] newArray(int size) {
            return new NetworkTemplate[size];
        }
    };

    private static boolean isKnownMatchRule(int rule) {
        switch (rule) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    public static void forceAllNetworkTypes() {
        sForceAllNetworkTypes = true;
    }

    @VisibleForTesting
    public static void resetForceAllNetworkTypes() {
        sForceAllNetworkTypes = false;
    }

    @UnsupportedAppUsage
    public static NetworkTemplate buildTemplateMobileAll(String subscriberId) {
        return new NetworkTemplate(1, subscriberId, null);
    }

    public static NetworkTemplate buildTemplateMobileWithRatType(String subscriberId, int ratType) {
        if (TextUtils.isEmpty(subscriberId)) {
            return new NetworkTemplate(6, null, null, null, -1, -1, -1, ratType, -1, 0);
        }
        return new NetworkTemplate(1, subscriberId, new String[]{subscriberId}, null, -1, -1, -1, ratType, -1, 0);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static NetworkTemplate buildTemplateMobileWildcard() {
        return new NetworkTemplate(6, null, null);
    }

    @UnsupportedAppUsage
    public static NetworkTemplate buildTemplateWifiWildcard() {
        return new NetworkTemplate(7, null, null);
    }

    @Deprecated
    @UnsupportedAppUsage
    public static NetworkTemplate buildTemplateWifi() {
        return NetworkTemplate.buildTemplateWifiWildcard();
    }

    public static NetworkTemplate buildTemplateWifi(String networkId) {
        Objects.requireNonNull(networkId);
        return new NetworkTemplate(4, null, new String[]{null}, networkId, -1, -1, -1, -1, -1, 1);
    }

    public static NetworkTemplate buildTemplateWifi(String networkId, String subscriberId) {
        return new NetworkTemplate(4, subscriberId, new String[]{subscriberId}, networkId, -1, -1, -1, -1, -1, 0);
    }

    @UnsupportedAppUsage
    public static NetworkTemplate buildTemplateEthernet() {
        return new NetworkTemplate(5, null, null);
    }

    public static NetworkTemplate buildTemplateBluetooth() {
        return new NetworkTemplate(8, null, null);
    }

    public static NetworkTemplate buildTemplateProxy() {
        return new NetworkTemplate(9, null, null);
    }

    public static NetworkTemplate buildTemplateCarrierMetered(String subscriberId) {
        Objects.requireNonNull(subscriberId);
        return new NetworkTemplate(10, subscriberId, new String[]{subscriberId}, null, 1, -1, -1, -1, -1, 0);
    }

    private void checkValidSubscriberIdMatchRule() {
        switch (this.mMatchRule) {
            case 1: 
            case 10: {
                if (this.mSubscriberIdMatchRule == 1) {
                    throw new IllegalArgumentException("Invalid SubscriberIdMatchRuleon match rule: " + NetworkTemplate.getMatchRuleName(this.mMatchRule));
                }
                return;
            }
        }
    }

    @UnsupportedAppUsage
    public NetworkTemplate(int matchRule, String subscriberId, String networkId) {
        this(matchRule, subscriberId, new String[]{subscriberId}, networkId);
    }

    public NetworkTemplate(int matchRule, String subscriberId, String[] matchSubscriberIds, String networkId) {
        this(matchRule, subscriberId, matchSubscriberIds, networkId, -1, -1, -1, -1, -1, 0);
    }

    public NetworkTemplate(int matchRule, String subscriberId, String[] matchSubscriberIds, String networkId, int metered, int roaming, int defaultNetwork, int subType, int oemManaged) {
        this(matchRule, subscriberId, matchSubscriberIds, networkId, metered, roaming, defaultNetwork, subType, oemManaged, 0);
    }

    public NetworkTemplate(int matchRule, String subscriberId, String[] matchSubscriberIds, String networkId, int metered, int roaming, int defaultNetwork, int subType, int oemManaged, int subscriberIdMatchRule) {
        this.mMatchRule = matchRule;
        this.mSubscriberId = subscriberId;
        this.mMatchSubscriberIds = matchSubscriberIds;
        this.mNetworkId = networkId;
        this.mMetered = metered;
        this.mRoaming = roaming;
        this.mDefaultNetwork = defaultNetwork;
        this.mSubType = subType;
        this.mOemManaged = oemManaged;
        this.mSubscriberIdMatchRule = subscriberIdMatchRule;
        this.checkValidSubscriberIdMatchRule();
        if (!NetworkTemplate.isKnownMatchRule(matchRule)) {
            Log.e(TAG, "Unknown network template rule " + matchRule + " will not match any identity.");
        }
    }

    private NetworkTemplate(Parcel in) {
        this.mMatchRule = in.readInt();
        this.mSubscriberId = in.readString();
        this.mMatchSubscriberIds = in.createStringArray();
        this.mNetworkId = in.readString();
        this.mMetered = in.readInt();
        this.mRoaming = in.readInt();
        this.mDefaultNetwork = in.readInt();
        this.mSubType = in.readInt();
        this.mOemManaged = in.readInt();
        this.mSubscriberIdMatchRule = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMatchRule);
        dest.writeString(this.mSubscriberId);
        dest.writeStringArray(this.mMatchSubscriberIds);
        dest.writeString(this.mNetworkId);
        dest.writeInt(this.mMetered);
        dest.writeInt(this.mRoaming);
        dest.writeInt(this.mDefaultNetwork);
        dest.writeInt(this.mSubType);
        dest.writeInt(this.mOemManaged);
        dest.writeInt(this.mSubscriberIdMatchRule);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder("NetworkTemplate: ");
        builder2.append("matchRule=").append(NetworkTemplate.getMatchRuleName(this.mMatchRule));
        if (this.mSubscriberId != null) {
            builder2.append(", subscriberId=").append(NetworkIdentityUtils.scrubSubscriberId(this.mSubscriberId));
        }
        if (this.mMatchSubscriberIds != null) {
            builder2.append(", matchSubscriberIds=").append(Arrays.toString(NetworkIdentityUtils.scrubSubscriberIds(this.mMatchSubscriberIds)));
        }
        if (this.mNetworkId != null) {
            builder2.append(", networkId=").append(this.mNetworkId);
        }
        if (this.mMetered != -1) {
            builder2.append(", metered=").append(NetworkStats.meteredToString(this.mMetered));
        }
        if (this.mRoaming != -1) {
            builder2.append(", roaming=").append(NetworkStats.roamingToString(this.mRoaming));
        }
        if (this.mDefaultNetwork != -1) {
            builder2.append(", defaultNetwork=").append(NetworkStats.defaultNetworkToString(this.mDefaultNetwork));
        }
        if (this.mSubType != -1) {
            builder2.append(", subType=").append(this.mSubType);
        }
        if (this.mOemManaged != -1) {
            builder2.append(", oemManaged=").append(this.mOemManaged);
        }
        builder2.append(", subscriberIdMatchRule=").append(this.subscriberIdMatchRuleToString(this.mSubscriberIdMatchRule));
        return builder2.toString();
    }

    public int hashCode() {
        return Objects.hash(this.mMatchRule, this.mSubscriberId, this.mNetworkId, this.mMetered, this.mRoaming, this.mDefaultNetwork, this.mSubType, this.mOemManaged, this.mSubscriberIdMatchRule);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkTemplate) {
            NetworkTemplate other = (NetworkTemplate)obj;
            return this.mMatchRule == other.mMatchRule && Objects.equals(this.mSubscriberId, other.mSubscriberId) && Objects.equals(this.mNetworkId, other.mNetworkId) && this.mMetered == other.mMetered && this.mRoaming == other.mRoaming && this.mDefaultNetwork == other.mDefaultNetwork && this.mSubType == other.mSubType && this.mOemManaged == other.mOemManaged && this.mSubscriberIdMatchRule == other.mSubscriberIdMatchRule;
        }
        return false;
    }

    private String subscriberIdMatchRuleToString(int rule) {
        switch (rule) {
            case 0: {
                return "EXACT_MATCH";
            }
            case 1: {
                return "ALL";
            }
        }
        return "Unknown rule " + rule;
    }

    public boolean isMatchRuleMobile() {
        switch (this.mMatchRule) {
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isPersistable() {
        switch (this.mMatchRule) {
            case 6: 
            case 7: {
                return false;
            }
            case 10: {
                return this.mSubscriberId != null;
            }
            case 4: {
                return !Objects.equals(this.mNetworkId, WIFI_NETWORKID_ALL) || this.mSubscriberIdMatchRule != 1;
            }
        }
        return true;
    }

    @UnsupportedAppUsage
    public int getMatchRule() {
        return this.mMatchRule;
    }

    @UnsupportedAppUsage
    public String getSubscriberId() {
        return this.mSubscriberId;
    }

    public String getNetworkId() {
        return this.mNetworkId;
    }

    public int getSubscriberIdMatchRule() {
        return this.mSubscriberIdMatchRule;
    }

    public int getMeteredness() {
        return this.mMetered;
    }

    public boolean matches(NetworkIdentity ident) {
        if (!this.matchesMetered(ident)) {
            return false;
        }
        if (!this.matchesRoaming(ident)) {
            return false;
        }
        if (!this.matchesDefaultNetwork(ident)) {
            return false;
        }
        if (!this.matchesOemNetwork(ident)) {
            return false;
        }
        switch (this.mMatchRule) {
            case 1: {
                return this.matchesMobile(ident);
            }
            case 4: {
                return this.matchesWifi(ident);
            }
            case 5: {
                return this.matchesEthernet(ident);
            }
            case 6: {
                return this.matchesMobileWildcard(ident);
            }
            case 7: {
                return this.matchesWifiWildcard(ident);
            }
            case 8: {
                return this.matchesBluetooth(ident);
            }
            case 9: {
                return this.matchesProxy(ident);
            }
            case 10: {
                return this.matchesCarrier(ident);
            }
        }
        return false;
    }

    private boolean matchesMetered(NetworkIdentity ident) {
        return this.mMetered == -1 || this.mMetered == 1 && ident.mMetered || this.mMetered == 0 && !ident.mMetered;
    }

    private boolean matchesRoaming(NetworkIdentity ident) {
        return this.mRoaming == -1 || this.mRoaming == 1 && ident.mRoaming || this.mRoaming == 0 && !ident.mRoaming;
    }

    private boolean matchesDefaultNetwork(NetworkIdentity ident) {
        return this.mDefaultNetwork == -1 || this.mDefaultNetwork == 1 && ident.mDefaultNetwork || this.mDefaultNetwork == 0 && !ident.mDefaultNetwork;
    }

    private boolean matchesOemNetwork(NetworkIdentity ident) {
        return this.mOemManaged == -1 || this.mOemManaged == -2 && ident.mOemManaged != 0 || this.mOemManaged == ident.mOemManaged;
    }

    private boolean matchesCollapsedRatType(NetworkIdentity ident) {
        return this.mSubType == -1 || NetworkTemplate.getCollapsedRatType(this.mSubType) == NetworkTemplate.getCollapsedRatType(ident.mSubType);
    }

    public boolean matchesSubscriberId(String subscriberId) {
        return this.mSubscriberIdMatchRule == 1 || ArrayUtils.contains(this.mMatchSubscriberIds, subscriberId);
    }

    private boolean matchesWifiNetworkId(String networkId) {
        return Objects.equals(this.mNetworkId, WIFI_NETWORKID_ALL) || Objects.equals(WifiInfo.sanitizeSsid(this.mNetworkId), WifiInfo.sanitizeSsid(networkId));
    }

    private boolean matchesMobile(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return true;
        }
        return (sForceAllNetworkTypes || ident.mType == 0 && ident.mMetered) && !ArrayUtils.isEmpty(this.mMatchSubscriberIds) && ArrayUtils.contains(this.mMatchSubscriberIds, ident.mSubscriberId) && this.matchesCollapsedRatType(ident);
    }

    public static int getCollapsedRatType(int ratType) {
        switch (ratType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return 16;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return 3;
            }
            case 13: 
            case 18: {
                return 13;
            }
            case 20: {
                return 20;
            }
            case -2: {
                return -2;
            }
        }
        return 0;
    }

    public static int[] getAllCollapsedRatTypes() {
        int[] ratTypes = TelephonyManager.getAllNetworkTypes();
        HashSet<Integer> collapsedRatTypes = new HashSet<Integer>();
        for (int ratType : ratTypes) {
            collapsedRatTypes.add(NetworkTemplate.getCollapsedRatType(ratType));
        }
        collapsedRatTypes.add(NetworkTemplate.getCollapsedRatType(-2));
        collapsedRatTypes.add(0);
        return NetworkTemplate.toIntArray(collapsedRatTypes);
    }

    private static int[] toIntArray(Collection<Integer> list) {
        int[] array2 = new int[list.size()];
        int i = 0;
        for (Integer item : list) {
            array2[i++] = item;
        }
        return array2;
    }

    private boolean matchesWifi(NetworkIdentity ident) {
        switch (ident.mType) {
            case 1: {
                return this.matchesSubscriberId(ident.mSubscriberId) && this.matchesWifiNetworkId(ident.mNetworkId);
            }
        }
        return false;
    }

    private boolean matchesEthernet(NetworkIdentity ident) {
        return ident.mType == 9;
    }

    private boolean matchesCarrier(NetworkIdentity ident) {
        return ident.mSubscriberId != null && !ArrayUtils.isEmpty(this.mMatchSubscriberIds) && ArrayUtils.contains(this.mMatchSubscriberIds, ident.mSubscriberId);
    }

    private boolean matchesMobileWildcard(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return true;
        }
        return (sForceAllNetworkTypes || ident.mType == 0 && ident.mMetered) && this.matchesCollapsedRatType(ident);
    }

    private boolean matchesWifiWildcard(NetworkIdentity ident) {
        switch (ident.mType) {
            case 1: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private boolean matchesBluetooth(NetworkIdentity ident) {
        return ident.mType == 7;
    }

    private boolean matchesProxy(NetworkIdentity ident) {
        return ident.mType == 16;
    }

    private static String getMatchRuleName(int matchRule) {
        switch (matchRule) {
            case 1: {
                return "MOBILE";
            }
            case 4: {
                return "WIFI";
            }
            case 5: {
                return "ETHERNET";
            }
            case 6: {
                return "MOBILE_WILDCARD";
            }
            case 7: {
                return "WIFI_WILDCARD";
            }
            case 8: {
                return "BLUETOOTH";
            }
            case 9: {
                return "PROXY";
            }
            case 10: {
                return "CARRIER";
            }
        }
        return "UNKNOWN(" + matchRule + ")";
    }

    @UnsupportedAppUsage
    public static NetworkTemplate normalize(NetworkTemplate template, String[] merged) {
        return NetworkTemplate.normalize(template, Arrays.asList(new String[][]{merged}));
    }

    public static NetworkTemplate normalize(NetworkTemplate template, List<String[]> mergedList) {
        if (!template.isMatchRuleMobile()) {
            return template;
        }
        for (String[] merged : mergedList) {
            if (!ArrayUtils.contains(merged, template.mSubscriberId)) continue;
            return new NetworkTemplate(template.mMatchRule, merged[0], merged, template.mNetworkId);
        }
        return template;
    }

    public byte[] getBytesForBackup() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(1);
        out.writeInt(this.mMatchRule);
        BackupUtils.writeString(out, this.mSubscriberId);
        BackupUtils.writeString(out, this.mNetworkId);
        return baos.toByteArray();
    }

    public static NetworkTemplate getNetworkTemplateFromBackup(DataInputStream in) throws IOException, BackupUtils.BadVersionException {
        int version = in.readInt();
        if (version < 1 || version > 1) {
            throw new BackupUtils.BadVersionException("Unknown Backup Serialization Version");
        }
        int matchRule = in.readInt();
        String subscriberId = BackupUtils.readString(in);
        String networkId = BackupUtils.readString(in);
        if (!NetworkTemplate.isKnownMatchRule(matchRule)) {
            throw new BackupUtils.BadVersionException("Restored network template contains unknown match rule " + matchRule);
        }
        return new NetworkTemplate(matchRule, subscriberId, networkId);
    }
}

