/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.INetworkScoreCache;
import android.net.INetworkScoreService;
import android.net.NetworkKey;
import android.net.NetworkScorerAppData;
import android.net.ScoredNetwork;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;

@SystemApi
public class NetworkScoreManager {
    private static final String TAG = "NetworkScoreManager";
    @Deprecated
    public static final String ACTION_CHANGE_ACTIVE = "android.net.scoring.CHANGE_ACTIVE";
    @Deprecated
    public static final String EXTRA_PACKAGE_NAME = "packageName";
    @Deprecated
    public static final String ACTION_SCORE_NETWORKS = "android.net.scoring.SCORE_NETWORKS";
    @Deprecated
    public static final String EXTRA_NETWORKS_TO_SCORE = "networksToScore";
    public static final String ACTION_CUSTOM_ENABLE = "android.net.scoring.CUSTOM_ENABLE";
    public static final String RECOMMENDATION_SERVICE_LABEL_META_DATA = "android.net.scoring.recommendation_service_label";
    public static final String USE_OPEN_WIFI_PACKAGE_META_DATA = "android.net.wifi.use_open_wifi_package";
    public static final String NETWORK_AVAILABLE_NOTIFICATION_CHANNEL_ID_META_DATA = "android.net.wifi.notification_channel_id_network_available";
    public static final String ACTION_SCORER_CHANGED = "android.net.scoring.SCORER_CHANGED";
    public static final String ACTION_RECOMMEND_NETWORKS = "android.net.action.RECOMMEND_NETWORKS";
    public static final String EXTRA_NEW_SCORER = "newScorer";
    public static final int SCORE_FILTER_NONE = 0;
    public static final int SCORE_FILTER_CURRENT_NETWORK = 1;
    public static final int SCORE_FILTER_SCAN_RESULTS = 2;
    public static final int RECOMMENDATIONS_ENABLED_FORCED_OFF = -1;
    public static final int RECOMMENDATIONS_ENABLED_OFF = 0;
    public static final int RECOMMENDATIONS_ENABLED_ON = 1;
    private final Context mContext;
    private final INetworkScoreService mService;

    public NetworkScoreManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mService = INetworkScoreService.Stub.asInterface(ServiceManager.getServiceOrThrow("network_score"));
    }

    @RequiresPermission(anyOf={"android.permission.SCORE_NETWORKS", "android.permission.REQUEST_NETWORK_SCORES"})
    public String getActiveScorerPackage() {
        try {
            return this.mService.getActiveScorerPackage();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REQUEST_NETWORK_SCORES")
    public NetworkScorerAppData getActiveScorer() {
        try {
            return this.mService.getActiveScorer();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REQUEST_NETWORK_SCORES")
    public List<NetworkScorerAppData> getAllValidScorers() {
        try {
            return this.mService.getAllValidScorers();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SCORE_NETWORKS")
    public boolean updateScores(ScoredNetwork[] networks) throws SecurityException {
        try {
            return this.mService.updateScores(networks);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.SCORE_NETWORKS", "android.permission.REQUEST_NETWORK_SCORES"})
    public boolean clearScores() throws SecurityException {
        try {
            return this.mService.clearScores();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.SCORE_NETWORKS", "android.permission.REQUEST_NETWORK_SCORES"})
    public boolean setActiveScorer(String packageName) throws SecurityException {
        try {
            return this.mService.setActiveScorer(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.SCORE_NETWORKS", "android.permission.REQUEST_NETWORK_SCORES"})
    public void disableScoring() throws SecurityException {
        try {
            this.mService.disableScoring();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REQUEST_NETWORK_SCORES")
    public boolean requestScores(NetworkKey[] networks) throws SecurityException {
        try {
            return this.mService.requestScores(networks);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.REQUEST_NETWORK_SCORES")
    public boolean requestScores(Collection<NetworkKey> networks) throws SecurityException {
        return this.requestScores(networks.toArray(new NetworkKey[0]));
    }

    @Deprecated
    @RequiresPermission(value="android.permission.REQUEST_NETWORK_SCORES")
    public void registerNetworkScoreCache(int networkType, INetworkScoreCache scoreCache) {
        this.registerNetworkScoreCache(networkType, scoreCache, 0);
    }

    @RequiresPermission(value="android.permission.REQUEST_NETWORK_SCORES")
    public void registerNetworkScoreCache(int networkType, INetworkScoreCache scoreCache, int filterType) {
        try {
            this.mService.registerNetworkScoreCache(networkType, scoreCache, filterType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REQUEST_NETWORK_SCORES")
    public void unregisterNetworkScoreCache(int networkType, INetworkScoreCache scoreCache) {
        try {
            this.mService.unregisterNetworkScoreCache(networkType, scoreCache);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.REQUEST_NETWORK_SCORES")
    public void registerNetworkScoreCallback(int networkType, int filterType, Executor executor, NetworkScoreCallback callback2) throws SecurityException {
        if (callback2 == null || executor == null) {
            throw new IllegalArgumentException("callback / executor cannot be null");
        }
        Log.v(TAG, "registerNetworkScoreCallback: callback=" + callback2 + ", executor=" + executor);
        this.registerNetworkScoreCache(networkType, new NetworkScoreCallbackProxy(executor, callback2), filterType);
    }

    @RequiresPermission(value="android.permission.REQUEST_NETWORK_SCORES")
    public boolean isCallerActiveScorer(int callingUid) {
        try {
            return this.mService.isCallerActiveScorer(callingUid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private class NetworkScoreCallbackProxy
    extends INetworkScoreCache.Stub {
        private final Executor mExecutor;
        private final NetworkScoreCallback mCallback;

        NetworkScoreCallbackProxy(Executor executor, NetworkScoreCallback callback2) {
            this.mExecutor = executor;
            this.mCallback = callback2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateScores(List<ScoredNetwork> networks) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onScoresUpdated(networks));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void clearScores() {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onScoresInvalidated());
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    @SystemApi
    public static abstract class NetworkScoreCallback {
        public abstract void onScoresUpdated(Collection<ScoredNetwork> var1);

        public abstract void onScoresInvalidated();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecommendationsEnabledSetting {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScoreUpdateFilter {
    }
}

