/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.Network;
import android.net.NetworkPolicy;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.os.Process;
import android.os.RemoteException;
import android.telephony.SubscriptionPlan;
import android.util.DebugUtils;
import android.util.Pair;
import android.util.Range;
import com.android.internal.util.function.pooled.PooledLambda;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class NetworkPolicyManager {
    public static final int POLICY_NONE = 0;
    public static final int POLICY_REJECT_METERED_BACKGROUND = 1;
    public static final int POLICY_ALLOW_METERED_BACKGROUND = 4;
    public static final int RULE_NONE = 0;
    public static final int RULE_ALLOW_METERED = 1;
    public static final int RULE_TEMPORARY_ALLOW_METERED = 2;
    public static final int RULE_REJECT_METERED = 4;
    public static final int RULE_ALLOW_ALL = 32;
    public static final int RULE_REJECT_ALL = 64;
    public static final int RULE_REJECT_RESTRICTED_MODE = 1024;
    public static final int MASK_METERED_NETWORKS = 15;
    public static final int MASK_ALL_NETWORKS = 240;
    public static final int MASK_RESTRICTED_MODE_NETWORKS = 3840;
    public static final int FIREWALL_RULE_DEFAULT = 0;
    public static final String FIREWALL_CHAIN_NAME_NONE = "none";
    public static final String FIREWALL_CHAIN_NAME_DOZABLE = "dozable";
    public static final String FIREWALL_CHAIN_NAME_STANDBY = "standby";
    public static final String FIREWALL_CHAIN_NAME_POWERSAVE = "powersave";
    public static final String FIREWALL_CHAIN_NAME_RESTRICTED = "restricted";
    private static final boolean ALLOW_PLATFORM_APP_POLICY = true;
    public static final int FOREGROUND_THRESHOLD_STATE = 5;
    public static final String EXTRA_NETWORK_TEMPLATE = "android.net.NETWORK_TEMPLATE";
    public static final int SUBSCRIPTION_OVERRIDE_UNMETERED = 1;
    public static final int SUBSCRIPTION_OVERRIDE_CONGESTED = 2;
    public static final int ALLOWED_REASON_NONE = 0;
    public static final int ALLOWED_REASON_SYSTEM = 1;
    public static final int ALLOWED_REASON_FOREGROUND = 2;
    public static final int ALLOWED_REASON_POWER_SAVE_ALLOWLIST = 4;
    public static final int ALLOWED_REASON_POWER_SAVE_EXCEPT_IDLE_ALLOWLIST = 8;
    public static final int ALLOWED_REASON_RESTRICTED_MODE_PERMISSIONS = 16;
    public static final int ALLOWED_METERED_REASON_USER_EXEMPTED = 65536;
    public static final int ALLOWED_METERED_REASON_SYSTEM = 131072;
    public static final int ALLOWED_METERED_REASON_FOREGROUND = 262144;
    public static final int ALLOWED_METERED_REASON_MASK = -65536;
    private final Context mContext;
    @UnsupportedAppUsage
    private INetworkPolicyManager mService;
    private final Map<SubscriptionCallback, SubscriptionCallbackProxy> mSubscriptionCallbackMap = new ConcurrentHashMap<SubscriptionCallback, SubscriptionCallbackProxy>();
    private final Map<NetworkPolicyCallback, NetworkPolicyCallbackProxy> mNetworkPolicyCallbackMap = new ConcurrentHashMap<NetworkPolicyCallback, NetworkPolicyCallbackProxy>();

    public NetworkPolicyManager(Context context, INetworkPolicyManager service) {
        if (service == null) {
            throw new IllegalArgumentException("missing INetworkPolicyManager");
        }
        this.mContext = context;
        this.mService = service;
    }

    @UnsupportedAppUsage
    public static NetworkPolicyManager from(Context context) {
        return (NetworkPolicyManager)context.getSystemService("netpolicy");
    }

    @UnsupportedAppUsage
    public void setUidPolicy(int uid, int policy) {
        try {
            this.mService.setUidPolicy(uid, policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void addUidPolicy(int uid, int policy) {
        try {
            this.mService.addUidPolicy(uid, policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeUidPolicy(int uid, int policy) {
        try {
            this.mService.removeUidPolicy(uid, policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getUidPolicy(int uid) {
        try {
            return this.mService.getUidPolicy(uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public int[] getUidsWithPolicy(int policy) {
        try {
            return this.mService.getUidsWithPolicy(policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void registerListener(INetworkPolicyListener listener2) {
        try {
            this.mService.registerListener(listener2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void unregisterListener(INetworkPolicyListener listener2) {
        try {
            this.mService.unregisterListener(listener2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.OBSERVE_NETWORK_POLICY")
    public void registerSubscriptionCallback(SubscriptionCallback callback2) {
        if (callback2 == null) {
            throw new NullPointerException("Callback cannot be null.");
        }
        SubscriptionCallbackProxy callbackProxy = new SubscriptionCallbackProxy(callback2);
        if (null != this.mSubscriptionCallbackMap.putIfAbsent(callback2, callbackProxy)) {
            throw new IllegalArgumentException("Callback is already registered.");
        }
        this.registerListener(callbackProxy);
    }

    @RequiresPermission(value="android.permission.OBSERVE_NETWORK_POLICY")
    public void unregisterSubscriptionCallback(SubscriptionCallback callback2) {
        if (callback2 == null) {
            throw new NullPointerException("Callback cannot be null.");
        }
        SubscriptionCallbackProxy callbackProxy = this.mSubscriptionCallbackMap.remove(callback2);
        if (callbackProxy == null) {
            return;
        }
        this.unregisterListener(callbackProxy);
    }

    public void setNetworkPolicies(NetworkPolicy[] policies) {
        try {
            this.mService.setNetworkPolicies(policies);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public NetworkPolicy[] getNetworkPolicies() {
        try {
            return this.mService.getNetworkPolicies(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setRestrictBackground(boolean restrictBackground) {
        try {
            this.mService.setRestrictBackground(restrictBackground);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean getRestrictBackground() {
        try {
            return this.mService.getRestrictBackground();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MAINLINE_NETWORK_STACK")
    public int getRestrictBackgroundStatus(int uid) {
        try {
            return this.mService.getRestrictBackgroundStatus(uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setSubscriptionOverride(int subId, int overrideMask, int overrideValue, int[] networkTypes, long timeoutMillis, String callingPackage) {
        try {
            this.mService.setSubscriptionOverride(subId, overrideMask, overrideValue, networkTypes, timeoutMillis, callingPackage);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setSubscriptionPlans(int subId, SubscriptionPlan[] plans, String callingPackage) {
        try {
            this.mService.setSubscriptionPlans(subId, plans, callingPackage);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public SubscriptionPlan[] getSubscriptionPlans(int subId, String callingPackage) {
        try {
            return this.mService.getSubscriptionPlans(subId, callingPackage);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void factoryReset(String subscriber) {
        try {
            this.mService.factoryReset(subscriber);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.OBSERVE_NETWORK_POLICY")
    public boolean isUidNetworkingBlocked(int uid, boolean meteredNetwork) {
        try {
            return this.mService.isUidNetworkingBlocked(uid, meteredNetwork);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.OBSERVE_NETWORK_POLICY")
    public boolean isUidRestrictedOnMeteredNetworks(int uid) {
        try {
            return this.mService.isUidRestrictedOnMeteredNetworks(uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MAINLINE_NETWORK_STACK")
    public int getMultipathPreference(Network network) {
        try {
            return this.mService.getMultipathPreference(network);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public static Iterator<Pair<ZonedDateTime, ZonedDateTime>> cycleIterator(NetworkPolicy policy) {
        final Iterator<Range<ZonedDateTime>> it = policy.cycleIterator();
        return new Iterator<Pair<ZonedDateTime, ZonedDateTime>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Pair<ZonedDateTime, ZonedDateTime> next() {
                if (this.hasNext()) {
                    Range r = (Range)it.next();
                    return Pair.create((ZonedDateTime)r.getLower(), (ZonedDateTime)r.getUpper());
                }
                return Pair.create(null, null);
            }
        };
    }

    @Deprecated
    public static boolean isUidValidForPolicy(Context context, int uid) {
        return Process.isApplicationUid(uid);
    }

    public static String uidRulesToString(int uidRules) {
        StringBuilder string2 = new StringBuilder().append(uidRules).append(" (");
        if (uidRules == 0) {
            string2.append("NONE");
        } else {
            string2.append(DebugUtils.flagsToString(NetworkPolicyManager.class, "RULE_", uidRules));
        }
        string2.append(")");
        return string2.toString();
    }

    public static String uidPoliciesToString(int uidPolicies) {
        StringBuilder string2 = new StringBuilder().append(uidPolicies).append(" (");
        if (uidPolicies == 0) {
            string2.append("NONE");
        } else {
            string2.append(DebugUtils.flagsToString(NetworkPolicyManager.class, "POLICY_", uidPolicies));
        }
        string2.append(")");
        return string2.toString();
    }

    public static boolean isProcStateAllowedWhileIdleOrPowerSaveMode(UidState uidState) {
        if (uidState == null) {
            return false;
        }
        return NetworkPolicyManager.isProcStateAllowedWhileIdleOrPowerSaveMode(uidState.procState, uidState.capability);
    }

    public static boolean isProcStateAllowedWhileIdleOrPowerSaveMode(int procState, int capability) {
        return procState <= 5 || (capability & 8) != 0;
    }

    public static boolean isProcStateAllowedWhileOnRestrictBackground(UidState uidState) {
        if (uidState == null) {
            return false;
        }
        return NetworkPolicyManager.isProcStateAllowedWhileOnRestrictBackground(uidState.procState);
    }

    public static boolean isProcStateAllowedWhileOnRestrictBackground(int procState) {
        return procState <= 5;
    }

    public static String resolveNetworkId(WifiConfiguration config) {
        return WifiInfo.sanitizeSsid(config.isPasspoint() ? config.providerFriendlyName : config.SSID);
    }

    public static String resolveNetworkId(String ssid) {
        return WifiInfo.sanitizeSsid(ssid);
    }

    public static String blockedReasonsToString(int blockedReasons) {
        return DebugUtils.flagsToString(ConnectivityManager.class, "BLOCKED_", blockedReasons);
    }

    public static String allowedReasonsToString(int allowedReasons) {
        return DebugUtils.flagsToString(NetworkPolicyManager.class, "ALLOWED_", allowedReasons);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.OBSERVE_NETWORK_POLICY")
    public void registerNetworkPolicyCallback(Executor executor, NetworkPolicyCallback callback2) {
        if (callback2 == null) {
            throw new NullPointerException("Callback cannot be null.");
        }
        NetworkPolicyCallbackProxy callbackProxy = new NetworkPolicyCallbackProxy(executor, callback2);
        this.registerListener(callbackProxy);
        this.mNetworkPolicyCallbackMap.put(callback2, callbackProxy);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.OBSERVE_NETWORK_POLICY")
    public void unregisterNetworkPolicyCallback(NetworkPolicyCallback callback2) {
        if (callback2 == null) {
            throw new NullPointerException("Callback cannot be null.");
        }
        NetworkPolicyCallbackProxy callbackProxy = this.mNetworkPolicyCallbackMap.remove(callback2);
        if (callbackProxy == null) {
            return;
        }
        this.unregisterListener(callbackProxy);
    }

    private static void dispatchOnUidBlockedReasonChanged(Executor executor, NetworkPolicyCallback callback2, int uid, int blockedReasons) {
        if (executor == null) {
            callback2.onUidBlockedReasonChanged(uid, blockedReasons);
        } else {
            executor.execute(PooledLambda.obtainRunnable(NetworkPolicyCallback::onUidBlockedReasonChanged, callback2, uid, blockedReasons).recycleOnUse());
        }
    }

    public static class Listener
    extends INetworkPolicyListener.Stub {
        @Override
        public void onUidRulesChanged(int uid, int uidRules) {
        }

        @Override
        public void onMeteredIfacesChanged(String[] meteredIfaces) {
        }

        @Override
        public void onRestrictBackgroundChanged(boolean restrictBackground) {
        }

        @Override
        public void onUidPoliciesChanged(int uid, int uidPolicies) {
        }

        @Override
        public void onSubscriptionOverride(int subId, int overrideMask, int overrideValue, int[] networkTypes) {
        }

        @Override
        public void onSubscriptionPlansChanged(int subId, SubscriptionPlan[] plans) {
        }

        @Override
        public void onBlockedReasonChanged(int uid, int oldBlockedReasons, int newBlockedReasons) {
        }
    }

    public class SubscriptionCallbackProxy
    extends Listener {
        private final SubscriptionCallback mCallback;

        SubscriptionCallbackProxy(SubscriptionCallback callback2) {
            this.mCallback = callback2;
        }

        @Override
        public void onSubscriptionOverride(int subId, int overrideMask, int overrideValue, int[] networkTypes) {
            this.mCallback.onSubscriptionOverride(subId, overrideMask, overrideValue, networkTypes);
        }

        @Override
        public void onSubscriptionPlansChanged(int subId, SubscriptionPlan[] plans) {
            this.mCallback.onSubscriptionPlansChanged(subId, plans);
        }
    }

    public static class SubscriptionCallback {
        public void onSubscriptionOverride(int subId, int overrideMask, int overrideValue, int[] networkTypes) {
        }

        public void onSubscriptionPlansChanged(int subId, SubscriptionPlan[] plans) {
        }
    }

    public static class NetworkPolicyCallbackProxy
    extends Listener {
        private final Executor mExecutor;
        private final NetworkPolicyCallback mCallback;

        NetworkPolicyCallbackProxy(Executor executor, NetworkPolicyCallback callback2) {
            this.mExecutor = executor;
            this.mCallback = callback2;
        }

        @Override
        public void onBlockedReasonChanged(int uid, int oldBlockedReasons, int newBlockedReasons) {
            if (oldBlockedReasons != newBlockedReasons) {
                NetworkPolicyManager.dispatchOnUidBlockedReasonChanged(this.mExecutor, this.mCallback, uid, newBlockedReasons);
            }
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static interface NetworkPolicyCallback {
        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        default public void onUidBlockedReasonChanged(int uid, int blockedReasons) {
        }
    }

    public static class UidState {
        public int uid;
        public int procState;
        public int capability;

        public UidState(int uid, int procState, int capability) {
            this.uid = uid;
            this.procState = procState;
            this.capability = capability;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{procState=");
            sb.append(ActivityManager.procStateToString(this.procState));
            sb.append(",cap=");
            ActivityManager.printCapabilitiesSummary(sb, this.capability);
            sb.append("}");
            return sb.toString();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SubscriptionOverrideMask {
    }
}

