/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.DataUsageRequest;
import android.net.INetworkStatsSession;
import android.net.Network;
import android.net.NetworkStateSnapshot;
import android.net.NetworkStats;
import android.net.UnderlyingNetworkInfo;
import android.net.netstats.provider.INetworkStatsProvider;
import android.net.netstats.provider.INetworkStatsProviderCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Messenger;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkStatsService
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/net/INetworkStatsService.aidl:36:1:36:25")
    public INetworkStatsSession openSession() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/net/INetworkStatsService.aidl:45:1:45:69")
    public INetworkStatsSession openSessionForUsageStats(int var1, String var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/net/INetworkStatsService.aidl:49:1:49:25")
    public NetworkStats getDataLayerSnapshotForUid(int var1) throws RemoteException;

    public NetworkStats getDetailedUidStats(String[] var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/net/INetworkStatsService.aidl:62:1:62:25")
    public String[] getMobileIfaces() throws RemoteException;

    public void incrementOperationCount(int var1, int var2, int var3) throws RemoteException;

    public void notifyNetworkStatus(Network[] var1, NetworkStateSnapshot[] var2, String var3, UnderlyingNetworkInfo[] var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/net/INetworkStatsService.aidl:75:1:75:25")
    public void forceUpdate() throws RemoteException;

    public DataUsageRequest registerUsageCallback(String var1, DataUsageRequest var2, Messenger var3, IBinder var4) throws RemoteException;

    public void unregisterUsageRequest(DataUsageRequest var1) throws RemoteException;

    public long getUidStats(int var1, int var2) throws RemoteException;

    public long getIfaceStats(String var1, int var2) throws RemoteException;

    public long getTotalStats(int var1) throws RemoteException;

    public INetworkStatsProviderCallback registerNetworkStatsProvider(String var1, INetworkStatsProvider var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkStatsService {
        public static final String DESCRIPTOR = "android.net.INetworkStatsService";
        static final int TRANSACTION_openSession = 1;
        static final int TRANSACTION_openSessionForUsageStats = 2;
        static final int TRANSACTION_getDataLayerSnapshotForUid = 3;
        static final int TRANSACTION_getDetailedUidStats = 4;
        static final int TRANSACTION_getMobileIfaces = 5;
        static final int TRANSACTION_incrementOperationCount = 6;
        static final int TRANSACTION_notifyNetworkStatus = 7;
        static final int TRANSACTION_forceUpdate = 8;
        static final int TRANSACTION_registerUsageCallback = 9;
        static final int TRANSACTION_unregisterUsageRequest = 10;
        static final int TRANSACTION_getUidStats = 11;
        static final int TRANSACTION_getIfaceStats = 12;
        static final int TRANSACTION_getTotalStats = 13;
        static final int TRANSACTION_registerNetworkStatsProvider = 14;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INetworkStatsService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INetworkStatsService) {
                return (INetworkStatsService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "openSession";
                }
                case 2: {
                    return "openSessionForUsageStats";
                }
                case 3: {
                    return "getDataLayerSnapshotForUid";
                }
                case 4: {
                    return "getDetailedUidStats";
                }
                case 5: {
                    return "getMobileIfaces";
                }
                case 6: {
                    return "incrementOperationCount";
                }
                case 7: {
                    return "notifyNetworkStatus";
                }
                case 8: {
                    return "forceUpdate";
                }
                case 9: {
                    return "registerUsageCallback";
                }
                case 10: {
                    return "unregisterUsageRequest";
                }
                case 11: {
                    return "getUidStats";
                }
                case 12: {
                    return "getIfaceStats";
                }
                case 13: {
                    return "getTotalStats";
                }
                case 14: {
                    return "registerNetworkStatsProvider";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    INetworkStatsSession _result = this.openSession();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    INetworkStatsSession _result = this.openSessionForUsageStats(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    NetworkStats _result = this.getDataLayerSnapshotForUid(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    NetworkStats _result = this.getDetailedUidStats(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getMobileIfaces();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.incrementOperationCount(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    Network[] _arg0 = data.createTypedArray(Network.CREATOR);
                    NetworkStateSnapshot[] _arg1 = data.createTypedArray(NetworkStateSnapshot.CREATOR);
                    String _arg2 = data.readString();
                    UnderlyingNetworkInfo[] _arg3 = data.createTypedArray(UnderlyingNetworkInfo.CREATOR);
                    this.notifyNetworkStatus(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    this.forceUpdate();
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    DataUsageRequest _arg1 = 0 != data.readInt() ? DataUsageRequest.CREATOR.createFromParcel(data) : null;
                    Messenger _arg2 = 0 != data.readInt() ? Messenger.CREATOR.createFromParcel(data) : null;
                    IBinder _arg3 = data.readStrongBinder();
                    DataUsageRequest _result = this.registerUsageCallback(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    DataUsageRequest _arg0 = 0 != data.readInt() ? DataUsageRequest.CREATOR.createFromParcel(data) : null;
                    this.unregisterUsageRequest(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    long _result = this.getUidStats(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    long _result = this.getIfaceStats(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    long _result = this.getTotalStats(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    INetworkStatsProvider _arg1 = INetworkStatsProvider.Stub.asInterface(data.readStrongBinder());
                    INetworkStatsProviderCallback _result = this.registerNetworkStatsProvider(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(INetworkStatsService impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static INetworkStatsService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements INetworkStatsService {
            private IBinder mRemote;
            public static INetworkStatsService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INetworkStatsSession openSession() throws RemoteException {
                INetworkStatsSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        INetworkStatsSession iNetworkStatsSession = Stub.getDefaultImpl().openSession();
                        return iNetworkStatsSession;
                    }
                    _reply.readException();
                    _result = INetworkStatsSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INetworkStatsSession openSessionForUsageStats(int flags, String callingPackage) throws RemoteException {
                INetworkStatsSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        INetworkStatsSession iNetworkStatsSession = Stub.getDefaultImpl().openSessionForUsageStats(flags, callingPackage);
                        return iNetworkStatsSession;
                    }
                    _reply.readException();
                    _result = INetworkStatsSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkStats getDataLayerSnapshotForUid(int uid) throws RemoteException {
                NetworkStats _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkStats networkStats = Stub.getDefaultImpl().getDataLayerSnapshotForUid(uid);
                        return networkStats;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? NetworkStats.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkStats getDetailedUidStats(String[] requiredIfaces) throws RemoteException {
                NetworkStats _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(requiredIfaces);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkStats networkStats = Stub.getDefaultImpl().getDetailedUidStats(requiredIfaces);
                        return networkStats;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? NetworkStats.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getMobileIfaces() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getMobileIfaces();
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void incrementOperationCount(int uid, int tag, int operationCount) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(tag);
                    _data.writeInt(operationCount);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().incrementOperationCount(uid, tag, operationCount);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyNetworkStatus(Network[] defaultNetworks, NetworkStateSnapshot[] snapshots, String activeIface, UnderlyingNetworkInfo[] underlyingNetworkInfos) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(defaultNetworks, 0);
                    _data.writeTypedArray(snapshots, 0);
                    _data.writeString(activeIface);
                    _data.writeTypedArray(underlyingNetworkInfos, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyNetworkStatus(defaultNetworks, snapshots, activeIface, underlyingNetworkInfos);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceUpdate() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().forceUpdate();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DataUsageRequest registerUsageCallback(String callingPackage, DataUsageRequest request, Messenger messenger, IBinder binder) throws RemoteException {
                DataUsageRequest _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (messenger != null) {
                        _data.writeInt(1);
                        messenger.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(binder);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        DataUsageRequest dataUsageRequest = Stub.getDefaultImpl().registerUsageCallback(callingPackage, request, messenger, binder);
                        return dataUsageRequest;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? DataUsageRequest.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterUsageRequest(DataUsageRequest request) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterUsageRequest(request);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getUidStats(int uid, int type) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(type);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long l = Stub.getDefaultImpl().getUidStats(uid, type);
                        return l;
                    }
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getIfaceStats(String iface, int type) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeInt(type);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long l = Stub.getDefaultImpl().getIfaceStats(iface, type);
                        return l;
                    }
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getTotalStats(int type) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long l = Stub.getDefaultImpl().getTotalStats(type);
                        return l;
                    }
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INetworkStatsProviderCallback registerNetworkStatsProvider(String tag, INetworkStatsProvider provider2) throws RemoteException {
                INetworkStatsProviderCallback _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(tag);
                    _data.writeStrongBinder(provider2 != null ? provider2.asBinder() : null);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        INetworkStatsProviderCallback iNetworkStatsProviderCallback = Stub.getDefaultImpl().registerNetworkStatsProvider(tag, provider2);
                        return iNetworkStatsProviderCallback;
                    }
                    _reply.readException();
                    _result = INetworkStatsProviderCallback.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements INetworkStatsService {
        @Override
        public INetworkStatsSession openSession() throws RemoteException {
            return null;
        }

        @Override
        public INetworkStatsSession openSessionForUsageStats(int flags, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public NetworkStats getDataLayerSnapshotForUid(int uid) throws RemoteException {
            return null;
        }

        @Override
        public NetworkStats getDetailedUidStats(String[] requiredIfaces) throws RemoteException {
            return null;
        }

        @Override
        public String[] getMobileIfaces() throws RemoteException {
            return null;
        }

        @Override
        public void incrementOperationCount(int uid, int tag, int operationCount) throws RemoteException {
        }

        @Override
        public void notifyNetworkStatus(Network[] defaultNetworks, NetworkStateSnapshot[] snapshots, String activeIface, UnderlyingNetworkInfo[] underlyingNetworkInfos) throws RemoteException {
        }

        @Override
        public void forceUpdate() throws RemoteException {
        }

        @Override
        public DataUsageRequest registerUsageCallback(String callingPackage, DataUsageRequest request, Messenger messenger, IBinder binder) throws RemoteException {
            return null;
        }

        @Override
        public void unregisterUsageRequest(DataUsageRequest request) throws RemoteException {
        }

        @Override
        public long getUidStats(int uid, int type) throws RemoteException {
            return 0L;
        }

        @Override
        public long getIfaceStats(String iface, int type) throws RemoteException {
            return 0L;
        }

        @Override
        public long getTotalStats(int type) throws RemoteException {
            return 0L;
        }

        @Override
        public INetworkStatsProviderCallback registerNetworkStatsProvider(String tag, INetworkStatsProvider provider2) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

