/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.IEthernetManager;
import android.net.IEthernetServiceListener;
import android.net.ITetheredInterfaceCallback;
import android.net.IpConfiguration;
import android.os.RemoteException;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class EthernetManager {
    private static final String TAG = "EthernetManager";
    private final IEthernetManager mService;
    @GuardedBy(value={"mListeners"})
    private final ArrayList<ListenerInfo> mListeners = new ArrayList();
    private final IEthernetServiceListener.Stub mServiceListener = new IEthernetServiceListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAvailabilityChanged(String iface, boolean isAvailable) {
            ArrayList arrayList = EthernetManager.this.mListeners;
            synchronized (arrayList) {
                for (ListenerInfo li : EthernetManager.this.mListeners) {
                    li.executor.execute(() -> li.listener.onAvailabilityChanged(iface, isAvailable));
                }
            }
        }
    };

    public EthernetManager(Context context, IEthernetManager service) {
        this.mService = service;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public IpConfiguration getConfiguration(String iface) {
        try {
            return this.mService.getConfiguration(iface);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setConfiguration(String iface, IpConfiguration config) {
        try {
            this.mService.setConfiguration(iface, config);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isAvailable() {
        return this.getAvailableInterfaces().length > 0;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isAvailable(String iface) {
        try {
            return this.mService.isAvailable(iface);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void addListener(Listener listener2) {
        this.addListener(listener2, BackgroundThread.getExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void addListener(Listener listener2, Executor executor) {
        if (listener2 == null || executor == null) {
            throw new NullPointerException("listener and executor must not be null");
        }
        ArrayList<ListenerInfo> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mListeners.add(new ListenerInfo(executor, listener2));
            if (this.mListeners.size() == 1) {
                try {
                    this.mService.addListener(this.mServiceListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public String[] getAvailableInterfaces() {
        try {
            return this.mService.getAvailableInterfaces();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void removeListener(Listener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        ArrayList<ListenerInfo> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mListeners.removeIf(l -> l.listener == listener2);
            if (this.mListeners.isEmpty()) {
                try {
                    this.mService.removeListener(this.mServiceListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    public void setIncludeTestInterfaces(boolean include) {
        try {
            this.mService.setIncludeTestInterfaces(include);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
    public TetheredInterfaceRequest requestTetheredInterface(final Executor executor, final TetheredInterfaceCallback callback2) {
        Objects.requireNonNull(callback2, "Callback must be non-null");
        Objects.requireNonNull(executor, "Executor must be non-null");
        ITetheredInterfaceCallback.Stub cbInternal = new ITetheredInterfaceCallback.Stub(){

            @Override
            public void onAvailable(String iface) {
                executor.execute(() -> callback2.onAvailable(iface));
            }

            @Override
            public void onUnavailable() {
                executor.execute(() -> callback2.onUnavailable());
            }
        };
        try {
            this.mService.requestTetheredInterface(cbInternal);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return new TetheredInterfaceRequest(this.mService, cbInternal);
    }

    public static interface TetheredInterfaceCallback {
        public void onAvailable(String var1);

        public void onUnavailable();
    }

    public static class TetheredInterfaceRequest {
        private final IEthernetManager mService;
        private final ITetheredInterfaceCallback mCb;

        private TetheredInterfaceRequest(IEthernetManager service, ITetheredInterfaceCallback cb) {
            this.mService = service;
            this.mCb = cb;
        }

        public void release() {
            try {
                this.mService.releaseTetheredInterface(this.mCb);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    }

    public static interface Listener {
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public void onAvailabilityChanged(String var1, boolean var2);
    }

    private static class ListenerInfo {
        public final Executor executor;
        public final Listener listener;

        private ListenerInfo(Executor executor, Listener listener2) {
            this.executor = executor;
            this.listener = listener2;
        }
    }
}

