/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.tunerresourcemanager;

import android.media.tv.tuner.TunerFrontendInfo;
import android.media.tv.tunerresourcemanager.CasSessionRequest;
import android.media.tv.tunerresourcemanager.IResourcesReclaimListener;
import android.media.tv.tunerresourcemanager.ResourceClientProfile;
import android.media.tv.tunerresourcemanager.TunerCiCamRequest;
import android.media.tv.tunerresourcemanager.TunerDemuxRequest;
import android.media.tv.tunerresourcemanager.TunerDescramblerRequest;
import android.media.tv.tunerresourcemanager.TunerFrontendRequest;
import android.media.tv.tunerresourcemanager.TunerLnbRequest;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITunerResourceManager
extends IInterface {
    public static final String DESCRIPTOR = "android$media$tv$tunerresourcemanager$ITunerResourceManager".replace('$', '.');

    public void registerClientProfile(ResourceClientProfile var1, IResourcesReclaimListener var2, int[] var3) throws RemoteException;

    public void unregisterClientProfile(int var1) throws RemoteException;

    public boolean updateClientPriority(int var1, int var2, int var3) throws RemoteException;

    public void setFrontendInfoList(TunerFrontendInfo[] var1) throws RemoteException;

    public void updateCasInfo(int var1, int var2) throws RemoteException;

    public void setLnbInfoList(int[] var1) throws RemoteException;

    public boolean requestFrontend(TunerFrontendRequest var1, int[] var2) throws RemoteException;

    public void shareFrontend(int var1, int var2) throws RemoteException;

    public boolean requestDemux(TunerDemuxRequest var1, int[] var2) throws RemoteException;

    public boolean requestDescrambler(TunerDescramblerRequest var1, int[] var2) throws RemoteException;

    public boolean requestCasSession(CasSessionRequest var1, int[] var2) throws RemoteException;

    public boolean requestCiCam(TunerCiCamRequest var1, int[] var2) throws RemoteException;

    public boolean requestLnb(TunerLnbRequest var1, int[] var2) throws RemoteException;

    public void releaseFrontend(int var1, int var2) throws RemoteException;

    public void releaseDemux(int var1, int var2) throws RemoteException;

    public void releaseDescrambler(int var1, int var2) throws RemoteException;

    public void releaseCasSession(int var1, int var2) throws RemoteException;

    public void releaseCiCam(int var1, int var2) throws RemoteException;

    public void releaseLnb(int var1, int var2) throws RemoteException;

    public boolean isHigherPriority(ResourceClientProfile var1, ResourceClientProfile var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITunerResourceManager {
        static final int TRANSACTION_registerClientProfile = 1;
        static final int TRANSACTION_unregisterClientProfile = 2;
        static final int TRANSACTION_updateClientPriority = 3;
        static final int TRANSACTION_setFrontendInfoList = 4;
        static final int TRANSACTION_updateCasInfo = 5;
        static final int TRANSACTION_setLnbInfoList = 6;
        static final int TRANSACTION_requestFrontend = 7;
        static final int TRANSACTION_shareFrontend = 8;
        static final int TRANSACTION_requestDemux = 9;
        static final int TRANSACTION_requestDescrambler = 10;
        static final int TRANSACTION_requestCasSession = 11;
        static final int TRANSACTION_requestCiCam = 12;
        static final int TRANSACTION_requestLnb = 13;
        static final int TRANSACTION_releaseFrontend = 14;
        static final int TRANSACTION_releaseDemux = 15;
        static final int TRANSACTION_releaseDescrambler = 16;
        static final int TRANSACTION_releaseCasSession = 17;
        static final int TRANSACTION_releaseCiCam = 18;
        static final int TRANSACTION_releaseLnb = 19;
        static final int TRANSACTION_isHigherPriority = 20;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITunerResourceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITunerResourceManager) {
                return (ITunerResourceManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    ResourceClientProfile _arg0 = 0 != data.readInt() ? ResourceClientProfile.CREATOR.createFromParcel(data) : null;
                    IResourcesReclaimListener _arg1 = IResourcesReclaimListener.Stub.asInterface(data.readStrongBinder());
                    int _arg2_length = data.readInt();
                    int[] _arg2 = _arg2_length < 0 ? null : new int[_arg2_length];
                    this.registerClientProfile(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeIntArray(_arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.unregisterClientProfile(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _result = this.updateClientPriority(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    TunerFrontendInfo[] _arg0 = data.createTypedArray(TunerFrontendInfo.CREATOR);
                    this.setFrontendInfoList(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.updateCasInfo(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    this.setLnbInfoList(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    TunerFrontendRequest _arg0 = 0 != data.readInt() ? TunerFrontendRequest.CREATOR.createFromParcel(data) : null;
                    int _arg1_length = data.readInt();
                    int[] _arg1 = _arg1_length < 0 ? null : new int[_arg1_length];
                    boolean _result = this.requestFrontend(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    reply.writeIntArray(_arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.shareFrontend(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    TunerDemuxRequest _arg0 = 0 != data.readInt() ? TunerDemuxRequest.CREATOR.createFromParcel(data) : null;
                    int _arg1_length = data.readInt();
                    int[] _arg1 = _arg1_length < 0 ? null : new int[_arg1_length];
                    boolean _result = this.requestDemux(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    reply.writeIntArray(_arg1);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    TunerDescramblerRequest _arg0 = 0 != data.readInt() ? TunerDescramblerRequest.CREATOR.createFromParcel(data) : null;
                    int _arg1_length = data.readInt();
                    int[] _arg1 = _arg1_length < 0 ? null : new int[_arg1_length];
                    boolean _result = this.requestDescrambler(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    reply.writeIntArray(_arg1);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    CasSessionRequest _arg0 = 0 != data.readInt() ? CasSessionRequest.CREATOR.createFromParcel(data) : null;
                    int _arg1_length = data.readInt();
                    int[] _arg1 = _arg1_length < 0 ? null : new int[_arg1_length];
                    boolean _result = this.requestCasSession(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    reply.writeIntArray(_arg1);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    TunerCiCamRequest _arg0 = 0 != data.readInt() ? TunerCiCamRequest.CREATOR.createFromParcel(data) : null;
                    int _arg1_length = data.readInt();
                    int[] _arg1 = _arg1_length < 0 ? null : new int[_arg1_length];
                    boolean _result = this.requestCiCam(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    reply.writeIntArray(_arg1);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    TunerLnbRequest _arg0 = 0 != data.readInt() ? TunerLnbRequest.CREATOR.createFromParcel(data) : null;
                    int _arg1_length = data.readInt();
                    int[] _arg1 = _arg1_length < 0 ? null : new int[_arg1_length];
                    boolean _result = this.requestLnb(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    reply.writeIntArray(_arg1);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.releaseFrontend(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.releaseDemux(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.releaseDescrambler(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.releaseCasSession(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.releaseCiCam(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.releaseLnb(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    ResourceClientProfile _arg0 = 0 != data.readInt() ? ResourceClientProfile.CREATOR.createFromParcel(data) : null;
                    ResourceClientProfile _arg1 = 0 != data.readInt() ? ResourceClientProfile.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.isHigherPriority(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITunerResourceManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITunerResourceManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITunerResourceManager {
            private IBinder mRemote;
            public static ITunerResourceManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerClientProfile(ResourceClientProfile profile, IResourcesReclaimListener listener2, int[] clientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (profile != null) {
                        _data.writeInt(1);
                        profile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener2 != null ? listener2.asBinder() : null);
                    if (clientId == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(clientId.length);
                    }
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerClientProfile(profile, listener2, clientId);
                        return;
                    }
                    _reply.readException();
                    _reply.readIntArray(clientId);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterClientProfile(int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterClientProfile(clientId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean updateClientPriority(int clientId, int priority, int niceValue) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeInt(priority);
                    _data.writeInt(niceValue);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().updateClientPriority(clientId, priority, niceValue);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFrontendInfoList(TunerFrontendInfo[] infos) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedArray(infos, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setFrontendInfoList(infos);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateCasInfo(int casSystemId, int maxSessionNum) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(casSystemId);
                    _data.writeInt(maxSessionNum);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateCasInfo(casSystemId, maxSessionNum);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLnbInfoList(int[] lnbIds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeIntArray(lnbIds);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setLnbInfoList(lnbIds);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestFrontend(TunerFrontendRequest request, int[] frontendHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (frontendHandle == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(frontendHandle.length);
                    }
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().requestFrontend(request, frontendHandle);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    _reply.readIntArray(frontendHandle);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shareFrontend(int selfClientId, int targetClientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(selfClientId);
                    _data.writeInt(targetClientId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().shareFrontend(selfClientId, targetClientId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestDemux(TunerDemuxRequest request, int[] demuxHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (demuxHandle == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(demuxHandle.length);
                    }
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().requestDemux(request, demuxHandle);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    _reply.readIntArray(demuxHandle);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestDescrambler(TunerDescramblerRequest request, int[] descramblerHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (descramblerHandle == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(descramblerHandle.length);
                    }
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().requestDescrambler(request, descramblerHandle);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    _reply.readIntArray(descramblerHandle);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestCasSession(CasSessionRequest request, int[] casSessionHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (casSessionHandle == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(casSessionHandle.length);
                    }
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().requestCasSession(request, casSessionHandle);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    _reply.readIntArray(casSessionHandle);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestCiCam(TunerCiCamRequest request, int[] ciCamHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (ciCamHandle == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(ciCamHandle.length);
                    }
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().requestCiCam(request, ciCamHandle);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    _reply.readIntArray(ciCamHandle);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestLnb(TunerLnbRequest request, int[] lnbHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (lnbHandle == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(lnbHandle.length);
                    }
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().requestLnb(request, lnbHandle);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    _reply.readIntArray(lnbHandle);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseFrontend(int frontendHandle, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(frontendHandle);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseFrontend(frontendHandle, clientId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseDemux(int demuxHandle, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(demuxHandle);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseDemux(demuxHandle, clientId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseDescrambler(int descramblerHandle, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(descramblerHandle);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseDescrambler(descramblerHandle, clientId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseCasSession(int casSessionHandle, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(casSessionHandle);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseCasSession(casSessionHandle, clientId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseCiCam(int ciCamHandle, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(ciCamHandle);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseCiCam(ciCamHandle, clientId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseLnb(int lnbHandle, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(lnbHandle);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseLnb(lnbHandle, clientId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHigherPriority(ResourceClientProfile challengerProfile, ResourceClientProfile holderProfile) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (challengerProfile != null) {
                        _data.writeInt(1);
                        challengerProfile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (holderProfile != null) {
                        _data.writeInt(1);
                        holderProfile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isHigherPriority(challengerProfile, holderProfile);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ITunerResourceManager {
        @Override
        public void registerClientProfile(ResourceClientProfile profile, IResourcesReclaimListener listener2, int[] clientId) throws RemoteException {
        }

        @Override
        public void unregisterClientProfile(int clientId) throws RemoteException {
        }

        @Override
        public boolean updateClientPriority(int clientId, int priority, int niceValue) throws RemoteException {
            return false;
        }

        @Override
        public void setFrontendInfoList(TunerFrontendInfo[] infos) throws RemoteException {
        }

        @Override
        public void updateCasInfo(int casSystemId, int maxSessionNum) throws RemoteException {
        }

        @Override
        public void setLnbInfoList(int[] lnbIds) throws RemoteException {
        }

        @Override
        public boolean requestFrontend(TunerFrontendRequest request, int[] frontendHandle) throws RemoteException {
            return false;
        }

        @Override
        public void shareFrontend(int selfClientId, int targetClientId) throws RemoteException {
        }

        @Override
        public boolean requestDemux(TunerDemuxRequest request, int[] demuxHandle) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestDescrambler(TunerDescramblerRequest request, int[] descramblerHandle) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestCasSession(CasSessionRequest request, int[] casSessionHandle) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestCiCam(TunerCiCamRequest request, int[] ciCamHandle) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestLnb(TunerLnbRequest request, int[] lnbHandle) throws RemoteException {
            return false;
        }

        @Override
        public void releaseFrontend(int frontendHandle, int clientId) throws RemoteException {
        }

        @Override
        public void releaseDemux(int demuxHandle, int clientId) throws RemoteException {
        }

        @Override
        public void releaseDescrambler(int descramblerHandle, int clientId) throws RemoteException {
        }

        @Override
        public void releaseCasSession(int casSessionHandle, int clientId) throws RemoteException {
        }

        @Override
        public void releaseCiCam(int ciCamHandle, int clientId) throws RemoteException {
        }

        @Override
        public void releaseLnb(int lnbHandle, int clientId) throws RemoteException {
        }

        @Override
        public boolean isHigherPriority(ResourceClientProfile challengerProfile, ResourceClientProfile holderProfile) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

