/*
 * Decompiled with CFR 0.152.
 */
package android.media.musicrecognition;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.media.MediaMetadata;
import android.media.musicrecognition.IMusicRecognitionManager;
import android.media.musicrecognition.IMusicRecognitionManagerCallback;
import android.media.musicrecognition.RecognitionRequest;
import android.os.Bundle;
import android.os.RemoteException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class MusicRecognitionManager {
    public static final int RECOGNITION_FAILED_UNKNOWN = -1;
    public static final int RECOGNITION_FAILED_NOT_FOUND = 1;
    public static final int RECOGNITION_FAILED_NO_CONNECTIVITY = 2;
    public static final int RECOGNITION_FAILED_SERVICE_UNAVAILABLE = 3;
    public static final int RECOGNITION_FAILED_SERVICE_KILLED = 5;
    public static final int RECOGNITION_FAILED_TIMEOUT = 6;
    public static final int RECOGNITION_FAILED_AUDIO_UNAVAILABLE = 7;
    private final IMusicRecognitionManager mService;

    public MusicRecognitionManager(IMusicRecognitionManager service) {
        this.mService = service;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_MUSIC_RECOGNITION")
    public void beginStreamingSearch(RecognitionRequest recognitionRequest, Executor callbackExecutor, RecognitionCallback callback2) {
        try {
            this.mService.beginRecognition(Objects.requireNonNull(recognitionRequest), new MusicRecognitionCallbackWrapper(Objects.requireNonNull(recognitionRequest), Objects.requireNonNull(callback2), Objects.requireNonNull(callbackExecutor)));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private class MusicRecognitionCallbackWrapper
    extends IMusicRecognitionManagerCallback.Stub {
        private final RecognitionRequest mRecognitionRequest;
        private final RecognitionCallback mCallback;
        private final Executor mCallbackExecutor;

        MusicRecognitionCallbackWrapper(RecognitionRequest recognitionRequest, RecognitionCallback callback2, Executor callbackExecutor) {
            this.mRecognitionRequest = recognitionRequest;
            this.mCallback = callback2;
            this.mCallbackExecutor = callbackExecutor;
        }

        @Override
        public void onRecognitionSucceeded(MediaMetadata result, Bundle extras) {
            this.mCallbackExecutor.execute(() -> this.mCallback.onRecognitionSucceeded(this.mRecognitionRequest, result, extras));
        }

        @Override
        public void onRecognitionFailed(int failureCode) {
            this.mCallbackExecutor.execute(() -> this.mCallback.onRecognitionFailed(this.mRecognitionRequest, failureCode));
        }

        @Override
        public void onAudioStreamClosed() {
            this.mCallbackExecutor.execute(this.mCallback::onAudioStreamClosed);
        }
    }

    public static interface RecognitionCallback {
        public void onRecognitionSucceeded(RecognitionRequest var1, MediaMetadata var2, @SuppressLint(value={"NullableCollection"}) Bundle var3);

        public void onRecognitionFailed(RecognitionRequest var1, int var2);

        public void onAudioStreamClosed();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecognitionFailureCode {
    }
}

