/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import java.io.IOException;

public abstract class MidiReceiver {
    private final int mMaxMessageSize;

    public MidiReceiver() {
        this.mMaxMessageSize = Integer.MAX_VALUE;
    }

    public MidiReceiver(int maxMessageSize) {
        this.mMaxMessageSize = maxMessageSize;
    }

    public abstract void onSend(byte[] var1, int var2, int var3, long var4) throws IOException;

    public void flush() throws IOException {
        this.onFlush();
    }

    public void onFlush() throws IOException {
    }

    public int getMaxMessageSize() {
        return this.mMaxMessageSize;
    }

    public void send(byte[] msg, int offset2, int count) throws IOException {
        this.send(msg, offset2, count, 0L);
    }

    public void send(byte[] msg, int offset2, int count, long timestamp) throws IOException {
        int messageSize = this.getMaxMessageSize();
        while (count > 0) {
            int length = count > messageSize ? messageSize : count;
            this.onSend(msg, offset2, length, timestamp);
            offset2 += length;
            count -= length;
        }
    }
}

