/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.media.midi.IMidiDeviceServer;
import android.media.midi.MidiPortImpl;
import android.media.midi.MidiReceiver;
import android.media.midi.MidiSender;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.midi.MidiDispatcher;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import libcore.io.IoUtils;

public class MidiOutputPort
extends MidiSender
implements Closeable {
    private static final String TAG = "MidiOutputPort";
    private IMidiDeviceServer mDeviceServer;
    private final IBinder mToken;
    private final int mPortNumber;
    private final FileInputStream mInputStream;
    private final MidiDispatcher mDispatcher = new MidiDispatcher();
    private final CloseGuard mGuard = CloseGuard.get();
    private boolean mIsClosed;
    private final Thread mThread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            try {
                block8: while (true) {
                    int count;
                    if ((count = MidiOutputPort.this.mInputStream.read(buffer)) < 0) {
                        return;
                    }
                    int packetType = MidiPortImpl.getPacketType(buffer, count);
                    switch (packetType) {
                        case 1: {
                            int offset2 = MidiPortImpl.getDataOffset(buffer, count);
                            int size = MidiPortImpl.getDataSize(buffer, count);
                            long timestamp = MidiPortImpl.getPacketTimestamp(buffer, count);
                            MidiOutputPort.this.mDispatcher.send(buffer, offset2, size, timestamp);
                            continue block8;
                        }
                        case 2: {
                            MidiOutputPort.this.mDispatcher.flush();
                            continue block8;
                        }
                    }
                    Log.e(MidiOutputPort.TAG, "Unknown packet type " + packetType);
                }
            }
            catch (IOException iOException) {
                return;
            }
            finally {
                IoUtils.closeQuietly(MidiOutputPort.this.mInputStream);
            }
        }
    };

    MidiOutputPort(IMidiDeviceServer server, IBinder token, FileDescriptor fd, int portNumber) {
        this.mDeviceServer = server;
        this.mToken = token;
        this.mPortNumber = portNumber;
        this.mInputStream = new ParcelFileDescriptor.AutoCloseInputStream(new ParcelFileDescriptor(fd));
        this.mThread.start();
        this.mGuard.open("close");
    }

    MidiOutputPort(FileDescriptor fd, int portNumber) {
        this(null, null, fd, portNumber);
    }

    public int getPortNumber() {
        return this.mPortNumber;
    }

    @Override
    public void onConnect(MidiReceiver receiver) {
        this.mDispatcher.getSender().connect(receiver);
    }

    @Override
    public void onDisconnect(MidiReceiver receiver) {
        this.mDispatcher.getSender().disconnect(receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CloseGuard closeGuard = this.mGuard;
        synchronized (closeGuard) {
            if (this.mIsClosed) {
                return;
            }
            this.mGuard.close();
            this.mInputStream.close();
            if (this.mDeviceServer != null) {
                try {
                    this.mDeviceServer.closePort(this.mToken);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "RemoteException in MidiOutputPort.close()");
                }
            }
            this.mIsClosed = true;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
            }
            this.mDeviceServer = null;
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

