/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.media.MediaDataSource;
import android.media.MediaHTTPService;
import android.net.Uri;
import android.os.Bundle;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MediaMetadataRetriever
implements AutoCloseable {
    private static final String TAG = "MediaMetadataRetriever";
    private static final String[] STANDARD_GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "BritPop", "Afro-Punk", "Polsk Punk", "Beat", "Christian Gangsta Rap", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "Jpop", "Synthpop"};
    private long mNativeContext;
    private static final int EMBEDDED_PICTURE_TYPE_ANY = 65535;
    public static final int OPTION_PREVIOUS_SYNC = 0;
    public static final int OPTION_NEXT_SYNC = 1;
    public static final int OPTION_CLOSEST_SYNC = 2;
    public static final int OPTION_CLOSEST = 3;
    public static final int METADATA_KEY_CD_TRACK_NUMBER = 0;
    public static final int METADATA_KEY_ALBUM = 1;
    public static final int METADATA_KEY_ARTIST = 2;
    public static final int METADATA_KEY_AUTHOR = 3;
    public static final int METADATA_KEY_COMPOSER = 4;
    public static final int METADATA_KEY_DATE = 5;
    public static final int METADATA_KEY_GENRE = 6;
    public static final int METADATA_KEY_TITLE = 7;
    public static final int METADATA_KEY_YEAR = 8;
    public static final int METADATA_KEY_DURATION = 9;
    public static final int METADATA_KEY_NUM_TRACKS = 10;
    public static final int METADATA_KEY_WRITER = 11;
    public static final int METADATA_KEY_MIMETYPE = 12;
    public static final int METADATA_KEY_ALBUMARTIST = 13;
    public static final int METADATA_KEY_DISC_NUMBER = 14;
    public static final int METADATA_KEY_COMPILATION = 15;
    public static final int METADATA_KEY_HAS_AUDIO = 16;
    public static final int METADATA_KEY_HAS_VIDEO = 17;
    public static final int METADATA_KEY_VIDEO_WIDTH = 18;
    public static final int METADATA_KEY_VIDEO_HEIGHT = 19;
    public static final int METADATA_KEY_BITRATE = 20;
    public static final int METADATA_KEY_TIMED_TEXT_LANGUAGES = 21;
    public static final int METADATA_KEY_IS_DRM = 22;
    public static final int METADATA_KEY_LOCATION = 23;
    public static final int METADATA_KEY_VIDEO_ROTATION = 24;
    public static final int METADATA_KEY_CAPTURE_FRAMERATE = 25;
    public static final int METADATA_KEY_HAS_IMAGE = 26;
    public static final int METADATA_KEY_IMAGE_COUNT = 27;
    public static final int METADATA_KEY_IMAGE_PRIMARY = 28;
    public static final int METADATA_KEY_IMAGE_WIDTH = 29;
    public static final int METADATA_KEY_IMAGE_HEIGHT = 30;
    public static final int METADATA_KEY_IMAGE_ROTATION = 31;
    public static final int METADATA_KEY_VIDEO_FRAME_COUNT = 32;
    public static final int METADATA_KEY_EXIF_OFFSET = 33;
    public static final int METADATA_KEY_EXIF_LENGTH = 34;
    public static final int METADATA_KEY_COLOR_STANDARD = 35;
    public static final int METADATA_KEY_COLOR_TRANSFER = 36;
    public static final int METADATA_KEY_COLOR_RANGE = 37;
    public static final int METADATA_KEY_SAMPLERATE = 38;
    public static final int METADATA_KEY_BITS_PER_SAMPLE = 39;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int METADATA_KEY_VIDEO_CODEC_MIME_TYPE = 40;
    public static final int METADATA_KEY_XMP_OFFSET = 41;
    public static final int METADATA_KEY_XMP_LENGTH = 42;

    public MediaMetadataRetriever() {
        this.native_setup();
    }

    public void setDataSource(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        Uri uri = Uri.parse(path);
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            path = uri.getPath();
        } else if (scheme != null) {
            this.setDataSource(path, new HashMap<String, String>());
            return;
        }
        try (FileInputStream is = new FileInputStream(path);){
            FileDescriptor fd = is.getFD();
            this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
        }
        catch (FileNotFoundException fileEx) {
            throw new IllegalArgumentException(path + " does not exist");
        }
        catch (IOException ioEx) {
            throw new IllegalArgumentException("couldn't open " + path);
        }
    }

    public void setDataSource(String uri, Map<String, String> headers) throws IllegalArgumentException {
        int i = 0;
        String[] keys = new String[headers.size()];
        String[] values2 = new String[headers.size()];
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            keys[i] = entry.getKey();
            values2[i] = entry.getValue();
            ++i;
        }
        this._setDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(uri), uri, keys, values2);
    }

    private void _setDataSource(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2) throws IllegalArgumentException {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#_setDataSource(Landroid/os/IBinder;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V", true, this);
    }

    public void setDataSource(FileDescriptor fd, long offset2, long length) throws IllegalArgumentException {
        try (ParcelFileDescriptor modernFd = FileUtils.convertToModernFd(fd);){
            if (modernFd == null) {
                this._setDataSource(fd, offset2, length);
            } else {
                this._setDataSource(modernFd.getFileDescriptor(), offset2, length);
            }
        }
        catch (IOException e) {
            Log.w(TAG, "Ignoring IO error while setting data source", e);
        }
    }

    private void _setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IllegalArgumentException {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#_setDataSource(Ljava/io/FileDescriptor;JJ)V", true, this);
    }

    public void setDataSource(FileDescriptor fd) throws IllegalArgumentException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(Context context, Uri uri) throws IllegalArgumentException, SecurityException {
        if (uri == null) {
            throw new IllegalArgumentException("null uri");
        }
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        AssetFileDescriptor fd = null;
        try {
            ContentResolver resolver = context.getContentResolver();
            try {
                boolean optimize = SystemProperties.getBoolean("fuse.sys.transcode_retriever_optimize", false);
                Bundle opts = new Bundle();
                opts.putBoolean("android.provider.extra.ACCEPT_ORIGINAL_MEDIA_FORMAT", true);
                fd = optimize ? resolver.openTypedAssetFileDescriptor(uri, "*/*", opts) : resolver.openAssetFileDescriptor(uri, "r");
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("could not access " + uri);
            }
            if (fd == null) {
                throw new IllegalArgumentException("got null FileDescriptor for " + uri);
            }
            FileDescriptor descriptor = fd.getFileDescriptor();
            if (!descriptor.valid()) {
                throw new IllegalArgumentException("got invalid FileDescriptor for " + uri);
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(descriptor);
            } else {
                this.setDataSource(descriptor, fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        catch (SecurityException securityException) {
        }
        finally {
            try {
                if (fd != null) {
                    fd.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.setDataSource(uri.toString());
    }

    public void setDataSource(MediaDataSource dataSource) throws IllegalArgumentException {
        this._setDataSource(dataSource);
    }

    private void _setDataSource(MediaDataSource mediaDataSource) throws IllegalArgumentException {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#_setDataSource(Landroid/media/MediaDataSource;)V", true, this);
    }

    private String nativeExtractMetadata(int n) {
        return (String)OverrideMethod.invokeA("android.media.MediaMetadataRetriever#nativeExtractMetadata(I)Ljava/lang/String;", true, this);
    }

    public String extractMetadata(int keyCode) {
        String meta = this.nativeExtractMetadata(keyCode);
        if (keyCode == 6) {
            meta = this.convertGenreTag(meta);
        }
        return meta;
    }

    private String convertGenreTag(String meta) {
        if (TextUtils.isEmpty(meta)) {
            return null;
        }
        if (Character.isDigit(meta.charAt(0))) {
            try {
                int genreIndex = Integer.parseInt(meta);
                if (genreIndex >= 0 && genreIndex < STANDARD_GENRES.length) {
                    return STANDARD_GENRES[genreIndex];
                }
            }
            catch (NumberFormatException genreIndex) {
                // empty catch block
            }
            return null;
        }
        StringBuilder genres = null;
        String nextGenre = null;
        while (true) {
            int closeParenOffset;
            if (!TextUtils.isEmpty(nextGenre)) {
                if (genres == null) {
                    genres = new StringBuilder();
                }
                if (genres.length() != 0) {
                    genres.append(", ");
                }
                genres.append(nextGenre);
                nextGenre = null;
            }
            if (TextUtils.isEmpty(meta)) break;
            if (meta.startsWith("(RX)")) {
                nextGenre = "Remix";
                meta = meta.substring(4);
                continue;
            }
            if (meta.startsWith("(CR)")) {
                nextGenre = "Cover";
                meta = meta.substring(4);
                continue;
            }
            if (meta.startsWith("((")) {
                closeParenOffset = meta.indexOf(41);
                if (closeParenOffset == -1) {
                    nextGenre = meta.substring(1);
                    meta = "";
                    continue;
                }
                nextGenre = meta.substring(1, closeParenOffset + 1);
                meta = meta.substring(closeParenOffset + 1);
                continue;
            }
            if (meta.startsWith("(")) {
                closeParenOffset = meta.indexOf(41);
                if (closeParenOffset == -1) {
                    return null;
                }
                String genreNumString = meta.substring(1, closeParenOffset);
                try {
                    int genreIndex = Integer.parseInt(genreNumString.toString());
                    if (genreIndex < 0 || genreIndex >= STANDARD_GENRES.length) {
                        return null;
                    }
                    nextGenre = STANDARD_GENRES[genreIndex];
                }
                catch (NumberFormatException e) {
                    return null;
                }
                meta = meta.substring(closeParenOffset + 1);
                continue;
            }
            nextGenre = meta;
            meta = "";
        }
        return genres == null || genres.length() == 0 ? null : genres.toString();
    }

    public Bitmap getFrameAtTime(long timeUs, int option) {
        if (option < 0 || option > 3) {
            throw new IllegalArgumentException("Unsupported option: " + option);
        }
        return this._getFrameAtTime(timeUs, option, -1, -1, null);
    }

    public Bitmap getFrameAtTime(long timeUs, int option, BitmapParams params) {
        if (option < 0 || option > 3) {
            throw new IllegalArgumentException("Unsupported option: " + option);
        }
        return this._getFrameAtTime(timeUs, option, -1, -1, params);
    }

    public Bitmap getScaledFrameAtTime(long timeUs, int option, int dstWidth, int dstHeight) {
        this.validate(option, dstWidth, dstHeight);
        return this._getFrameAtTime(timeUs, option, dstWidth, dstHeight, null);
    }

    public Bitmap getScaledFrameAtTime(long timeUs, int option, int dstWidth, int dstHeight, BitmapParams params) {
        this.validate(option, dstWidth, dstHeight);
        return this._getFrameAtTime(timeUs, option, dstWidth, dstHeight, params);
    }

    private void validate(int option, int dstWidth, int dstHeight) {
        if (option < 0 || option > 3) {
            throw new IllegalArgumentException("Unsupported option: " + option);
        }
        if (dstWidth <= 0) {
            throw new IllegalArgumentException("Invalid width: " + dstWidth);
        }
        if (dstHeight <= 0) {
            throw new IllegalArgumentException("Invalid height: " + dstHeight);
        }
    }

    public Bitmap getFrameAtTime(long timeUs) {
        return this.getFrameAtTime(timeUs, 2);
    }

    public Bitmap getFrameAtTime() {
        return this._getFrameAtTime(-1L, 2, -1, -1, null);
    }

    private Bitmap _getFrameAtTime(long l, int n, int n2, int n3, BitmapParams bitmapParams) {
        return (Bitmap)OverrideMethod.invokeA("android.media.MediaMetadataRetriever#_getFrameAtTime(JIIILandroid/media/MediaMetadataRetriever$BitmapParams;)Landroid/graphics/Bitmap;", true, this);
    }

    public Bitmap getFrameAtIndex(int frameIndex, BitmapParams params) {
        List<Bitmap> bitmaps = this.getFramesAtIndex(frameIndex, 1, params);
        return bitmaps.get(0);
    }

    public Bitmap getFrameAtIndex(int frameIndex) {
        List<Bitmap> bitmaps = this.getFramesAtIndex(frameIndex, 1);
        return bitmaps.get(0);
    }

    public List<Bitmap> getFramesAtIndex(int frameIndex, int numFrames, BitmapParams params) {
        return this.getFramesAtIndexInternal(frameIndex, numFrames, params);
    }

    public List<Bitmap> getFramesAtIndex(int frameIndex, int numFrames) {
        return this.getFramesAtIndexInternal(frameIndex, numFrames, null);
    }

    private List<Bitmap> getFramesAtIndexInternal(int frameIndex, int numFrames, BitmapParams params) {
        if (!"yes".equals(this.extractMetadata(17))) {
            throw new IllegalStateException("Does not contail video or image sequences");
        }
        int frameCount = Integer.parseInt(this.extractMetadata(32));
        if (frameIndex < 0 || numFrames < 1 || frameIndex >= frameCount || frameIndex > frameCount - numFrames) {
            throw new IllegalArgumentException("Invalid frameIndex or numFrames: " + frameIndex + ", " + numFrames);
        }
        return this._getFrameAtIndex(frameIndex, numFrames, params);
    }

    private List<Bitmap> _getFrameAtIndex(int n, int n2, BitmapParams bitmapParams) {
        return (List)OverrideMethod.invokeA("android.media.MediaMetadataRetriever#_getFrameAtIndex(IILandroid/media/MediaMetadataRetriever$BitmapParams;)Ljava/util/List;", true, this);
    }

    public Bitmap getImageAtIndex(int imageIndex, BitmapParams params) {
        return this.getImageAtIndexInternal(imageIndex, params);
    }

    public Bitmap getThumbnailImageAtIndex(int n, BitmapParams bitmapParams, int n2, int n3) {
        return (Bitmap)OverrideMethod.invokeA("android.media.MediaMetadataRetriever#getThumbnailImageAtIndex(ILandroid/media/MediaMetadataRetriever$BitmapParams;II)Landroid/graphics/Bitmap;", true, this);
    }

    public Bitmap getImageAtIndex(int imageIndex) {
        return this.getImageAtIndexInternal(imageIndex, null);
    }

    public Bitmap getPrimaryImage(BitmapParams params) {
        return this.getImageAtIndexInternal(-1, params);
    }

    public Bitmap getPrimaryImage() {
        return this.getImageAtIndexInternal(-1, null);
    }

    private Bitmap getImageAtIndexInternal(int imageIndex, BitmapParams params) {
        if (!"yes".equals(this.extractMetadata(26))) {
            throw new IllegalStateException("Does not contail still images");
        }
        String imageCount = this.extractMetadata(27);
        if (imageIndex >= Integer.parseInt(imageCount)) {
            throw new IllegalArgumentException("Invalid image index: " + imageCount);
        }
        return this._getImageAtIndex(imageIndex, params);
    }

    private Bitmap _getImageAtIndex(int n, BitmapParams bitmapParams) {
        return (Bitmap)OverrideMethod.invokeA("android.media.MediaMetadataRetriever#_getImageAtIndex(ILandroid/media/MediaMetadataRetriever$BitmapParams;)Landroid/graphics/Bitmap;", true, this);
    }

    public byte[] getEmbeddedPicture() {
        return this.getEmbeddedPicture(65535);
    }

    @UnsupportedAppUsage
    private byte[] getEmbeddedPicture(int n) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaMetadataRetriever#getEmbeddedPicture(I)[B", true, this);
    }

    @Override
    public void close() {
        this.release();
    }

    public void release() {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#release()V", true, this);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private void native_setup() {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#native_setup()V", true, this);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#native_init()V", true, null);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#native_finalize()V", true, this);
    }

    protected void finalize() throws Throwable {
        try {
            this.native_finalize();
        }
        finally {
            super.finalize();
        }
    }

    static {
        System_Delegate.loadLibrary("media_jni");
        MediaMetadataRetriever.native_init();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Option {
    }

    public static class BitmapParams {
        private Bitmap.Config inPreferredConfig = Bitmap.Config.ARGB_8888;
        private Bitmap.Config outActualConfig = Bitmap.Config.ARGB_8888;

        public void setPreferredConfig(Bitmap.Config config) {
            if (config == null) {
                throw new IllegalArgumentException("preferred config can't be null");
            }
            this.inPreferredConfig = config;
        }

        public Bitmap.Config getPreferredConfig() {
            return this.inPreferredConfig;
        }

        public Bitmap.Config getActualConfig() {
            return this.outActualConfig;
        }
    }
}

