/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.media.DeniedByServerException;
import android.media.NotProvisionedException;
import android.media.ResourceBusyException;
import android.media.UnsupportedSchemeException;
import android.media.metrics.LogSessionId;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.Looper;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.util.Log;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;

public class MediaDrm
implements AutoCloseable {
    private static final String TAG = "MediaDrm";
    private final AtomicBoolean mClosed = new AtomicBoolean();
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private static final String PERMISSION = "android.permission.ACCESS_DRM_CERTIFICATES";
    private long mNativeContext;
    private final String mAppPackageName;
    public static final int CERTIFICATE_TYPE_NONE = 0;
    public static final int CERTIFICATE_TYPE_X509 = 1;
    public static final int EVENT_PROVISION_REQUIRED = 1;
    public static final int EVENT_KEY_REQUIRED = 2;
    public static final int EVENT_KEY_EXPIRED = 3;
    public static final int EVENT_VENDOR_DEFINED = 4;
    public static final int EVENT_SESSION_RECLAIMED = 5;
    private static final int DRM_EVENT = 200;
    private static final int EXPIRATION_UPDATE = 201;
    private static final int KEY_STATUS_CHANGE = 202;
    private static final int SESSION_LOST_STATE = 203;
    private final Map<Integer, ListenerWithExecutor> mListenerMap = new ConcurrentHashMap<Integer, ListenerWithExecutor>();
    private final Map<ByteBuffer, PlaybackComponent> mPlaybackComponentMap = new ConcurrentHashMap<ByteBuffer, PlaybackComponent>();
    public static final int KEY_TYPE_STREAMING = 1;
    public static final int KEY_TYPE_OFFLINE = 2;
    public static final int KEY_TYPE_RELEASE = 3;
    public static final int OFFLINE_LICENSE_STATE_UNKNOWN = 0;
    public static final int OFFLINE_LICENSE_STATE_USABLE = 1;
    public static final int OFFLINE_LICENSE_STATE_RELEASED = 2;
    public static final int HDCP_LEVEL_UNKNOWN = 0;
    public static final int HDCP_NONE = 1;
    public static final int HDCP_V1 = 2;
    public static final int HDCP_V2 = 3;
    public static final int HDCP_V2_1 = 4;
    public static final int HDCP_V2_2 = 5;
    public static final int HDCP_V2_3 = 6;
    public static final int HDCP_NO_DIGITAL_OUTPUT = Integer.MAX_VALUE;
    public static final int SECURITY_LEVEL_UNKNOWN = 0;
    public static final int SECURITY_LEVEL_SW_SECURE_CRYPTO = 1;
    public static final int SECURITY_LEVEL_SW_SECURE_DECODE = 2;
    public static final int SECURITY_LEVEL_HW_SECURE_CRYPTO = 3;
    public static final int SECURITY_LEVEL_HW_SECURE_DECODE = 4;
    public static final int SECURITY_LEVEL_HW_SECURE_ALL = 5;
    public static final int SECURITY_LEVEL_MAX = 6;
    public static final String PROPERTY_VENDOR = "vendor";
    public static final String PROPERTY_VERSION = "version";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_ALGORITHMS = "algorithms";
    public static final String PROPERTY_DEVICE_UNIQUE_ID = "deviceUniqueId";

    public static boolean isCryptoSchemeSupported(UUID uuid) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uuid), null, 0);
    }

    public static boolean isCryptoSchemeSupported(UUID uuid, String mimeType) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uuid), mimeType, 0);
    }

    public static boolean isCryptoSchemeSupported(UUID uuid, String mimeType, int securityLevel) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uuid), mimeType, securityLevel);
    }

    public static List<UUID> getSupportedCryptoSchemes() {
        byte[] uuidBytes = MediaDrm.getSupportedCryptoSchemesNative();
        return MediaDrm.getUUIDsFromByteArray(uuidBytes);
    }

    private static byte[] getByteArrayFromUUID(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] uuidBytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
            uuidBytes[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    private static UUID getUUIDFromByteArray(byte[] uuidBytes, int off) {
        long msb = 0L;
        long lsb = 0L;
        for (int i = 0; i < 8; ++i) {
            msb = msb << 8 | 0xFFL & (long)uuidBytes[off + i];
            lsb = lsb << 8 | 0xFFL & (long)uuidBytes[off + i + 8];
        }
        return new UUID(msb, lsb);
    }

    private static List<UUID> getUUIDsFromByteArray(byte[] uuidBytes) {
        LinkedHashSet<UUID> uuids = new LinkedHashSet<UUID>();
        for (int off = 0; off < uuidBytes.length; off += 16) {
            uuids.add(MediaDrm.getUUIDFromByteArray(uuidBytes, off));
        }
        return new ArrayList<UUID>(uuids);
    }

    private static byte[] getSupportedCryptoSchemesNative() {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#getSupportedCryptoSchemesNative()[B", true, null);
    }

    private static boolean isCryptoSchemeSupportedNative(byte[] byArray, String string2, int n) {
        return OverrideMethod.invokeI("android.media.MediaDrm#isCryptoSchemeSupportedNative([BLjava/lang/String;I)Z", true, null) != 0;
    }

    private Handler createHandler() {
        Looper looper = Looper.myLooper();
        Handler handler = looper != null ? new Handler(looper) : ((looper = Looper.getMainLooper()) != null ? new Handler(looper) : null);
        return handler;
    }

    public MediaDrm(UUID uuid) throws UnsupportedSchemeException {
        this.mAppPackageName = ActivityThread.currentOpPackageName();
        this.native_setup(new WeakReference<MediaDrm>(this), MediaDrm.getByteArrayFromUUID(uuid), this.mAppPackageName);
        this.mCloseGuard.open("release");
    }

    public void setOnExpirationUpdateListener(OnExpirationUpdateListener listener2, Handler handler) {
        this.setListenerWithHandler(201, handler, listener2, this::createOnExpirationUpdateListener);
    }

    public void setOnExpirationUpdateListener(Executor executor, OnExpirationUpdateListener listener2) {
        this.setListenerWithExecutor(201, executor, listener2, this::createOnExpirationUpdateListener);
    }

    public void clearOnExpirationUpdateListener() {
        this.clearGenericListener(201);
    }

    public void setOnKeyStatusChangeListener(OnKeyStatusChangeListener listener2, Handler handler) {
        this.setListenerWithHandler(202, handler, listener2, this::createOnKeyStatusChangeListener);
    }

    public void setOnKeyStatusChangeListener(Executor executor, OnKeyStatusChangeListener listener2) {
        this.setListenerWithExecutor(202, executor, listener2, this::createOnKeyStatusChangeListener);
    }

    public void clearOnKeyStatusChangeListener() {
        this.clearGenericListener(202);
    }

    public void setOnSessionLostStateListener(OnSessionLostStateListener listener2, Handler handler) {
        this.setListenerWithHandler(203, handler, listener2, this::createOnSessionLostStateListener);
    }

    public void setOnSessionLostStateListener(Executor executor, OnSessionLostStateListener listener2) {
        this.setListenerWithExecutor(203, executor, listener2, this::createOnSessionLostStateListener);
    }

    public void clearOnSessionLostStateListener() {
        this.clearGenericListener(203);
    }

    public void setOnEventListener(OnEventListener listener2) {
        this.setOnEventListener(listener2, null);
    }

    public void setOnEventListener(OnEventListener listener2, Handler handler) {
        this.setListenerWithHandler(200, handler, listener2, this::createOnEventListener);
    }

    public void setOnEventListener(Executor executor, OnEventListener listener2) {
        this.setListenerWithExecutor(200, executor, listener2, this::createOnEventListener);
    }

    public void clearOnEventListener() {
        this.clearGenericListener(200);
    }

    private <T> void setListenerWithHandler(int what, Handler handler, T listener2, Function<T, Consumer<ListenerArgs>> converter) {
        if (listener2 == null) {
            this.clearGenericListener(what);
        } else {
            handler = handler == null ? this.createHandler() : handler;
            HandlerExecutor executor = new HandlerExecutor(handler);
            this.setGenericListener(what, executor, listener2, converter);
        }
    }

    private <T> void setListenerWithExecutor(int what, Executor executor, T listener2, Function<T, Consumer<ListenerArgs>> converter) {
        if (executor == null || listener2 == null) {
            String errMsg = String.format("executor %s listener %s", executor, listener2);
            throw new IllegalArgumentException(errMsg);
        }
        this.setGenericListener(what, executor, listener2, converter);
    }

    private <T> void setGenericListener(int what, Executor executor, T listener2, Function<T, Consumer<ListenerArgs>> converter) {
        this.mListenerMap.put(what, new ListenerWithExecutor(executor, converter.apply(listener2)));
    }

    private void clearGenericListener(int what) {
        this.mListenerMap.remove(what);
    }

    private Consumer<ListenerArgs> createOnEventListener(OnEventListener listener2) {
        return args -> {
            byte[] data;
            byte[] sessionId = ((ListenerArgs)args).sessionId;
            if (sessionId.length == 0) {
                sessionId = null;
            }
            if ((data = ((ListenerArgs)args).data) != null && data.length == 0) {
                data = null;
            }
            Log.i(TAG, "Drm event (" + ((ListenerArgs)args).arg1 + "," + ((ListenerArgs)args).arg2 + ")");
            listener2.onEvent(this, sessionId, ((ListenerArgs)args).arg1, ((ListenerArgs)args).arg2, data);
        };
    }

    private Consumer<ListenerArgs> createOnKeyStatusChangeListener(OnKeyStatusChangeListener listener2) {
        return args -> {
            byte[] sessionId = ((ListenerArgs)args).sessionId;
            if (sessionId.length > 0) {
                List keyStatusList = ((ListenerArgs)args).keyStatusList;
                boolean hasNewUsableKey = ((ListenerArgs)args).hasNewUsableKey;
                Log.i(TAG, "Drm key status changed");
                listener2.onKeyStatusChange(this, sessionId, keyStatusList, hasNewUsableKey);
            }
        };
    }

    private Consumer<ListenerArgs> createOnExpirationUpdateListener(OnExpirationUpdateListener listener2) {
        return args -> {
            byte[] sessionId = ((ListenerArgs)args).sessionId;
            if (sessionId.length > 0) {
                long expirationTime = ((ListenerArgs)args).expirationTime;
                Log.i(TAG, "Drm key expiration update: " + expirationTime);
                listener2.onExpirationUpdate(this, sessionId, expirationTime);
            }
        };
    }

    private Consumer<ListenerArgs> createOnSessionLostStateListener(OnSessionLostStateListener listener2) {
        return args -> {
            byte[] sessionId = ((ListenerArgs)args).sessionId;
            Log.i(TAG, "Drm session lost state event: ");
            listener2.onSessionLostState(this, sessionId);
        };
    }

    private List<KeyStatus> keyStatusListFromParcel(Parcel parcel) {
        int nelems = parcel.readInt();
        ArrayList<KeyStatus> keyStatusList = new ArrayList<KeyStatus>(nelems);
        while (nelems-- > 0) {
            byte[] keyId = parcel.createByteArray();
            int keyStatusCode = parcel.readInt();
            keyStatusList.add(new KeyStatus(keyId, keyStatusCode));
        }
        return keyStatusList;
    }

    private static void postEventFromNative(Object mediadrm_ref, int what, int eventType, int extra, byte[] sessionId, byte[] data, long expirationTime, List<KeyStatus> keyStatusList, boolean hasNewUsableKey) {
        MediaDrm md = (MediaDrm)((WeakReference)mediadrm_ref).get();
        if (md == null) {
            return;
        }
        switch (what) {
            case 200: 
            case 201: 
            case 202: 
            case 203: {
                ListenerWithExecutor listener2 = md.mListenerMap.get(what);
                if (listener2 == null) break;
                Runnable command = () -> {
                    if (md.mNativeContext == 0L) {
                        Log.w(TAG, "MediaDrm went away with unhandled events");
                        return;
                    }
                    ListenerArgs args = new ListenerArgs(eventType, extra, sessionId, data, expirationTime, keyStatusList, hasNewUsableKey);
                    listener2.mConsumer.accept(args);
                };
                listener2.mExecutor.execute(command);
                break;
            }
            default: {
                Log.e(TAG, "Unknown message type " + what);
            }
        }
    }

    public byte[] openSession() throws NotProvisionedException, ResourceBusyException {
        return this.openSession(MediaDrm.getMaxSecurityLevel());
    }

    public byte[] openSession(int level) throws NotProvisionedException, ResourceBusyException {
        byte[] sessionId = this.openSessionNative(level);
        this.mPlaybackComponentMap.put(ByteBuffer.wrap(sessionId), new PlaybackComponent(sessionId));
        return sessionId;
    }

    private byte[] openSessionNative(int n) throws NotProvisionedException, ResourceBusyException {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#openSessionNative(I)[B", true, this);
    }

    public void closeSession(byte[] sessionId) {
        this.closeSessionNative(sessionId);
        this.mPlaybackComponentMap.remove(ByteBuffer.wrap(sessionId));
    }

    private void closeSessionNative(byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#closeSessionNative([B)V", true, this);
    }

    public KeyRequest getKeyRequest(byte[] scope, byte[] init2, String mimeType, int keyType, HashMap<String, String> optionalParameters) throws NotProvisionedException {
        HashMap<Object, Object> internalParams = optionalParameters == null ? new HashMap() : new HashMap<String, String>(optionalParameters);
        byte[] rawBytes = this.getNewestAvailablePackageCertificateRawBytes();
        byte[] hashBytes = null;
        if (rawBytes != null) {
            hashBytes = MediaDrm.getDigestBytes(rawBytes, "SHA-256");
        }
        if (hashBytes != null) {
            Base64.Encoder encoderB64 = Base64.getEncoder();
            String hashBytesB64 = encoderB64.encodeToString(hashBytes);
            internalParams.put("package_certificate_hash_bytes", hashBytesB64);
        }
        return this.getKeyRequestNative(scope, init2, mimeType, keyType, internalParams);
    }

    private byte[] getNewestAvailablePackageCertificateRawBytes() {
        Application application = ActivityThread.currentApplication();
        if (application == null) {
            Log.w(TAG, "pkg cert: Application is null");
            return null;
        }
        PackageManager pm = application.getPackageManager();
        if (pm == null) {
            Log.w(TAG, "pkg cert: PackageManager is null");
            return null;
        }
        PackageInfo packageInfo = null;
        try {
            packageInfo = pm.getPackageInfo(this.mAppPackageName, 0x8000000);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, this.mAppPackageName, e);
        }
        if (packageInfo == null || packageInfo.signingInfo == null) {
            Log.w(TAG, "pkg cert: PackageInfo or SigningInfo is null");
            return null;
        }
        Signature[] signers = packageInfo.signingInfo.getApkContentsSigners();
        if (signers != null && signers.length == 1) {
            return signers[0].toByteArray();
        }
        Log.w(TAG, "pkg cert: " + signers.length + " signers");
        return null;
    }

    private static byte[] getDigestBytes(byte[] rawBytes, String algorithm) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            return messageDigest.digest(rawBytes);
        }
        catch (NoSuchAlgorithmException e) {
            Log.w(TAG, algorithm, e);
            return null;
        }
    }

    private KeyRequest getKeyRequestNative(byte[] byArray, byte[] byArray2, String string2, int n, HashMap<String, String> hashMap) throws NotProvisionedException {
        return (KeyRequest)OverrideMethod.invokeA("android.media.MediaDrm#getKeyRequestNative([B[BLjava/lang/String;ILjava/util/HashMap;)Landroid/media/MediaDrm$KeyRequest;", true, this);
    }

    public byte[] provideKeyResponse(byte[] byArray, byte[] byArray2) throws NotProvisionedException, DeniedByServerException {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#provideKeyResponse([B[B)[B", true, this);
    }

    public void restoreKeys(byte[] byArray, byte[] byArray2) {
        OverrideMethod.invokeV("android.media.MediaDrm#restoreKeys([B[B)V", true, this);
    }

    public void removeKeys(byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#removeKeys([B)V", true, this);
    }

    public HashMap<String, String> queryKeyStatus(byte[] byArray) {
        return (HashMap)OverrideMethod.invokeA("android.media.MediaDrm#queryKeyStatus([B)Ljava/util/HashMap;", true, this);
    }

    public ProvisionRequest getProvisionRequest() {
        return this.getProvisionRequestNative(0, "");
    }

    private ProvisionRequest getProvisionRequestNative(int n, String string2) {
        return (ProvisionRequest)OverrideMethod.invokeA("android.media.MediaDrm#getProvisionRequestNative(ILjava/lang/String;)Landroid/media/MediaDrm$ProvisionRequest;", true, this);
    }

    public void provideProvisionResponse(byte[] response) throws DeniedByServerException {
        this.provideProvisionResponseNative(response);
    }

    private Certificate provideProvisionResponseNative(byte[] byArray) throws DeniedByServerException {
        return (Certificate)OverrideMethod.invokeA("android.media.MediaDrm#provideProvisionResponseNative([B)Landroid/media/MediaDrm$Certificate;", true, this);
    }

    public List<byte[]> getOfflineLicenseKeySetIds() {
        return (List)OverrideMethod.invokeA("android.media.MediaDrm#getOfflineLicenseKeySetIds()Ljava/util/List;", true, this);
    }

    public void removeOfflineLicense(byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#removeOfflineLicense([B)V", true, this);
    }

    public int getOfflineLicenseState(byte[] byArray) {
        return OverrideMethod.invokeI("android.media.MediaDrm#getOfflineLicenseState([B)I", true, this);
    }

    public List<byte[]> getSecureStops() {
        return (List)OverrideMethod.invokeA("android.media.MediaDrm#getSecureStops()Ljava/util/List;", true, this);
    }

    public List<byte[]> getSecureStopIds() {
        return (List)OverrideMethod.invokeA("android.media.MediaDrm#getSecureStopIds()Ljava/util/List;", true, this);
    }

    public byte[] getSecureStop(byte[] byArray) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#getSecureStop([B)[B", true, this);
    }

    public void releaseSecureStops(byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#releaseSecureStops([B)V", true, this);
    }

    public void removeSecureStop(byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#removeSecureStop([B)V", true, this);
    }

    public void removeAllSecureStops() {
        OverrideMethod.invokeV("android.media.MediaDrm#removeAllSecureStops()V", true, this);
    }

    public void releaseAllSecureStops() {
        this.removeAllSecureStops();
    }

    public int getConnectedHdcpLevel() {
        return OverrideMethod.invokeI("android.media.MediaDrm#getConnectedHdcpLevel()I", true, this);
    }

    public int getMaxHdcpLevel() {
        return OverrideMethod.invokeI("android.media.MediaDrm#getMaxHdcpLevel()I", true, this);
    }

    public int getOpenSessionCount() {
        return OverrideMethod.invokeI("android.media.MediaDrm#getOpenSessionCount()I", true, this);
    }

    public int getMaxSessionCount() {
        return OverrideMethod.invokeI("android.media.MediaDrm#getMaxSessionCount()I", true, this);
    }

    public static int getMaxSecurityLevel() {
        return 6;
    }

    public int getSecurityLevel(byte[] byArray) {
        return OverrideMethod.invokeI("android.media.MediaDrm#getSecurityLevel([B)I", true, this);
    }

    public String getPropertyString(String string2) {
        return (String)OverrideMethod.invokeA("android.media.MediaDrm#getPropertyString(Ljava/lang/String;)Ljava/lang/String;", true, this);
    }

    public void setPropertyString(String string2, String string3) {
        OverrideMethod.invokeV("android.media.MediaDrm#setPropertyString(Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }

    public byte[] getPropertyByteArray(String string2) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#getPropertyByteArray(Ljava/lang/String;)[B", true, this);
    }

    public void setPropertyByteArray(String string2, byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#setPropertyByteArray(Ljava/lang/String;[B)V", true, this);
    }

    private static void setCipherAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
        OverrideMethod.invokeV("android.media.MediaDrm#setCipherAlgorithmNative(Landroid/media/MediaDrm;[BLjava/lang/String;)V", true, null);
    }

    private static void setMacAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
        OverrideMethod.invokeV("android.media.MediaDrm#setMacAlgorithmNative(Landroid/media/MediaDrm;[BLjava/lang/String;)V", true, null);
    }

    private static byte[] encryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#encryptNative(Landroid/media/MediaDrm;[B[B[B[B)[B", true, null);
    }

    private static byte[] decryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#decryptNative(Landroid/media/MediaDrm;[B[B[B[B)[B", true, null);
    }

    private static byte[] signNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#signNative(Landroid/media/MediaDrm;[B[B[B)[B", true, null);
    }

    private static boolean verifyNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return OverrideMethod.invokeI("android.media.MediaDrm#verifyNative(Landroid/media/MediaDrm;[B[B[B[B)Z", true, null) != 0;
    }

    public PersistableBundle getMetrics() {
        PersistableBundle bundle = this.getMetricsNative();
        return bundle;
    }

    private PersistableBundle getMetricsNative() {
        return (PersistableBundle)OverrideMethod.invokeA("android.media.MediaDrm#getMetricsNative()Landroid/os/PersistableBundle;", true, this);
    }

    public CryptoSession getCryptoSession(byte[] sessionId, String cipherAlgorithm, String macAlgorithm) {
        return new CryptoSession(sessionId, cipherAlgorithm, macAlgorithm);
    }

    @UnsupportedAppUsage
    public CertificateRequest getCertificateRequest(int certType, String certAuthority) {
        ProvisionRequest provisionRequest = this.getProvisionRequestNative(certType, certAuthority);
        return new CertificateRequest(provisionRequest.getData(), provisionRequest.getDefaultUrl());
    }

    @UnsupportedAppUsage
    public Certificate provideCertificateResponse(byte[] response) throws DeniedByServerException {
        return this.provideProvisionResponseNative(response);
    }

    private static byte[] signRSANative(MediaDrm mediaDrm, byte[] byArray, String string2, byte[] byArray2, byte[] byArray3) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#signRSANative(Landroid/media/MediaDrm;[BLjava/lang/String;[B[B)[B", true, null);
    }

    @UnsupportedAppUsage
    public byte[] signRSA(byte[] sessionId, String algorithm, byte[] wrappedKey, byte[] message) {
        return MediaDrm.signRSANative(this, sessionId, algorithm, wrappedKey, message);
    }

    public boolean requiresSecureDecoder(String mime) {
        return this.requiresSecureDecoder(mime, MediaDrm.getMaxSecurityLevel());
    }

    public boolean requiresSecureDecoder(String string2, int n) {
        return OverrideMethod.invokeI("android.media.MediaDrm#requiresSecureDecoder(Ljava/lang/String;I)Z", true, this) != 0;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        this.release();
    }

    @Deprecated
    public void release() {
        this.mCloseGuard.close();
        if (this.mClosed.compareAndSet(false, true)) {
            this.native_release();
            this.mPlaybackComponentMap.clear();
        }
    }

    public void native_release() {
        OverrideMethod.invokeV("android.media.MediaDrm#native_release()V", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaDrm#native_init()V", true, null);
    }

    private void native_setup(Object object, byte[] byArray, String string2) {
        OverrideMethod.invokeV("android.media.MediaDrm#native_setup(Ljava/lang/Object;[BLjava/lang/String;)V", true, this);
    }

    public PlaybackComponent getPlaybackComponent(byte[] sessionId) {
        if (sessionId == null) {
            throw new IllegalArgumentException("sessionId is null");
        }
        return this.mPlaybackComponentMap.get(ByteBuffer.wrap(sessionId));
    }

    private void setPlaybackId(byte[] byArray, String string2) {
        OverrideMethod.invokeV("android.media.MediaDrm#setPlaybackId([BLjava/lang/String;)V", true, this);
    }

    public List<LogMessage> getLogMessages() {
        return (List)OverrideMethod.invokeA("android.media.MediaDrm#getLogMessages()Ljava/util/List;", true, this);
    }

    static {
        System_Delegate.loadLibrary("media_jni");
        MediaDrm.native_init();
    }

    public static class LogMessage {
        private final long timestampMillis;
        private final int priority;
        private final String message;

        public long getTimestampMillis() {
            return this.timestampMillis;
        }

        public int getPriority() {
            return this.priority;
        }

        public String getMessage() {
            return this.message;
        }

        private LogMessage(long timestampMillis, int priority, String message) {
            this.timestampMillis = timestampMillis;
            if (priority < 2 || priority > 7) {
                throw new IllegalArgumentException("invalid log priority " + priority);
            }
            this.priority = priority;
            this.message = message;
        }

        private char logPriorityChar() {
            switch (this.priority) {
                case 2: {
                    return 'V';
                }
                case 3: {
                    return 'D';
                }
                case 4: {
                    return 'I';
                }
                case 5: {
                    return 'W';
                }
                case 6: {
                    return 'E';
                }
                case 7: {
                    return 'F';
                }
            }
            return 'U';
        }

        public String toString() {
            return String.format("LogMessage{%s %c %s}", Instant.ofEpochMilli(this.timestampMillis), Character.valueOf(this.logPriorityChar()), this.message);
        }
    }

    public class PlaybackComponent {
        private final byte[] mSessionId;
        private LogSessionId mLogSessionId = LogSessionId.LOG_SESSION_ID_NONE;

        public PlaybackComponent(byte[] sessionId) {
            this.mSessionId = sessionId;
        }

        public void setLogSessionId(LogSessionId logSessionId) {
            Objects.requireNonNull(logSessionId);
            if (logSessionId.getStringId() == null) {
                throw new IllegalArgumentException("playbackId is null");
            }
            MediaDrm.this.setPlaybackId(this.mSessionId, logSessionId.getStringId());
            this.mLogSessionId = logSessionId;
        }

        public LogSessionId getLogSessionId() {
            return this.mLogSessionId;
        }
    }

    public static class MetricsConstants {
        public static final String OPEN_SESSION_OK_COUNT = "drm.mediadrm.open_session.ok.count";
        public static final String OPEN_SESSION_ERROR_COUNT = "drm.mediadrm.open_session.error.count";
        public static final String OPEN_SESSION_ERROR_LIST = "drm.mediadrm.open_session.error.list";
        public static final String CLOSE_SESSION_OK_COUNT = "drm.mediadrm.close_session.ok.count";
        public static final String CLOSE_SESSION_ERROR_COUNT = "drm.mediadrm.close_session.error.count";
        public static final String CLOSE_SESSION_ERROR_LIST = "drm.mediadrm.close_session.error.list";
        public static final String SESSION_START_TIMES_MS = "drm.mediadrm.session_start_times_ms";
        public static final String SESSION_END_TIMES_MS = "drm.mediadrm.session_end_times_ms";
        public static final String GET_KEY_REQUEST_OK_COUNT = "drm.mediadrm.get_key_request.ok.count";
        public static final String GET_KEY_REQUEST_ERROR_COUNT = "drm.mediadrm.get_key_request.error.count";
        public static final String GET_KEY_REQUEST_ERROR_LIST = "drm.mediadrm.get_key_request.error.list";
        public static final String GET_KEY_REQUEST_OK_TIME_MICROS = "drm.mediadrm.get_key_request.ok.average_time_micros";
        public static final String PROVIDE_KEY_RESPONSE_OK_COUNT = "drm.mediadrm.provide_key_response.ok.count";
        public static final String PROVIDE_KEY_RESPONSE_ERROR_COUNT = "drm.mediadrm.provide_key_response.error.count";
        public static final String PROVIDE_KEY_RESPONSE_ERROR_LIST = "drm.mediadrm.provide_key_response.error.list";
        public static final String PROVIDE_KEY_RESPONSE_OK_TIME_MICROS = "drm.mediadrm.provide_key_response.ok.average_time_micros";
        public static final String GET_PROVISION_REQUEST_OK_COUNT = "drm.mediadrm.get_provision_request.ok.count";
        public static final String GET_PROVISION_REQUEST_ERROR_COUNT = "drm.mediadrm.get_provision_request.error.count";
        public static final String GET_PROVISION_REQUEST_ERROR_LIST = "drm.mediadrm.get_provision_request.error.list";
        public static final String PROVIDE_PROVISION_RESPONSE_OK_COUNT = "drm.mediadrm.provide_provision_response.ok.count";
        public static final String PROVIDE_PROVISION_RESPONSE_ERROR_COUNT = "drm.mediadrm.provide_provision_response.error.count";
        public static final String PROVIDE_PROVISION_RESPONSE_ERROR_LIST = "drm.mediadrm.provide_provision_response.error.list";
        public static final String GET_DEVICE_UNIQUE_ID_OK_COUNT = "drm.mediadrm.get_device_unique_id.ok.count";
        public static final String GET_DEVICE_UNIQUE_ID_ERROR_COUNT = "drm.mediadrm.get_device_unique_id.error.count";
        public static final String GET_DEVICE_UNIQUE_ID_ERROR_LIST = "drm.mediadrm.get_device_unique_id.error.list";
        public static final String KEY_STATUS_EXPIRED_COUNT = "drm.mediadrm.key_status.EXPIRED.count";
        public static final String KEY_STATUS_INTERNAL_ERROR_COUNT = "drm.mediadrm.key_status.INTERNAL_ERROR.count";
        public static final String KEY_STATUS_OUTPUT_NOT_ALLOWED_COUNT = "drm.mediadrm.key_status_change.OUTPUT_NOT_ALLOWED.count";
        public static final String KEY_STATUS_PENDING_COUNT = "drm.mediadrm.key_status_change.PENDING.count";
        public static final String KEY_STATUS_USABLE_COUNT = "drm.mediadrm.key_status_change.USABLE.count";
        public static final String EVENT_PROVISION_REQUIRED_COUNT = "drm.mediadrm.event.PROVISION_REQUIRED.count";
        public static final String EVENT_KEY_NEEDED_COUNT = "drm.mediadrm.event.KEY_NEEDED.count";
        public static final String EVENT_KEY_EXPIRED_COUNT = "drm.mediadrm.event.KEY_EXPIRED.count";
        public static final String EVENT_VENDOR_DEFINED_COUNT = "drm.mediadrm.event.VENDOR_DEFINED.count";
        public static final String EVENT_SESSION_RECLAIMED_COUNT = "drm.mediadrm.event.SESSION_RECLAIMED.count";

        private MetricsConstants() {
        }
    }

    public static class Certificate {
        private byte[] mWrappedKey;
        private byte[] mCertificateData;

        Certificate() {
        }

        @UnsupportedAppUsage
        public byte[] getWrappedPrivateKey() {
            if (this.mWrappedKey == null) {
                throw new RuntimeException("Certificate is not initialized");
            }
            return this.mWrappedKey;
        }

        @UnsupportedAppUsage
        public byte[] getContent() {
            if (this.mCertificateData == null) {
                throw new RuntimeException("Certificate is not initialized");
            }
            return this.mCertificateData;
        }
    }

    public static class CertificateRequest {
        private byte[] mData;
        private String mDefaultUrl;

        CertificateRequest(byte[] data, String defaultUrl) {
            this.mData = data;
            this.mDefaultUrl = defaultUrl;
        }

        @UnsupportedAppUsage
        public byte[] getData() {
            return this.mData;
        }

        @UnsupportedAppUsage
        public String getDefaultUrl() {
            return this.mDefaultUrl;
        }
    }

    public class CryptoSession {
        private byte[] mSessionId;

        CryptoSession(byte[] sessionId, String cipherAlgorithm, String macAlgorithm) {
            this.mSessionId = sessionId;
            MediaDrm.setCipherAlgorithmNative(MediaDrm.this, sessionId, cipherAlgorithm);
            MediaDrm.setMacAlgorithmNative(MediaDrm.this, sessionId, macAlgorithm);
        }

        public byte[] encrypt(byte[] keyid, byte[] input, byte[] iv) {
            return MediaDrm.encryptNative(MediaDrm.this, this.mSessionId, keyid, input, iv);
        }

        public byte[] decrypt(byte[] keyid, byte[] input, byte[] iv) {
            return MediaDrm.decryptNative(MediaDrm.this, this.mSessionId, keyid, input, iv);
        }

        public byte[] sign(byte[] keyid, byte[] message) {
            return MediaDrm.signNative(MediaDrm.this, this.mSessionId, keyid, message);
        }

        public boolean verify(byte[] keyid, byte[] message, byte[] signature) {
            return MediaDrm.verifyNative(MediaDrm.this, this.mSessionId, keyid, message, signature);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ArrayProperty {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StringProperty {
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityLevel {
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HdcpLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OfflineLicenseState {
    }

    public static class ProvisionRequest {
        private byte[] mData;
        private String mDefaultUrl;

        ProvisionRequest() {
        }

        public byte[] getData() {
            if (this.mData == null) {
                throw new RuntimeException("ProvisionRequest is not initialized");
            }
            return this.mData;
        }

        public String getDefaultUrl() {
            if (this.mDefaultUrl == null) {
                throw new RuntimeException("ProvisionRequest is not initialized");
            }
            return this.mDefaultUrl;
        }
    }

    public static class KeyRequest {
        private byte[] mData;
        private String mDefaultUrl;
        private int mRequestType;
        public static final int REQUEST_TYPE_INITIAL = 0;
        public static final int REQUEST_TYPE_RENEWAL = 1;
        public static final int REQUEST_TYPE_RELEASE = 2;
        public static final int REQUEST_TYPE_NONE = 3;
        public static final int REQUEST_TYPE_UPDATE = 4;

        KeyRequest() {
        }

        public byte[] getData() {
            if (this.mData == null) {
                throw new RuntimeException("KeyRequest is not initialized");
            }
            return this.mData;
        }

        public String getDefaultUrl() {
            if (this.mDefaultUrl == null) {
                throw new RuntimeException("KeyRequest is not initialized");
            }
            return this.mDefaultUrl;
        }

        public int getRequestType() {
            return this.mRequestType;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RequestType {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface KeyType {
    }

    private static class ListenerWithExecutor {
        private final Consumer<ListenerArgs> mConsumer;
        private final Executor mExecutor;

        public ListenerWithExecutor(Executor executor, Consumer<ListenerArgs> consumer) {
            this.mExecutor = executor;
            this.mConsumer = consumer;
        }
    }

    private static class ListenerArgs {
        private final int arg1;
        private final int arg2;
        private final byte[] sessionId;
        private final byte[] data;
        private final long expirationTime;
        private final List<KeyStatus> keyStatusList;
        private final boolean hasNewUsableKey;

        public ListenerArgs(int arg1, int arg2, byte[] sessionId, byte[] data, long expirationTime, List<KeyStatus> keyStatusList, boolean hasNewUsableKey) {
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.sessionId = sessionId;
            this.data = data;
            this.expirationTime = expirationTime;
            this.keyStatusList = keyStatusList;
            this.hasNewUsableKey = hasNewUsableKey;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DrmEvent {
    }

    public static interface OnEventListener {
        public void onEvent(MediaDrm var1, byte[] var2, int var3, int var4, byte[] var5);
    }

    public static class KeyStatus {
        private final byte[] mKeyId;
        private final int mStatusCode;
        public static final int STATUS_USABLE = 0;
        public static final int STATUS_EXPIRED = 1;
        public static final int STATUS_OUTPUT_NOT_ALLOWED = 2;
        public static final int STATUS_PENDING = 3;
        public static final int STATUS_INTERNAL_ERROR = 4;
        public static final int STATUS_USABLE_IN_FUTURE = 5;

        KeyStatus(byte[] keyId, int statusCode) {
            this.mKeyId = keyId;
            this.mStatusCode = statusCode;
        }

        public int getStatusCode() {
            return this.mStatusCode;
        }

        public byte[] getKeyId() {
            return this.mKeyId;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface KeyStatusCode {
        }
    }

    public static interface OnSessionLostStateListener {
        public void onSessionLostState(MediaDrm var1, byte[] var2);
    }

    public static interface OnKeyStatusChangeListener {
        public void onKeyStatusChange(MediaDrm var1, byte[] var2, List<KeyStatus> var3, boolean var4);
    }

    public static interface OnExpirationUpdateListener {
        public void onExpirationUpdate(MediaDrm var1, byte[] var2, long var3);
    }

    public static class SessionException
    extends RuntimeException {
        public static final int ERROR_UNKNOWN = 0;
        public static final int ERROR_RESOURCE_CONTENTION = 1;
        private final int mErrorCode;

        public SessionException(int errorCode, String detailMessage) {
            super(detailMessage);
            this.mErrorCode = errorCode;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        public boolean isTransient() {
            return this.mErrorCode == 1;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface SessionErrorCode {
        }
    }

    public static class MediaDrmStateException
    extends IllegalStateException {
        private final int mErrorCode;
        private final String mDiagnosticInfo;

        public MediaDrmStateException(int errorCode, String detailMessage) {
            super(detailMessage);
            this.mErrorCode = errorCode;
            String sign = errorCode < 0 ? "neg_" : "";
            this.mDiagnosticInfo = "android.media.MediaDrm.error_" + sign + Math.abs(errorCode);
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        public boolean isTransient() {
            return this.mErrorCode == 28 || this.mErrorCode == 29;
        }

        public String getDiagnosticInfo() {
            return this.mDiagnosticInfo;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaDrmErrorCode {
    }

    public static class ErrorCodes {
        public static final int ERROR_UNKNOWN = 0;
        public static final int ERROR_NO_KEY = 1;
        public static final int ERROR_KEY_EXPIRED = 2;
        public static final int ERROR_RESOURCE_BUSY = 3;
        public static final int ERROR_INSUFFICIENT_OUTPUT_PROTECTION = 4;
        public static final int ERROR_SESSION_NOT_OPENED = 5;
        public static final int ERROR_UNSUPPORTED_OPERATION = 6;
        public static final int ERROR_INSUFFICIENT_SECURITY = 7;
        public static final int ERROR_FRAME_TOO_LARGE = 8;
        public static final int ERROR_LOST_STATE = 9;
        public static final int ERROR_CERTIFICATE_MALFORMED = 10;
        public static final int ERROR_CERTIFICATE_MISSING = 11;
        public static final int ERROR_CRYPTO_LIBRARY = 12;
        public static final int ERROR_GENERIC_OEM = 13;
        public static final int ERROR_GENERIC_PLUGIN = 14;
        public static final int ERROR_INIT_DATA = 15;
        public static final int ERROR_KEY_NOT_LOADED = 16;
        public static final int ERROR_LICENSE_PARSE = 17;
        public static final int ERROR_LICENSE_POLICY = 18;
        public static final int ERROR_LICENSE_RELEASE = 19;
        public static final int ERROR_LICENSE_REQUEST_REJECTED = 20;
        public static final int ERROR_LICENSE_RESTORE = 21;
        public static final int ERROR_LICENSE_STATE = 22;
        public static final int ERROR_MEDIA_FRAMEWORK = 23;
        public static final int ERROR_PROVISIONING_CERTIFICATE = 24;
        public static final int ERROR_PROVISIONING_CONFIG = 25;
        public static final int ERROR_PROVISIONING_PARSE = 26;
        public static final int ERROR_PROVISIONING_REQUEST_REJECTED = 27;
        public static final int ERROR_PROVISIONING_RETRY = 28;
        public static final int ERROR_RESOURCE_CONTENTION = 29;
        public static final int ERROR_SECURE_STOP_RELEASE = 30;
        public static final int ERROR_STORAGE_READ = 31;
        public static final int ERROR_STORAGE_WRITE = 32;
        public static final int ERROR_ZERO_SUBSAMPLES = 33;

        private ErrorCodes() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CertificateType {
    }
}

