/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.GraphicBuffer;
import android.graphics.Rect;
import android.hardware.HardwareBuffer;
import android.hardware.camera2.MultiResolutionImageReader;
import android.media.Image;
import android.media.ImageReader_Delegate;
import android.media.ImageUtils;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.java.NioUtils_Delegate;
import dalvik.system.VMRuntime;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class ImageReader
implements AutoCloseable {
    private static final int ACQUIRE_SUCCESS = 0;
    private static final int ACQUIRE_NO_BUFS = 1;
    private static final int ACQUIRE_MAX_IMAGES = 2;
    private final int mWidth;
    private final int mHeight;
    private final int mFormat;
    private final long mUsage;
    private final int mMaxImages;
    private final int mNumPlanes;
    private final Surface mSurface;
    private int mEstimatedNativeAllocBytes;
    private final Object mListenerLock = new Object();
    private final Object mCloseLock = new Object();
    private boolean mIsReaderValid = false;
    private OnImageAvailableListener mListener;
    private Executor mListenerExecutor;
    private ListenerHandler mListenerHandler;
    private List<Image> mAcquiredImages = new CopyOnWriteArrayList<Image>();
    private final MultiResolutionImageReader mParent;
    private long mNativeContext;

    public static ImageReader newInstance(int width, int height, int format, int maxImages) {
        return new ImageReader(width, height, format, maxImages, format == 34 ? 0L : 3L, null);
    }

    public static ImageReader newInstance(int width, int height, int format, int maxImages, long usage) {
        return new ImageReader(width, height, format, maxImages, usage, null);
    }

    public static ImageReader newInstance(int width, int height, int format, int maxImages, MultiResolutionImageReader parent) {
        return new ImageReader(width, height, format, maxImages, format == 34 ? 0L : 3L, parent);
    }

    protected ImageReader(int width, int height, int format, int maxImages, long usage, MultiResolutionImageReader parent) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        this.mUsage = usage;
        this.mMaxImages = maxImages;
        this.mParent = parent;
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("The image dimensions must be positive");
        }
        if (this.mMaxImages < 1) {
            throw new IllegalArgumentException("Maximum outstanding image count must be at least 1");
        }
        if (format == 17) {
            throw new IllegalArgumentException("NV21 format is not supported");
        }
        this.mNumPlanes = ImageUtils.getNumPlanesForFormat(this.mFormat);
        this.nativeInit(new WeakReference<ImageReader>(this), width, height, format, maxImages, usage);
        this.mSurface = this.nativeGetSurface();
        this.mIsReaderValid = true;
        this.mEstimatedNativeAllocBytes = ImageUtils.getEstimatedNativeAllocBytes(width, height, format, 1);
        VMRuntime.getRuntime().registerNativeAllocation(this.mEstimatedNativeAllocBytes);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getImageFormat() {
        return this.mFormat;
    }

    public int getMaxImages() {
        return this.mMaxImages;
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    public Image acquireLatestImage() {
        Image image = this.acquireNextImage();
        if (image == null) {
            return null;
        }
        try {
            while (true) {
                Image next;
                if ((next = this.acquireNextImageNoThrowISE()) == null) {
                    Image result = image;
                    image = null;
                    Image image2 = result;
                    return image2;
                }
                image.close();
                image = next;
            }
        }
        finally {
            if (image != null) {
                image.close();
            }
            if (this.mParent != null) {
                this.mParent.flushOther(this);
            }
        }
    }

    public Image acquireNextImageNoThrowISE() {
        SurfaceImage si = new SurfaceImage(this.mFormat);
        return this.acquireNextSurfaceImage(si) == 0 ? si : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquireNextSurfaceImage(SurfaceImage si) {
        Object object = this.mCloseLock;
        synchronized (object) {
            int status = 1;
            if (this.mIsReaderValid) {
                status = this.nativeImageSetup(si);
            }
            switch (status) {
                case 0: {
                    si.mIsImageValid = true;
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown nativeImageSetup return code " + status));
                }
            }
            if (status == 0) {
                this.mAcquiredImages.add(si);
            }
            return status;
        }
    }

    public Image acquireNextImage() {
        SurfaceImage si = new SurfaceImage(this.mFormat);
        int status = this.acquireNextSurfaceImage(si);
        switch (status) {
            case 0: {
                return si;
            }
            case 1: {
                return null;
            }
            case 2: {
                throw new IllegalStateException(String.format("maxImages (%d) has already been acquired, call #close before acquiring more.", this.mMaxImages));
            }
        }
        throw new AssertionError((Object)("Unknown nativeImageSetup return code " + status));
    }

    private void releaseImage(Image i) {
        if (!(i instanceof SurfaceImage)) {
            throw new IllegalArgumentException("This image was not produced by an ImageReader");
        }
        SurfaceImage si = (SurfaceImage)i;
        if (!si.mIsImageValid) {
            return;
        }
        if (si.getReader() != this || !this.mAcquiredImages.contains(i)) {
            throw new IllegalArgumentException("This image was not produced by this ImageReader");
        }
        si.clearSurfacePlanes();
        this.nativeReleaseImage(i);
        si.mIsImageValid = false;
        this.mAcquiredImages.remove(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnImageAvailableListener(OnImageAvailableListener listener2, Handler handler) {
        Object object = this.mListenerLock;
        synchronized (object) {
            if (listener2 != null) {
                Looper looper;
                Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
                if (looper == null) {
                    throw new IllegalArgumentException("handler is null but the current thread is not a looper");
                }
                if (this.mListenerHandler == null || this.mListenerHandler.getLooper() != looper) {
                    this.mListenerHandler = new ListenerHandler(looper);
                    this.mListenerExecutor = new HandlerExecutor(this.mListenerHandler);
                }
            } else {
                this.mListenerHandler = null;
                this.mListenerExecutor = null;
            }
            this.mListener = listener2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnImageAvailableListenerWithExecutor(OnImageAvailableListener listener2, Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mListenerExecutor = executor;
            this.mListener = listener2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.setOnImageAvailableListener(null, null);
        if (this.mSurface != null) {
            this.mSurface.release();
        }
        Object object = this.mCloseLock;
        synchronized (object) {
            this.mIsReaderValid = false;
            for (Image image : this.mAcquiredImages) {
                image.close();
            }
            this.mAcquiredImages.clear();
            this.nativeClose();
            if (this.mEstimatedNativeAllocBytes > 0) {
                VMRuntime.getRuntime().registerNativeFree(this.mEstimatedNativeAllocBytes);
                this.mEstimatedNativeAllocBytes = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardFreeBuffers() {
        Object object = this.mCloseLock;
        synchronized (object) {
            this.nativeDiscardFreeBuffers();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void detachImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("input image must not be null");
        }
        if (!this.isImageOwnedbyMe(image)) {
            throw new IllegalArgumentException("Trying to detach an image that is not owned by this ImageReader");
        }
        SurfaceImage si = (SurfaceImage)image;
        si.throwISEIfImageIsInvalid();
        if (si.isAttachable()) {
            throw new IllegalStateException("Image was already detached from this ImageReader");
        }
        this.nativeDetachImage(image);
        si.clearSurfacePlanes();
        SurfaceImage.access$102(si, null);
        si.setDetached(true);
    }

    private boolean isImageOwnedbyMe(Image image) {
        if (!(image instanceof SurfaceImage)) {
            return false;
        }
        SurfaceImage si = (SurfaceImage)image;
        return si.getReader() == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postEventFromNative(Object selfRef) {
        boolean isReaderValid;
        OnImageAvailableListener listener2;
        Executor executor;
        WeakReference weakSelf = (WeakReference)selfRef;
        final ImageReader ir = (ImageReader)weakSelf.get();
        if (ir == null) {
            return;
        }
        Object object = ir.mListenerLock;
        synchronized (object) {
            executor = ir.mListenerExecutor;
            listener2 = ir.mListener;
        }
        Object object2 = ir.mCloseLock;
        synchronized (object2) {
            isReaderValid = ir.mIsReaderValid;
        }
        if (executor != null && listener2 != null && isReaderValid) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener2.onImageAvailable(ir);
                }
            });
        }
    }

    private synchronized native void nativeInit(Object var1, int var2, int var3, int var4, int var5, long var6);

    private synchronized native void nativeClose();

    private synchronized native void nativeReleaseImage(Image var1);

    private synchronized native Surface nativeGetSurface();

    private synchronized native int nativeDetachImage(Image var1);

    private synchronized native void nativeDiscardFreeBuffers();

    private synchronized native int nativeImageSetup(Image var1);

    public static ImagePlane[] initializeImagePlanes(int numPlanes, GraphicBuffer buffer, int fenceFd, int format, long timestamp, int transform, int scalingMode, Rect crop) {
        return ImageReader.nativeCreateImagePlanes(numPlanes, buffer, fenceFd, format, crop.left, crop.top, crop.right, crop.bottom);
    }

    private static synchronized native ImagePlane[] nativeCreateImagePlanes(int var0, GraphicBuffer var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static void unlockGraphicBuffer(GraphicBuffer buffer) {
        ImageReader.nativeUnlockGraphicBuffer(buffer);
    }

    private static synchronized native void nativeUnlockGraphicBuffer(GraphicBuffer var0);

    public static native void nativeClassInit();

    static {
        System_Delegate.loadLibrary("media_jni");
        ImageReader_Delegate.nativeClassInit();
    }

    public static class ImagePlane
    extends Image.Plane {
        private final int mPixelStride;
        private final int mRowStride;
        private ByteBuffer mBuffer;

        private ImagePlane(int rowStride, int pixelStride, ByteBuffer buffer) {
            this.mRowStride = rowStride;
            this.mPixelStride = pixelStride;
            this.mBuffer = buffer;
            this.mBuffer.order(ByteOrder.nativeOrder());
        }

        @Override
        public ByteBuffer getBuffer() {
            return this.mBuffer;
        }

        @Override
        public int getPixelStride() {
            return this.mPixelStride;
        }

        @Override
        public int getRowStride() {
            return this.mRowStride;
        }
    }

    private class SurfaceImage
    extends Image {
        private long mNativeBuffer;
        private long mTimestamp;
        private int mTransform;
        private int mScalingMode;
        private SurfacePlane[] mPlanes;
        private int mFormat = 0;
        private AtomicBoolean mIsDetached = new AtomicBoolean(false);

        public SurfaceImage(int format) {
            this.mFormat = format;
        }

        @Override
        public void close() {
            ImageReader.this.releaseImage(this);
        }

        public ImageReader getReader() {
            return ImageReader.this;
        }

        @Override
        public int getFormat() {
            this.throwISEIfImageIsInvalid();
            int readerFormat = ImageReader.this.getImageFormat();
            this.mFormat = readerFormat == 34 ? readerFormat : this.nativeGetFormat(readerFormat);
            return this.mFormat;
        }

        @Override
        public int getWidth() {
            int width;
            this.throwISEIfImageIsInvalid();
            switch (this.getFormat()) {
                case 36: 
                case 256: 
                case 257: 
                case 1212500294: 
                case 1768253795: {
                    width = ImageReader.this.getWidth();
                    break;
                }
                default: {
                    width = this.nativeGetWidth();
                }
            }
            return width;
        }

        @Override
        public int getHeight() {
            int height;
            this.throwISEIfImageIsInvalid();
            switch (this.getFormat()) {
                case 36: 
                case 256: 
                case 257: 
                case 1212500294: 
                case 1768253795: {
                    height = ImageReader.this.getHeight();
                    break;
                }
                default: {
                    height = this.nativeGetHeight();
                }
            }
            return height;
        }

        @Override
        public long getTimestamp() {
            this.throwISEIfImageIsInvalid();
            return this.mTimestamp;
        }

        @Override
        public int getTransform() {
            this.throwISEIfImageIsInvalid();
            return this.mTransform;
        }

        @Override
        public int getScalingMode() {
            this.throwISEIfImageIsInvalid();
            return this.mScalingMode;
        }

        @Override
        public int getPlaneCount() {
            this.throwISEIfImageIsInvalid();
            return ImageReader.this.mNumPlanes;
        }

        @Override
        public int getFenceFd() {
            this.throwISEIfImageIsInvalid();
            return this.nativeGetFenceFd();
        }

        @Override
        public HardwareBuffer getHardwareBuffer() {
            this.throwISEIfImageIsInvalid();
            return this.nativeGetHardwareBuffer();
        }

        @Override
        public void setTimestamp(long timestampNs) {
            this.throwISEIfImageIsInvalid();
            this.mTimestamp = timestampNs;
        }

        @Override
        public Image.Plane[] getPlanes() {
            this.throwISEIfImageIsInvalid();
            if (this.mPlanes == null) {
                this.mPlanes = this.nativeCreatePlanes(ImageReader.this.mNumPlanes, ImageReader.this.mFormat, ImageReader.this.mUsage);
            }
            return (Image.Plane[])this.mPlanes.clone();
        }

        protected final void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        @Override
        public boolean isAttachable() {
            this.throwISEIfImageIsInvalid();
            return this.mIsDetached.get();
        }

        @Override
        ImageReader getOwner() {
            this.throwISEIfImageIsInvalid();
            return ImageReader.this;
        }

        @Override
        long getNativeContext() {
            this.throwISEIfImageIsInvalid();
            return this.mNativeBuffer;
        }

        private void setDetached(boolean detached) {
            this.throwISEIfImageIsInvalid();
            this.mIsDetached.getAndSet(detached);
        }

        private void clearSurfacePlanes() {
            if (this.mIsImageValid && this.mPlanes != null) {
                for (int i = 0; i < this.mPlanes.length; ++i) {
                    if (this.mPlanes[i] == null) continue;
                    this.mPlanes[i].clearBuffer();
                    this.mPlanes[i] = null;
                }
            }
        }

        private synchronized native SurfacePlane[] nativeCreatePlanes(int var1, int var2, long var3);

        private synchronized native int nativeGetWidth();

        private synchronized native int nativeGetHeight();

        private synchronized native int nativeGetFormat(int var1);

        private synchronized native int nativeGetFenceFd();

        private synchronized native HardwareBuffer nativeGetHardwareBuffer();

        static /* synthetic */ SurfacePlane[] access$102(SurfaceImage x0, SurfacePlane[] x1) {
            x0.mPlanes = x1;
            return x1;
        }

        private class SurfacePlane
        extends Image.Plane {
            private final int mPixelStride;
            private final int mRowStride;
            private ByteBuffer mBuffer;

            private SurfacePlane(int rowStride, int pixelStride, ByteBuffer buffer) {
                this.mRowStride = rowStride;
                this.mPixelStride = pixelStride;
                this.mBuffer = buffer;
                this.mBuffer.order(ByteOrder.nativeOrder());
            }

            @Override
            public ByteBuffer getBuffer() {
                SurfaceImage.this.throwISEIfImageIsInvalid();
                return this.mBuffer;
            }

            @Override
            public int getPixelStride() {
                SurfaceImage.this.throwISEIfImageIsInvalid();
                if (ImageReader.this.mFormat == 36) {
                    throw new UnsupportedOperationException("getPixelStride is not supported for RAW_PRIVATE plane");
                }
                return this.mPixelStride;
            }

            @Override
            public int getRowStride() {
                SurfaceImage.this.throwISEIfImageIsInvalid();
                if (ImageReader.this.mFormat == 36) {
                    throw new UnsupportedOperationException("getRowStride is not supported for RAW_PRIVATE plane");
                }
                return this.mRowStride;
            }

            private void clearBuffer() {
                if (this.mBuffer == null) {
                    return;
                }
                if (this.mBuffer.isDirect()) {
                    NioUtils_Delegate.freeDirectBuffer(this.mBuffer);
                }
                this.mBuffer = null;
            }
        }
    }

    private class HandlerExecutor
    implements Executor {
        private final Handler mHandler;

        public HandlerExecutor(Handler handler) {
            this.mHandler = Objects.requireNonNull(handler);
        }

        @Override
        public void execute(Runnable command) {
            this.mHandler.post(command);
        }
    }

    private class ListenerHandler
    extends Handler {
        public ListenerHandler(Looper looper) {
            super(looper, null, true);
        }
    }

    public static interface OnImageAvailableListener {
        public void onImageAvailable(ImageReader var1);
    }
}

