/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.Session2Command;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;

public interface IMediaController2
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IMediaController2";

    public void notifyConnected(int var1, Bundle var2) throws RemoteException;

    public void notifyDisconnected(int var1) throws RemoteException;

    public void notifyPlaybackActiveChanged(int var1, boolean var2) throws RemoteException;

    public void sendSessionCommand(int var1, Session2Command var2, Bundle var3, ResultReceiver var4) throws RemoteException;

    public void cancelSessionCommand(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaController2 {
        static final int TRANSACTION_notifyConnected = 1;
        static final int TRANSACTION_notifyDisconnected = 2;
        static final int TRANSACTION_notifyPlaybackActiveChanged = 3;
        static final int TRANSACTION_sendSessionCommand = 4;
        static final int TRANSACTION_cancelSessionCommand = 5;

        public Stub() {
            this.attachInterface(this, IMediaController2.DESCRIPTOR);
        }

        public static IMediaController2 asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMediaController2.DESCRIPTOR);
            if (iin != null && iin instanceof IMediaController2) {
                return (IMediaController2)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMediaController2.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Bundle _arg1 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.notifyConnected(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.notifyDisconnected(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.notifyPlaybackActiveChanged(_arg0, _arg1);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Session2Command _arg1 = 0 != data.readInt() ? Session2Command.CREATOR.createFromParcel(data) : null;
                    Bundle _arg2 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    ResultReceiver _arg3 = 0 != data.readInt() ? ResultReceiver.CREATOR.createFromParcel(data) : null;
                    this.sendSessionCommand(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.cancelSessionCommand(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IMediaController2 impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IMediaController2 getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IMediaController2 {
            private IBinder mRemote;
            public static IMediaController2 sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMediaController2.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyConnected(int seq, Bundle connectionResult) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaController2.DESCRIPTOR);
                    _data.writeInt(seq);
                    if (connectionResult != null) {
                        _data.writeInt(1);
                        connectionResult.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyConnected(seq, connectionResult);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDisconnected(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaController2.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyDisconnected(seq);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyPlaybackActiveChanged(int seq, boolean playbackActive) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaController2.DESCRIPTOR);
                    _data.writeInt(seq);
                    _data.writeInt(playbackActive ? 1 : 0);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyPlaybackActiveChanged(seq, playbackActive);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSessionCommand(int seq, Session2Command command, Bundle args, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaController2.DESCRIPTOR);
                    _data.writeInt(seq);
                    if (command != null) {
                        _data.writeInt(1);
                        command.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (args != null) {
                        _data.writeInt(1);
                        args.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (resultReceiver != null) {
                        _data.writeInt(1);
                        resultReceiver.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendSessionCommand(seq, command, args, resultReceiver);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelSessionCommand(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaController2.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().cancelSessionCommand(seq);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaController2 {
        @Override
        public void notifyConnected(int seq, Bundle connectionResult) throws RemoteException {
        }

        @Override
        public void notifyDisconnected(int seq) throws RemoteException {
        }

        @Override
        public void notifyPlaybackActiveChanged(int seq, boolean playbackActive) throws RemoteException {
        }

        @Override
        public void sendSessionCommand(int seq, Session2Command command, Bundle args, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public void cancelSessionCommand(int seq) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

