/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.AudioRecordingConfiguration;
import android.media.AudioRecordingMonitor;
import android.media.AudioRecordingMonitorClient;
import android.media.AudioRecordingMonitorImpl;
import android.media.AudioRouting;
import android.media.AudioTimestamp;
import android.media.IAudioService;
import android.media.MediaRecorder;
import android.media.MediaSyncEvent;
import android.media.MicrophoneDirection;
import android.media.MicrophoneInfo;
import android.media.NativeRoutingEventHandlerDelegate;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioPolicy;
import android.media.metrics.LogSessionId;
import android.media.projection.MediaProjection;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class AudioRecord
implements AudioRouting,
MicrophoneDirection,
AudioRecordingMonitor,
AudioRecordingMonitorClient {
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int RECORDSTATE_STOPPED = 1;
    public static final int RECORDSTATE_RECORDING = 3;
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -2;
    public static final int ERROR_INVALID_OPERATION = -3;
    public static final int ERROR_DEAD_OBJECT = -6;
    private static final int AUDIORECORD_ERROR_SETUP_ZEROFRAMECOUNT = -16;
    private static final int AUDIORECORD_ERROR_SETUP_INVALIDCHANNELMASK = -17;
    private static final int AUDIORECORD_ERROR_SETUP_INVALIDFORMAT = -18;
    private static final int AUDIORECORD_ERROR_SETUP_INVALIDSOURCE = -19;
    private static final int AUDIORECORD_ERROR_SETUP_NATIVEINITFAILED = -20;
    private static final int NATIVE_EVENT_MARKER = 2;
    private static final int NATIVE_EVENT_NEW_POS = 3;
    private static final String TAG = "android.media.AudioRecord";
    public static final String SUBMIX_FIXED_VOLUME = "fixedVolume";
    public static final int READ_BLOCKING = 0;
    public static final int READ_NON_BLOCKING = 1;
    @UnsupportedAppUsage
    private long mNativeRecorderInJavaObj;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long mNativeCallbackCookie;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long mNativeDeviceCallback;
    private AudioPolicy mAudioCapturePolicy;
    private int mSampleRate;
    private int mChannelCount;
    private int mChannelMask;
    private int mChannelIndexMask;
    private int mAudioFormat;
    private int mRecordSource;
    private int mState = 0;
    private int mRecordingState = 1;
    private final Object mRecordingStateLock = new Object();
    private OnRecordPositionUpdateListener mPositionListener = null;
    private final Object mPositionListenerLock = new Object();
    private NativeEventHandler mEventHandler = null;
    @UnsupportedAppUsage
    private Looper mInitializationLooper = null;
    private int mNativeBufferSizeInBytes = 0;
    private int mSessionId = 0;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private AudioAttributes mAudioAttributes;
    private boolean mIsSubmixFullVolume = false;
    private LogSessionId mLogSessionId = LogSessionId.LOG_SESSION_ID_NONE;
    private final IBinder mICallBack = new Binder();
    private static final long MAX_SHARED_AUDIO_HISTORY_MS = 5000L;
    @GuardedBy(value={"mRoutingChangeListeners"})
    private ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> mRoutingChangeListeners = new ArrayMap();
    private AudioDeviceInfo mPreferredDevice = null;
    AudioRecordingMonitorImpl mRecordingInfoImpl = new AudioRecordingMonitorImpl(this);

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public AudioRecord(int audioSource, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes) throws IllegalArgumentException {
        this(new AudioAttributes.Builder().setInternalCapturePreset(audioSource).build(), new AudioFormat.Builder().setChannelMask(AudioRecord.getChannelMaskFromLegacyConfig(channelConfig, true)).setEncoding(audioFormat).setSampleRate(sampleRateInHz).build(), bufferSizeInBytes, 0);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public AudioRecord(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int sessionId) throws IllegalArgumentException {
        this(attributes, format, bufferSizeInBytes, sessionId, ActivityThread.currentApplication(), 0);
    }

    private AudioRecord(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int sessionId, Context context, int maxSharedAudioHistoryMs) throws IllegalArgumentException {
        AttributionSource attributionSource;
        this.mRecordingState = 1;
        if (attributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        if (format == null) {
            throw new IllegalArgumentException("Illegal null AudioFormat");
        }
        this.mInitializationLooper = Looper.myLooper();
        if (this.mInitializationLooper == null) {
            this.mInitializationLooper = Looper.getMainLooper();
        }
        if (attributes.getCapturePreset() == 8) {
            AudioAttributes.Builder filteredAttr = new AudioAttributes.Builder();
            for (String tag : attributes.getTags()) {
                if (tag.equalsIgnoreCase(SUBMIX_FIXED_VOLUME)) {
                    this.mIsSubmixFullVolume = true;
                    Log.v(TAG, "Will record from REMOTE_SUBMIX at full fixed volume");
                    continue;
                }
                filteredAttr.addTag(tag);
            }
            filteredAttr.setInternalCapturePreset(attributes.getCapturePreset());
            this.mAudioAttributes = filteredAttr.build();
        } else {
            this.mAudioAttributes = attributes;
        }
        int rate = format.getSampleRate();
        if (rate == 0) {
            rate = 0;
        }
        int encoding = 1;
        if ((format.getPropertySetMask() & 1) != 0) {
            encoding = format.getEncoding();
        }
        this.audioParamCheck(attributes.getCapturePreset(), rate, encoding);
        if ((format.getPropertySetMask() & 8) != 0) {
            this.mChannelIndexMask = format.getChannelIndexMask();
            this.mChannelCount = format.getChannelCount();
        }
        if ((format.getPropertySetMask() & 4) != 0) {
            this.mChannelMask = AudioRecord.getChannelMaskFromLegacyConfig(format.getChannelMask(), false);
            this.mChannelCount = format.getChannelCount();
        } else if (this.mChannelIndexMask == 0) {
            this.mChannelMask = AudioRecord.getChannelMaskFromLegacyConfig(1, false);
            this.mChannelCount = AudioFormat.channelCountFromInChannelMask(this.mChannelMask);
        }
        this.audioBuffSizeCheck(bufferSizeInBytes);
        AttributionSource attributionSource2 = attributionSource = context != null ? context.getAttributionSource() : AttributionSource.myAttributionSource();
        if (attributionSource.getPackageName() == null) {
            attributionSource = attributionSource.withPackageName("uid:" + Binder.getCallingUid());
        }
        int[] sampleRate = new int[]{this.mSampleRate};
        int[] session = new int[]{sessionId};
        try (AttributionSource.ScopedParcelState attributionSourceState = attributionSource.asScopedParcelState();){
            int initResult = this.native_setup(new WeakReference<AudioRecord>(this), this.mAudioAttributes, sampleRate, this.mChannelMask, this.mChannelIndexMask, this.mAudioFormat, this.mNativeBufferSizeInBytes, session, attributionSourceState.getParcel(), 0L, maxSharedAudioHistoryMs);
            if (initResult != 0) {
                AudioRecord.loge("Error code " + initResult + " when initializing native AudioRecord object.");
                return;
            }
        }
        this.mSampleRate = sampleRate[0];
        this.mSessionId = session[0];
        this.mState = 1;
    }

    AudioRecord(long nativeRecordInJavaObj) {
        this.mNativeRecorderInJavaObj = 0L;
        this.mNativeCallbackCookie = 0L;
        this.mNativeDeviceCallback = 0L;
        if (nativeRecordInJavaObj != 0L) {
            this.deferred_connect(nativeRecordInJavaObj);
        } else {
            this.mState = 0;
        }
    }

    private void unregisterAudioPolicyOnRelease(AudioPolicy audioPolicy) {
        this.mAudioCapturePolicy = audioPolicy;
    }

    void deferred_connect(long nativeRecordInJavaObj) {
        if (this.mState != 1) {
            int initResult;
            int[] session = new int[]{0};
            int[] rates = new int[]{0};
            try (AttributionSource.ScopedParcelState attributionSourceState = AttributionSource.myAttributionSource().asScopedParcelState();){
                initResult = this.native_setup(new WeakReference<AudioRecord>(this), null, rates, 0, 0, 0, 0, session, attributionSourceState.getParcel(), nativeRecordInJavaObj, 0);
            }
            if (initResult != 0) {
                AudioRecord.loge("Error code " + initResult + " when initializing native AudioRecord object.");
                return;
            }
            this.mSessionId = session[0];
            this.mState = 1;
        }
    }

    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttributes;
    }

    private static int getChannelMaskFromLegacyConfig(int inChannelConfig, boolean allowLegacyConfig) {
        int mask;
        switch (inChannelConfig) {
            case 1: 
            case 2: 
            case 16: {
                mask = 16;
                break;
            }
            case 3: 
            case 12: {
                mask = 12;
                break;
            }
            case 48: {
                mask = inChannelConfig;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported channel configuration.");
            }
        }
        if (!(allowLegacyConfig || inChannelConfig != 2 && inChannelConfig != 3)) {
            throw new IllegalArgumentException("Unsupported deprecated configuration.");
        }
        return mask;
    }

    private void audioParamCheck(int audioSource, int sampleRateInHz, int audioFormat) throws IllegalArgumentException {
        if (audioSource < 0 || audioSource > MediaRecorder.getAudioSourceMax() && audioSource != 1998 && audioSource != 1997 && audioSource != 1999) {
            throw new IllegalArgumentException("Invalid audio source " + audioSource);
        }
        this.mRecordSource = audioSource;
        if ((sampleRateInHz < AudioFormat.SAMPLE_RATE_HZ_MIN || sampleRateInHz > AudioFormat.SAMPLE_RATE_HZ_MAX) && sampleRateInHz != 0) {
            throw new IllegalArgumentException(sampleRateInHz + "Hz is not a supported sample rate.");
        }
        this.mSampleRate = sampleRateInHz;
        switch (audioFormat) {
            case 1: {
                this.mAudioFormat = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 21: 
            case 22: {
                this.mAudioFormat = audioFormat;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported sample encoding " + audioFormat + ". Should be ENCODING_PCM_8BIT, ENCODING_PCM_16BIT, ENCODING_PCM_24BIT_PACKED, ENCODING_PCM_32BIT, or ENCODING_PCM_FLOAT.");
            }
        }
    }

    private void audioBuffSizeCheck(int audioBufferSize) throws IllegalArgumentException {
        int frameSizeInBytes = this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat);
        if (audioBufferSize % frameSizeInBytes != 0 || audioBufferSize < 1) {
            throw new IllegalArgumentException("Invalid audio buffer size " + audioBufferSize + " (frame size " + frameSizeInBytes + ")");
        }
        this.mNativeBufferSizeInBytes = audioBufferSize;
    }

    public void release() {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.mAudioCapturePolicy != null) {
            AudioManager.unregisterAudioPolicyAsyncStatic((AudioPolicy)this.mAudioCapturePolicy);
            this.mAudioCapturePolicy = null;
        }
        this.native_release();
        this.mState = 0;
    }

    protected void finalize() {
        this.release();
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getAudioSource() {
        return this.mRecordSource;
    }

    public int getAudioFormat() {
        return this.mAudioFormat;
    }

    public int getChannelConfiguration() {
        return this.mChannelMask;
    }

    public AudioFormat getFormat() {
        AudioFormat.Builder builder2 = new AudioFormat.Builder().setSampleRate(this.mSampleRate).setEncoding(this.mAudioFormat);
        if (this.mChannelMask != 0) {
            builder2.setChannelMask(this.mChannelMask);
        }
        if (this.mChannelIndexMask != 0) {
            builder2.setChannelIndexMask(this.mChannelIndexMask);
        }
        return builder2.build();
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public int getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordingState() {
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            return this.mRecordingState;
        }
    }

    public int getBufferSizeInFrames() {
        return this.native_get_buffer_size_in_frames();
    }

    public int getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    public int getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    public int getTimestamp(AudioTimestamp outTimestamp, int timebase) {
        if (outTimestamp == null || timebase != 1 && timebase != 0) {
            throw new IllegalArgumentException();
        }
        return this.native_get_timestamp(outTimestamp, timebase);
    }

    public static int getMinBufferSize(int sampleRateInHz, int channelConfig, int audioFormat) {
        int channelCount = 0;
        switch (channelConfig) {
            case 1: 
            case 2: 
            case 16: {
                channelCount = 1;
                break;
            }
            case 3: 
            case 12: 
            case 48: {
                channelCount = 2;
                break;
            }
            default: {
                AudioRecord.loge("getMinBufferSize(): Invalid channel configuration.");
                return -2;
            }
        }
        int size = AudioRecord.native_get_min_buff_size(sampleRateInHz, channelCount, audioFormat);
        if (size == 0) {
            return -2;
        }
        if (size == -1) {
            return -1;
        }
        return size;
    }

    public int getAudioSessionId() {
        return this.mSessionId;
    }

    public boolean isPrivacySensitive() {
        return (this.mAudioAttributes.getAllFlags() & 0x2000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecording() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("startRecording() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            if (this.native_start(0, 0) == 0) {
                this.handleFullVolumeRec(true);
                this.mRecordingState = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecording(MediaSyncEvent syncEvent) throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("startRecording() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            if (this.native_start(syncEvent.getType(), syncEvent.getAudioSessionId()) == 0) {
                this.handleFullVolumeRec(true);
                this.mRecordingState = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            this.handleFullVolumeRec(false);
            this.native_stop();
            this.mRecordingState = 1;
        }
    }

    private void handleFullVolumeRec(boolean starting) {
        if (!this.mIsSubmixFullVolume) {
            return;
        }
        IBinder b = ServiceManager.getService("audio");
        IAudioService ias = IAudioService.Stub.asInterface(b);
        try {
            ias.forceRemoteSubmixFullVolume(starting, this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to AudioService when handling full submix volume", e);
        }
    }

    public int read(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        return this.read(audioData, offsetInBytes, sizeInBytes, 0);
    }

    public int read(byte[] audioData, int offsetInBytes, int sizeInBytes, int readMode) {
        if (this.mState != 1 || this.mAudioFormat == 4) {
            return -3;
        }
        if (readMode != 0 && readMode != 1) {
            Log.e(TAG, "AudioRecord.read() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInBytes < 0 || sizeInBytes < 0 || offsetInBytes + sizeInBytes < 0 || offsetInBytes + sizeInBytes > audioData.length) {
            return -2;
        }
        return this.native_read_in_byte_array(audioData, offsetInBytes, sizeInBytes, readMode == 0);
    }

    public int read(short[] audioData, int offsetInShorts, int sizeInShorts) {
        return this.read(audioData, offsetInShorts, sizeInShorts, 0);
    }

    public int read(short[] audioData, int offsetInShorts, int sizeInShorts, int readMode) {
        if (this.mState != 1 || this.mAudioFormat == 4 || this.mAudioFormat > 20) {
            return -3;
        }
        if (readMode != 0 && readMode != 1) {
            Log.e(TAG, "AudioRecord.read() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInShorts < 0 || sizeInShorts < 0 || offsetInShorts + sizeInShorts < 0 || offsetInShorts + sizeInShorts > audioData.length) {
            return -2;
        }
        return this.native_read_in_short_array(audioData, offsetInShorts, sizeInShorts, readMode == 0);
    }

    public int read(float[] audioData, int offsetInFloats, int sizeInFloats, int readMode) {
        if (this.mState == 0) {
            Log.e(TAG, "AudioRecord.read() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (this.mAudioFormat != 4) {
            Log.e(TAG, "AudioRecord.read(float[] ...) requires format ENCODING_PCM_FLOAT");
            return -3;
        }
        if (readMode != 0 && readMode != 1) {
            Log.e(TAG, "AudioRecord.read() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInFloats < 0 || sizeInFloats < 0 || offsetInFloats + sizeInFloats < 0 || offsetInFloats + sizeInFloats > audioData.length) {
            return -2;
        }
        return this.native_read_in_float_array(audioData, offsetInFloats, sizeInFloats, readMode == 0);
    }

    public int read(ByteBuffer audioBuffer, int sizeInBytes) {
        return this.read(audioBuffer, sizeInBytes, 0);
    }

    public int read(ByteBuffer audioBuffer, int sizeInBytes, int readMode) {
        if (this.mState != 1) {
            return -3;
        }
        if (readMode != 0 && readMode != 1) {
            Log.e(TAG, "AudioRecord.read() called with invalid blocking mode");
            return -2;
        }
        if (audioBuffer == null || sizeInBytes < 0) {
            return -2;
        }
        return this.native_read_in_direct_buffer(audioBuffer, sizeInBytes, readMode == 0);
    }

    public PersistableBundle getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private PersistableBundle native_getMetrics() {
        return (PersistableBundle)OverrideMethod.invokeA("android.media.AudioRecord#native_getMetrics()Landroid/os/PersistableBundle;", true, this);
    }

    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener listener2) {
        this.setRecordPositionUpdateListener(listener2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener listener2, Handler handler) {
        Object object = this.mPositionListenerLock;
        synchronized (object) {
            this.mPositionListener = listener2;
            this.mEventHandler = listener2 != null ? (handler != null ? new NativeEventHandler(this, handler.getLooper()) : new NativeEventHandler(this, this.mInitializationLooper)) : null;
        }
    }

    public int setNotificationMarkerPosition(int markerInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_marker_pos(markerInFrames);
    }

    @Override
    public AudioDeviceInfo getRoutedDevice() {
        int deviceId = this.native_getRoutedDeviceId();
        if (deviceId == 0) {
            return null;
        }
        return AudioManager.getDeviceForPortId((int)deviceId, (int)1);
    }

    @SystemApi
    public static long getMaxSharedAudioHistoryMillis() {
        return 5000L;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CAPTURE_AUDIO_HOTWORD")
    public MediaSyncEvent shareAudioHistory(String sharedPackage, long startFromMillis) {
        Objects.requireNonNull(sharedPackage);
        if (startFromMillis < 0L) {
            throw new IllegalArgumentException("Illegal negative sharedAudioHistoryMs argument");
        }
        int status = this.native_shareAudioHistory(sharedPackage, startFromMillis);
        if (status == -2) {
            throw new IllegalArgumentException("Illegal sharedAudioHistoryMs argument");
        }
        if (status == -4) {
            throw new SecurityException("permission CAPTURE_AUDIO_HOTWORD required");
        }
        MediaSyncEvent event = MediaSyncEvent.createEvent(100);
        event.setAudioSessionId(this.mSessionId);
        return event;
    }

    @GuardedBy(value={"mRoutingChangeListeners"})
    private void testEnableNativeRoutingCallbacksLocked() {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_enableDeviceCallback();
        }
    }

    @GuardedBy(value={"mRoutingChangeListeners"})
    private void testDisableNativeRoutingCallbacksLocked() {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_disableDeviceCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener2, Handler handler) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (listener2 != null && !this.mRoutingChangeListeners.containsKey(listener2)) {
                this.testEnableNativeRoutingCallbacksLocked();
                this.mRoutingChangeListeners.put(listener2, new NativeRoutingEventHandlerDelegate(this, listener2, handler != null ? handler : new Handler(this.mInitializationLooper)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener2) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (this.mRoutingChangeListeners.containsKey(listener2)) {
                this.mRoutingChangeListeners.remove(listener2);
                this.testDisableNativeRoutingCallbacksLocked();
            }
        }
    }

    @Deprecated
    public void addOnRoutingChangedListener(OnRoutingChangedListener listener2, Handler handler) {
        this.addOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)listener2, handler);
    }

    @Deprecated
    public void removeOnRoutingChangedListener(OnRoutingChangedListener listener2) {
        this.removeOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastRoutingChange() {
        AudioManager.resetAudioPortGeneration();
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            for (NativeRoutingEventHandlerDelegate delegate : this.mRoutingChangeListeners.values()) {
                delegate.notifyClient();
            }
        }
    }

    public int setPositionNotificationPeriod(int periodInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_pos_update_period(periodInFrames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPreferredDevice(AudioDeviceInfo deviceInfo) {
        if (deviceInfo != null && !deviceInfo.isSource()) {
            return false;
        }
        int preferredDeviceId = deviceInfo != null ? deviceInfo.getId() : 0;
        boolean status = this.native_setInputDevice(preferredDeviceId);
        if (status) {
            AudioRecord audioRecord = this;
            synchronized (audioRecord) {
                this.mPreferredDevice = deviceInfo;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioDeviceInfo getPreferredDevice() {
        AudioRecord audioRecord = this;
        synchronized (audioRecord) {
            return this.mPreferredDevice;
        }
    }

    public List<MicrophoneInfo> getActiveMicrophones() throws IOException {
        AudioDeviceInfo device;
        ArrayList<MicrophoneInfo> activeMicrophones = new ArrayList<MicrophoneInfo>();
        int status = this.native_get_active_microphones(activeMicrophones);
        if (status != 0) {
            if (status != -3) {
                Log.e(TAG, "getActiveMicrophones failed:" + status);
            }
            Log.i(TAG, "getActiveMicrophones failed, fallback on routed device info");
        }
        AudioManager.setPortIdForMicrophones(activeMicrophones);
        if (activeMicrophones.size() == 0 && (device = this.getRoutedDevice()) != null) {
            MicrophoneInfo microphone = AudioManager.microphoneInfoFromAudioDeviceInfo((AudioDeviceInfo)device);
            ArrayList<Pair<Integer, Integer>> channelMapping = new ArrayList<Pair<Integer, Integer>>();
            for (int i = 0; i < this.mChannelCount; ++i) {
                channelMapping.add(new Pair<Integer, Integer>(i, 1));
            }
            microphone.setChannelMapping(channelMapping);
            activeMicrophones.add(microphone);
        }
        return activeMicrophones;
    }

    @Override
    public void registerAudioRecordingCallback(Executor executor, AudioManager.AudioRecordingCallback cb) {
        this.mRecordingInfoImpl.registerAudioRecordingCallback(executor, cb);
    }

    @Override
    public void unregisterAudioRecordingCallback(AudioManager.AudioRecordingCallback cb) {
        this.mRecordingInfoImpl.unregisterAudioRecordingCallback(cb);
    }

    @Override
    public AudioRecordingConfiguration getActiveRecordingConfiguration() {
        return this.mRecordingInfoImpl.getActiveRecordingConfiguration();
    }

    @Override
    public int getPortId() {
        if (this.mNativeRecorderInJavaObj == 0L) {
            return 0;
        }
        try {
            return this.native_getPortId();
        }
        catch (IllegalStateException e) {
            return 0;
        }
    }

    @Override
    public boolean setPreferredMicrophoneDirection(int direction) {
        return this.native_set_preferred_microphone_direction(direction) == 0;
    }

    @Override
    public boolean setPreferredMicrophoneFieldDimension(float zoom) {
        Preconditions.checkArgument(zoom >= -1.0f && zoom <= 1.0f, "Argument must fall between -1 & 1 (inclusive)");
        return this.native_set_preferred_microphone_field_dimension(zoom) == 0;
    }

    public void setLogSessionId(LogSessionId logSessionId) {
        Objects.requireNonNull(logSessionId);
        if (this.mState == 0) {
            throw new IllegalStateException("AudioRecord not initialized");
        }
        String stringId = logSessionId.getStringId();
        this.native_setLogSessionId(stringId);
        this.mLogSessionId = logSessionId;
    }

    public LogSessionId getLogSessionId() {
        return this.mLogSessionId;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static void postEventFromNative(Object audiorecord_ref, int what, int arg1, int arg2, Object obj) {
        AudioRecord recorder = (AudioRecord)((WeakReference)audiorecord_ref).get();
        if (recorder == null) {
            return;
        }
        if (what == 1000) {
            recorder.broadcastRoutingChange();
            return;
        }
        if (recorder.mEventHandler != null) {
            Message m = recorder.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            recorder.mEventHandler.sendMessage(m);
        }
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, publicAlternatives="{@code AudioRecord.Builder}")
    private int native_setup(Object audiorecordThis, Object attributes, int[] sampleRate, int channelMask, int channelIndexMask, int audioFormat, int buffSizeInBytes, int[] sessionId, String opPackageName, long nativeRecordInJavaObj) {
        AttributionSource attributionSource = AttributionSource.myAttributionSource().withPackageName(opPackageName);
        try (AttributionSource.ScopedParcelState attributionSourceState = attributionSource.asScopedParcelState();){
            int n = this.native_setup(audiorecordThis, attributes, sampleRate, channelMask, channelIndexMask, audioFormat, buffSizeInBytes, sessionId, attributionSourceState.getParcel(), nativeRecordInJavaObj, 0);
            return n;
        }
    }

    private int native_setup(Object object, Object object2, int[] nArray, int n, int n2, int n3, int n4, int[] nArray2, Parcel parcel, long l, int n5) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_setup(Ljava/lang/Object;Ljava/lang/Object;[IIIII[ILandroid/os/Parcel;JI)I", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.AudioRecord#native_finalize()V", true, this);
    }

    @UnsupportedAppUsage
    public void native_release() {
        OverrideMethod.invokeV("android.media.AudioRecord#native_release()V", true, this);
    }

    private int native_start(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_start(II)I", true, this);
    }

    private void native_stop() {
        OverrideMethod.invokeV("android.media.AudioRecord#native_stop()V", true, this);
    }

    private int native_read_in_byte_array(byte[] byArray, int n, int n2, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_read_in_byte_array([BIIZ)I", true, this);
    }

    private int native_read_in_short_array(short[] sArray, int n, int n2, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_read_in_short_array([SIIZ)I", true, this);
    }

    private int native_read_in_float_array(float[] fArray, int n, int n2, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_read_in_float_array([FIIZ)I", true, this);
    }

    private int native_read_in_direct_buffer(Object object, int n, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_read_in_direct_buffer(Ljava/lang/Object;IZ)I", true, this);
    }

    private int native_get_buffer_size_in_frames() {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_get_buffer_size_in_frames()I", true, this);
    }

    private int native_set_marker_pos(int n) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_set_marker_pos(I)I", true, this);
    }

    private int native_get_marker_pos() {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_get_marker_pos()I", true, this);
    }

    private int native_set_pos_update_period(int n) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_set_pos_update_period(I)I", true, this);
    }

    private int native_get_pos_update_period() {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_get_pos_update_period()I", true, this);
    }

    private static int native_get_min_buff_size(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_get_min_buff_size(III)I", true, null);
    }

    private boolean native_setInputDevice(int n) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_setInputDevice(I)Z", true, this) != 0;
    }

    private int native_getRoutedDeviceId() {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_getRoutedDeviceId()I", true, this);
    }

    private void native_enableDeviceCallback() {
        OverrideMethod.invokeV("android.media.AudioRecord#native_enableDeviceCallback()V", true, this);
    }

    private void native_disableDeviceCallback() {
        OverrideMethod.invokeV("android.media.AudioRecord#native_disableDeviceCallback()V", true, this);
    }

    private int native_get_timestamp(AudioTimestamp audioTimestamp, int n) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_get_timestamp(Landroid/media/AudioTimestamp;I)I", true, this);
    }

    private int native_get_active_microphones(ArrayList<MicrophoneInfo> arrayList) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_get_active_microphones(Ljava/util/ArrayList;)I", true, this);
    }

    private int native_getPortId() {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_getPortId()I", true, this);
    }

    private int native_set_preferred_microphone_direction(int n) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_set_preferred_microphone_direction(I)I", true, this);
    }

    private int native_set_preferred_microphone_field_dimension(float f) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_set_preferred_microphone_field_dimension(F)I", true, this);
    }

    private void native_setLogSessionId(String string2) {
        OverrideMethod.invokeV("android.media.AudioRecord#native_setLogSessionId(Ljava/lang/String;)V", true, this);
    }

    private int native_shareAudioHistory(String string2, long l) {
        return OverrideMethod.invokeI("android.media.AudioRecord#native_shareAudioHistory(Ljava/lang/String;J)I", true, this);
    }

    private static void logd(String msg) {
        Log.d(TAG, msg);
    }

    private static void loge(String msg) {
        Log.e(TAG, msg);
    }

    public static class MetricsConstants {
        private static final String MM_PREFIX = "android.media.audiorecord.";
        public static final String ENCODING = "android.media.audiorecord.encoding";
        public static final String SOURCE = "android.media.audiorecord.source";
        @Deprecated
        public static final String LATENCY = "android.media.audiorecord.latency";
        public static final String SAMPLERATE = "android.media.audiorecord.samplerate";
        public static final String CHANNELS = "android.media.audiorecord.channels";
        public static final String CHANNEL_MASK = "android.media.audiorecord.channelMask";
        public static final String PORT_ID = "android.media.audiorecord.portId";
        public static final String FRAME_COUNT = "android.media.audiorecord.frameCount";
        public static final String ATTRIBUTES = "android.media.audiorecord.attributes";
        public static final String DURATION_MS = "android.media.audiorecord.durationMs";
        public static final String START_COUNT = "android.media.audiorecord.startCount";

        private MetricsConstants() {
        }
    }

    private class NativeEventHandler
    extends Handler {
        private final AudioRecord mAudioRecord;

        NativeEventHandler(AudioRecord recorder, Looper looper) {
            super(looper);
            this.mAudioRecord = recorder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            OnRecordPositionUpdateListener listener2 = null;
            Object object = AudioRecord.this.mPositionListenerLock;
            synchronized (object) {
                listener2 = this.mAudioRecord.mPositionListener;
            }
            switch (msg.what) {
                case 2: {
                    if (listener2 == null) break;
                    listener2.onMarkerReached(this.mAudioRecord);
                    break;
                }
                case 3: {
                    if (listener2 == null) break;
                    listener2.onPeriodicNotification(this.mAudioRecord);
                    break;
                }
                default: {
                    AudioRecord.loge("Unknown native event type: " + msg.what);
                }
            }
        }
    }

    public static interface OnRecordPositionUpdateListener {
        public void onMarkerReached(AudioRecord var1);

        public void onPeriodicNotification(AudioRecord var1);
    }

    @Deprecated
    public static interface OnRoutingChangedListener
    extends AudioRouting.OnRoutingChangedListener {
        public void onRoutingChanged(AudioRecord var1);

        @Override
        default public void onRoutingChanged(AudioRouting router) {
            if (router instanceof AudioRecord) {
                this.onRoutingChanged((AudioRecord)router);
            }
        }
    }

    public static class Builder {
        private static final String ERROR_MESSAGE_SOURCE_MISMATCH = "Cannot both set audio source and set playback capture config";
        private AudioPlaybackCaptureConfiguration mAudioPlaybackCaptureConfiguration;
        private AudioAttributes mAttributes;
        private AudioFormat mFormat;
        private Context mContext;
        private int mBufferSizeInBytes;
        private int mSessionId = 0;
        private int mPrivacySensitive = -1;
        private int mMaxSharedAudioHistoryMs = 0;
        private static final int PRIVACY_SENSITIVE_DEFAULT = -1;
        private static final int PRIVACY_SENSITIVE_DISABLED = 0;
        private static final int PRIVACY_SENSITIVE_ENABLED = 1;

        public Builder setAudioSource(int source) throws IllegalArgumentException {
            Preconditions.checkState(this.mAudioPlaybackCaptureConfiguration == null, ERROR_MESSAGE_SOURCE_MISMATCH);
            if (source < 0 || source > MediaRecorder.getAudioSourceMax()) {
                throw new IllegalArgumentException("Invalid audio source " + source);
            }
            this.mAttributes = new AudioAttributes.Builder().setInternalCapturePreset(source).build();
            return this;
        }

        public Builder setContext(Context context) {
            Objects.requireNonNull(context);
            this.mContext = context;
            return this;
        }

        @SystemApi
        public Builder setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
            if (attributes == null) {
                throw new IllegalArgumentException("Illegal null AudioAttributes argument");
            }
            if (attributes.getCapturePreset() == -1) {
                throw new IllegalArgumentException("No valid capture preset in AudioAttributes argument");
            }
            this.mAttributes = attributes;
            return this;
        }

        public Builder setAudioFormat(AudioFormat format) throws IllegalArgumentException {
            if (format == null) {
                throw new IllegalArgumentException("Illegal null AudioFormat argument");
            }
            this.mFormat = format;
            return this;
        }

        public Builder setBufferSizeInBytes(int bufferSizeInBytes) throws IllegalArgumentException {
            if (bufferSizeInBytes <= 0) {
                throw new IllegalArgumentException("Invalid buffer size " + bufferSizeInBytes);
            }
            this.mBufferSizeInBytes = bufferSizeInBytes;
            return this;
        }

        public Builder setAudioPlaybackCaptureConfig(AudioPlaybackCaptureConfiguration config) {
            Preconditions.checkNotNull(config, "Illegal null AudioPlaybackCaptureConfiguration argument");
            Preconditions.checkState(this.mAttributes == null, ERROR_MESSAGE_SOURCE_MISMATCH);
            this.mAudioPlaybackCaptureConfiguration = config;
            return this;
        }

        public Builder setPrivacySensitive(boolean privacySensitive) {
            this.mPrivacySensitive = privacySensitive ? 1 : 0;
            return this;
        }

        @SystemApi
        public Builder setSessionId(int sessionId) throws IllegalArgumentException {
            if (sessionId < 0) {
                throw new IllegalArgumentException("Invalid session ID " + sessionId);
            }
            if (this.mSessionId == 0) {
                this.mSessionId = sessionId;
            } else {
                Log.e(AudioRecord.TAG, "setSessionId() called twice or after setSharedAudioEvent()");
            }
            return this;
        }

        private AudioRecord buildAudioPlaybackCaptureRecord() {
            AudioMix audioMix = this.mAudioPlaybackCaptureConfiguration.createAudioMix(this.mFormat);
            MediaProjection projection = this.mAudioPlaybackCaptureConfiguration.getMediaProjection();
            AudioPolicy audioPolicy = new AudioPolicy.Builder(null).setMediaProjection(projection).addMix(audioMix).build();
            int error = AudioManager.registerAudioPolicyStatic((AudioPolicy)audioPolicy);
            if (error != 0) {
                throw new UnsupportedOperationException("Error: could not register audio policy");
            }
            AudioRecord record = audioPolicy.createAudioRecordSink(audioMix);
            if (record == null) {
                throw new UnsupportedOperationException("Cannot create AudioRecord");
            }
            record.unregisterAudioPolicyOnRelease(audioPolicy);
            return record;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.CAPTURE_AUDIO_HOTWORD")
        public Builder setMaxSharedAudioHistoryMillis(long maxSharedAudioHistoryMillis) throws IllegalArgumentException {
            if (maxSharedAudioHistoryMillis <= 0L || maxSharedAudioHistoryMillis > 5000L) {
                throw new IllegalArgumentException("Illegal maxSharedAudioHistoryMillis argument");
            }
            this.mMaxSharedAudioHistoryMs = (int)maxSharedAudioHistoryMillis;
            return this;
        }

        @SystemApi
        public Builder setSharedAudioEvent(MediaSyncEvent event) throws IllegalArgumentException {
            Objects.requireNonNull(event);
            if (event.getType() != 100) {
                throw new IllegalArgumentException("Invalid event type " + event.getType());
            }
            if (event.getAudioSessionId() == 0) {
                throw new IllegalArgumentException("Invalid session ID " + event.getAudioSessionId());
            }
            this.mSessionId = event.getAudioSessionId();
            return this;
        }

        @RequiresPermission(value="android.permission.RECORD_AUDIO")
        public AudioRecord build() throws UnsupportedOperationException {
            if (this.mAudioPlaybackCaptureConfiguration != null) {
                return this.buildAudioPlaybackCaptureRecord();
            }
            if (this.mFormat == null) {
                this.mFormat = new AudioFormat.Builder().setEncoding(2).setChannelMask(16).build();
            } else {
                if (this.mFormat.getEncoding() == 0) {
                    this.mFormat = new AudioFormat.Builder(this.mFormat).setEncoding(2).build();
                }
                if (this.mFormat.getChannelMask() == 0 && this.mFormat.getChannelIndexMask() == 0) {
                    this.mFormat = new AudioFormat.Builder(this.mFormat).setChannelMask(16).build();
                }
            }
            if (this.mAttributes == null) {
                this.mAttributes = new AudioAttributes.Builder().setInternalCapturePreset(0).build();
            }
            if (this.mPrivacySensitive != -1) {
                int source = this.mAttributes.getCapturePreset();
                if (source == 8 || source == 1998 || source == 3 || source == 2 || source == 4 || source == 1997) {
                    throw new UnsupportedOperationException("Cannot request private capture with source: " + source);
                }
                this.mAttributes = new AudioAttributes.Builder(this.mAttributes).setInternalCapturePreset(source).setPrivacySensitive(this.mPrivacySensitive == 1).build();
            }
            try {
                AudioRecord record;
                if (this.mBufferSizeInBytes == 0) {
                    this.mBufferSizeInBytes = this.mFormat.getChannelCount() * AudioFormat.getBytesPerSample(this.mFormat.getEncoding());
                }
                if ((record = new AudioRecord(this.mAttributes, this.mFormat, this.mBufferSizeInBytes, this.mSessionId, this.mContext, this.mMaxSharedAudioHistoryMs)).getState() == 0) {
                    throw new UnsupportedOperationException("Cannot create AudioRecord");
                }
                return record;
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedOperationException(e.getMessage());
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ReadMode {
    }
}

