/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioMetadataMap;
import android.util.Log;
import android.util.Pair;
import java.lang.reflect.ParameterizedType;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AudioMetadata {
    private static final String TAG = "AudioMetadata";
    private static final int AUDIO_METADATA_OBJ_TYPE_NONE = 0;
    private static final int AUDIO_METADATA_OBJ_TYPE_INT = 1;
    private static final int AUDIO_METADATA_OBJ_TYPE_LONG = 2;
    private static final int AUDIO_METADATA_OBJ_TYPE_FLOAT = 3;
    private static final int AUDIO_METADATA_OBJ_TYPE_DOUBLE = 4;
    private static final int AUDIO_METADATA_OBJ_TYPE_STRING = 5;
    private static final int AUDIO_METADATA_OBJ_TYPE_BASEMAP = 6;
    private static final HashMap<Class, Integer> AUDIO_METADATA_OBJ_TYPES = new HashMap<Class, Integer>(){
        {
            this.put(Integer.class, 1);
            this.put(Long.class, 2);
            this.put(Float.class, 3);
            this.put(Double.class, 4);
            this.put(String.class, 5);
            this.put(BaseMap.class, 6);
        }
    };
    private static final Charset AUDIO_METADATA_CHARSET = StandardCharsets.UTF_8;
    private static final HashMap<Integer, DataPackage<?>> DATA_PACKAGES = new HashMap<Integer, DataPackage<?>>(){
        {
            this.put(1, new DataPackage<Integer>(){

                @Override
                public Integer unpack(ByteBuffer buffer) {
                    return buffer.getInt();
                }

                @Override
                public boolean pack(AutoGrowByteBuffer output, Integer obj) {
                    output.putInt(obj);
                    return true;
                }
            });
            this.put(2, new DataPackage<Long>(){

                @Override
                public Long unpack(ByteBuffer buffer) {
                    return buffer.getLong();
                }

                @Override
                public boolean pack(AutoGrowByteBuffer output, Long obj) {
                    output.putLong(obj);
                    return true;
                }
            });
            this.put(3, new DataPackage<Float>(){

                @Override
                public Float unpack(ByteBuffer buffer) {
                    return Float.valueOf(buffer.getFloat());
                }

                @Override
                public boolean pack(AutoGrowByteBuffer output, Float obj) {
                    output.putFloat(obj.floatValue());
                    return true;
                }
            });
            this.put(4, new DataPackage<Double>(){

                @Override
                public Double unpack(ByteBuffer buffer) {
                    return buffer.getDouble();
                }

                @Override
                public boolean pack(AutoGrowByteBuffer output, Double obj) {
                    output.putDouble(obj);
                    return true;
                }
            });
            this.put(5, new DataPackage<String>(){

                @Override
                public String unpack(ByteBuffer buffer) {
                    int dataSize = buffer.getInt();
                    if (buffer.position() + dataSize > buffer.limit()) {
                        return null;
                    }
                    byte[] valueArr = new byte[dataSize];
                    buffer.get(valueArr);
                    String value2 = new String(valueArr, AUDIO_METADATA_CHARSET);
                    return value2;
                }

                @Override
                public boolean pack(AutoGrowByteBuffer output, String obj) {
                    byte[] valueArr = obj.getBytes(AUDIO_METADATA_CHARSET);
                    output.putInt(valueArr.length);
                    output.put(valueArr);
                    return true;
                }
            });
            this.put(6, new BaseMapPackage());
        }
    };
    private static final ObjectPackage OBJECT_PACKAGE = new ObjectPackage();

    public static AudioMetadataMap createMap() {
        return new BaseMap();
    }

    public static <T> Key<T> createKey(final String name, final Class<T> type) {
        return new Key<T>(){
            private final String mName;
            private final Class<T> mType;
            {
                this.mName = name;
                this.mType = type;
            }

            @Override
            public String getName() {
                return this.mName;
            }

            @Override
            public Class<T> getValueClass() {
                return this.mType;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Key)) {
                    return false;
                }
                Key other = (Key)obj;
                return this.mName.equals(other.getName()) && this.mType.equals(other.getValueClass());
            }

            public int hashCode() {
                return Objects.hash(this.mName, this.mType);
            }
        };
    }

    public static BaseMap fromByteBuffer(ByteBuffer buffer) {
        DataPackage<?> dataPackage = DATA_PACKAGES.get(6);
        if (dataPackage == null) {
            Log.e(TAG, "Cannot find DataPackage for BaseMap");
            return null;
        }
        try {
            return (BaseMap)dataPackage.unpack(buffer);
        }
        catch (BufferUnderflowException e) {
            Log.e(TAG, "No enough data to unpack");
            return null;
        }
    }

    public static ByteBuffer toByteBuffer(BaseMap data, ByteOrder order) {
        DataPackage<?> dataPackage = DATA_PACKAGES.get(6);
        if (dataPackage == null) {
            Log.e(TAG, "Cannot find DataPackage for BaseMap");
            return null;
        }
        AutoGrowByteBuffer output = new AutoGrowByteBuffer();
        output.order(order);
        if (dataPackage.pack(output, data)) {
            return output.getRawByteBuffer();
        }
        return null;
    }

    private AudioMetadata() {
    }

    private static class BaseMapPackage
    implements DataPackage<BaseMap> {
        private BaseMapPackage() {
        }

        @Override
        public BaseMap unpack(ByteBuffer buffer) {
            BaseMap ret = new BaseMap();
            int mapSize = buffer.getInt();
            DataPackage strDataPackage = (DataPackage)DATA_PACKAGES.get(5);
            if (strDataPackage == null) {
                Log.e(AudioMetadata.TAG, "Cannot find DataPackage for String");
                return null;
            }
            for (int i = 0; i < mapSize; ++i) {
                String key = (String)strDataPackage.unpack(buffer);
                if (key == null) {
                    Log.e(AudioMetadata.TAG, "Failed to unpack key for map");
                    return null;
                }
                Object value2 = OBJECT_PACKAGE.unpack(buffer);
                if (value2 == null) {
                    Log.e(AudioMetadata.TAG, "Failed to unpack value for map");
                    return null;
                }
                if (key.equals(Format.KEY_HAS_ATMOS.getName()) && ((Pair)value2).first == Format.KEY_HAS_ATMOS.getValueClass()) {
                    ret.set(Format.KEY_ATMOS_PRESENT, (Integer)((Pair)value2).second != 0);
                    continue;
                }
                ret.set(AudioMetadata.createKey(key, (Class)((Pair)value2).first), ((Class)((Pair)value2).first).cast(((Pair)value2).second));
            }
            return ret;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean pack(AutoGrowByteBuffer output, BaseMap obj) {
            output.putInt(obj.size());
            DataPackage strDataPackage = (DataPackage)DATA_PACKAGES.get(5);
            if (strDataPackage == null) {
                Log.e(AudioMetadata.TAG, "Cannot find DataPackage for String");
                return false;
            }
            for (Key<?> key : obj.keySet()) {
                void var5_5;
                Object value2 = obj.get(key);
                if (key == Format.KEY_ATMOS_PRESENT) {
                    Key<Integer> key2 = Format.KEY_HAS_ATMOS;
                    value2 = (Boolean)value2 != false ? 1 : 0;
                }
                if (!strDataPackage.pack(output, var5_5.getName())) {
                    Log.i(AudioMetadata.TAG, "Failed to pack key: " + var5_5.getName());
                    return false;
                }
                if (OBJECT_PACKAGE.pack(output, new Pair<Class, Object>(var5_5.getValueClass(), value2))) continue;
                Log.i(AudioMetadata.TAG, "Failed to pack value: " + obj.get(var5_5));
                return false;
            }
            return true;
        }
    }

    private static class ObjectPackage
    implements DataPackage<Pair<Class, Object>> {
        private ObjectPackage() {
        }

        @Override
        public Pair<Class, Object> unpack(ByteBuffer buffer) {
            int dataType = buffer.getInt();
            DataPackage dataPackage = (DataPackage)DATA_PACKAGES.get(dataType);
            if (dataPackage == null) {
                Log.e(AudioMetadata.TAG, "Cannot find DataPackage for type:" + dataType);
                return null;
            }
            int dataSize = buffer.getInt();
            int position = buffer.position();
            Object obj = dataPackage.unpack(buffer);
            if (buffer.position() - position != dataSize) {
                Log.e(AudioMetadata.TAG, "Broken data package");
                return null;
            }
            return new Pair<Class, Object>(dataPackage.getMyType(), obj);
        }

        @Override
        public boolean pack(AutoGrowByteBuffer output, Pair<Class, Object> obj) {
            Integer dataType = (Integer)AUDIO_METADATA_OBJ_TYPES.get(obj.first);
            if (dataType == null) {
                Log.e(AudioMetadata.TAG, "Cannot find data type for " + obj.first);
                return false;
            }
            DataPackage dataPackage = (DataPackage)DATA_PACKAGES.get(dataType);
            if (dataPackage == null) {
                Log.e(AudioMetadata.TAG, "Cannot find DataPackage for type:" + dataType);
                return false;
            }
            output.putInt(dataType);
            int position = output.position();
            output.putInt(0);
            int payloadIdx = output.position();
            if (!dataPackage.pack(output, obj.second)) {
                Log.i(AudioMetadata.TAG, "Failed to pack object: " + obj.second);
                return false;
            }
            int currentPosition = output.position();
            output.position(position);
            output.putInt(currentPosition - payloadIdx);
            output.position(currentPosition);
            return true;
        }
    }

    private static interface DataPackage<T> {
        public T unpack(ByteBuffer var1);

        public boolean pack(AutoGrowByteBuffer var1, T var2);

        default public Class getMyType() {
            return (Class)((ParameterizedType)this.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
        }
    }

    private static class AutoGrowByteBuffer {
        private static final int INTEGER_BYTE_COUNT = 4;
        private static final int LONG_BYTE_COUNT = 8;
        private static final int FLOAT_BYTE_COUNT = 4;
        private static final int DOUBLE_BYTE_COUNT = 8;
        private ByteBuffer mBuffer;

        AutoGrowByteBuffer() {
            this(1024);
        }

        AutoGrowByteBuffer(int initialCapacity) {
            this.mBuffer = ByteBuffer.allocateDirect(initialCapacity);
        }

        public ByteBuffer getRawByteBuffer() {
            int limit = this.mBuffer.limit();
            int position = this.mBuffer.position();
            this.mBuffer.limit(position);
            this.mBuffer.position(0);
            ByteBuffer buffer = this.mBuffer.slice();
            this.mBuffer.limit(limit);
            this.mBuffer.position(position);
            return buffer;
        }

        public ByteOrder order() {
            return this.mBuffer.order();
        }

        public int position() {
            return this.mBuffer.position();
        }

        public AutoGrowByteBuffer position(int newPosition) {
            this.mBuffer.position(newPosition);
            return this;
        }

        public AutoGrowByteBuffer order(ByteOrder order) {
            this.mBuffer.order(order);
            return this;
        }

        public AutoGrowByteBuffer putInt(int value2) {
            this.ensureCapacity(4);
            this.mBuffer.putInt(value2);
            return this;
        }

        public AutoGrowByteBuffer putLong(long value2) {
            this.ensureCapacity(8);
            this.mBuffer.putLong(value2);
            return this;
        }

        public AutoGrowByteBuffer putFloat(float value2) {
            this.ensureCapacity(4);
            this.mBuffer.putFloat(value2);
            return this;
        }

        public AutoGrowByteBuffer putDouble(double value2) {
            this.ensureCapacity(8);
            this.mBuffer.putDouble(value2);
            return this;
        }

        public AutoGrowByteBuffer put(byte[] src) {
            this.ensureCapacity(src.length);
            this.mBuffer.put(src);
            return this;
        }

        private void ensureCapacity(int count) {
            if (this.mBuffer.remaining() < count) {
                int newCapacity = this.mBuffer.position() + count;
                if (newCapacity > 0x3FFFFFFF) {
                    throw new IllegalStateException("Item memory requirements too large: " + newCapacity);
                }
                ByteBuffer buffer = ByteBuffer.allocateDirect(newCapacity <<= 1);
                buffer.order(this.mBuffer.order());
                this.mBuffer.flip();
                buffer.put(this.mBuffer);
                this.mBuffer = buffer;
            }
        }
    }

    public static class BaseMap
    implements AudioMetadataMap {
        private final HashMap<Pair<String, Class<?>>, Pair<Key<?>, Object>> mHashMap = new HashMap();

        @Override
        public <T> boolean containsKey(Key<T> key) {
            Pair<Key<?>, Object> valuePair = this.mHashMap.get(BaseMap.pairFromKey(key));
            return valuePair != null;
        }

        @Override
        public AudioMetadataMap dup() {
            BaseMap map2 = new BaseMap();
            map2.mHashMap.putAll(this.mHashMap);
            return map2;
        }

        @Override
        public <T> T get(Key<T> key) {
            Pair<Key<?>, Object> valuePair = this.mHashMap.get(BaseMap.pairFromKey(key));
            return (T)BaseMap.getValueFromValuePair(valuePair);
        }

        @Override
        public Set<Key<?>> keySet() {
            HashSet set = new HashSet();
            for (Pair<Key<?>, Object> pair : this.mHashMap.values()) {
                set.add((Key)pair.first);
            }
            return set;
        }

        @Override
        public <T> T remove(Key<T> key) {
            Pair<Key<?>, Object> valuePair = this.mHashMap.remove(BaseMap.pairFromKey(key));
            return (T)BaseMap.getValueFromValuePair(valuePair);
        }

        @Override
        public <T> T set(Key<T> key, T value2) {
            Objects.requireNonNull(value2);
            Pair<Key<?>, Object> valuePair = this.mHashMap.put(BaseMap.pairFromKey(key), new Pair<Key<T>, T>(key, value2));
            return (T)BaseMap.getValueFromValuePair(valuePair);
        }

        @Override
        public int size() {
            return this.mHashMap.size();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BaseMap)) {
                return false;
            }
            BaseMap other = (BaseMap)obj;
            return this.mHashMap.equals(other.mHashMap);
        }

        public int hashCode() {
            return Objects.hash(this.mHashMap);
        }

        private static <T> Pair<String, Class<?>> pairFromKey(Key<T> key) {
            Objects.requireNonNull(key);
            return new Pair(key.getName(), key.getValueClass());
        }

        private static Object getValueFromValuePair(Pair<Key<?>, Object> valuePair) {
            if (valuePair == null) {
                return null;
            }
            return valuePair.second;
        }
    }

    public static class Format {
        public static final Key<Integer> KEY_BIT_RATE = AudioMetadata.createKey("bitrate", Integer.class);
        public static final Key<Integer> KEY_CHANNEL_MASK = AudioMetadata.createKey("channel-mask", Integer.class);
        public static final Key<String> KEY_MIME = AudioMetadata.createKey("mime", String.class);
        public static final Key<Integer> KEY_SAMPLE_RATE = AudioMetadata.createKey("sample-rate", Integer.class);
        public static final Key<Integer> KEY_BIT_WIDTH = AudioMetadata.createKey("bit-width", Integer.class);
        public static final Key<Boolean> KEY_ATMOS_PRESENT = AudioMetadata.createKey("atmos-present", Boolean.class);
        public static final Key<Integer> KEY_HAS_ATMOS = AudioMetadata.createKey("has-atmos", Integer.class);
        public static final Key<Integer> KEY_AUDIO_ENCODING = AudioMetadata.createKey("audio-encoding", Integer.class);
        public static final Key<Integer> KEY_PRESENTATION_ID = AudioMetadata.createKey("presentation-id", Integer.class);
        public static final Key<Integer> KEY_PROGRAM_ID = AudioMetadata.createKey("program-id", Integer.class);
        public static final Key<Integer> KEY_PRESENTATION_CONTENT_CLASSIFIER = AudioMetadata.createKey("presentation-content-classifier", Integer.class);
        public static final Key<String> KEY_PRESENTATION_LANGUAGE = AudioMetadata.createKey("presentation-language", String.class);

        private Format() {
        }
    }

    public static interface Key<T> {
        public String getName();

        public Class<T> getValueClass();
    }
}

