/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Printer;
import android.util.TimeUtils;
import com.android.internal.lang.System_Delegate;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;

public class Location
implements Parcelable {
    public static final int FORMAT_DEGREES = 0;
    public static final int FORMAT_MINUTES = 1;
    public static final int FORMAT_SECONDS = 2;
    @SystemApi
    @Deprecated
    public static final String EXTRA_NO_GPS_LOCATION = "noGPSLocation";
    private static final int HAS_ALTITUDE_MASK = 1;
    private static final int HAS_SPEED_MASK = 2;
    private static final int HAS_BEARING_MASK = 4;
    private static final int HAS_HORIZONTAL_ACCURACY_MASK = 8;
    private static final int HAS_MOCK_PROVIDER_MASK = 16;
    private static final int HAS_VERTICAL_ACCURACY_MASK = 32;
    private static final int HAS_SPEED_ACCURACY_MASK = 64;
    private static final int HAS_BEARING_ACCURACY_MASK = 128;
    private static final int HAS_ELAPSED_REALTIME_UNCERTAINTY_MASK = 256;
    private static final ThreadLocal<BearingDistanceCache> sBearingDistanceCache = ThreadLocal.withInitial(() -> new BearingDistanceCache());
    private String mProvider;
    private long mTime = 0L;
    @UnsupportedAppUsage(maxTargetSdk=30, publicAlternatives="{@link #getElapsedRealtimeNanos()}")
    private long mElapsedRealtimeNanos = 0L;
    private double mElapsedRealtimeUncertaintyNanos = 0.0;
    private double mLatitude = 0.0;
    private double mLongitude = 0.0;
    private double mAltitude = 0.0;
    private float mSpeed = 0.0f;
    private float mBearing = 0.0f;
    private float mHorizontalAccuracyMeters = 0.0f;
    private float mVerticalAccuracyMeters = 0.0f;
    private float mSpeedAccuracyMetersPerSecond = 0.0f;
    private float mBearingAccuracyDegrees = 0.0f;
    private Bundle mExtras = null;
    private int mFieldsMask = 0;
    public static final Parcelable.Creator<Location> CREATOR = new Parcelable.Creator<Location>(){

        @Override
        public Location createFromParcel(Parcel in) {
            Location l = new Location(in.readString());
            l.mFieldsMask = in.readInt();
            l.mTime = in.readLong();
            l.mElapsedRealtimeNanos = in.readLong();
            if (l.hasElapsedRealtimeUncertaintyNanos()) {
                l.mElapsedRealtimeUncertaintyNanos = in.readDouble();
            }
            l.mLatitude = in.readDouble();
            l.mLongitude = in.readDouble();
            if (l.hasAltitude()) {
                l.mAltitude = in.readDouble();
            }
            if (l.hasSpeed()) {
                l.mSpeed = in.readFloat();
            }
            if (l.hasBearing()) {
                l.mBearing = in.readFloat();
            }
            if (l.hasAccuracy()) {
                l.mHorizontalAccuracyMeters = in.readFloat();
            }
            if (l.hasVerticalAccuracy()) {
                l.mVerticalAccuracyMeters = in.readFloat();
            }
            if (l.hasSpeedAccuracy()) {
                l.mSpeedAccuracyMetersPerSecond = in.readFloat();
            }
            if (l.hasBearingAccuracy()) {
                l.mBearingAccuracyDegrees = in.readFloat();
            }
            l.mExtras = Bundle.setDefusable(in.readBundle(), true);
            return l;
        }

        public Location[] newArray(int size) {
            return new Location[size];
        }
    };

    public Location(String provider2) {
        this.mProvider = provider2;
    }

    public Location(Location l) {
        this.set(l);
    }

    public void set(Location l) {
        this.mProvider = l.mProvider;
        this.mTime = l.mTime;
        this.mElapsedRealtimeNanos = l.mElapsedRealtimeNanos;
        this.mElapsedRealtimeUncertaintyNanos = l.mElapsedRealtimeUncertaintyNanos;
        this.mFieldsMask = l.mFieldsMask;
        this.mLatitude = l.mLatitude;
        this.mLongitude = l.mLongitude;
        this.mAltitude = l.mAltitude;
        this.mSpeed = l.mSpeed;
        this.mBearing = l.mBearing;
        this.mHorizontalAccuracyMeters = l.mHorizontalAccuracyMeters;
        this.mVerticalAccuracyMeters = l.mVerticalAccuracyMeters;
        this.mSpeedAccuracyMetersPerSecond = l.mSpeedAccuracyMetersPerSecond;
        this.mBearingAccuracyDegrees = l.mBearingAccuracyDegrees;
        this.mExtras = l.mExtras == null ? null : new Bundle(l.mExtras);
    }

    public void reset() {
        this.mProvider = null;
        this.mTime = 0L;
        this.mElapsedRealtimeNanos = 0L;
        this.mElapsedRealtimeUncertaintyNanos = 0.0;
        this.mFieldsMask = 0;
        this.mLatitude = 0.0;
        this.mLongitude = 0.0;
        this.mAltitude = 0.0;
        this.mSpeed = 0.0f;
        this.mBearing = 0.0f;
        this.mHorizontalAccuracyMeters = 0.0f;
        this.mVerticalAccuracyMeters = 0.0f;
        this.mSpeedAccuracyMetersPerSecond = 0.0f;
        this.mBearingAccuracyDegrees = 0.0f;
        this.mExtras = null;
    }

    public static String convert(double coordinate, int outputType) {
        if (coordinate < -180.0 || coordinate > 180.0 || Double.isNaN(coordinate)) {
            throw new IllegalArgumentException("coordinate=" + coordinate);
        }
        if (outputType != 0 && outputType != 1 && outputType != 2) {
            throw new IllegalArgumentException("outputType=" + outputType);
        }
        StringBuilder sb = new StringBuilder();
        if (coordinate < 0.0) {
            sb.append('-');
            coordinate = -coordinate;
        }
        DecimalFormat df = new DecimalFormat("###.#####");
        if (outputType == 1 || outputType == 2) {
            int degrees = (int)Math.floor(coordinate);
            sb.append(degrees);
            sb.append(':');
            coordinate -= (double)degrees;
            coordinate *= 60.0;
            if (outputType == 2) {
                int minutes = (int)Math.floor(coordinate);
                sb.append(minutes);
                sb.append(':');
                coordinate -= (double)minutes;
                coordinate *= 60.0;
            }
        }
        sb.append(df.format(coordinate));
        return sb.toString();
    }

    public static double convert(String coordinate) {
        StringTokenizer st;
        int tokens;
        if (coordinate == null) {
            throw new NullPointerException("coordinate");
        }
        boolean negative = false;
        if (coordinate.charAt(0) == '-') {
            coordinate = coordinate.substring(1);
            negative = true;
        }
        if ((tokens = (st = new StringTokenizer(coordinate, ":")).countTokens()) < 1) {
            throw new IllegalArgumentException("coordinate=" + coordinate);
        }
        try {
            boolean isNegative180;
            double min;
            String degrees = st.nextToken();
            if (tokens == 1) {
                double val = Double.parseDouble(degrees);
                return negative ? -val : val;
            }
            String minutes = st.nextToken();
            int deg = Integer.parseInt(degrees);
            double sec = 0.0;
            boolean secPresent = false;
            if (st.hasMoreTokens()) {
                min = Integer.parseInt(minutes);
                String seconds = st.nextToken();
                sec = Double.parseDouble(seconds);
                secPresent = true;
            } else {
                min = Double.parseDouble(minutes);
            }
            boolean bl = isNegative180 = negative && deg == 180 && min == 0.0 && sec == 0.0;
            if ((double)deg < 0.0 || deg > 179 && !isNegative180) {
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            if (min < 0.0 || min >= 60.0 || secPresent && min > 59.0) {
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            if (sec < 0.0 || sec >= 60.0) {
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            double val = (double)deg * 3600.0 + min * 60.0 + sec;
            return negative ? -val : (val /= 3600.0);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("coordinate=" + coordinate);
        }
    }

    private static void computeDistanceAndBearing(double lat1, double lon1, double lat2, double lon2, BearingDistanceCache results) {
        int MAXITERS = 20;
        lat1 *= Math.PI / 180;
        lat2 *= Math.PI / 180;
        double a = 6378137.0;
        double b = 6356752.3142;
        double f = (a - b) / a;
        double aSqMinusBSqOverBSq = (a * a - b * b) / (b * b);
        double L = (lon2 *= Math.PI / 180) - (lon1 *= Math.PI / 180);
        double A = 0.0;
        double U1 = Math.atan((1.0 - f) * Math.tan(lat1));
        double U2 = Math.atan((1.0 - f) * Math.tan(lat2));
        double cosU1 = Math.cos(U1);
        double cosU2 = Math.cos(U2);
        double sinU1 = Math.sin(U1);
        double sinU2 = Math.sin(U2);
        double cosU1cosU2 = cosU1 * cosU2;
        double sinU1sinU2 = sinU1 * sinU2;
        double sigma = 0.0;
        double deltaSigma = 0.0;
        double cosLambda = 0.0;
        double sinLambda = 0.0;
        double lambda2 = L;
        for (int iter = 0; iter < MAXITERS; ++iter) {
            double lambdaOrig = lambda2;
            cosLambda = Math.cos(lambda2);
            sinLambda = Math.sin(lambda2);
            double t1 = cosU2 * sinLambda;
            double t2 = cosU1 * sinU2 - sinU1 * cosU2 * cosLambda;
            double sinSqSigma = t1 * t1 + t2 * t2;
            double sinSigma = Math.sqrt(sinSqSigma);
            double cosSigma = sinU1sinU2 + cosU1cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            double sinAlpha = sinSigma == 0.0 ? 0.0 : cosU1cosU2 * sinLambda / sinSigma;
            double cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            double cos2SM = cosSqAlpha == 0.0 ? 0.0 : cosSigma - 2.0 * sinU1sinU2 / cosSqAlpha;
            double uSquared = cosSqAlpha * aSqMinusBSqOverBSq;
            A = 1.0 + uSquared / 16384.0 * (4096.0 + uSquared * (-768.0 + uSquared * (320.0 - 175.0 * uSquared)));
            double B = uSquared / 1024.0 * (256.0 + uSquared * (-128.0 + uSquared * (74.0 - 47.0 * uSquared)));
            double C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha));
            double cos2SMSq = cos2SM * cos2SM;
            deltaSigma = B * sinSigma * (cos2SM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SMSq) - B / 6.0 * cos2SM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SMSq)));
            lambda2 = L + (1.0 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SM + C * cosSigma * (-1.0 + 2.0 * cos2SM * cos2SM)));
            double delta = (lambda2 - lambdaOrig) / lambda2;
            if (Math.abs(delta) < 1.0E-12) break;
        }
        results.mDistance = (float)(b * A * (sigma - deltaSigma));
        float initialBearing = (float)Math.atan2(cosU2 * sinLambda, cosU1 * sinU2 - sinU1 * cosU2 * cosLambda);
        results.mInitialBearing = initialBearing = (float)((double)initialBearing * 57.29577951308232);
        float finalBearing = (float)Math.atan2(cosU1 * sinLambda, -sinU1 * cosU2 + cosU1 * sinU2 * cosLambda);
        results.mFinalBearing = finalBearing = (float)((double)finalBearing * 57.29577951308232);
        results.mLat1 = lat1;
        results.mLat2 = lat2;
        results.mLon1 = lon1;
        results.mLon2 = lon2;
    }

    public static void distanceBetween(double startLatitude, double startLongitude, double endLatitude, double endLongitude, float[] results) {
        if (results == null || results.length < 1) {
            throw new IllegalArgumentException("results is null or has length < 1");
        }
        BearingDistanceCache cache = sBearingDistanceCache.get();
        Location.computeDistanceAndBearing(startLatitude, startLongitude, endLatitude, endLongitude, cache);
        results[0] = cache.mDistance;
        if (results.length > 1) {
            results[1] = cache.mInitialBearing;
            if (results.length > 2) {
                results[2] = cache.mFinalBearing;
            }
        }
    }

    public float distanceTo(Location dest) {
        BearingDistanceCache cache = sBearingDistanceCache.get();
        if (this.mLatitude != cache.mLat1 || this.mLongitude != cache.mLon1 || dest.mLatitude != cache.mLat2 || dest.mLongitude != cache.mLon2) {
            Location.computeDistanceAndBearing(this.mLatitude, this.mLongitude, dest.mLatitude, dest.mLongitude, cache);
        }
        return cache.mDistance;
    }

    public float bearingTo(Location dest) {
        BearingDistanceCache cache = sBearingDistanceCache.get();
        if (this.mLatitude != cache.mLat1 || this.mLongitude != cache.mLon1 || dest.mLatitude != cache.mLat2 || dest.mLongitude != cache.mLon2) {
            Location.computeDistanceAndBearing(this.mLatitude, this.mLongitude, dest.mLatitude, dest.mLongitude, cache);
        }
        return cache.mInitialBearing;
    }

    public String getProvider() {
        return this.mProvider;
    }

    public void setProvider(String provider2) {
        this.mProvider = provider2;
    }

    public long getTime() {
        return this.mTime;
    }

    public void setTime(long time) {
        this.mTime = time;
    }

    public long getElapsedRealtimeNanos() {
        return this.mElapsedRealtimeNanos;
    }

    public long getElapsedRealtimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.getElapsedRealtimeNanos());
    }

    public long getElapsedRealtimeAgeMillis() {
        return this.getElapsedRealtimeAgeMillis(SystemClock.elapsedRealtime());
    }

    public long getElapsedRealtimeAgeMillis(long referenceRealtimeMs) {
        return referenceRealtimeMs - TimeUnit.NANOSECONDS.toMillis(this.mElapsedRealtimeNanos);
    }

    public void setElapsedRealtimeNanos(long time) {
        this.mElapsedRealtimeNanos = time;
    }

    public double getElapsedRealtimeUncertaintyNanos() {
        return this.mElapsedRealtimeUncertaintyNanos;
    }

    public void setElapsedRealtimeUncertaintyNanos(double time) {
        this.mElapsedRealtimeUncertaintyNanos = time;
        this.mFieldsMask |= 0x100;
    }

    public boolean hasElapsedRealtimeUncertaintyNanos() {
        return (this.mFieldsMask & 0x100) != 0;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public void setLatitude(double latitude) {
        this.mLatitude = latitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public void setLongitude(double longitude) {
        this.mLongitude = longitude;
    }

    public boolean hasAltitude() {
        return (this.mFieldsMask & 1) != 0;
    }

    public double getAltitude() {
        return this.mAltitude;
    }

    public void setAltitude(double altitude) {
        this.mAltitude = altitude;
        this.mFieldsMask |= 1;
    }

    @Deprecated
    public void removeAltitude() {
        this.mAltitude = 0.0;
        this.mFieldsMask &= 0xFFFFFFFE;
    }

    public boolean hasSpeed() {
        return (this.mFieldsMask & 2) != 0;
    }

    public float getSpeed() {
        return this.mSpeed;
    }

    public void setSpeed(float speed) {
        this.mSpeed = speed;
        this.mFieldsMask |= 2;
    }

    @Deprecated
    public void removeSpeed() {
        this.mSpeed = 0.0f;
        this.mFieldsMask &= 0xFFFFFFFD;
    }

    public boolean hasBearing() {
        return (this.mFieldsMask & 4) != 0;
    }

    public float getBearing() {
        return this.mBearing;
    }

    public void setBearing(float bearing) {
        while (bearing < 0.0f) {
            bearing += 360.0f;
        }
        while (bearing >= 360.0f) {
            bearing -= 360.0f;
        }
        this.mBearing = bearing;
        this.mFieldsMask |= 4;
    }

    @Deprecated
    public void removeBearing() {
        this.mBearing = 0.0f;
        this.mFieldsMask &= 0xFFFFFFFB;
    }

    public boolean hasAccuracy() {
        return (this.mFieldsMask & 8) != 0;
    }

    public float getAccuracy() {
        return this.mHorizontalAccuracyMeters;
    }

    public void setAccuracy(float horizontalAccuracy) {
        this.mHorizontalAccuracyMeters = horizontalAccuracy;
        this.mFieldsMask |= 8;
    }

    @Deprecated
    public void removeAccuracy() {
        this.mHorizontalAccuracyMeters = 0.0f;
        this.mFieldsMask &= 0xFFFFFFF7;
    }

    public boolean hasVerticalAccuracy() {
        return (this.mFieldsMask & 0x20) != 0;
    }

    public float getVerticalAccuracyMeters() {
        return this.mVerticalAccuracyMeters;
    }

    public void setVerticalAccuracyMeters(float verticalAccuracyMeters) {
        this.mVerticalAccuracyMeters = verticalAccuracyMeters;
        this.mFieldsMask |= 0x20;
    }

    @Deprecated
    public void removeVerticalAccuracy() {
        this.mVerticalAccuracyMeters = 0.0f;
        this.mFieldsMask &= 0xFFFFFFDF;
    }

    public boolean hasSpeedAccuracy() {
        return (this.mFieldsMask & 0x40) != 0;
    }

    public float getSpeedAccuracyMetersPerSecond() {
        return this.mSpeedAccuracyMetersPerSecond;
    }

    public void setSpeedAccuracyMetersPerSecond(float speedAccuracyMeterPerSecond) {
        this.mSpeedAccuracyMetersPerSecond = speedAccuracyMeterPerSecond;
        this.mFieldsMask |= 0x40;
    }

    @Deprecated
    public void removeSpeedAccuracy() {
        this.mSpeedAccuracyMetersPerSecond = 0.0f;
        this.mFieldsMask &= 0xFFFFFFBF;
    }

    public boolean hasBearingAccuracy() {
        return (this.mFieldsMask & 0x80) != 0;
    }

    public float getBearingAccuracyDegrees() {
        return this.mBearingAccuracyDegrees;
    }

    public void setBearingAccuracyDegrees(float bearingAccuracyDegrees) {
        this.mBearingAccuracyDegrees = bearingAccuracyDegrees;
        this.mFieldsMask |= 0x80;
    }

    @Deprecated
    public void removeBearingAccuracy() {
        this.mBearingAccuracyDegrees = 0.0f;
        this.mFieldsMask &= 0xFFFFFF7F;
    }

    @SystemApi
    public boolean isComplete() {
        return this.mProvider != null && this.hasAccuracy() && this.mTime != 0L && this.mElapsedRealtimeNanos != 0L;
    }

    @SystemApi
    public void makeComplete() {
        if (this.mProvider == null) {
            this.mProvider = "?";
        }
        if (!this.hasAccuracy()) {
            this.mFieldsMask |= 8;
            this.mHorizontalAccuracyMeters = 100.0f;
        }
        if (this.mTime == 0L) {
            this.mTime = System_Delegate.currentTimeMillis();
        }
        if (this.mElapsedRealtimeNanos == 0L) {
            this.mElapsedRealtimeNanos = SystemClock.elapsedRealtimeNanos();
        }
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public void setExtras(Bundle extras) {
        this.mExtras = extras == null ? null : new Bundle(extras);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return !(this.mTime != location.mTime || this.mElapsedRealtimeNanos != location.mElapsedRealtimeNanos || this.hasElapsedRealtimeUncertaintyNanos() != location.hasElapsedRealtimeUncertaintyNanos() || this.hasElapsedRealtimeUncertaintyNanos() && Double.compare(location.mElapsedRealtimeUncertaintyNanos, this.mElapsedRealtimeUncertaintyNanos) != 0 || Double.compare(location.mLatitude, this.mLatitude) != 0 || Double.compare(location.mLongitude, this.mLongitude) != 0 || this.hasAltitude() != location.hasAltitude() || this.hasAltitude() && Double.compare(location.mAltitude, this.mAltitude) != 0 || this.hasSpeed() != location.hasSpeed() || this.hasSpeed() && Float.compare(location.mSpeed, this.mSpeed) != 0 || this.hasBearing() != location.hasBearing() || this.hasBearing() && Float.compare(location.mBearing, this.mBearing) != 0 || this.hasAccuracy() != location.hasAccuracy() || this.hasAccuracy() && Float.compare(location.mHorizontalAccuracyMeters, this.mHorizontalAccuracyMeters) != 0 || this.hasVerticalAccuracy() != location.hasVerticalAccuracy() || this.hasVerticalAccuracy() && Float.compare(location.mVerticalAccuracyMeters, this.mVerticalAccuracyMeters) != 0 || this.hasSpeedAccuracy() != location.hasSpeedAccuracy() || this.hasSpeedAccuracy() && Float.compare(location.mSpeedAccuracyMetersPerSecond, this.mSpeedAccuracyMetersPerSecond) != 0 || this.hasBearingAccuracy() != location.hasBearingAccuracy() || this.hasBearingAccuracy() && Float.compare(location.mBearingAccuracyDegrees, this.mBearingAccuracyDegrees) != 0 || !Objects.equals(this.mProvider, location.mProvider) || !Location.areExtrasEqual(this.mExtras, location.mExtras));
    }

    private static boolean areExtrasEqual(Bundle extras1, Bundle extras2) {
        if ((extras1 == null || extras1.isEmpty()) && (extras2 == null || extras2.isEmpty())) {
            return true;
        }
        if (extras1 == null || extras2 == null) {
            return false;
        }
        return extras1.kindofEquals(extras2);
    }

    public int hashCode() {
        return Objects.hash(this.mProvider, this.mElapsedRealtimeNanos, this.mLatitude, this.mLongitude);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Location[");
        s.append(this.mProvider);
        s.append(" ").append(String.format(Locale.ROOT, "%.6f,%.6f", this.mLatitude, this.mLongitude));
        if (this.hasAccuracy()) {
            s.append(" hAcc=").append(this.mHorizontalAccuracyMeters);
        }
        s.append(" et=");
        TimeUtils.formatDuration(this.getElapsedRealtimeMillis(), s);
        if (this.hasAltitude()) {
            s.append(" alt=").append(this.mAltitude);
            if (this.hasVerticalAccuracy()) {
                s.append(" vAcc=").append(this.mVerticalAccuracyMeters);
            }
        }
        if (this.hasSpeed()) {
            s.append(" vel=").append(this.mSpeed);
            if (this.hasSpeedAccuracy()) {
                s.append(" sAcc=").append(this.mSpeedAccuracyMetersPerSecond);
            }
        }
        if (this.hasBearing()) {
            s.append(" bear=").append(this.mBearing);
            if (this.hasBearingAccuracy()) {
                s.append(" bAcc=").append(this.mBearingAccuracyDegrees);
            }
        }
        if (this.isMock()) {
            s.append(" mock");
        }
        if (this.mExtras != null) {
            s.append(" {").append(this.mExtras).append('}');
        }
        s.append(']');
        return s.toString();
    }

    public void dump(Printer pw, String prefix) {
        pw.println(prefix + this.toString());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mProvider);
        parcel.writeInt(this.mFieldsMask);
        parcel.writeLong(this.mTime);
        parcel.writeLong(this.mElapsedRealtimeNanos);
        if (this.hasElapsedRealtimeUncertaintyNanos()) {
            parcel.writeDouble(this.mElapsedRealtimeUncertaintyNanos);
        }
        parcel.writeDouble(this.mLatitude);
        parcel.writeDouble(this.mLongitude);
        if (this.hasAltitude()) {
            parcel.writeDouble(this.mAltitude);
        }
        if (this.hasSpeed()) {
            parcel.writeFloat(this.mSpeed);
        }
        if (this.hasBearing()) {
            parcel.writeFloat(this.mBearing);
        }
        if (this.hasAccuracy()) {
            parcel.writeFloat(this.mHorizontalAccuracyMeters);
        }
        if (this.hasVerticalAccuracy()) {
            parcel.writeFloat(this.mVerticalAccuracyMeters);
        }
        if (this.hasSpeedAccuracy()) {
            parcel.writeFloat(this.mSpeedAccuracyMetersPerSecond);
        }
        if (this.hasBearingAccuracy()) {
            parcel.writeFloat(this.mBearingAccuracyDegrees);
        }
        parcel.writeBundle(this.mExtras);
    }

    @Deprecated
    public boolean isFromMockProvider() {
        return this.isMock();
    }

    @Deprecated
    @SystemApi
    public void setIsFromMockProvider(boolean isFromMockProvider) {
        this.setMock(isFromMockProvider);
    }

    public boolean isMock() {
        return (this.mFieldsMask & 0x10) != 0;
    }

    public void setMock(boolean mock) {
        this.mFieldsMask = mock ? (this.mFieldsMask |= 0x10) : (this.mFieldsMask &= 0xFFFFFFEF);
    }

    private static class BearingDistanceCache {
        double mLat1 = 0.0;
        double mLon1 = 0.0;
        double mLat2 = 0.0;
        double mLon2 = 0.0;
        float mDistance = 0.0f;
        float mInitialBearing = 0.0f;
        float mFinalBearing = 0.0f;

        private BearingDistanceCache() {
        }
    }
}

