/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.security.InvalidParameterException;

@Deprecated
@SystemApi
public class GpsNavigationMessage
implements Parcelable {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    public static final byte TYPE_UNKNOWN = 0;
    public static final byte TYPE_L1CA = 1;
    public static final byte TYPE_L2CNAV = 2;
    public static final byte TYPE_L5CNAV = 3;
    public static final byte TYPE_CNAV2 = 4;
    public static final short STATUS_UNKNOWN = 0;
    public static final short STATUS_PARITY_PASSED = 1;
    public static final short STATUS_PARITY_REBUILT = 2;
    private byte mType;
    private byte mPrn;
    private short mMessageId;
    private short mSubmessageId;
    private byte[] mData;
    private short mStatus;
    public static final Parcelable.Creator<GpsNavigationMessage> CREATOR = new Parcelable.Creator<GpsNavigationMessage>(){

        @Override
        public GpsNavigationMessage createFromParcel(Parcel parcel) {
            GpsNavigationMessage navigationMessage = new GpsNavigationMessage();
            navigationMessage.setType(parcel.readByte());
            navigationMessage.setPrn(parcel.readByte());
            navigationMessage.setMessageId((short)parcel.readInt());
            navigationMessage.setSubmessageId((short)parcel.readInt());
            int dataLength = parcel.readInt();
            byte[] data = new byte[dataLength];
            parcel.readByteArray(data);
            navigationMessage.setData(data);
            int status = parcel.readInt();
            navigationMessage.setStatus((short)status);
            return navigationMessage;
        }

        public GpsNavigationMessage[] newArray(int size) {
            return new GpsNavigationMessage[size];
        }
    };

    GpsNavigationMessage() {
        this.initialize();
    }

    public void set(GpsNavigationMessage navigationMessage) {
        this.mType = navigationMessage.mType;
        this.mPrn = navigationMessage.mPrn;
        this.mMessageId = navigationMessage.mMessageId;
        this.mSubmessageId = navigationMessage.mSubmessageId;
        this.mData = navigationMessage.mData;
        this.mStatus = navigationMessage.mStatus;
    }

    public void reset() {
        this.initialize();
    }

    public byte getType() {
        return this.mType;
    }

    public void setType(byte value2) {
        this.mType = value2;
    }

    private String getTypeString() {
        switch (this.mType) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "L1 C/A";
            }
            case 2: {
                return "L2-CNAV";
            }
            case 3: {
                return "L5-CNAV";
            }
            case 4: {
                return "CNAV-2";
            }
        }
        return "<Invalid:" + this.mType + ">";
    }

    public byte getPrn() {
        return this.mPrn;
    }

    public void setPrn(byte value2) {
        this.mPrn = value2;
    }

    public short getMessageId() {
        return this.mMessageId;
    }

    public void setMessageId(short value2) {
        this.mMessageId = value2;
    }

    public short getSubmessageId() {
        return this.mSubmessageId;
    }

    public void setSubmessageId(short value2) {
        this.mSubmessageId = value2;
    }

    public byte[] getData() {
        return this.mData;
    }

    public void setData(byte[] value2) {
        if (value2 == null) {
            throw new InvalidParameterException("Data must be a non-null array");
        }
        this.mData = value2;
    }

    public short getStatus() {
        return this.mStatus;
    }

    public void setStatus(short value2) {
        this.mStatus = value2;
    }

    private String getStatusString() {
        switch (this.mStatus) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "ParityPassed";
            }
            case 2: {
                return "ParityRebuilt";
            }
        }
        return "<Invalid:" + this.mStatus + ">";
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeByte(this.mType);
        parcel.writeByte(this.mPrn);
        parcel.writeInt(this.mMessageId);
        parcel.writeInt(this.mSubmessageId);
        parcel.writeInt(this.mData.length);
        parcel.writeByteArray(this.mData);
        parcel.writeInt(this.mStatus);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        String format = "   %-15s = %s\n";
        StringBuilder builder2 = new StringBuilder("GpsNavigationMessage:\n");
        builder2.append(String.format("   %-15s = %s\n", "Type", this.getTypeString()));
        builder2.append(String.format("   %-15s = %s\n", "Prn", this.mPrn));
        builder2.append(String.format("   %-15s = %s\n", "Status", this.getStatusString()));
        builder2.append(String.format("   %-15s = %s\n", "MessageId", this.mMessageId));
        builder2.append(String.format("   %-15s = %s\n", "SubmessageId", this.mSubmessageId));
        builder2.append(String.format("   %-15s = %s\n", "Data", "{"));
        String prefix = "        ";
        for (byte value2 : this.mData) {
            builder2.append(prefix);
            builder2.append(value2);
            prefix = ", ";
        }
        builder2.append(" }");
        return builder2.toString();
    }

    private void initialize() {
        this.mType = 0;
        this.mPrn = 0;
        this.mMessageId = (short)-1;
        this.mSubmessageId = (short)-1;
        this.mData = EMPTY_ARRAY;
        this.mStatus = 0;
    }
}

