/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SystemApi;
import android.location.GpsClock;
import android.location.GpsMeasurement;
import android.os.Parcel;
import android.os.Parcelable;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Deprecated
@SystemApi
public class GpsMeasurementsEvent
implements Parcelable {
    public static final int STATUS_NOT_SUPPORTED = 0;
    public static final int STATUS_READY = 1;
    public static final int STATUS_GPS_LOCATION_DISABLED = 2;
    private final GpsClock mClock;
    private final Collection<GpsMeasurement> mReadOnlyMeasurements;
    public static final Parcelable.Creator<GpsMeasurementsEvent> CREATOR = new Parcelable.Creator<GpsMeasurementsEvent>(){

        @Override
        public GpsMeasurementsEvent createFromParcel(Parcel in) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            GpsClock clock = (GpsClock)in.readParcelable(classLoader);
            int measurementsLength = in.readInt();
            GpsMeasurement[] measurementsArray = new GpsMeasurement[measurementsLength];
            in.readTypedArray(measurementsArray, GpsMeasurement.CREATOR);
            return new GpsMeasurementsEvent(clock, measurementsArray);
        }

        public GpsMeasurementsEvent[] newArray(int size) {
            return new GpsMeasurementsEvent[size];
        }
    };

    public GpsMeasurementsEvent(GpsClock clock, GpsMeasurement[] measurements) {
        if (clock == null) {
            throw new InvalidParameterException("Parameter 'clock' must not be null.");
        }
        if (measurements == null || measurements.length == 0) {
            throw new InvalidParameterException("Parameter 'measurements' must not be null or empty.");
        }
        this.mClock = clock;
        List<GpsMeasurement> measurementCollection = Arrays.asList(measurements);
        this.mReadOnlyMeasurements = Collections.unmodifiableCollection(measurementCollection);
    }

    public GpsClock getClock() {
        return this.mClock;
    }

    public Collection<GpsMeasurement> getMeasurements() {
        return this.mReadOnlyMeasurements;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mClock, flags);
        int measurementsCount = this.mReadOnlyMeasurements.size();
        Parcelable[] measurementsArray = this.mReadOnlyMeasurements.toArray(new GpsMeasurement[measurementsCount]);
        parcel.writeInt(measurementsArray.length);
        parcel.writeTypedArray(measurementsArray, flags);
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder("[ GpsMeasurementsEvent:\n\n");
        builder2.append(this.mClock.toString());
        builder2.append("\n");
        for (GpsMeasurement measurement : this.mReadOnlyMeasurements) {
            builder2.append(measurement.toString());
            builder2.append("\n");
        }
        builder2.append("]");
        return builder2.toString();
    }

    @SystemApi
    public static interface Listener {
        public void onGpsMeasurementsReceived(GpsMeasurementsEvent var1);

        public void onStatusChanged(int var1);
    }
}

