/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;

@Deprecated
@SystemApi
public class GpsMeasurement
implements Parcelable {
    private int mFlags;
    private byte mPrn;
    private double mTimeOffsetInNs;
    private short mState;
    private long mReceivedGpsTowInNs;
    private long mReceivedGpsTowUncertaintyInNs;
    private double mCn0InDbHz;
    private double mPseudorangeRateInMetersPerSec;
    private double mPseudorangeRateUncertaintyInMetersPerSec;
    private short mAccumulatedDeltaRangeState;
    private double mAccumulatedDeltaRangeInMeters;
    private double mAccumulatedDeltaRangeUncertaintyInMeters;
    private double mPseudorangeInMeters;
    private double mPseudorangeUncertaintyInMeters;
    private double mCodePhaseInChips;
    private double mCodePhaseUncertaintyInChips;
    private float mCarrierFrequencyInHz;
    private long mCarrierCycles;
    private double mCarrierPhase;
    private double mCarrierPhaseUncertainty;
    private byte mLossOfLock;
    private int mBitNumber;
    private short mTimeFromLastBitInMs;
    private double mDopplerShiftInHz;
    private double mDopplerShiftUncertaintyInHz;
    private byte mMultipathIndicator;
    private double mSnrInDb;
    private double mElevationInDeg;
    private double mElevationUncertaintyInDeg;
    private double mAzimuthInDeg;
    private double mAzimuthUncertaintyInDeg;
    private boolean mUsedInFix;
    private static final int HAS_NO_FLAGS = 0;
    private static final int HAS_SNR = 1;
    private static final int HAS_ELEVATION = 2;
    private static final int HAS_ELEVATION_UNCERTAINTY = 4;
    private static final int HAS_AZIMUTH = 8;
    private static final int HAS_AZIMUTH_UNCERTAINTY = 16;
    private static final int HAS_PSEUDORANGE = 32;
    private static final int HAS_PSEUDORANGE_UNCERTAINTY = 64;
    private static final int HAS_CODE_PHASE = 128;
    private static final int HAS_CODE_PHASE_UNCERTAINTY = 256;
    private static final int HAS_CARRIER_FREQUENCY = 512;
    private static final int HAS_CARRIER_CYCLES = 1024;
    private static final int HAS_CARRIER_PHASE = 2048;
    private static final int HAS_CARRIER_PHASE_UNCERTAINTY = 4096;
    private static final int HAS_BIT_NUMBER = 8192;
    private static final int HAS_TIME_FROM_LAST_BIT = 16384;
    private static final int HAS_DOPPLER_SHIFT = 32768;
    private static final int HAS_DOPPLER_SHIFT_UNCERTAINTY = 65536;
    private static final int HAS_USED_IN_FIX = 131072;
    private static final int GPS_MEASUREMENT_HAS_UNCORRECTED_PSEUDORANGE_RATE = 262144;
    public static final byte LOSS_OF_LOCK_UNKNOWN = 0;
    public static final byte LOSS_OF_LOCK_OK = 1;
    public static final byte LOSS_OF_LOCK_CYCLE_SLIP = 2;
    public static final byte MULTIPATH_INDICATOR_UNKNOWN = 0;
    public static final byte MULTIPATH_INDICATOR_DETECTED = 1;
    public static final byte MULTIPATH_INDICATOR_NOT_USED = 2;
    public static final short STATE_UNKNOWN = 0;
    public static final short STATE_CODE_LOCK = 1;
    public static final short STATE_BIT_SYNC = 2;
    public static final short STATE_SUBFRAME_SYNC = 4;
    public static final short STATE_TOW_DECODED = 8;
    public static final short STATE_MSEC_AMBIGUOUS = 16;
    private static final short STATE_ALL = 31;
    public static final short ADR_STATE_UNKNOWN = 0;
    public static final short ADR_STATE_VALID = 1;
    public static final short ADR_STATE_RESET = 2;
    public static final short ADR_STATE_CYCLE_SLIP = 4;
    private static final short ADR_ALL = 7;
    public static final Parcelable.Creator<GpsMeasurement> CREATOR = new Parcelable.Creator<GpsMeasurement>(){

        @Override
        public GpsMeasurement createFromParcel(Parcel parcel) {
            GpsMeasurement gpsMeasurement = new GpsMeasurement();
            gpsMeasurement.mFlags = parcel.readInt();
            gpsMeasurement.mPrn = parcel.readByte();
            gpsMeasurement.mTimeOffsetInNs = parcel.readDouble();
            gpsMeasurement.mState = (short)parcel.readInt();
            gpsMeasurement.mReceivedGpsTowInNs = parcel.readLong();
            gpsMeasurement.mReceivedGpsTowUncertaintyInNs = parcel.readLong();
            gpsMeasurement.mCn0InDbHz = parcel.readDouble();
            gpsMeasurement.mPseudorangeRateInMetersPerSec = parcel.readDouble();
            gpsMeasurement.mPseudorangeRateUncertaintyInMetersPerSec = parcel.readDouble();
            gpsMeasurement.mAccumulatedDeltaRangeState = (short)parcel.readInt();
            gpsMeasurement.mAccumulatedDeltaRangeInMeters = parcel.readDouble();
            gpsMeasurement.mAccumulatedDeltaRangeUncertaintyInMeters = parcel.readDouble();
            gpsMeasurement.mPseudorangeInMeters = parcel.readDouble();
            gpsMeasurement.mPseudorangeUncertaintyInMeters = parcel.readDouble();
            gpsMeasurement.mCodePhaseInChips = parcel.readDouble();
            gpsMeasurement.mCodePhaseUncertaintyInChips = parcel.readDouble();
            gpsMeasurement.mCarrierFrequencyInHz = parcel.readFloat();
            gpsMeasurement.mCarrierCycles = parcel.readLong();
            gpsMeasurement.mCarrierPhase = parcel.readDouble();
            gpsMeasurement.mCarrierPhaseUncertainty = parcel.readDouble();
            gpsMeasurement.mLossOfLock = parcel.readByte();
            gpsMeasurement.mBitNumber = parcel.readInt();
            gpsMeasurement.mTimeFromLastBitInMs = (short)parcel.readInt();
            gpsMeasurement.mDopplerShiftInHz = parcel.readDouble();
            gpsMeasurement.mDopplerShiftUncertaintyInHz = parcel.readDouble();
            gpsMeasurement.mMultipathIndicator = parcel.readByte();
            gpsMeasurement.mSnrInDb = parcel.readDouble();
            gpsMeasurement.mElevationInDeg = parcel.readDouble();
            gpsMeasurement.mElevationUncertaintyInDeg = parcel.readDouble();
            gpsMeasurement.mAzimuthInDeg = parcel.readDouble();
            gpsMeasurement.mAzimuthUncertaintyInDeg = parcel.readDouble();
            gpsMeasurement.mUsedInFix = parcel.readInt() != 0;
            return gpsMeasurement;
        }

        public GpsMeasurement[] newArray(int i) {
            return new GpsMeasurement[i];
        }
    };

    GpsMeasurement() {
        this.initialize();
    }

    public void set(GpsMeasurement measurement) {
        this.mFlags = measurement.mFlags;
        this.mPrn = measurement.mPrn;
        this.mTimeOffsetInNs = measurement.mTimeOffsetInNs;
        this.mState = measurement.mState;
        this.mReceivedGpsTowInNs = measurement.mReceivedGpsTowInNs;
        this.mReceivedGpsTowUncertaintyInNs = measurement.mReceivedGpsTowUncertaintyInNs;
        this.mCn0InDbHz = measurement.mCn0InDbHz;
        this.mPseudorangeRateInMetersPerSec = measurement.mPseudorangeRateInMetersPerSec;
        this.mPseudorangeRateUncertaintyInMetersPerSec = measurement.mPseudorangeRateUncertaintyInMetersPerSec;
        this.mAccumulatedDeltaRangeState = measurement.mAccumulatedDeltaRangeState;
        this.mAccumulatedDeltaRangeInMeters = measurement.mAccumulatedDeltaRangeInMeters;
        this.mAccumulatedDeltaRangeUncertaintyInMeters = measurement.mAccumulatedDeltaRangeUncertaintyInMeters;
        this.mPseudorangeInMeters = measurement.mPseudorangeInMeters;
        this.mPseudorangeUncertaintyInMeters = measurement.mPseudorangeUncertaintyInMeters;
        this.mCodePhaseInChips = measurement.mCodePhaseInChips;
        this.mCodePhaseUncertaintyInChips = measurement.mCodePhaseUncertaintyInChips;
        this.mCarrierFrequencyInHz = measurement.mCarrierFrequencyInHz;
        this.mCarrierCycles = measurement.mCarrierCycles;
        this.mCarrierPhase = measurement.mCarrierPhase;
        this.mCarrierPhaseUncertainty = measurement.mCarrierPhaseUncertainty;
        this.mLossOfLock = measurement.mLossOfLock;
        this.mBitNumber = measurement.mBitNumber;
        this.mTimeFromLastBitInMs = measurement.mTimeFromLastBitInMs;
        this.mDopplerShiftInHz = measurement.mDopplerShiftInHz;
        this.mDopplerShiftUncertaintyInHz = measurement.mDopplerShiftUncertaintyInHz;
        this.mMultipathIndicator = measurement.mMultipathIndicator;
        this.mSnrInDb = measurement.mSnrInDb;
        this.mElevationInDeg = measurement.mElevationInDeg;
        this.mElevationUncertaintyInDeg = measurement.mElevationUncertaintyInDeg;
        this.mAzimuthInDeg = measurement.mAzimuthInDeg;
        this.mAzimuthUncertaintyInDeg = measurement.mAzimuthUncertaintyInDeg;
        this.mUsedInFix = measurement.mUsedInFix;
    }

    public void reset() {
        this.initialize();
    }

    public byte getPrn() {
        return this.mPrn;
    }

    public void setPrn(byte value2) {
        this.mPrn = value2;
    }

    public double getTimeOffsetInNs() {
        return this.mTimeOffsetInNs;
    }

    public void setTimeOffsetInNs(double value2) {
        this.mTimeOffsetInNs = value2;
    }

    public short getState() {
        return this.mState;
    }

    public void setState(short value2) {
        this.mState = value2;
    }

    private String getStateString() {
        int remainingStates;
        if (this.mState == 0) {
            return "Unknown";
        }
        StringBuilder builder2 = new StringBuilder();
        if ((this.mState & 1) == 1) {
            builder2.append("CodeLock|");
        }
        if ((this.mState & 2) == 2) {
            builder2.append("BitSync|");
        }
        if ((this.mState & 4) == 4) {
            builder2.append("SubframeSync|");
        }
        if ((this.mState & 8) == 8) {
            builder2.append("TowDecoded|");
        }
        if ((this.mState & 0x10) == 16) {
            builder2.append("MsecAmbiguous");
        }
        if ((remainingStates = this.mState & 0xFFFFFFE0) > 0) {
            builder2.append("Other(");
            builder2.append(Integer.toBinaryString(remainingStates));
            builder2.append(")|");
        }
        builder2.deleteCharAt(builder2.length() - 1);
        return builder2.toString();
    }

    public long getReceivedGpsTowInNs() {
        return this.mReceivedGpsTowInNs;
    }

    public void setReceivedGpsTowInNs(long value2) {
        this.mReceivedGpsTowInNs = value2;
    }

    public long getReceivedGpsTowUncertaintyInNs() {
        return this.mReceivedGpsTowUncertaintyInNs;
    }

    public void setReceivedGpsTowUncertaintyInNs(long value2) {
        this.mReceivedGpsTowUncertaintyInNs = value2;
    }

    public double getCn0InDbHz() {
        return this.mCn0InDbHz;
    }

    public void setCn0InDbHz(double value2) {
        this.mCn0InDbHz = value2;
    }

    public double getPseudorangeRateInMetersPerSec() {
        return this.mPseudorangeRateInMetersPerSec;
    }

    public void setPseudorangeRateInMetersPerSec(double value2) {
        this.mPseudorangeRateInMetersPerSec = value2;
    }

    public boolean isPseudorangeRateCorrected() {
        return !this.isFlagSet(262144);
    }

    public double getPseudorangeRateUncertaintyInMetersPerSec() {
        return this.mPseudorangeRateUncertaintyInMetersPerSec;
    }

    public void setPseudorangeRateUncertaintyInMetersPerSec(double value2) {
        this.mPseudorangeRateUncertaintyInMetersPerSec = value2;
    }

    public short getAccumulatedDeltaRangeState() {
        return this.mAccumulatedDeltaRangeState;
    }

    public void setAccumulatedDeltaRangeState(short value2) {
        this.mAccumulatedDeltaRangeState = value2;
    }

    private String getAccumulatedDeltaRangeStateString() {
        int remainingStates;
        if (this.mAccumulatedDeltaRangeState == 0) {
            return "Unknown";
        }
        StringBuilder builder2 = new StringBuilder();
        if ((this.mAccumulatedDeltaRangeState & 1) == 1) {
            builder2.append("Valid|");
        }
        if ((this.mAccumulatedDeltaRangeState & 2) == 2) {
            builder2.append("Reset|");
        }
        if ((this.mAccumulatedDeltaRangeState & 4) == 4) {
            builder2.append("CycleSlip|");
        }
        if ((remainingStates = this.mAccumulatedDeltaRangeState & 0xFFFFFFF8) > 0) {
            builder2.append("Other(");
            builder2.append(Integer.toBinaryString(remainingStates));
            builder2.append(")|");
        }
        builder2.deleteCharAt(builder2.length() - 1);
        return builder2.toString();
    }

    public double getAccumulatedDeltaRangeInMeters() {
        return this.mAccumulatedDeltaRangeInMeters;
    }

    public void setAccumulatedDeltaRangeInMeters(double value2) {
        this.mAccumulatedDeltaRangeInMeters = value2;
    }

    public double getAccumulatedDeltaRangeUncertaintyInMeters() {
        return this.mAccumulatedDeltaRangeUncertaintyInMeters;
    }

    public void setAccumulatedDeltaRangeUncertaintyInMeters(double value2) {
        this.mAccumulatedDeltaRangeUncertaintyInMeters = value2;
    }

    public boolean hasPseudorangeInMeters() {
        return this.isFlagSet(32);
    }

    public double getPseudorangeInMeters() {
        return this.mPseudorangeInMeters;
    }

    public void setPseudorangeInMeters(double value2) {
        this.setFlag(32);
        this.mPseudorangeInMeters = value2;
    }

    public void resetPseudorangeInMeters() {
        this.resetFlag(32);
        this.mPseudorangeInMeters = Double.NaN;
    }

    public boolean hasPseudorangeUncertaintyInMeters() {
        return this.isFlagSet(64);
    }

    public double getPseudorangeUncertaintyInMeters() {
        return this.mPseudorangeUncertaintyInMeters;
    }

    public void setPseudorangeUncertaintyInMeters(double value2) {
        this.setFlag(64);
        this.mPseudorangeUncertaintyInMeters = value2;
    }

    public void resetPseudorangeUncertaintyInMeters() {
        this.resetFlag(64);
        this.mPseudorangeUncertaintyInMeters = Double.NaN;
    }

    public boolean hasCodePhaseInChips() {
        return this.isFlagSet(128);
    }

    public double getCodePhaseInChips() {
        return this.mCodePhaseInChips;
    }

    public void setCodePhaseInChips(double value2) {
        this.setFlag(128);
        this.mCodePhaseInChips = value2;
    }

    public void resetCodePhaseInChips() {
        this.resetFlag(128);
        this.mCodePhaseInChips = Double.NaN;
    }

    public boolean hasCodePhaseUncertaintyInChips() {
        return this.isFlagSet(256);
    }

    public double getCodePhaseUncertaintyInChips() {
        return this.mCodePhaseUncertaintyInChips;
    }

    public void setCodePhaseUncertaintyInChips(double value2) {
        this.setFlag(256);
        this.mCodePhaseUncertaintyInChips = value2;
    }

    public void resetCodePhaseUncertaintyInChips() {
        this.resetFlag(256);
        this.mCodePhaseUncertaintyInChips = Double.NaN;
    }

    public boolean hasCarrierFrequencyInHz() {
        return this.isFlagSet(512);
    }

    public float getCarrierFrequencyInHz() {
        return this.mCarrierFrequencyInHz;
    }

    public void setCarrierFrequencyInHz(float carrierFrequencyInHz) {
        this.setFlag(512);
        this.mCarrierFrequencyInHz = carrierFrequencyInHz;
    }

    public void resetCarrierFrequencyInHz() {
        this.resetFlag(512);
        this.mCarrierFrequencyInHz = Float.NaN;
    }

    public boolean hasCarrierCycles() {
        return this.isFlagSet(1024);
    }

    public long getCarrierCycles() {
        return this.mCarrierCycles;
    }

    public void setCarrierCycles(long value2) {
        this.setFlag(1024);
        this.mCarrierCycles = value2;
    }

    public void resetCarrierCycles() {
        this.resetFlag(1024);
        this.mCarrierCycles = Long.MIN_VALUE;
    }

    public boolean hasCarrierPhase() {
        return this.isFlagSet(2048);
    }

    public double getCarrierPhase() {
        return this.mCarrierPhase;
    }

    public void setCarrierPhase(double value2) {
        this.setFlag(2048);
        this.mCarrierPhase = value2;
    }

    public void resetCarrierPhase() {
        this.resetFlag(2048);
        this.mCarrierPhase = Double.NaN;
    }

    public boolean hasCarrierPhaseUncertainty() {
        return this.isFlagSet(4096);
    }

    public double getCarrierPhaseUncertainty() {
        return this.mCarrierPhaseUncertainty;
    }

    public void setCarrierPhaseUncertainty(double value2) {
        this.setFlag(4096);
        this.mCarrierPhaseUncertainty = value2;
    }

    public void resetCarrierPhaseUncertainty() {
        this.resetFlag(4096);
        this.mCarrierPhaseUncertainty = Double.NaN;
    }

    public byte getLossOfLock() {
        return this.mLossOfLock;
    }

    public void setLossOfLock(byte value2) {
        this.mLossOfLock = value2;
    }

    private String getLossOfLockString() {
        switch (this.mLossOfLock) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Ok";
            }
            case 2: {
                return "CycleSlip";
            }
        }
        return "<Invalid:" + this.mLossOfLock + ">";
    }

    public boolean hasBitNumber() {
        return this.isFlagSet(8192);
    }

    public int getBitNumber() {
        return this.mBitNumber;
    }

    public void setBitNumber(int bitNumber) {
        this.setFlag(8192);
        this.mBitNumber = bitNumber;
    }

    public void resetBitNumber() {
        this.resetFlag(8192);
        this.mBitNumber = Integer.MIN_VALUE;
    }

    public boolean hasTimeFromLastBitInMs() {
        return this.isFlagSet(16384);
    }

    public short getTimeFromLastBitInMs() {
        return this.mTimeFromLastBitInMs;
    }

    public void setTimeFromLastBitInMs(short value2) {
        this.setFlag(16384);
        this.mTimeFromLastBitInMs = value2;
    }

    public void resetTimeFromLastBitInMs() {
        this.resetFlag(16384);
        this.mTimeFromLastBitInMs = (short)Short.MIN_VALUE;
    }

    public boolean hasDopplerShiftInHz() {
        return this.isFlagSet(32768);
    }

    public double getDopplerShiftInHz() {
        return this.mDopplerShiftInHz;
    }

    public void setDopplerShiftInHz(double value2) {
        this.setFlag(32768);
        this.mDopplerShiftInHz = value2;
    }

    public void resetDopplerShiftInHz() {
        this.resetFlag(32768);
        this.mDopplerShiftInHz = Double.NaN;
    }

    public boolean hasDopplerShiftUncertaintyInHz() {
        return this.isFlagSet(65536);
    }

    public double getDopplerShiftUncertaintyInHz() {
        return this.mDopplerShiftUncertaintyInHz;
    }

    public void setDopplerShiftUncertaintyInHz(double value2) {
        this.setFlag(65536);
        this.mDopplerShiftUncertaintyInHz = value2;
    }

    public void resetDopplerShiftUncertaintyInHz() {
        this.resetFlag(65536);
        this.mDopplerShiftUncertaintyInHz = Double.NaN;
    }

    public byte getMultipathIndicator() {
        return this.mMultipathIndicator;
    }

    public void setMultipathIndicator(byte value2) {
        this.mMultipathIndicator = value2;
    }

    private String getMultipathIndicatorString() {
        switch (this.mMultipathIndicator) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Detected";
            }
            case 2: {
                return "NotUsed";
            }
        }
        return "<Invalid:" + this.mMultipathIndicator + ">";
    }

    public boolean hasSnrInDb() {
        return this.isFlagSet(1);
    }

    public double getSnrInDb() {
        return this.mSnrInDb;
    }

    public void setSnrInDb(double snrInDb) {
        this.setFlag(1);
        this.mSnrInDb = snrInDb;
    }

    public void resetSnrInDb() {
        this.resetFlag(1);
        this.mSnrInDb = Double.NaN;
    }

    public boolean hasElevationInDeg() {
        return this.isFlagSet(2);
    }

    public double getElevationInDeg() {
        return this.mElevationInDeg;
    }

    public void setElevationInDeg(double elevationInDeg) {
        this.setFlag(2);
        this.mElevationInDeg = elevationInDeg;
    }

    public void resetElevationInDeg() {
        this.resetFlag(2);
        this.mElevationInDeg = Double.NaN;
    }

    public boolean hasElevationUncertaintyInDeg() {
        return this.isFlagSet(4);
    }

    public double getElevationUncertaintyInDeg() {
        return this.mElevationUncertaintyInDeg;
    }

    public void setElevationUncertaintyInDeg(double value2) {
        this.setFlag(4);
        this.mElevationUncertaintyInDeg = value2;
    }

    public void resetElevationUncertaintyInDeg() {
        this.resetFlag(4);
        this.mElevationUncertaintyInDeg = Double.NaN;
    }

    public boolean hasAzimuthInDeg() {
        return this.isFlagSet(8);
    }

    public double getAzimuthInDeg() {
        return this.mAzimuthInDeg;
    }

    public void setAzimuthInDeg(double value2) {
        this.setFlag(8);
        this.mAzimuthInDeg = value2;
    }

    public void resetAzimuthInDeg() {
        this.resetFlag(8);
        this.mAzimuthInDeg = Double.NaN;
    }

    public boolean hasAzimuthUncertaintyInDeg() {
        return this.isFlagSet(16);
    }

    public double getAzimuthUncertaintyInDeg() {
        return this.mAzimuthUncertaintyInDeg;
    }

    public void setAzimuthUncertaintyInDeg(double value2) {
        this.setFlag(16);
        this.mAzimuthUncertaintyInDeg = value2;
    }

    public void resetAzimuthUncertaintyInDeg() {
        this.resetFlag(16);
        this.mAzimuthUncertaintyInDeg = Double.NaN;
    }

    public boolean isUsedInFix() {
        return this.mUsedInFix;
    }

    public void setUsedInFix(boolean value2) {
        this.mUsedInFix = value2;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mFlags);
        parcel.writeByte(this.mPrn);
        parcel.writeDouble(this.mTimeOffsetInNs);
        parcel.writeInt(this.mState);
        parcel.writeLong(this.mReceivedGpsTowInNs);
        parcel.writeLong(this.mReceivedGpsTowUncertaintyInNs);
        parcel.writeDouble(this.mCn0InDbHz);
        parcel.writeDouble(this.mPseudorangeRateInMetersPerSec);
        parcel.writeDouble(this.mPseudorangeRateUncertaintyInMetersPerSec);
        parcel.writeInt(this.mAccumulatedDeltaRangeState);
        parcel.writeDouble(this.mAccumulatedDeltaRangeInMeters);
        parcel.writeDouble(this.mAccumulatedDeltaRangeUncertaintyInMeters);
        parcel.writeDouble(this.mPseudorangeInMeters);
        parcel.writeDouble(this.mPseudorangeUncertaintyInMeters);
        parcel.writeDouble(this.mCodePhaseInChips);
        parcel.writeDouble(this.mCodePhaseUncertaintyInChips);
        parcel.writeFloat(this.mCarrierFrequencyInHz);
        parcel.writeLong(this.mCarrierCycles);
        parcel.writeDouble(this.mCarrierPhase);
        parcel.writeDouble(this.mCarrierPhaseUncertainty);
        parcel.writeByte(this.mLossOfLock);
        parcel.writeInt(this.mBitNumber);
        parcel.writeInt(this.mTimeFromLastBitInMs);
        parcel.writeDouble(this.mDopplerShiftInHz);
        parcel.writeDouble(this.mDopplerShiftUncertaintyInHz);
        parcel.writeByte(this.mMultipathIndicator);
        parcel.writeDouble(this.mSnrInDb);
        parcel.writeDouble(this.mElevationInDeg);
        parcel.writeDouble(this.mElevationUncertaintyInDeg);
        parcel.writeDouble(this.mAzimuthInDeg);
        parcel.writeDouble(this.mAzimuthUncertaintyInDeg);
        parcel.writeInt(this.mUsedInFix ? 1 : 0);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        String format = "   %-29s = %s\n";
        String formatWithUncertainty = "   %-29s = %-25s   %-40s = %s\n";
        StringBuilder builder2 = new StringBuilder("GpsMeasurement:\n");
        builder2.append(String.format("   %-29s = %s\n", "Prn", this.mPrn));
        builder2.append(String.format("   %-29s = %s\n", "TimeOffsetInNs", this.mTimeOffsetInNs));
        builder2.append(String.format("   %-29s = %s\n", "State", this.getStateString()));
        builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "ReceivedGpsTowInNs", this.mReceivedGpsTowInNs, "ReceivedGpsTowUncertaintyInNs", this.mReceivedGpsTowUncertaintyInNs));
        builder2.append(String.format("   %-29s = %s\n", "Cn0InDbHz", this.mCn0InDbHz));
        builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "PseudorangeRateInMetersPerSec", this.mPseudorangeRateInMetersPerSec, "PseudorangeRateUncertaintyInMetersPerSec", this.mPseudorangeRateUncertaintyInMetersPerSec));
        builder2.append(String.format("   %-29s = %s\n", "PseudorangeRateIsCorrected", this.isPseudorangeRateCorrected()));
        builder2.append(String.format("   %-29s = %s\n", "AccumulatedDeltaRangeState", this.getAccumulatedDeltaRangeStateString()));
        builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "AccumulatedDeltaRangeInMeters", this.mAccumulatedDeltaRangeInMeters, "AccumulatedDeltaRangeUncertaintyInMeters", this.mAccumulatedDeltaRangeUncertaintyInMeters));
        builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "PseudorangeInMeters", this.hasPseudorangeInMeters() ? Double.valueOf(this.mPseudorangeInMeters) : null, "PseudorangeUncertaintyInMeters", this.hasPseudorangeUncertaintyInMeters() ? Double.valueOf(this.mPseudorangeUncertaintyInMeters) : null));
        builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "CodePhaseInChips", this.hasCodePhaseInChips() ? Double.valueOf(this.mCodePhaseInChips) : null, "CodePhaseUncertaintyInChips", this.hasCodePhaseUncertaintyInChips() ? Double.valueOf(this.mCodePhaseUncertaintyInChips) : null));
        builder2.append(String.format("   %-29s = %s\n", "CarrierFrequencyInHz", this.hasCarrierFrequencyInHz() ? Float.valueOf(this.mCarrierFrequencyInHz) : null));
        builder2.append(String.format("   %-29s = %s\n", "CarrierCycles", this.hasCarrierCycles() ? Long.valueOf(this.mCarrierCycles) : null));
        builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "CarrierPhase", this.hasCarrierPhase() ? Double.valueOf(this.mCarrierPhase) : null, "CarrierPhaseUncertainty", this.hasCarrierPhaseUncertainty() ? Double.valueOf(this.mCarrierPhaseUncertainty) : null));
        builder2.append(String.format("   %-29s = %s\n", "LossOfLock", this.getLossOfLockString()));
        builder2.append(String.format("   %-29s = %s\n", "BitNumber", this.hasBitNumber() ? Integer.valueOf(this.mBitNumber) : null));
        builder2.append(String.format("   %-29s = %s\n", "TimeFromLastBitInMs", this.hasTimeFromLastBitInMs() ? Short.valueOf(this.mTimeFromLastBitInMs) : null));
        builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "DopplerShiftInHz", this.hasDopplerShiftInHz() ? Double.valueOf(this.mDopplerShiftInHz) : null, "DopplerShiftUncertaintyInHz", this.hasDopplerShiftUncertaintyInHz() ? Double.valueOf(this.mDopplerShiftUncertaintyInHz) : null));
        builder2.append(String.format("   %-29s = %s\n", "MultipathIndicator", this.getMultipathIndicatorString()));
        builder2.append(String.format("   %-29s = %s\n", "SnrInDb", this.hasSnrInDb() ? Double.valueOf(this.mSnrInDb) : null));
        builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "ElevationInDeg", this.hasElevationInDeg() ? Double.valueOf(this.mElevationInDeg) : null, "ElevationUncertaintyInDeg", this.hasElevationUncertaintyInDeg() ? Double.valueOf(this.mElevationUncertaintyInDeg) : null));
        builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "AzimuthInDeg", this.hasAzimuthInDeg() ? Double.valueOf(this.mAzimuthInDeg) : null, "AzimuthUncertaintyInDeg", this.hasAzimuthUncertaintyInDeg() ? Double.valueOf(this.mAzimuthUncertaintyInDeg) : null));
        builder2.append(String.format("   %-29s = %s\n", "UsedInFix", this.mUsedInFix));
        return builder2.toString();
    }

    private void initialize() {
        this.mFlags = 0;
        this.setPrn((byte)-128);
        this.setTimeOffsetInNs(-9.223372036854776E18);
        this.setState((short)0);
        this.setReceivedGpsTowInNs(Long.MIN_VALUE);
        this.setReceivedGpsTowUncertaintyInNs(Long.MAX_VALUE);
        this.setCn0InDbHz(Double.MIN_VALUE);
        this.setPseudorangeRateInMetersPerSec(Double.MIN_VALUE);
        this.setPseudorangeRateUncertaintyInMetersPerSec(Double.MIN_VALUE);
        this.setAccumulatedDeltaRangeState((short)0);
        this.setAccumulatedDeltaRangeInMeters(Double.MIN_VALUE);
        this.setAccumulatedDeltaRangeUncertaintyInMeters(Double.MIN_VALUE);
        this.resetPseudorangeInMeters();
        this.resetPseudorangeUncertaintyInMeters();
        this.resetCodePhaseInChips();
        this.resetCodePhaseUncertaintyInChips();
        this.resetCarrierFrequencyInHz();
        this.resetCarrierCycles();
        this.resetCarrierPhase();
        this.resetCarrierPhaseUncertainty();
        this.setLossOfLock((byte)0);
        this.resetBitNumber();
        this.resetTimeFromLastBitInMs();
        this.resetDopplerShiftInHz();
        this.resetDopplerShiftUncertaintyInHz();
        this.setMultipathIndicator((byte)0);
        this.resetSnrInDb();
        this.resetElevationInDeg();
        this.resetElevationUncertaintyInDeg();
        this.resetAzimuthInDeg();
        this.resetAzimuthUncertaintyInDeg();
        this.setUsedInFix(false);
    }

    private void setFlag(int flag) {
        this.mFlags |= flag;
    }

    private void resetFlag(int flag) {
        this.mFlags &= ~flag;
    }

    private boolean isFlagSet(int flag) {
        return (this.mFlags & flag) == flag;
    }
}

