/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.InvalidParameterException;

public class GnssNavigationMessage
implements Parcelable {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_GPS_L1CA = 257;
    public static final int TYPE_GPS_L2CNAV = 258;
    public static final int TYPE_GPS_L5CNAV = 259;
    public static final int TYPE_GPS_CNAV2 = 260;
    public static final int TYPE_SBS = 513;
    public static final int TYPE_GLO_L1CA = 769;
    public static final int TYPE_QZS_L1CA = 1025;
    public static final int TYPE_BDS_D1 = 1281;
    public static final int TYPE_BDS_D2 = 1282;
    public static final int TYPE_BDS_CNAV1 = 1283;
    public static final int TYPE_BDS_CNAV2 = 1284;
    public static final int TYPE_GAL_I = 1537;
    public static final int TYPE_GAL_F = 1538;
    public static final int TYPE_IRN_L5CA = 1793;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_PARITY_PASSED = 1;
    public static final int STATUS_PARITY_REBUILT = 2;
    private int mType;
    private int mSvid;
    private int mMessageId;
    private int mSubmessageId;
    private byte[] mData;
    private int mStatus;
    public static final Parcelable.Creator<GnssNavigationMessage> CREATOR = new Parcelable.Creator<GnssNavigationMessage>(){

        @Override
        public GnssNavigationMessage createFromParcel(Parcel parcel) {
            GnssNavigationMessage navigationMessage = new GnssNavigationMessage();
            navigationMessage.setType(parcel.readInt());
            navigationMessage.setSvid(parcel.readInt());
            navigationMessage.setMessageId(parcel.readInt());
            navigationMessage.setSubmessageId(parcel.readInt());
            int dataLength = parcel.readInt();
            byte[] data = new byte[dataLength];
            parcel.readByteArray(data);
            navigationMessage.setData(data);
            navigationMessage.setStatus(parcel.readInt());
            return navigationMessage;
        }

        public GnssNavigationMessage[] newArray(int size) {
            return new GnssNavigationMessage[size];
        }
    };

    public GnssNavigationMessage() {
        this.initialize();
    }

    public void set(GnssNavigationMessage navigationMessage) {
        this.mType = navigationMessage.mType;
        this.mSvid = navigationMessage.mSvid;
        this.mMessageId = navigationMessage.mMessageId;
        this.mSubmessageId = navigationMessage.mSubmessageId;
        this.mData = navigationMessage.mData;
        this.mStatus = navigationMessage.mStatus;
    }

    public void reset() {
        this.initialize();
    }

    public int getType() {
        return this.mType;
    }

    public void setType(int value2) {
        this.mType = value2;
    }

    private String getTypeString() {
        switch (this.mType) {
            case 0: {
                return "Unknown";
            }
            case 257: {
                return "GPS L1 C/A";
            }
            case 258: {
                return "GPS L2-CNAV";
            }
            case 259: {
                return "GPS L5-CNAV";
            }
            case 260: {
                return "GPS CNAV2";
            }
            case 513: {
                return "SBS";
            }
            case 769: {
                return "Glonass L1 C/A";
            }
            case 1025: {
                return "QZSS L1 C/A";
            }
            case 1281: {
                return "Beidou D1";
            }
            case 1282: {
                return "Beidou D2";
            }
            case 1283: {
                return "Beidou CNAV1";
            }
            case 1284: {
                return "Beidou CNAV2";
            }
            case 1537: {
                return "Galileo I";
            }
            case 1538: {
                return "Galileo F";
            }
            case 1793: {
                return "IRNSS L5 C/A";
            }
        }
        return "<Invalid:" + this.mType + ">";
    }

    public int getSvid() {
        return this.mSvid;
    }

    public void setSvid(int value2) {
        this.mSvid = value2;
    }

    public int getMessageId() {
        return this.mMessageId;
    }

    public void setMessageId(int value2) {
        this.mMessageId = value2;
    }

    public int getSubmessageId() {
        return this.mSubmessageId;
    }

    public void setSubmessageId(int value2) {
        this.mSubmessageId = value2;
    }

    public byte[] getData() {
        return this.mData;
    }

    public void setData(byte[] value2) {
        if (value2 == null) {
            throw new InvalidParameterException("Data must be a non-null array");
        }
        this.mData = value2;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public void setStatus(int value2) {
        this.mStatus = value2;
    }

    private String getStatusString() {
        switch (this.mStatus) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "ParityPassed";
            }
            case 2: {
                return "ParityRebuilt";
            }
        }
        return "<Invalid:" + this.mStatus + ">";
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mType);
        parcel.writeInt(this.mSvid);
        parcel.writeInt(this.mMessageId);
        parcel.writeInt(this.mSubmessageId);
        parcel.writeInt(this.mData.length);
        parcel.writeByteArray(this.mData);
        parcel.writeInt(this.mStatus);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        String format = "   %-15s = %s\n";
        StringBuilder builder2 = new StringBuilder("GnssNavigationMessage:\n");
        builder2.append(String.format("   %-15s = %s\n", "Type", this.getTypeString()));
        builder2.append(String.format("   %-15s = %s\n", "Svid", this.mSvid));
        builder2.append(String.format("   %-15s = %s\n", "Status", this.getStatusString()));
        builder2.append(String.format("   %-15s = %s\n", "MessageId", this.mMessageId));
        builder2.append(String.format("   %-15s = %s\n", "SubmessageId", this.mSubmessageId));
        builder2.append(String.format("   %-15s = %s\n", "Data", "{"));
        String prefix = "        ";
        for (byte value2 : this.mData) {
            builder2.append(prefix);
            builder2.append(value2);
            prefix = ", ";
        }
        builder2.append(" }");
        return builder2.toString();
    }

    private void initialize() {
        this.mType = 0;
        this.mSvid = 0;
        this.mMessageId = -1;
        this.mSubmessageId = -1;
        this.mData = EMPTY_ARRAY;
        this.mStatus = 0;
    }

    public static abstract class Callback {
        @Deprecated
        public static final int STATUS_NOT_SUPPORTED = 0;
        @Deprecated
        public static final int STATUS_READY = 1;
        @Deprecated
        public static final int STATUS_LOCATION_DISABLED = 2;

        public void onGnssNavigationMessageReceived(GnssNavigationMessage event) {
        }

        @Deprecated
        public void onStatusChanged(int status) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface GnssNavigationMessageStatus {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GnssNavigationMessageStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GnssNavigationMessageType {
    }
}

