/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.compat.annotation.UnsupportedAppUsage;
import android.location.Country;
import android.location.CountryListener;
import android.location.ICountryDetector;
import android.location.ICountryListener;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import java.util.HashMap;

public class CountryDetector {
    private static final String TAG = "CountryDetector";
    private final ICountryDetector mService;
    private final HashMap<CountryListener, ListenerTransport> mListeners;

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public CountryDetector(ICountryDetector service) {
        this.mService = service;
        this.mListeners = new HashMap();
    }

    @UnsupportedAppUsage
    public Country detectCountry() {
        try {
            return this.mService.detectCountry();
        }
        catch (RemoteException e) {
            Log.e(TAG, "detectCountry: RemoteException", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void addCountryListener(CountryListener listener2, Looper looper) {
        HashMap<CountryListener, ListenerTransport> hashMap = this.mListeners;
        synchronized (hashMap) {
            if (!this.mListeners.containsKey(listener2)) {
                ListenerTransport transport = new ListenerTransport(listener2, looper);
                try {
                    this.mService.addCountryListener(transport);
                    this.mListeners.put(listener2, transport);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "addCountryListener: RemoteException", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void removeCountryListener(CountryListener listener2) {
        HashMap<CountryListener, ListenerTransport> hashMap = this.mListeners;
        synchronized (hashMap) {
            ListenerTransport transport = this.mListeners.get(listener2);
            if (transport != null) {
                try {
                    this.mListeners.remove(listener2);
                    this.mService.removeCountryListener(transport);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "removeCountryListener: RemoteException", e);
                }
            }
        }
    }

    private static class ListenerTransport
    extends ICountryListener.Stub {
        private final CountryListener mListener;
        private final Handler mHandler;

        public ListenerTransport(CountryListener listener2, Looper looper) {
            this.mListener = listener2;
            this.mHandler = looper != null ? new Handler(looper) : new Handler();
        }

        @Override
        public void onCountryDetected(final Country country) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mListener.onCountryDetected(country);
                }
            });
        }
    }
}

