/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUDebug;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.UResource;
import android.icu.impl.coll.CollationData;
import android.icu.impl.coll.CollationRoot;
import android.icu.lang.UCharacter;
import android.icu.text.CollationKey;
import android.icu.text.RawCollationKey;
import android.icu.text.RuleBasedCollator;
import android.icu.text.UnicodeSet;
import android.icu.util.Freezable;
import android.icu.util.ICUException;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import android.icu.util.VersionInfo;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;

public abstract class Collator
implements Comparator<Object>,
Freezable<Collator>,
Cloneable {
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int QUATERNARY = 3;
    public static final int IDENTICAL = 15;
    public static final int FULL_DECOMPOSITION = 15;
    public static final int NO_DECOMPOSITION = 16;
    public static final int CANONICAL_DECOMPOSITION = 17;
    private static ServiceShim shim;
    private static final String[] KEYWORDS;
    private static final String RESOURCE = "collations";
    private static final String BASE = "android/icu/impl/data/icudt68b/coll";
    private static final boolean DEBUG;

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return 0;
    }

    private void checkNotFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen Collator");
        }
    }

    public void setStrength(int newStrength) {
        this.checkNotFrozen();
    }

    @Deprecated
    public Collator setStrength2(int newStrength) {
        this.setStrength(newStrength);
        return this;
    }

    public void setDecomposition(int decomposition) {
        this.checkNotFrozen();
    }

    public void setReorderCodes(int ... order) {
        throw new UnsupportedOperationException("Needs to be implemented by the subclass.");
    }

    public static Collator getInstance() {
        return Collator.getInstance(ULocale.getDefault());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static ServiceShim getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName("android.icu.text.CollatorServiceShim");
                shim = (ServiceShim)cls.newInstance();
            }
            catch (MissingResourceException e) {
                throw e;
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                throw new ICUException(e);
            }
        }
        return shim;
    }

    private static boolean getYesOrNo(String keyword, String s) {
        if (ASCII.equalIgnoreCase(s, "yes")) {
            return true;
        }
        if (ASCII.equalIgnoreCase(s, "no")) {
            return false;
        }
        throw new IllegalArgumentException("illegal locale keyword=value: " + keyword + "=" + s);
    }

    private static int getIntValue(String keyword, String s, String ... values2) {
        for (int i = 0; i < values2.length; ++i) {
            if (!ASCII.equalIgnoreCase(s, values2[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("illegal locale keyword=value: " + keyword + "=" + s);
    }

    private static int getReorderCode(String keyword, String s) {
        return 4096 + Collator.getIntValue(keyword, s, "space", "punct", "symbol", "currency", "digit");
    }

    private static void setAttributesFromKeywords(ULocale loc, Collator coll, RuleBasedCollator rbc) {
        String value2 = loc.getKeywordValue("colHiraganaQuaternary");
        if (value2 != null) {
            throw new UnsupportedOperationException("locale keyword kh/colHiraganaQuaternary");
        }
        value2 = loc.getKeywordValue("variableTop");
        if (value2 != null) {
            throw new UnsupportedOperationException("locale keyword vt/variableTop");
        }
        value2 = loc.getKeywordValue("colStrength");
        if (value2 != null) {
            int strength = Collator.getIntValue("colStrength", value2, "primary", "secondary", "tertiary", "quaternary", "identical");
            coll.setStrength(strength <= 3 ? strength : 15);
        }
        if ((value2 = loc.getKeywordValue("colBackwards")) != null) {
            if (rbc != null) {
                rbc.setFrenchCollation(Collator.getYesOrNo("colBackwards", value2));
            } else {
                throw new UnsupportedOperationException("locale keyword kb/colBackwards only settable for RuleBasedCollator");
            }
        }
        if ((value2 = loc.getKeywordValue("colCaseLevel")) != null) {
            if (rbc != null) {
                rbc.setCaseLevel(Collator.getYesOrNo("colCaseLevel", value2));
            } else {
                throw new UnsupportedOperationException("locale keyword kb/colBackwards only settable for RuleBasedCollator");
            }
        }
        if ((value2 = loc.getKeywordValue("colCaseFirst")) != null) {
            if (rbc != null) {
                int cf = Collator.getIntValue("colCaseFirst", value2, "no", "lower", "upper");
                if (cf == 0) {
                    rbc.setLowerCaseFirst(false);
                    rbc.setUpperCaseFirst(false);
                } else if (cf == 1) {
                    rbc.setLowerCaseFirst(true);
                } else {
                    rbc.setUpperCaseFirst(true);
                }
            } else {
                throw new UnsupportedOperationException("locale keyword kf/colCaseFirst only settable for RuleBasedCollator");
            }
        }
        if ((value2 = loc.getKeywordValue("colAlternate")) != null) {
            if (rbc != null) {
                rbc.setAlternateHandlingShifted(Collator.getIntValue("colAlternate", value2, "non-ignorable", "shifted") != 0);
            } else {
                throw new UnsupportedOperationException("locale keyword ka/colAlternate only settable for RuleBasedCollator");
            }
        }
        if ((value2 = loc.getKeywordValue("colNormalization")) != null) {
            coll.setDecomposition(Collator.getYesOrNo("colNormalization", value2) ? 17 : 16);
        }
        if ((value2 = loc.getKeywordValue("colNumeric")) != null) {
            if (rbc != null) {
                rbc.setNumericCollation(Collator.getYesOrNo("colNumeric", value2));
            } else {
                throw new UnsupportedOperationException("locale keyword kn/colNumeric only settable for RuleBasedCollator");
            }
        }
        if ((value2 = loc.getKeywordValue("colReorder")) != null) {
            int[] codes = new int[198];
            int codesLength = 0;
            int scriptNameStart = 0;
            while (true) {
                int limit;
                if (codesLength == codes.length) {
                    throw new IllegalArgumentException("too many script codes for colReorder locale keyword: " + value2);
                }
                for (limit = scriptNameStart; limit < value2.length() && value2.charAt(limit) != '-'; ++limit) {
                }
                String scriptName = value2.substring(scriptNameStart, limit);
                int code = scriptName.length() == 4 ? UCharacter.getPropertyValueEnum(4106, scriptName) : Collator.getReorderCode("colReorder", scriptName);
                codes[codesLength++] = code;
                if (limit == value2.length()) break;
                scriptNameStart = limit + 1;
            }
            if (codesLength == 0) {
                throw new IllegalArgumentException("no script codes for colReorder locale keyword");
            }
            int[] args = new int[codesLength];
            System.arraycopy(codes, 0, args, 0, codesLength);
            coll.setReorderCodes(args);
        }
        if ((value2 = loc.getKeywordValue("kv")) != null) {
            coll.setMaxVariable(Collator.getReorderCode("kv", value2));
        }
    }

    public static Collator getInstance(ULocale locale) {
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        Collator coll = Collator.getShim().getInstance(locale);
        if (!locale.getName().equals(locale.getBaseName())) {
            Collator.setAttributesFromKeywords(locale, coll, coll instanceof RuleBasedCollator ? (RuleBasedCollator)coll : null);
        }
        return coll;
    }

    public static Collator getInstance(Locale locale) {
        return Collator.getInstance(ULocale.forLocale(locale));
    }

    public static Object registerInstance(Collator collator, ULocale locale) {
        return Collator.getShim().registerInstance(collator, locale);
    }

    public static Object registerFactory(CollatorFactory factory) {
        return Collator.getShim().registerFactory(factory);
    }

    public static boolean unregister(Object registryKey) {
        if (shim == null) {
            return false;
        }
        return shim.unregister(registryKey);
    }

    public static Locale[] getAvailableLocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableLocales(BASE, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        }
        return shim.getAvailableLocales();
    }

    public static ULocale[] getAvailableULocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableULocales(BASE, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        }
        return shim.getAvailableULocales();
    }

    public static String[] getKeywords() {
        return KEYWORDS;
    }

    public static String[] getKeywordValues(String keyword) {
        if (!keyword.equals(KEYWORDS[0])) {
            throw new IllegalArgumentException("Invalid keyword: " + keyword);
        }
        return ICUResourceBundle.getKeywordValues(BASE, RESOURCE);
    }

    public static String[] getKeywordValuesForLocale(String key, ULocale locale, boolean commonlyUsed) {
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance(BASE, locale);
        KeywordsSink sink = new KeywordsSink();
        bundle.getAllItemsWithFallback(RESOURCE, sink);
        return sink.values.toArray(new String[sink.values.size()]);
    }

    public static ULocale getFunctionalEquivalent(String keyword, ULocale locID, boolean[] isAvailable) {
        return ICUResourceBundle.getFunctionalEquivalent(BASE, ICUResourceBundle.ICU_DATA_CLASS_LOADER, RESOURCE, keyword, locID, isAvailable, true);
    }

    public static ULocale getFunctionalEquivalent(String keyword, ULocale locID) {
        return Collator.getFunctionalEquivalent(keyword, locID, null);
    }

    public static String getDisplayName(Locale objectLocale, Locale displayLocale) {
        return Collator.getShim().getDisplayName(ULocale.forLocale(objectLocale), ULocale.forLocale(displayLocale));
    }

    public static String getDisplayName(ULocale objectLocale, ULocale displayLocale) {
        return Collator.getShim().getDisplayName(objectLocale, displayLocale);
    }

    public static String getDisplayName(Locale objectLocale) {
        return Collator.getShim().getDisplayName(ULocale.forLocale(objectLocale), ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    public static String getDisplayName(ULocale objectLocale) {
        return Collator.getShim().getDisplayName(objectLocale, ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    public int getStrength() {
        return 2;
    }

    public int getDecomposition() {
        return 16;
    }

    public boolean equals(String source, String target) {
        return this.compare(source, target) == 0;
    }

    public UnicodeSet getTailoredSet() {
        return new UnicodeSet(0, 0x10FFFF);
    }

    @Override
    public abstract int compare(String var1, String var2);

    @Override
    public int compare(Object source, Object target) {
        return this.doCompare((CharSequence)source, (CharSequence)target);
    }

    @Deprecated
    protected int doCompare(CharSequence left, CharSequence right2) {
        return this.compare(left.toString(), right2.toString());
    }

    public abstract CollationKey getCollationKey(String var1);

    public abstract RawCollationKey getRawCollationKey(String var1, RawCollationKey var2);

    public Collator setMaxVariable(int group) {
        throw new UnsupportedOperationException("Needs to be implemented by the subclass.");
    }

    public int getMaxVariable() {
        return 4097;
    }

    @Deprecated
    public abstract int setVariableTop(String var1);

    public abstract int getVariableTop();

    @Deprecated
    public abstract void setVariableTop(int var1);

    public abstract VersionInfo getVersion();

    public abstract VersionInfo getUCAVersion();

    public int[] getReorderCodes() {
        throw new UnsupportedOperationException("Needs to be implemented by the subclass.");
    }

    public static int[] getEquivalentReorderCodes(int reorderCode) {
        CollationData baseData = CollationRoot.getData();
        return baseData.getEquivalentScripts(reorderCode);
    }

    @Override
    public boolean isFrozen() {
        return false;
    }

    @Override
    public Collator freeze() {
        throw new UnsupportedOperationException("Needs to be implemented by the subclass.");
    }

    @Override
    public Collator cloneAsThawed() {
        throw new UnsupportedOperationException("Needs to be implemented by the subclass.");
    }

    protected Collator() {
    }

    public ULocale getLocale(ULocale.Type type) {
        return ULocale.ROOT;
    }

    void setLocale(ULocale valid, ULocale actual) {
    }

    static {
        KEYWORDS = new String[]{"collation"};
        DEBUG = ICUDebug.enabled("collator");
    }

    private static class KeywordsSink
    extends UResource.Sink {
        LinkedList<String> values = new LinkedList();
        boolean hasDefault = false;

        private KeywordsSink() {
        }

        @Override
        public void put(UResource.Key key, UResource.Value value2, boolean noFallback) {
            UResource.Table collations = value2.getTable();
            int i = 0;
            while (collations.getKeyAndValue(i, key, value2)) {
                String collkey;
                int type = value2.getType();
                if (type == 0) {
                    String defcoll;
                    if (!this.hasDefault && key.contentEquals("default") && !(defcoll = value2.getString()).isEmpty()) {
                        this.values.remove(defcoll);
                        this.values.addFirst(defcoll);
                        this.hasDefault = true;
                    }
                } else if (type == 2 && !key.startsWith("private-") && !this.values.contains(collkey = key.toString())) {
                    this.values.add(collkey);
                }
                ++i;
            }
        }
    }

    private static class ASCII {
        private ASCII() {
        }

        static boolean equalIgnoreCase(CharSequence left, CharSequence right2) {
            int length = left.length();
            if (length != right2.length()) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                char rc;
                char lc = left.charAt(i);
                if (lc == (rc = right2.charAt(i)) || ('A' <= lc && lc <= 'Z' ? lc + 32 == rc : 'A' <= rc && rc <= 'Z' && rc + 32 == lc)) continue;
                return false;
            }
            return true;
        }
    }

    static abstract class ServiceShim {
        ServiceShim() {
        }

        abstract Collator getInstance(ULocale var1);

        abstract Object registerInstance(Collator var1, ULocale var2);

        abstract Object registerFactory(CollatorFactory var1);

        abstract boolean unregister(Object var1);

        abstract Locale[] getAvailableLocales();

        abstract ULocale[] getAvailableULocales();

        abstract String getDisplayName(ULocale var1, ULocale var2);
    }

    public static abstract class CollatorFactory {
        public boolean visible() {
            return true;
        }

        public Collator createCollator(ULocale loc) {
            return this.createCollator(loc.toLocale());
        }

        public Collator createCollator(Locale loc) {
            return this.createCollator(ULocale.forLocale(loc));
        }

        public String getDisplayName(Locale objectLocale, Locale displayLocale) {
            return this.getDisplayName(ULocale.forLocale(objectLocale), ULocale.forLocale(displayLocale));
        }

        public String getDisplayName(ULocale objectLocale, ULocale displayLocale) {
            String name;
            Set<String> supported;
            if (this.visible() && (supported = this.getSupportedLocaleIDs()).contains(name = objectLocale.getBaseName())) {
                return objectLocale.getDisplayName(displayLocale);
            }
            return null;
        }

        public abstract Set<String> getSupportedLocaleIDs();

        protected CollatorFactory() {
        }
    }

    public static interface ReorderCodes {
        public static final int DEFAULT = -1;
        public static final int NONE = 103;
        public static final int OTHERS = 103;
        public static final int SPACE = 4096;
        public static final int FIRST = 4096;
        public static final int PUNCTUATION = 4097;
        public static final int SYMBOL = 4098;
        public static final int CURRENCY = 4099;
        public static final int DIGIT = 4100;
        @Deprecated
        public static final int LIMIT = 4101;
    }
}

