/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.units;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.UResource;
import android.icu.impl.units.ConversionRates;
import android.icu.impl.units.MeasureUnitImpl;
import android.icu.impl.units.UnitPreferences;
import android.icu.util.MeasureUnit;
import android.icu.util.UResourceBundle;
import java.util.ArrayList;
import java.util.HashMap;

public class UnitsData {
    private static volatile String[] simpleUnits = null;
    private ConversionRates conversionRates = new ConversionRates();
    private UnitPreferences unitPreferences = new UnitPreferences();
    private Categories categories = new Categories();

    public static String[] getSimpleUnits() {
        if (simpleUnits != null) {
            return simpleUnits;
        }
        ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt68b", "units");
        SimpleUnitIdentifiersSink sink = new SimpleUnitIdentifiersSink();
        resource.getAllItemsWithFallback("convertUnits", sink);
        simpleUnits = sink.simpleUnits;
        return simpleUnits;
    }

    public ConversionRates getConversionRates() {
        return this.conversionRates;
    }

    public UnitPreferences getUnitPreferences() {
        return this.unitPreferences;
    }

    public String getCategory(MeasureUnitImpl measureUnit) {
        MeasureUnitImpl baseMeasureUnit = this.getConversionRates().extractCompoundBaseUnit(measureUnit);
        String baseUnitIdentifier = MeasureUnit.fromMeasureUnitImpl(baseMeasureUnit).getIdentifier();
        if (baseUnitIdentifier.equals("meter-per-cubic-meter")) {
            return "consumption-inverse";
        }
        return this.categories.mapFromUnitToCategory.get(baseUnitIdentifier);
    }

    public UnitPreferences.UnitPreference[] getPreferencesFor(String category, String usage, String region) {
        return this.unitPreferences.getPreferencesFor(category, usage, region);
    }

    public static class CategoriesSink
    extends UResource.Sink {
        HashMap<String, String> mapFromUnitToCategory = new HashMap();

        @Override
        public void put(UResource.Key key, UResource.Value value2, boolean noFallback) {
            assert (key.toString().equals("unitQuantities"));
            assert (value2.getType() == 2);
            UResource.Table categoryTable = value2.getTable();
            int i = 0;
            while (categoryTable.getKeyAndValue(i, key, value2)) {
                assert (value2.getType() == 0);
                this.mapFromUnitToCategory.put(key.toString(), value2.toString());
                ++i;
            }
        }

        public HashMap<String, String> getMapFromUnitToCategory() {
            return this.mapFromUnitToCategory;
        }
    }

    public static class Categories {
        HashMap<String, String> mapFromUnitToCategory;

        public Categories() {
            ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt68b", "units");
            CategoriesSink sink = new CategoriesSink();
            resource.getAllItemsWithFallback("unitQuantities", sink);
            this.mapFromUnitToCategory = sink.getMapFromUnitToCategory();
        }
    }

    public static class Constants {
        public static final int kSimpleUnitOffset = 512;
        public static final int kPowerPartOffset = 256;
        public static final int kInitialCompoundPartOffset = 192;
        public static final int kCompoundPartOffset = 128;
        public static final int kSIPrefixOffset = 64;
        public static final String CONVERSION_UNIT_TABLE_NAME = "convertUnits";
        public static final String UNIT_PREFERENCE_TABLE_NAME = "unitPreferenceData";
        public static final String CATEGORY_TABLE_NAME = "unitQuantities";
        public static final String DEFAULT_REGION = "001";
        public static final String DEFAULT_USAGE = "default";
    }

    public static class SimpleUnitIdentifiersSink
    extends UResource.Sink {
        String[] simpleUnits = null;

        @Override
        public void put(UResource.Key key, UResource.Value value2, boolean noFallback) {
            assert (key.toString().equals("convertUnits"));
            assert (value2.getType() == 2);
            UResource.Table simpleUnitsTable = value2.getTable();
            ArrayList<String> simpleUnits = new ArrayList<String>();
            int i = 0;
            while (simpleUnitsTable.getKeyAndValue(i, key, value2)) {
                if (!key.toString().equals("kilogram")) {
                    simpleUnits.add(key.toString());
                }
                ++i;
            }
            this.simpleUnits = simpleUnits.toArray(new String[0]);
        }
    }
}

