/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.MicroProps;
import android.icu.impl.number.MicroPropsGenerator;
import android.icu.impl.number.UsagePrefsHandler;
import android.icu.impl.units.ComplexUnitsConverter;
import android.icu.impl.units.MeasureUnitImpl;
import android.icu.impl.units.UnitsData;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import java.util.List;

public class UnitConversionHandler
implements MicroPropsGenerator {
    private final MicroPropsGenerator fParent;
    private MeasureUnit fOutputUnit;
    private ComplexUnitsConverter fComplexUnitConverter;

    public UnitConversionHandler(MeasureUnit inputUnit, MeasureUnit outputUnit, MicroPropsGenerator parent) {
        this.fOutputUnit = outputUnit;
        this.fParent = parent;
        MeasureUnitImpl inputUnitImpl = MeasureUnitImpl.forIdentifier(inputUnit.getIdentifier());
        MeasureUnitImpl outputUnitImpl = MeasureUnitImpl.forIdentifier(outputUnit.getIdentifier());
        this.fComplexUnitConverter = new ComplexUnitsConverter(inputUnitImpl, outputUnitImpl, new UnitsData().getConversionRates());
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity quantity) {
        MicroProps result = this.fParent.processQuantity(quantity);
        quantity.roundToInfinity();
        List<Measure> measures = this.fComplexUnitConverter.convert(quantity.toBigDecimal(), result.rounder);
        result.outputUnit = this.fOutputUnit;
        UsagePrefsHandler.mixedMeasuresToMicros(measures, quantity, result);
        return result;
    }
}

