/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_6;

import android.hardware.radio.V1_6.OptionalDnn;
import android.hardware.radio.V1_6.OptionalOsAppId;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public class TrafficDescriptor {
    public OptionalDnn dnn = new OptionalDnn();
    public OptionalOsAppId osAppId = new OptionalOsAppId();

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != TrafficDescriptor.class) {
            return false;
        }
        TrafficDescriptor other = (TrafficDescriptor)otherObject;
        if (!HidlSupport.deepEquals(this.dnn, other.dnn)) {
            return false;
        }
        return HidlSupport.deepEquals(this.osAppId, other.osAppId);
    }

    public int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.dnn), HidlSupport.deepHashCode(this.osAppId));
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("{");
        builder2.append(".dnn = ");
        builder2.append(this.dnn);
        builder2.append(", .osAppId = ");
        builder2.append(this.osAppId);
        builder2.append("}");
        return builder2.toString();
    }

    public void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(48L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static ArrayList<TrafficDescriptor> readVectorFromParcel(HwParcel parcel) {
        ArrayList<TrafficDescriptor> _hidl_vec = new ArrayList<TrafficDescriptor>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 48, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            TrafficDescriptor _hidl_vec_element = new TrafficDescriptor();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 48);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.dnn.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 0L);
        this.osAppId.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 24L);
    }

    public void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(48);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static void writeVectorToParcel(HwParcel parcel, ArrayList<TrafficDescriptor> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 48);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 48);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        this.dnn.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 0L);
        this.osAppId.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 24L);
    }
}

