/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_6;

import android.hardware.radio.V1_6.OptionalPdpProtocolType;
import android.hardware.radio.V1_6.OptionalSscMode;
import android.hardware.radio.V1_6.SliceInfo;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public class RouteSelectionDescriptor {
    public byte precedence = 0;
    public OptionalPdpProtocolType sessionType = new OptionalPdpProtocolType();
    public OptionalSscMode sscMode = new OptionalSscMode();
    public ArrayList<SliceInfo> sliceInfo = new ArrayList();
    public ArrayList<String> dnn = new ArrayList();

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != RouteSelectionDescriptor.class) {
            return false;
        }
        RouteSelectionDescriptor other = (RouteSelectionDescriptor)otherObject;
        if (this.precedence != other.precedence) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.sessionType, other.sessionType)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.sscMode, other.sscMode)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.sliceInfo, other.sliceInfo)) {
            return false;
        }
        return HidlSupport.deepEquals(this.dnn, other.dnn);
    }

    public int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.precedence), HidlSupport.deepHashCode(this.sessionType), HidlSupport.deepHashCode(this.sscMode), HidlSupport.deepHashCode(this.sliceInfo), HidlSupport.deepHashCode(this.dnn));
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("{");
        builder2.append(".precedence = ");
        builder2.append(this.precedence);
        builder2.append(", .sessionType = ");
        builder2.append(this.sessionType);
        builder2.append(", .sscMode = ");
        builder2.append(this.sscMode);
        builder2.append(", .sliceInfo = ");
        builder2.append(this.sliceInfo);
        builder2.append(", .dnn = ");
        builder2.append(this.dnn);
        builder2.append("}");
        return builder2.toString();
    }

    public void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(48L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static ArrayList<RouteSelectionDescriptor> readVectorFromParcel(HwParcel parcel) {
        ArrayList<RouteSelectionDescriptor> _hidl_vec = new ArrayList<RouteSelectionDescriptor>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 48, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            RouteSelectionDescriptor _hidl_vec_element = new RouteSelectionDescriptor();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 48);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        Object _hidl_vec_element;
        int _hidl_index_0;
        this.precedence = _hidl_blob.getInt8(_hidl_offset + 0L);
        this.sessionType.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 4L);
        this.sscMode.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 12L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 16L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 20, _hidl_blob.handle(), _hidl_offset + 16L + 0L, true);
        this.sliceInfo.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new SliceInfo();
            ((SliceInfo)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 20);
            this.sliceInfo.add((SliceInfo)_hidl_vec_element);
        }
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 32L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 16, _hidl_blob.handle(), _hidl_offset + 32L + 0L, true);
        this.dnn.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new String();
            _hidl_vec_element = childBlob.getString(_hidl_index_0 * 16);
            parcel.readEmbeddedBuffer(((String)_hidl_vec_element).getBytes().length + 1, childBlob.handle(), _hidl_index_0 * 16 + 0, false);
            this.dnn.add((String)_hidl_vec_element);
        }
    }

    public void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(48);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static void writeVectorToParcel(HwParcel parcel, ArrayList<RouteSelectionDescriptor> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 48);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 48);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        int _hidl_index_0;
        _hidl_blob.putInt8(_hidl_offset + 0L, this.precedence);
        this.sessionType.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 4L);
        this.sscMode.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 12L);
        int _hidl_vec_size = this.sliceInfo.size();
        _hidl_blob.putInt32(_hidl_offset + 16L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 16L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 20);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.sliceInfo.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 20);
        }
        _hidl_blob.putBlob(_hidl_offset + 16L + 0L, childBlob);
        _hidl_vec_size = this.dnn.size();
        _hidl_blob.putInt32(_hidl_offset + 32L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 32L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 16);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            childBlob.putString(_hidl_index_0 * 16, this.dnn.get(_hidl_index_0));
        }
        _hidl_blob.putBlob(_hidl_offset + 32L + 0L, childBlob);
    }
}

