/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_5;

import android.hardware.radio.V1_0.TimeStampType;
import android.hardware.radio.V1_2.CellConnectionStatus;
import android.hardware.radio.V1_2.CellInfoCdma;
import android.hardware.radio.V1_5.CellInfoGsm;
import android.hardware.radio.V1_5.CellInfoLte;
import android.hardware.radio.V1_5.CellInfoNr;
import android.hardware.radio.V1_5.CellInfoTdscdma;
import android.hardware.radio.V1_5.CellInfoWcdma;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public class CellInfo {
    public boolean registered = false;
    public int timeStampType = 0;
    public long timeStamp = 0L;
    public int connectionStatus = 0;
    public CellInfoRatSpecificInfo ratSpecificInfo = new CellInfoRatSpecificInfo();

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != CellInfo.class) {
            return false;
        }
        CellInfo other = (CellInfo)otherObject;
        if (this.registered != other.registered) {
            return false;
        }
        if (this.timeStampType != other.timeStampType) {
            return false;
        }
        if (this.timeStamp != other.timeStamp) {
            return false;
        }
        if (this.connectionStatus != other.connectionStatus) {
            return false;
        }
        return HidlSupport.deepEquals(this.ratSpecificInfo, other.ratSpecificInfo);
    }

    public int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.registered), HidlSupport.deepHashCode(this.timeStampType), HidlSupport.deepHashCode(this.timeStamp), HidlSupport.deepHashCode(this.connectionStatus), HidlSupport.deepHashCode(this.ratSpecificInfo));
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("{");
        builder2.append(".registered = ");
        builder2.append(this.registered);
        builder2.append(", .timeStampType = ");
        builder2.append(TimeStampType.toString(this.timeStampType));
        builder2.append(", .timeStamp = ");
        builder2.append(this.timeStamp);
        builder2.append(", .connectionStatus = ");
        builder2.append(CellConnectionStatus.toString(this.connectionStatus));
        builder2.append(", .ratSpecificInfo = ");
        builder2.append(this.ratSpecificInfo);
        builder2.append("}");
        return builder2.toString();
    }

    public void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(216L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static ArrayList<CellInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<CellInfo> _hidl_vec = new ArrayList<CellInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 216, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            CellInfo _hidl_vec_element = new CellInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 216);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.registered = _hidl_blob.getBool(_hidl_offset + 0L);
        this.timeStampType = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.timeStamp = _hidl_blob.getInt64(_hidl_offset + 8L);
        this.connectionStatus = _hidl_blob.getInt32(_hidl_offset + 16L);
        this.ratSpecificInfo.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 24L);
    }

    public void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(216);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static void writeVectorToParcel(HwParcel parcel, ArrayList<CellInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 216);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 216);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putBool(_hidl_offset + 0L, this.registered);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.timeStampType);
        _hidl_blob.putInt64(_hidl_offset + 8L, this.timeStamp);
        _hidl_blob.putInt32(_hidl_offset + 16L, this.connectionStatus);
        this.ratSpecificInfo.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 24L);
    }

    public static class CellInfoRatSpecificInfo {
        private byte hidl_d = 0;
        private Object hidl_o = new CellInfoGsm();

        public void gsm(CellInfoGsm gsm) {
            this.hidl_d = 0;
            this.hidl_o = gsm;
        }

        public CellInfoGsm gsm() {
            if (this.hidl_d != 0) {
                String className2 = this.hidl_o != null ? this.hidl_o.getClass().getName() : "null";
                throw new IllegalStateException("Read access to inactive union components is disallowed. Discriminator value is " + this.hidl_d + " (corresponding to " + hidl_discriminator.getName(this.hidl_d) + "), and hidl_o is of type " + className2 + ".");
            }
            if (this.hidl_o != null && !CellInfoGsm.class.isInstance(this.hidl_o)) {
                throw new Error("Union is in a corrupted state.");
            }
            return (CellInfoGsm)this.hidl_o;
        }

        public void wcdma(CellInfoWcdma wcdma) {
            this.hidl_d = 1;
            this.hidl_o = wcdma;
        }

        public CellInfoWcdma wcdma() {
            if (this.hidl_d != 1) {
                String className2 = this.hidl_o != null ? this.hidl_o.getClass().getName() : "null";
                throw new IllegalStateException("Read access to inactive union components is disallowed. Discriminator value is " + this.hidl_d + " (corresponding to " + hidl_discriminator.getName(this.hidl_d) + "), and hidl_o is of type " + className2 + ".");
            }
            if (this.hidl_o != null && !CellInfoWcdma.class.isInstance(this.hidl_o)) {
                throw new Error("Union is in a corrupted state.");
            }
            return (CellInfoWcdma)this.hidl_o;
        }

        public void tdscdma(CellInfoTdscdma tdscdma) {
            this.hidl_d = (byte)2;
            this.hidl_o = tdscdma;
        }

        public CellInfoTdscdma tdscdma() {
            if (this.hidl_d != 2) {
                String className2 = this.hidl_o != null ? this.hidl_o.getClass().getName() : "null";
                throw new IllegalStateException("Read access to inactive union components is disallowed. Discriminator value is " + this.hidl_d + " (corresponding to " + hidl_discriminator.getName(this.hidl_d) + "), and hidl_o is of type " + className2 + ".");
            }
            if (this.hidl_o != null && !CellInfoTdscdma.class.isInstance(this.hidl_o)) {
                throw new Error("Union is in a corrupted state.");
            }
            return (CellInfoTdscdma)this.hidl_o;
        }

        public void lte(CellInfoLte lte) {
            this.hidl_d = (byte)3;
            this.hidl_o = lte;
        }

        public CellInfoLte lte() {
            if (this.hidl_d != 3) {
                String className2 = this.hidl_o != null ? this.hidl_o.getClass().getName() : "null";
                throw new IllegalStateException("Read access to inactive union components is disallowed. Discriminator value is " + this.hidl_d + " (corresponding to " + hidl_discriminator.getName(this.hidl_d) + "), and hidl_o is of type " + className2 + ".");
            }
            if (this.hidl_o != null && !CellInfoLte.class.isInstance(this.hidl_o)) {
                throw new Error("Union is in a corrupted state.");
            }
            return (CellInfoLte)this.hidl_o;
        }

        public void nr(CellInfoNr nr) {
            this.hidl_d = (byte)4;
            this.hidl_o = nr;
        }

        public CellInfoNr nr() {
            if (this.hidl_d != 4) {
                String className2 = this.hidl_o != null ? this.hidl_o.getClass().getName() : "null";
                throw new IllegalStateException("Read access to inactive union components is disallowed. Discriminator value is " + this.hidl_d + " (corresponding to " + hidl_discriminator.getName(this.hidl_d) + "), and hidl_o is of type " + className2 + ".");
            }
            if (this.hidl_o != null && !CellInfoNr.class.isInstance(this.hidl_o)) {
                throw new Error("Union is in a corrupted state.");
            }
            return (CellInfoNr)this.hidl_o;
        }

        public void cdma(CellInfoCdma cdma) {
            this.hidl_d = (byte)5;
            this.hidl_o = cdma;
        }

        public CellInfoCdma cdma() {
            if (this.hidl_d != 5) {
                String className2 = this.hidl_o != null ? this.hidl_o.getClass().getName() : "null";
                throw new IllegalStateException("Read access to inactive union components is disallowed. Discriminator value is " + this.hidl_d + " (corresponding to " + hidl_discriminator.getName(this.hidl_d) + "), and hidl_o is of type " + className2 + ".");
            }
            if (this.hidl_o != null && !CellInfoCdma.class.isInstance(this.hidl_o)) {
                throw new Error("Union is in a corrupted state.");
            }
            return (CellInfoCdma)this.hidl_o;
        }

        public byte getDiscriminator() {
            return this.hidl_d;
        }

        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject == null) {
                return false;
            }
            if (otherObject.getClass() != CellInfoRatSpecificInfo.class) {
                return false;
            }
            CellInfoRatSpecificInfo other = (CellInfoRatSpecificInfo)otherObject;
            if (this.hidl_d != other.hidl_d) {
                return false;
            }
            return HidlSupport.deepEquals(this.hidl_o, other.hidl_o);
        }

        public int hashCode() {
            return Objects.hash(HidlSupport.deepHashCode(this.hidl_o), Objects.hashCode(this.hidl_d));
        }

        public String toString() {
            StringBuilder builder2 = new StringBuilder();
            builder2.append("{");
            switch (this.hidl_d) {
                case 0: {
                    builder2.append(".gsm = ");
                    builder2.append(this.gsm());
                    break;
                }
                case 1: {
                    builder2.append(".wcdma = ");
                    builder2.append(this.wcdma());
                    break;
                }
                case 2: {
                    builder2.append(".tdscdma = ");
                    builder2.append(this.tdscdma());
                    break;
                }
                case 3: {
                    builder2.append(".lte = ");
                    builder2.append(this.lte());
                    break;
                }
                case 4: {
                    builder2.append(".nr = ");
                    builder2.append(this.nr());
                    break;
                }
                case 5: {
                    builder2.append(".cdma = ");
                    builder2.append(this.cdma());
                    break;
                }
                default: {
                    throw new Error("Unknown union discriminator (value: " + this.hidl_d + ").");
                }
            }
            builder2.append("}");
            return builder2.toString();
        }

        public void readFromParcel(HwParcel parcel) {
            HwBlob blob = parcel.readBuffer(192L);
            this.readEmbeddedFromParcel(parcel, blob, 0L);
        }

        public static ArrayList<CellInfoRatSpecificInfo> readVectorFromParcel(HwParcel parcel) {
            ArrayList<CellInfoRatSpecificInfo> _hidl_vec = new ArrayList<CellInfoRatSpecificInfo>();
            HwBlob _hidl_blob = parcel.readBuffer(16L);
            int _hidl_vec_size = _hidl_blob.getInt32(8L);
            HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 192, _hidl_blob.handle(), 0L, true);
            _hidl_vec.clear();
            for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                CellInfoRatSpecificInfo _hidl_vec_element = new CellInfoRatSpecificInfo();
                _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 192);
                _hidl_vec.add(_hidl_vec_element);
            }
            return _hidl_vec;
        }

        public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
            this.hidl_d = _hidl_blob.getInt8(_hidl_offset + 0L);
            switch (this.hidl_d) {
                case 0: {
                    this.hidl_o = new CellInfoGsm();
                    ((CellInfoGsm)this.hidl_o).readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 8L);
                    break;
                }
                case 1: {
                    this.hidl_o = new CellInfoWcdma();
                    ((CellInfoWcdma)this.hidl_o).readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 8L);
                    break;
                }
                case 2: {
                    this.hidl_o = new CellInfoTdscdma();
                    ((CellInfoTdscdma)this.hidl_o).readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 8L);
                    break;
                }
                case 3: {
                    this.hidl_o = new CellInfoLte();
                    ((CellInfoLte)this.hidl_o).readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 8L);
                    break;
                }
                case 4: {
                    this.hidl_o = new CellInfoNr();
                    ((CellInfoNr)this.hidl_o).readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 8L);
                    break;
                }
                case 5: {
                    this.hidl_o = new CellInfoCdma();
                    ((CellInfoCdma)this.hidl_o).readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 8L);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown union discriminator (value: " + this.hidl_d + ").");
                }
            }
        }

        public void writeToParcel(HwParcel parcel) {
            HwBlob _hidl_blob = new HwBlob(192);
            this.writeEmbeddedToBlob(_hidl_blob, 0L);
            parcel.writeBuffer(_hidl_blob);
        }

        public static void writeVectorToParcel(HwParcel parcel, ArrayList<CellInfoRatSpecificInfo> _hidl_vec) {
            HwBlob _hidl_blob = new HwBlob(16);
            int _hidl_vec_size = _hidl_vec.size();
            _hidl_blob.putInt32(8L, _hidl_vec_size);
            _hidl_blob.putBool(12L, false);
            HwBlob childBlob = new HwBlob(_hidl_vec_size * 192);
            for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 192);
            }
            _hidl_blob.putBlob(0L, childBlob);
            parcel.writeBuffer(_hidl_blob);
        }

        public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
            _hidl_blob.putInt8(_hidl_offset + 0L, this.hidl_d);
            switch (this.hidl_d) {
                case 0: {
                    this.gsm().writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 8L);
                    break;
                }
                case 1: {
                    this.wcdma().writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 8L);
                    break;
                }
                case 2: {
                    this.tdscdma().writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 8L);
                    break;
                }
                case 3: {
                    this.lte().writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 8L);
                    break;
                }
                case 4: {
                    this.nr().writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 8L);
                    break;
                }
                case 5: {
                    this.cdma().writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 8L);
                    break;
                }
                default: {
                    throw new Error("Unknown union discriminator (value: " + this.hidl_d + ").");
                }
            }
        }

        public static class hidl_discriminator {
            public static final byte gsm = 0;
            public static final byte wcdma = 1;
            public static final byte tdscdma = 2;
            public static final byte lte = 3;
            public static final byte nr = 4;
            public static final byte cdma = 5;

            public static String getName(byte value2) {
                switch (value2) {
                    case 0: {
                        return "gsm";
                    }
                    case 1: {
                        return "wcdma";
                    }
                    case 2: {
                        return "tdscdma";
                    }
                    case 3: {
                        return "lte";
                    }
                    case 4: {
                        return "nr";
                    }
                    case 5: {
                        return "cdma";
                    }
                }
                return "Unknown";
            }

            private hidl_discriminator() {
            }
        }
    }
}

