/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_4;

import android.hardware.radio.V1_4.CellConfigLte;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public class CellInfoLte {
    public android.hardware.radio.V1_2.CellInfoLte base = new android.hardware.radio.V1_2.CellInfoLte();
    public CellConfigLte cellConfig = new CellConfigLte();

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != CellInfoLte.class) {
            return false;
        }
        CellInfoLte other = (CellInfoLte)otherObject;
        if (!HidlSupport.deepEquals(this.base, other.base)) {
            return false;
        }
        return HidlSupport.deepEquals(this.cellConfig, other.cellConfig);
    }

    public int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.base), HidlSupport.deepHashCode(this.cellConfig));
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("{");
        builder2.append(".base = ");
        builder2.append(this.base);
        builder2.append(", .cellConfig = ");
        builder2.append(this.cellConfig);
        builder2.append("}");
        return builder2.toString();
    }

    public void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(120L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static ArrayList<CellInfoLte> readVectorFromParcel(HwParcel parcel) {
        ArrayList<CellInfoLte> _hidl_vec = new ArrayList<CellInfoLte>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 120, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            CellInfoLte _hidl_vec_element = new CellInfoLte();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 120);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.base.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 0L);
        this.cellConfig.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 112L);
    }

    public void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(120);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static void writeVectorToParcel(HwParcel parcel, ArrayList<CellInfoLte> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 120);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 120);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        this.base.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 0L);
        this.cellConfig.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 112L);
    }
}

