/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public class LteSignalStrength {
    public int signalStrength = 0;
    public int rsrp = 0;
    public int rsrq = 0;
    public int rssnr = 0;
    public int cqi = 0;
    public int timingAdvance = 0;

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != LteSignalStrength.class) {
            return false;
        }
        LteSignalStrength other = (LteSignalStrength)otherObject;
        if (this.signalStrength != other.signalStrength) {
            return false;
        }
        if (this.rsrp != other.rsrp) {
            return false;
        }
        if (this.rsrq != other.rsrq) {
            return false;
        }
        if (this.rssnr != other.rssnr) {
            return false;
        }
        if (this.cqi != other.cqi) {
            return false;
        }
        return this.timingAdvance == other.timingAdvance;
    }

    public int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.signalStrength), HidlSupport.deepHashCode(this.rsrp), HidlSupport.deepHashCode(this.rsrq), HidlSupport.deepHashCode(this.rssnr), HidlSupport.deepHashCode(this.cqi), HidlSupport.deepHashCode(this.timingAdvance));
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("{");
        builder2.append(".signalStrength = ");
        builder2.append(this.signalStrength);
        builder2.append(", .rsrp = ");
        builder2.append(this.rsrp);
        builder2.append(", .rsrq = ");
        builder2.append(this.rsrq);
        builder2.append(", .rssnr = ");
        builder2.append(this.rssnr);
        builder2.append(", .cqi = ");
        builder2.append(this.cqi);
        builder2.append(", .timingAdvance = ");
        builder2.append(this.timingAdvance);
        builder2.append("}");
        return builder2.toString();
    }

    public void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(24L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static ArrayList<LteSignalStrength> readVectorFromParcel(HwParcel parcel) {
        ArrayList<LteSignalStrength> _hidl_vec = new ArrayList<LteSignalStrength>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 24, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            LteSignalStrength _hidl_vec_element = new LteSignalStrength();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 24);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.signalStrength = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.rsrp = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.rsrq = _hidl_blob.getInt32(_hidl_offset + 8L);
        this.rssnr = _hidl_blob.getInt32(_hidl_offset + 12L);
        this.cqi = _hidl_blob.getInt32(_hidl_offset + 16L);
        this.timingAdvance = _hidl_blob.getInt32(_hidl_offset + 20L);
    }

    public void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(24);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static void writeVectorToParcel(HwParcel parcel, ArrayList<LteSignalStrength> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 24);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 24);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.signalStrength);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.rsrp);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.rsrq);
        _hidl_blob.putInt32(_hidl_offset + 12L, this.rssnr);
        _hidl_blob.putInt32(_hidl_offset + 16L, this.cqi);
        _hidl_blob.putInt32(_hidl_offset + 20L, this.timingAdvance);
    }
}

