/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public class CellIdentityTdscdma {
    public String mcc = new String();
    public String mnc = new String();
    public int lac = 0;
    public int cid = 0;
    public int cpid = 0;

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != CellIdentityTdscdma.class) {
            return false;
        }
        CellIdentityTdscdma other = (CellIdentityTdscdma)otherObject;
        if (!HidlSupport.deepEquals(this.mcc, other.mcc)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.mnc, other.mnc)) {
            return false;
        }
        if (this.lac != other.lac) {
            return false;
        }
        if (this.cid != other.cid) {
            return false;
        }
        return this.cpid == other.cpid;
    }

    public int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.mcc), HidlSupport.deepHashCode(this.mnc), HidlSupport.deepHashCode(this.lac), HidlSupport.deepHashCode(this.cid), HidlSupport.deepHashCode(this.cpid));
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("{");
        builder2.append(".mcc = ");
        builder2.append(this.mcc);
        builder2.append(", .mnc = ");
        builder2.append(this.mnc);
        builder2.append(", .lac = ");
        builder2.append(this.lac);
        builder2.append(", .cid = ");
        builder2.append(this.cid);
        builder2.append(", .cpid = ");
        builder2.append(this.cpid);
        builder2.append("}");
        return builder2.toString();
    }

    public void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(48L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static ArrayList<CellIdentityTdscdma> readVectorFromParcel(HwParcel parcel) {
        ArrayList<CellIdentityTdscdma> _hidl_vec = new ArrayList<CellIdentityTdscdma>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 48, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            CellIdentityTdscdma _hidl_vec_element = new CellIdentityTdscdma();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 48);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.mcc = _hidl_blob.getString(_hidl_offset + 0L);
        parcel.readEmbeddedBuffer(this.mcc.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 0L + 0L, false);
        this.mnc = _hidl_blob.getString(_hidl_offset + 16L);
        parcel.readEmbeddedBuffer(this.mnc.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 16L + 0L, false);
        this.lac = _hidl_blob.getInt32(_hidl_offset + 32L);
        this.cid = _hidl_blob.getInt32(_hidl_offset + 36L);
        this.cpid = _hidl_blob.getInt32(_hidl_offset + 40L);
    }

    public void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(48);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static void writeVectorToParcel(HwParcel parcel, ArrayList<CellIdentityTdscdma> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 48);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 48);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putString(_hidl_offset + 0L, this.mcc);
        _hidl_blob.putString(_hidl_offset + 16L, this.mnc);
        _hidl_blob.putInt32(_hidl_offset + 32L, this.lac);
        _hidl_blob.putInt32(_hidl_offset + 36L, this.cid);
        _hidl_blob.putInt32(_hidl_offset + 40L, this.cpid);
    }
}

