/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;

@SystemApi
public class ProgramSelector
implements Parcelable {
    @Deprecated
    public static final int PROGRAM_TYPE_INVALID = 0;
    @Deprecated
    public static final int PROGRAM_TYPE_AM = 1;
    @Deprecated
    public static final int PROGRAM_TYPE_FM = 2;
    @Deprecated
    public static final int PROGRAM_TYPE_AM_HD = 3;
    @Deprecated
    public static final int PROGRAM_TYPE_FM_HD = 4;
    @Deprecated
    public static final int PROGRAM_TYPE_DAB = 5;
    @Deprecated
    public static final int PROGRAM_TYPE_DRMO = 6;
    @Deprecated
    public static final int PROGRAM_TYPE_SXM = 7;
    @Deprecated
    public static final int PROGRAM_TYPE_VENDOR_START = 1000;
    @Deprecated
    public static final int PROGRAM_TYPE_VENDOR_END = 1999;
    public static final int IDENTIFIER_TYPE_INVALID = 0;
    public static final int IDENTIFIER_TYPE_AMFM_FREQUENCY = 1;
    public static final int IDENTIFIER_TYPE_RDS_PI = 2;
    public static final int IDENTIFIER_TYPE_HD_STATION_ID_EXT = 3;
    @Deprecated
    public static final int IDENTIFIER_TYPE_HD_SUBCHANNEL = 4;
    public static final int IDENTIFIER_TYPE_HD_STATION_NAME = 10004;
    public static final int IDENTIFIER_TYPE_DAB_SIDECC = 5;
    public static final int IDENTIFIER_TYPE_DAB_SID_EXT = 5;
    public static final int IDENTIFIER_TYPE_DAB_ENSEMBLE = 6;
    public static final int IDENTIFIER_TYPE_DAB_SCID = 7;
    public static final int IDENTIFIER_TYPE_DAB_FREQUENCY = 8;
    public static final int IDENTIFIER_TYPE_DRMO_SERVICE_ID = 9;
    public static final int IDENTIFIER_TYPE_DRMO_FREQUENCY = 10;
    @Deprecated
    public static final int IDENTIFIER_TYPE_DRMO_MODULATION = 11;
    public static final int IDENTIFIER_TYPE_SXM_SERVICE_ID = 12;
    public static final int IDENTIFIER_TYPE_SXM_CHANNEL = 13;
    public static final int IDENTIFIER_TYPE_VENDOR_START = 1000;
    public static final int IDENTIFIER_TYPE_VENDOR_END = 1999;
    @Deprecated
    public static final int IDENTIFIER_TYPE_VENDOR_PRIMARY_START = 1000;
    @Deprecated
    public static final int IDENTIFIER_TYPE_VENDOR_PRIMARY_END = 1999;
    private final int mProgramType;
    private final Identifier mPrimaryId;
    private final Identifier[] mSecondaryIds;
    private final long[] mVendorIds;
    public static final Parcelable.Creator<ProgramSelector> CREATOR = new Parcelable.Creator<ProgramSelector>(){

        @Override
        public ProgramSelector createFromParcel(Parcel in) {
            return new ProgramSelector(in);
        }

        public ProgramSelector[] newArray(int size) {
            return new ProgramSelector[size];
        }
    };

    public ProgramSelector(int programType, Identifier primaryId, Identifier[] secondaryIds, long[] vendorIds) {
        if (secondaryIds == null) {
            secondaryIds = new Identifier[]{};
        }
        if (vendorIds == null) {
            vendorIds = new long[]{};
        }
        if (Stream.of(secondaryIds).anyMatch(id2 -> id2 == null)) {
            throw new IllegalArgumentException("secondaryIds list must not contain nulls");
        }
        this.mProgramType = programType;
        this.mPrimaryId = Objects.requireNonNull(primaryId);
        this.mSecondaryIds = secondaryIds;
        this.mVendorIds = vendorIds;
    }

    @Deprecated
    public int getProgramType() {
        return this.mProgramType;
    }

    public Identifier getPrimaryId() {
        return this.mPrimaryId;
    }

    public Identifier[] getSecondaryIds() {
        return this.mSecondaryIds;
    }

    public long getFirstId(int type) {
        if (this.mPrimaryId.getType() == type) {
            return this.mPrimaryId.getValue();
        }
        for (Identifier id2 : this.mSecondaryIds) {
            if (id2.getType() != type) continue;
            return id2.getValue();
        }
        throw new IllegalArgumentException("Identifier " + type + " not found");
    }

    public Identifier[] getAllIds(int type) {
        ArrayList<Identifier> out = new ArrayList<Identifier>();
        if (this.mPrimaryId.getType() == type) {
            out.add(this.mPrimaryId);
        }
        for (Identifier id2 : this.mSecondaryIds) {
            if (id2.getType() != type) continue;
            out.add(id2);
        }
        return out.toArray(new Identifier[out.size()]);
    }

    @Deprecated
    public long[] getVendorIds() {
        return this.mVendorIds;
    }

    public ProgramSelector withSecondaryPreferred(Identifier preferred) {
        int preferredType = preferred.getType();
        Identifier[] secondaryIds = (Identifier[])Stream.concat(Arrays.stream(this.mSecondaryIds).filter(id2 -> id2.getType() != preferredType), Stream.of(preferred)).toArray(Identifier[]::new);
        return new ProgramSelector(this.mProgramType, this.mPrimaryId, secondaryIds, this.mVendorIds);
    }

    public static ProgramSelector createAmFmSelector(int band, int frequencyKhz) {
        return ProgramSelector.createAmFmSelector(band, frequencyKhz, 0);
    }

    private static boolean isValidAmFmFrequency(boolean isAm, int frequencyKhz) {
        if (isAm) {
            return frequencyKhz > 150 && frequencyKhz <= 30000;
        }
        return frequencyKhz > 60000 && frequencyKhz < 110000;
    }

    public static ProgramSelector createAmFmSelector(int band, int frequencyKhz, int subChannel) {
        boolean isDigital;
        if (band == -1) {
            band = frequencyKhz < 50000 ? (subChannel <= 0 ? 0 : 3) : (subChannel <= 0 ? 1 : 2);
        }
        boolean isAm = band == 0 || band == 3;
        boolean bl = isDigital = band == 3 || band == 2;
        if (!isAm && !isDigital && band != 1) {
            throw new IllegalArgumentException("Unknown band: " + band);
        }
        if (subChannel < 0 || subChannel > 8) {
            throw new IllegalArgumentException("Invalid subchannel: " + subChannel);
        }
        if (subChannel > 0 && !isDigital) {
            throw new IllegalArgumentException("Subchannels are not supported for non-HD radio");
        }
        if (!ProgramSelector.isValidAmFmFrequency(isAm, frequencyKhz)) {
            throw new IllegalArgumentException("Provided value is not a valid AM/FM frequency: " + frequencyKhz);
        }
        int programType = isAm ? 1 : 2;
        Identifier primary = new Identifier(1, frequencyKhz);
        Identifier[] secondary = null;
        if (subChannel > 0) {
            secondary = new Identifier[]{new Identifier(4, subChannel - 1)};
        }
        return new ProgramSelector(programType, primary, secondary, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProgramSelector(type=").append(this.mProgramType).append(", primary=").append(this.mPrimaryId);
        if (this.mSecondaryIds.length > 0) {
            sb.append(", secondary=").append(this.mSecondaryIds);
        }
        if (this.mVendorIds.length > 0) {
            sb.append(", vendor=").append(this.mVendorIds);
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return this.mPrimaryId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProgramSelector)) {
            return false;
        }
        ProgramSelector other = (ProgramSelector)obj;
        return this.mPrimaryId.equals(other.getPrimaryId());
    }

    private ProgramSelector(Parcel in) {
        this.mProgramType = in.readInt();
        this.mPrimaryId = in.readTypedObject(Identifier.CREATOR);
        this.mSecondaryIds = in.createTypedArray(Identifier.CREATOR);
        if (Stream.of(this.mSecondaryIds).anyMatch(id2 -> id2 == null)) {
            throw new IllegalArgumentException("secondaryIds list must not contain nulls");
        }
        this.mVendorIds = in.createLongArray();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mProgramType);
        dest.writeTypedObject(this.mPrimaryId, 0);
        dest.writeTypedArray(this.mSecondaryIds, 0);
        dest.writeLongArray(this.mVendorIds);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Identifier
    implements Parcelable {
        private final int mType;
        private final long mValue;
        public static final Parcelable.Creator<Identifier> CREATOR = new Parcelable.Creator<Identifier>(){

            @Override
            public Identifier createFromParcel(Parcel in) {
                return new Identifier(in);
            }

            public Identifier[] newArray(int size) {
                return new Identifier[size];
            }
        };

        public Identifier(int type, long value2) {
            if (type == 10004) {
                type = 4;
            }
            this.mType = type;
            this.mValue = value2;
        }

        public int getType() {
            if (this.mType == 4 && this.mValue > 10L) {
                return 10004;
            }
            return this.mType;
        }

        public boolean isCategoryType() {
            return this.mType >= 1000 && this.mType <= 1999 || this.mType == 6;
        }

        public long getValue() {
            return this.mValue;
        }

        public String toString() {
            return "Identifier(" + this.mType + ", " + this.mValue + ")";
        }

        public int hashCode() {
            return Objects.hash(this.mType, this.mValue);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)obj;
            return other.getType() == this.mType && other.getValue() == this.mValue;
        }

        private Identifier(Parcel in) {
            this.mType = in.readInt();
            this.mValue = in.readLong();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mType);
            dest.writeLong(this.mValue);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IdentifierType {
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProgramType {
    }
}

