/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.hardware.fingerprint.IUdfpsOverlayControllerCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IUdfpsOverlayController
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.fingerprint.IUdfpsOverlayController";
    public static final int REASON_UNKNOWN = 0;
    public static final int REASON_ENROLL_FIND_SENSOR = 1;
    public static final int REASON_ENROLL_ENROLLING = 2;
    public static final int REASON_AUTH_BP = 3;
    public static final int REASON_AUTH_FPM_KEYGUARD = 4;
    public static final int REASON_AUTH_FPM_OTHER = 5;

    public void showUdfpsOverlay(int var1, int var2, IUdfpsOverlayControllerCallback var3) throws RemoteException;

    public void hideUdfpsOverlay(int var1) throws RemoteException;

    public void onAcquiredGood(int var1) throws RemoteException;

    public void onEnrollmentProgress(int var1, int var2) throws RemoteException;

    public void onEnrollmentHelp(int var1) throws RemoteException;

    public void setDebugMessage(int var1, String var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUdfpsOverlayController {
        static final int TRANSACTION_showUdfpsOverlay = 1;
        static final int TRANSACTION_hideUdfpsOverlay = 2;
        static final int TRANSACTION_onAcquiredGood = 3;
        static final int TRANSACTION_onEnrollmentProgress = 4;
        static final int TRANSACTION_onEnrollmentHelp = 5;
        static final int TRANSACTION_setDebugMessage = 6;

        public Stub() {
            this.attachInterface(this, IUdfpsOverlayController.DESCRIPTOR);
        }

        public static IUdfpsOverlayController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IUdfpsOverlayController.DESCRIPTOR);
            if (iin != null && iin instanceof IUdfpsOverlayController) {
                return (IUdfpsOverlayController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "showUdfpsOverlay";
                }
                case 2: {
                    return "hideUdfpsOverlay";
                }
                case 3: {
                    return "onAcquiredGood";
                }
                case 4: {
                    return "onEnrollmentProgress";
                }
                case 5: {
                    return "onEnrollmentHelp";
                }
                case 6: {
                    return "setDebugMessage";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IUdfpsOverlayController.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IUdfpsOverlayControllerCallback _arg2 = IUdfpsOverlayControllerCallback.Stub.asInterface(data.readStrongBinder());
                    this.showUdfpsOverlay(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.hideUdfpsOverlay(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onAcquiredGood(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onEnrollmentProgress(_arg0, _arg1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onEnrollmentHelp(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.setDebugMessage(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IUdfpsOverlayController impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IUdfpsOverlayController getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IUdfpsOverlayController {
            private IBinder mRemote;
            public static IUdfpsOverlayController sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IUdfpsOverlayController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showUdfpsOverlay(int sensorId, int reason, IUdfpsOverlayControllerCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUdfpsOverlayController.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(reason);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showUdfpsOverlay(sensorId, reason, callback2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideUdfpsOverlay(int sensorId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUdfpsOverlayController.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().hideUdfpsOverlay(sensorId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAcquiredGood(int sensorId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUdfpsOverlayController.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAcquiredGood(sensorId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollmentProgress(int sensorId, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUdfpsOverlayController.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(remaining);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onEnrollmentProgress(sensorId, remaining);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollmentHelp(int sensorId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUdfpsOverlayController.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onEnrollmentHelp(sensorId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDebugMessage(int sensorId, String message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUdfpsOverlayController.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeString(message);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDebugMessage(sensorId, message);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IUdfpsOverlayController {
        @Override
        public void showUdfpsOverlay(int sensorId, int reason, IUdfpsOverlayControllerCallback callback2) throws RemoteException {
        }

        @Override
        public void hideUdfpsOverlay(int sensorId) throws RemoteException {
        }

        @Override
        public void onAcquiredGood(int sensorId) throws RemoteException {
        }

        @Override
        public void onEnrollmentProgress(int sensorId, int remaining) throws RemoteException {
        }

        @Override
        public void onEnrollmentHelp(int sensorId) throws RemoteException {
        }

        @Override
        public void setDebugMessage(int sensorId, String message) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

