/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IUdfpsHbmListener
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.fingerprint.IUdfpsHbmListener";
    public static final int GLOBAL_HBM = 0;
    public static final int LOCAL_HBM = 1;

    public void onHbmEnabled(int var1, int var2) throws RemoteException;

    public void onHbmDisabled(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUdfpsHbmListener {
        static final int TRANSACTION_onHbmEnabled = 1;
        static final int TRANSACTION_onHbmDisabled = 2;

        public Stub() {
            this.attachInterface(this, IUdfpsHbmListener.DESCRIPTOR);
        }

        public static IUdfpsHbmListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IUdfpsHbmListener.DESCRIPTOR);
            if (iin != null && iin instanceof IUdfpsHbmListener) {
                return (IUdfpsHbmListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onHbmEnabled";
                }
                case 2: {
                    return "onHbmDisabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IUdfpsHbmListener.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onHbmEnabled(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onHbmDisabled(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IUdfpsHbmListener impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IUdfpsHbmListener getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IUdfpsHbmListener {
            private IBinder mRemote;
            public static IUdfpsHbmListener sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IUdfpsHbmListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHbmEnabled(int hbmType, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUdfpsHbmListener.DESCRIPTOR);
                    _data.writeInt(hbmType);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onHbmEnabled(hbmType, displayId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHbmDisabled(int hbmType, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUdfpsHbmListener.DESCRIPTOR);
                    _data.writeInt(hbmType);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onHbmDisabled(hbmType, displayId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IUdfpsHbmListener {
        @Override
        public void onHbmEnabled(int hbmType, int displayId) throws RemoteException {
        }

        @Override
        public void onHbmDisabled(int hbmType, int displayId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

