/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ParceledListSlice;
import android.graphics.Point;
import android.hardware.display.BrightnessConfiguration;
import android.hardware.display.BrightnessInfo;
import android.hardware.display.Curve;
import android.hardware.display.IDisplayManagerCallback;
import android.hardware.display.IVirtualDisplayCallback;
import android.hardware.display.VirtualDisplayConfig;
import android.hardware.display.WifiDisplayStatus;
import android.media.projection.IMediaProjection;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.DisplayInfo;
import android.view.Surface;

public interface IDisplayManager
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/hardware/display/IDisplayManager.aidl:35:1:35:25")
    public DisplayInfo getDisplayInfo(int var1) throws RemoteException;

    public int[] getDisplayIds() throws RemoteException;

    public boolean isUidPresentOnDisplay(int var1, int var2) throws RemoteException;

    public void registerCallback(IDisplayManagerCallback var1) throws RemoteException;

    public void registerCallbackWithEventMask(IDisplayManagerCallback var1, long var2) throws RemoteException;

    public void startWifiDisplayScan() throws RemoteException;

    public void stopWifiDisplayScan() throws RemoteException;

    public void connectWifiDisplay(String var1) throws RemoteException;

    public void disconnectWifiDisplay() throws RemoteException;

    public void renameWifiDisplay(String var1, String var2) throws RemoteException;

    public void forgetWifiDisplay(String var1) throws RemoteException;

    public void pauseWifiDisplay() throws RemoteException;

    public void resumeWifiDisplay() throws RemoteException;

    public WifiDisplayStatus getWifiDisplayStatus() throws RemoteException;

    public void setUserDisabledHdrTypes(int[] var1) throws RemoteException;

    public void setAreUserDisabledHdrTypesAllowed(boolean var1) throws RemoteException;

    public boolean areUserDisabledHdrTypesAllowed() throws RemoteException;

    public int[] getUserDisabledHdrTypes() throws RemoteException;

    public void requestColorMode(int var1, int var2) throws RemoteException;

    public int createVirtualDisplay(VirtualDisplayConfig var1, IVirtualDisplayCallback var2, IMediaProjection var3, String var4) throws RemoteException;

    public void resizeVirtualDisplay(IVirtualDisplayCallback var1, int var2, int var3, int var4) throws RemoteException;

    public void setVirtualDisplaySurface(IVirtualDisplayCallback var1, Surface var2) throws RemoteException;

    public void releaseVirtualDisplay(IVirtualDisplayCallback var1) throws RemoteException;

    public void setVirtualDisplayState(IVirtualDisplayCallback var1, boolean var2) throws RemoteException;

    public Point getStableDisplaySize() throws RemoteException;

    public ParceledListSlice getBrightnessEvents(String var1) throws RemoteException;

    public ParceledListSlice getAmbientBrightnessStats() throws RemoteException;

    public void setBrightnessConfigurationForUser(BrightnessConfiguration var1, int var2, String var3) throws RemoteException;

    public BrightnessConfiguration getBrightnessConfigurationForUser(int var1) throws RemoteException;

    public BrightnessConfiguration getDefaultBrightnessConfiguration() throws RemoteException;

    public boolean isMinimalPostProcessingRequested(int var1) throws RemoteException;

    public void setTemporaryBrightness(int var1, float var2) throws RemoteException;

    public void setBrightness(int var1, float var2) throws RemoteException;

    public float getBrightness(int var1) throws RemoteException;

    public void setTemporaryAutoBrightnessAdjustment(float var1) throws RemoteException;

    public Curve getMinimumBrightnessCurve() throws RemoteException;

    public BrightnessInfo getBrightnessInfo(int var1) throws RemoteException;

    public int getPreferredWideGamutColorSpaceId() throws RemoteException;

    public void setShouldAlwaysRespectAppRequestedMode(boolean var1) throws RemoteException;

    public boolean shouldAlwaysRespectAppRequestedMode() throws RemoteException;

    public void setRefreshRateSwitchingType(int var1) throws RemoteException;

    public int getRefreshRateSwitchingType() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDisplayManager {
        public static final String DESCRIPTOR = "android.hardware.display.IDisplayManager";
        static final int TRANSACTION_getDisplayInfo = 1;
        static final int TRANSACTION_getDisplayIds = 2;
        static final int TRANSACTION_isUidPresentOnDisplay = 3;
        static final int TRANSACTION_registerCallback = 4;
        static final int TRANSACTION_registerCallbackWithEventMask = 5;
        static final int TRANSACTION_startWifiDisplayScan = 6;
        static final int TRANSACTION_stopWifiDisplayScan = 7;
        static final int TRANSACTION_connectWifiDisplay = 8;
        static final int TRANSACTION_disconnectWifiDisplay = 9;
        static final int TRANSACTION_renameWifiDisplay = 10;
        static final int TRANSACTION_forgetWifiDisplay = 11;
        static final int TRANSACTION_pauseWifiDisplay = 12;
        static final int TRANSACTION_resumeWifiDisplay = 13;
        static final int TRANSACTION_getWifiDisplayStatus = 14;
        static final int TRANSACTION_setUserDisabledHdrTypes = 15;
        static final int TRANSACTION_setAreUserDisabledHdrTypesAllowed = 16;
        static final int TRANSACTION_areUserDisabledHdrTypesAllowed = 17;
        static final int TRANSACTION_getUserDisabledHdrTypes = 18;
        static final int TRANSACTION_requestColorMode = 19;
        static final int TRANSACTION_createVirtualDisplay = 20;
        static final int TRANSACTION_resizeVirtualDisplay = 21;
        static final int TRANSACTION_setVirtualDisplaySurface = 22;
        static final int TRANSACTION_releaseVirtualDisplay = 23;
        static final int TRANSACTION_setVirtualDisplayState = 24;
        static final int TRANSACTION_getStableDisplaySize = 25;
        static final int TRANSACTION_getBrightnessEvents = 26;
        static final int TRANSACTION_getAmbientBrightnessStats = 27;
        static final int TRANSACTION_setBrightnessConfigurationForUser = 28;
        static final int TRANSACTION_getBrightnessConfigurationForUser = 29;
        static final int TRANSACTION_getDefaultBrightnessConfiguration = 30;
        static final int TRANSACTION_isMinimalPostProcessingRequested = 31;
        static final int TRANSACTION_setTemporaryBrightness = 32;
        static final int TRANSACTION_setBrightness = 33;
        static final int TRANSACTION_getBrightness = 34;
        static final int TRANSACTION_setTemporaryAutoBrightnessAdjustment = 35;
        static final int TRANSACTION_getMinimumBrightnessCurve = 36;
        static final int TRANSACTION_getBrightnessInfo = 37;
        static final int TRANSACTION_getPreferredWideGamutColorSpaceId = 38;
        static final int TRANSACTION_setShouldAlwaysRespectAppRequestedMode = 39;
        static final int TRANSACTION_shouldAlwaysRespectAppRequestedMode = 40;
        static final int TRANSACTION_setRefreshRateSwitchingType = 41;
        static final int TRANSACTION_getRefreshRateSwitchingType = 42;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDisplayManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IDisplayManager) {
                return (IDisplayManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getDisplayInfo";
                }
                case 2: {
                    return "getDisplayIds";
                }
                case 3: {
                    return "isUidPresentOnDisplay";
                }
                case 4: {
                    return "registerCallback";
                }
                case 5: {
                    return "registerCallbackWithEventMask";
                }
                case 6: {
                    return "startWifiDisplayScan";
                }
                case 7: {
                    return "stopWifiDisplayScan";
                }
                case 8: {
                    return "connectWifiDisplay";
                }
                case 9: {
                    return "disconnectWifiDisplay";
                }
                case 10: {
                    return "renameWifiDisplay";
                }
                case 11: {
                    return "forgetWifiDisplay";
                }
                case 12: {
                    return "pauseWifiDisplay";
                }
                case 13: {
                    return "resumeWifiDisplay";
                }
                case 14: {
                    return "getWifiDisplayStatus";
                }
                case 15: {
                    return "setUserDisabledHdrTypes";
                }
                case 16: {
                    return "setAreUserDisabledHdrTypesAllowed";
                }
                case 17: {
                    return "areUserDisabledHdrTypesAllowed";
                }
                case 18: {
                    return "getUserDisabledHdrTypes";
                }
                case 19: {
                    return "requestColorMode";
                }
                case 20: {
                    return "createVirtualDisplay";
                }
                case 21: {
                    return "resizeVirtualDisplay";
                }
                case 22: {
                    return "setVirtualDisplaySurface";
                }
                case 23: {
                    return "releaseVirtualDisplay";
                }
                case 24: {
                    return "setVirtualDisplayState";
                }
                case 25: {
                    return "getStableDisplaySize";
                }
                case 26: {
                    return "getBrightnessEvents";
                }
                case 27: {
                    return "getAmbientBrightnessStats";
                }
                case 28: {
                    return "setBrightnessConfigurationForUser";
                }
                case 29: {
                    return "getBrightnessConfigurationForUser";
                }
                case 30: {
                    return "getDefaultBrightnessConfiguration";
                }
                case 31: {
                    return "isMinimalPostProcessingRequested";
                }
                case 32: {
                    return "setTemporaryBrightness";
                }
                case 33: {
                    return "setBrightness";
                }
                case 34: {
                    return "getBrightness";
                }
                case 35: {
                    return "setTemporaryAutoBrightnessAdjustment";
                }
                case 36: {
                    return "getMinimumBrightnessCurve";
                }
                case 37: {
                    return "getBrightnessInfo";
                }
                case 38: {
                    return "getPreferredWideGamutColorSpaceId";
                }
                case 39: {
                    return "setShouldAlwaysRespectAppRequestedMode";
                }
                case 40: {
                    return "shouldAlwaysRespectAppRequestedMode";
                }
                case 41: {
                    return "setRefreshRateSwitchingType";
                }
                case 42: {
                    return "getRefreshRateSwitchingType";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    DisplayInfo _result = this.getDisplayInfo(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int[] _result = this.getDisplayIds();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _result = this.isUidPresentOnDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IDisplayManagerCallback _arg0 = IDisplayManagerCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    IDisplayManagerCallback _arg0 = IDisplayManagerCallback.Stub.asInterface(data.readStrongBinder());
                    long _arg1 = data.readLong();
                    this.registerCallbackWithEventMask(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    this.startWifiDisplayScan();
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    this.stopWifiDisplayScan();
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.connectWifiDisplay(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    this.disconnectWifiDisplay();
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.renameWifiDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.forgetWifiDisplay(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    this.pauseWifiDisplay();
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    this.resumeWifiDisplay();
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    WifiDisplayStatus _result = this.getWifiDisplayStatus();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    this.setUserDisabledHdrTypes(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setAreUserDisabledHdrTypesAllowed(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.areUserDisabledHdrTypesAllowed();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    int[] _result = this.getUserDisabledHdrTypes();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.requestColorMode(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    VirtualDisplayConfig _arg0 = 0 != data.readInt() ? VirtualDisplayConfig.CREATOR.createFromParcel(data) : null;
                    IVirtualDisplayCallback _arg1 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    IMediaProjection _arg2 = IMediaProjection.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    int _result = this.createVirtualDisplay(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.resizeVirtualDisplay(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    Surface _arg1 = 0 != data.readInt() ? Surface.CREATOR.createFromParcel(data) : null;
                    this.setVirtualDisplaySurface(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    this.releaseVirtualDisplay(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = 0 != data.readInt();
                    this.setVirtualDisplayState(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    Point _result = this.getStableDisplaySize();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ParceledListSlice _result = this.getBrightnessEvents(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    ParceledListSlice _result = this.getAmbientBrightnessStats();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    BrightnessConfiguration _arg0 = 0 != data.readInt() ? BrightnessConfiguration.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    this.setBrightnessConfigurationForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    BrightnessConfiguration _result = this.getBrightnessConfigurationForUser(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    BrightnessConfiguration _result = this.getDefaultBrightnessConfiguration();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.isMinimalPostProcessingRequested(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    this.setTemporaryBrightness(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    this.setBrightness(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    float _result = this.getBrightness(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    float _arg0 = data.readFloat();
                    this.setTemporaryAutoBrightnessAdjustment(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    Curve _result = this.getMinimumBrightnessCurve();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    BrightnessInfo _result = this.getBrightnessInfo(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    int _result = this.getPreferredWideGamutColorSpaceId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setShouldAlwaysRespectAppRequestedMode(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.shouldAlwaysRespectAppRequestedMode();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.setRefreshRateSwitchingType(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    int _result = this.getRefreshRateSwitchingType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IDisplayManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IDisplayManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IDisplayManager {
            private IBinder mRemote;
            public static IDisplayManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DisplayInfo getDisplayInfo(int displayId) throws RemoteException {
                DisplayInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        DisplayInfo displayInfo = Stub.getDefaultImpl().getDisplayInfo(displayId);
                        return displayInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? DisplayInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getDisplayIds() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int[] nArray = Stub.getDefaultImpl().getDisplayIds();
                        return nArray;
                    }
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUidPresentOnDisplay(int uid, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isUidPresentOnDisplay(uid, displayId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(IDisplayManagerCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerCallback(callback2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallbackWithEventMask(IDisplayManagerCallback callback2, long eventsMask) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    _data.writeLong(eventsMask);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerCallbackWithEventMask(callback2, eventsMask);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWifiDisplayScan() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startWifiDisplayScan();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWifiDisplayScan() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopWifiDisplayScan();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectWifiDisplay(String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().connectWifiDisplay(address);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnectWifiDisplay() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().disconnectWifiDisplay();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void renameWifiDisplay(String address, String alias) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().renameWifiDisplay(address, alias);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forgetWifiDisplay(String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().forgetWifiDisplay(address);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pauseWifiDisplay() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().pauseWifiDisplay();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resumeWifiDisplay() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().resumeWifiDisplay();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiDisplayStatus getWifiDisplayStatus() throws RemoteException {
                WifiDisplayStatus _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        WifiDisplayStatus wifiDisplayStatus = Stub.getDefaultImpl().getWifiDisplayStatus();
                        return wifiDisplayStatus;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiDisplayStatus.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUserDisabledHdrTypes(int[] userDisabledTypes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(userDisabledTypes);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setUserDisabledHdrTypes(userDisabledTypes);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAreUserDisabledHdrTypesAllowed(boolean areUserDisabledHdrTypesAllowed) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(areUserDisabledHdrTypesAllowed ? 1 : 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAreUserDisabledHdrTypesAllowed(areUserDisabledHdrTypesAllowed);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean areUserDisabledHdrTypesAllowed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().areUserDisabledHdrTypesAllowed();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getUserDisabledHdrTypes() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int[] nArray = Stub.getDefaultImpl().getUserDisabledHdrTypes();
                        return nArray;
                    }
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestColorMode(int displayId, int colorMode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(colorMode);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestColorMode(displayId, colorMode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int createVirtualDisplay(VirtualDisplayConfig virtualDisplayConfig, IVirtualDisplayCallback callback2, IMediaProjection projectionToken, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (virtualDisplayConfig != null) {
                        _data.writeInt(1);
                        virtualDisplayConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    _data.writeStrongBinder(projectionToken != null ? projectionToken.asBinder() : null);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().createVirtualDisplay(virtualDisplayConfig, callback2, projectionToken, packageName);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resizeVirtualDisplay(IVirtualDisplayCallback token, int width, int height, int densityDpi) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token != null ? token.asBinder() : null);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeInt(densityDpi);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().resizeVirtualDisplay(token, width, height, densityDpi);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVirtualDisplaySurface(IVirtualDisplayCallback token, Surface surface2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token != null ? token.asBinder() : null);
                    if (surface2 != null) {
                        _data.writeInt(1);
                        surface2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setVirtualDisplaySurface(token, surface2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseVirtualDisplay(IVirtualDisplayCallback token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token != null ? token.asBinder() : null);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseVirtualDisplay(token);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVirtualDisplayState(IVirtualDisplayCallback token, boolean isOn) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token != null ? token.asBinder() : null);
                    _data.writeInt(isOn ? 1 : 0);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setVirtualDisplayState(token, isOn);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Point getStableDisplaySize() throws RemoteException {
                Point _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Point point = Stub.getDefaultImpl().getStableDisplaySize();
                        return point;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Point.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getBrightnessEvents(String callingPackage) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getBrightnessEvents(callingPackage);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getAmbientBrightnessStats() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getAmbientBrightnessStats();
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBrightnessConfigurationForUser(BrightnessConfiguration c, int userId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (c != null) {
                        _data.writeInt(1);
                        c.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setBrightnessConfigurationForUser(c, userId, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BrightnessConfiguration getBrightnessConfigurationForUser(int userId) throws RemoteException {
                BrightnessConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        BrightnessConfiguration brightnessConfiguration = Stub.getDefaultImpl().getBrightnessConfigurationForUser(userId);
                        return brightnessConfiguration;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? BrightnessConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BrightnessConfiguration getDefaultBrightnessConfiguration() throws RemoteException {
                BrightnessConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        BrightnessConfiguration brightnessConfiguration = Stub.getDefaultImpl().getDefaultBrightnessConfiguration();
                        return brightnessConfiguration;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? BrightnessConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMinimalPostProcessingRequested(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isMinimalPostProcessingRequested(displayId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTemporaryBrightness(int displayId, float brightness) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeFloat(brightness);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setTemporaryBrightness(displayId, brightness);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBrightness(int displayId, float brightness) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeFloat(brightness);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setBrightness(displayId, brightness);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getBrightness(int displayId) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        float f = Stub.getDefaultImpl().getBrightness(displayId);
                        return f;
                    }
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTemporaryAutoBrightnessAdjustment(float adjustment) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(adjustment);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setTemporaryAutoBrightnessAdjustment(adjustment);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Curve getMinimumBrightnessCurve() throws RemoteException {
                Curve _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Curve curve = Stub.getDefaultImpl().getMinimumBrightnessCurve();
                        return curve;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Curve.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BrightnessInfo getBrightnessInfo(int displayId) throws RemoteException {
                BrightnessInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        BrightnessInfo brightnessInfo = Stub.getDefaultImpl().getBrightnessInfo(displayId);
                        return brightnessInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? BrightnessInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPreferredWideGamutColorSpaceId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getPreferredWideGamutColorSpaceId();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldAlwaysRespectAppRequestedMode(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setShouldAlwaysRespectAppRequestedMode(enabled);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldAlwaysRespectAppRequestedMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().shouldAlwaysRespectAppRequestedMode();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRefreshRateSwitchingType(int newValue) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(newValue);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setRefreshRateSwitchingType(newValue);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRefreshRateSwitchingType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getRefreshRateSwitchingType();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IDisplayManager {
        @Override
        public DisplayInfo getDisplayInfo(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public int[] getDisplayIds() throws RemoteException {
            return null;
        }

        @Override
        public boolean isUidPresentOnDisplay(int uid, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void registerCallback(IDisplayManagerCallback callback2) throws RemoteException {
        }

        @Override
        public void registerCallbackWithEventMask(IDisplayManagerCallback callback2, long eventsMask) throws RemoteException {
        }

        @Override
        public void startWifiDisplayScan() throws RemoteException {
        }

        @Override
        public void stopWifiDisplayScan() throws RemoteException {
        }

        @Override
        public void connectWifiDisplay(String address) throws RemoteException {
        }

        @Override
        public void disconnectWifiDisplay() throws RemoteException {
        }

        @Override
        public void renameWifiDisplay(String address, String alias) throws RemoteException {
        }

        @Override
        public void forgetWifiDisplay(String address) throws RemoteException {
        }

        @Override
        public void pauseWifiDisplay() throws RemoteException {
        }

        @Override
        public void resumeWifiDisplay() throws RemoteException {
        }

        @Override
        public WifiDisplayStatus getWifiDisplayStatus() throws RemoteException {
            return null;
        }

        @Override
        public void setUserDisabledHdrTypes(int[] userDisabledTypes) throws RemoteException {
        }

        @Override
        public void setAreUserDisabledHdrTypesAllowed(boolean areUserDisabledHdrTypesAllowed) throws RemoteException {
        }

        @Override
        public boolean areUserDisabledHdrTypesAllowed() throws RemoteException {
            return false;
        }

        @Override
        public int[] getUserDisabledHdrTypes() throws RemoteException {
            return null;
        }

        @Override
        public void requestColorMode(int displayId, int colorMode) throws RemoteException {
        }

        @Override
        public int createVirtualDisplay(VirtualDisplayConfig virtualDisplayConfig, IVirtualDisplayCallback callback2, IMediaProjection projectionToken, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public void resizeVirtualDisplay(IVirtualDisplayCallback token, int width, int height, int densityDpi) throws RemoteException {
        }

        @Override
        public void setVirtualDisplaySurface(IVirtualDisplayCallback token, Surface surface2) throws RemoteException {
        }

        @Override
        public void releaseVirtualDisplay(IVirtualDisplayCallback token) throws RemoteException {
        }

        @Override
        public void setVirtualDisplayState(IVirtualDisplayCallback token, boolean isOn) throws RemoteException {
        }

        @Override
        public Point getStableDisplaySize() throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getBrightnessEvents(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getAmbientBrightnessStats() throws RemoteException {
            return null;
        }

        @Override
        public void setBrightnessConfigurationForUser(BrightnessConfiguration c, int userId, String packageName) throws RemoteException {
        }

        @Override
        public BrightnessConfiguration getBrightnessConfigurationForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public BrightnessConfiguration getDefaultBrightnessConfiguration() throws RemoteException {
            return null;
        }

        @Override
        public boolean isMinimalPostProcessingRequested(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setTemporaryBrightness(int displayId, float brightness) throws RemoteException {
        }

        @Override
        public void setBrightness(int displayId, float brightness) throws RemoteException {
        }

        @Override
        public float getBrightness(int displayId) throws RemoteException {
            return 0.0f;
        }

        @Override
        public void setTemporaryAutoBrightnessAdjustment(float adjustment) throws RemoteException {
        }

        @Override
        public Curve getMinimumBrightnessCurve() throws RemoteException {
            return null;
        }

        @Override
        public BrightnessInfo getBrightnessInfo(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public int getPreferredWideGamutColorSpaceId() throws RemoteException {
            return 0;
        }

        @Override
        public void setShouldAlwaysRespectAppRequestedMode(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean shouldAlwaysRespectAppRequestedMode() throws RemoteException {
            return false;
        }

        @Override
        public void setRefreshRateSwitchingType(int newValue) throws RemoteException {
        }

        @Override
        public int getRefreshRateSwitchingType() throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

