/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.devicestate;

import android.annotation.RequiresPermission;
import android.content.Context;
import android.hardware.devicestate.DeviceStateManagerGlobal;
import android.hardware.devicestate.DeviceStateRequest;
import com.android.internal.util.ArrayUtils;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class DeviceStateManager {
    public static final int INVALID_DEVICE_STATE = -1;
    public static final int MINIMUM_DEVICE_STATE = 0;
    public static final int MAXIMUM_DEVICE_STATE = 255;
    private final DeviceStateManagerGlobal mGlobal;

    public DeviceStateManager() {
        DeviceStateManagerGlobal global = DeviceStateManagerGlobal.getInstance();
        if (global == null) {
            throw new IllegalStateException("Failed to get instance of global device state manager.");
        }
        this.mGlobal = global;
    }

    public int[] getSupportedStates() {
        return this.mGlobal.getSupportedStates();
    }

    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE")
    public void requestState(DeviceStateRequest request, Executor executor, DeviceStateRequest.Callback callback2) {
        this.mGlobal.requestState(request, callback2, executor);
    }

    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE")
    public void cancelRequest(DeviceStateRequest request) {
        this.mGlobal.cancelRequest(request);
    }

    public void registerCallback(Executor executor, DeviceStateCallback callback2) {
        this.mGlobal.registerDeviceStateCallback(callback2, executor);
    }

    public void unregisterCallback(DeviceStateCallback callback2) {
        this.mGlobal.unregisterDeviceStateCallback(callback2);
    }

    public static class FoldStateListener
    implements DeviceStateCallback {
        private final int[] mFoldedDeviceStates;
        private final Consumer<Boolean> mDelegate;
        private Boolean lastResult;

        public FoldStateListener(Context context, Consumer<Boolean> listener2) {
            this.mFoldedDeviceStates = context.getResources().getIntArray(17236044);
            this.mDelegate = listener2;
        }

        @Override
        public void onStateChanged(int state) {
            boolean folded = ArrayUtils.contains(this.mFoldedDeviceStates, state);
            if (this.lastResult == null || !this.lastResult.equals(folded)) {
                this.lastResult = folded;
                this.mDelegate.accept(folded);
            }
        }
    }

    public static interface DeviceStateCallback {
        default public void onSupportedStatesChanged(int[] supportedStates) {
        }

        default public void onBaseStateChanged(int state) {
        }

        public void onStateChanged(int var1);
    }
}

