/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import com.android.internal.util.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;

public class TaskDrainer<T> {
    private static final String TAG = "TaskDrainer";
    private final boolean DEBUG = false;
    private final Executor mExecutor;
    private final DrainListener mListener;
    private final String mName;
    private final Set<T> mTaskSet = new HashSet<T>();
    private final Set<T> mEarlyFinishedTaskSet = new HashSet<T>();
    private final Object mLock = new Object();
    private boolean mDraining = false;
    private boolean mDrainFinished = false;

    public TaskDrainer(Executor executor, DrainListener listener2) {
        this.mExecutor = Preconditions.checkNotNull(executor, "executor must not be null");
        this.mListener = Preconditions.checkNotNull(listener2, "listener must not be null");
        this.mName = null;
    }

    public TaskDrainer(Executor executor, DrainListener listener2, String name) {
        this.mExecutor = Preconditions.checkNotNull(executor, "executor must not be null");
        this.mListener = Preconditions.checkNotNull(listener2, "listener must not be null");
        this.mName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskStarted(T task) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDraining) {
                throw new IllegalStateException("Can't start more tasks after draining has begun");
            }
            if (!this.mEarlyFinishedTaskSet.remove(task) && !this.mTaskSet.add(task)) {
                throw new IllegalStateException("Task " + task + " was already started");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskFinished(T task) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mTaskSet.remove(task) && !this.mEarlyFinishedTaskSet.add(task)) {
                throw new IllegalStateException("Task " + task + " was already finished");
            }
            this.checkIfDrainFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginDrain() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mDraining) {
                this.mDraining = true;
                this.checkIfDrainFinished();
            }
        }
    }

    private void checkIfDrainFinished() {
        if (this.mTaskSet.isEmpty() && this.mDraining && !this.mDrainFinished) {
            this.mDrainFinished = true;
            this.postDrained();
        }
    }

    private void postDrained() {
        this.mExecutor.execute(() -> this.mListener.onDrained());
    }

    public static interface DrainListener {
        public void onDrained();
    }
}

