/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.graphics.Point;
import android.graphics.Rect;

public class Face {
    public static final int ID_UNSUPPORTED = -1;
    public static final int SCORE_MIN = 1;
    public static final int SCORE_MAX = 100;
    private final Rect mBounds;
    private final int mScore;
    private final int mId;
    private final Point mLeftEye;
    private final Point mRightEye;
    private final Point mMouth;

    public Face(Rect bounds2, int score, int id2, Point leftEyePosition, Point rightEyePosition, Point mouthPosition) {
        Face.checkNotNull("bounds", bounds2);
        if (score < 1 || score > 100) {
            throw new IllegalArgumentException("Confidence out of range");
        }
        if (id2 < 0 && id2 != -1) {
            throw new IllegalArgumentException("Id out of range");
        }
        if (id2 == -1) {
            Face.checkNull("leftEyePosition", leftEyePosition);
            Face.checkNull("rightEyePosition", rightEyePosition);
            Face.checkNull("mouthPosition", mouthPosition);
        }
        this.mBounds = bounds2;
        this.mScore = score;
        this.mId = id2;
        this.mLeftEye = leftEyePosition;
        this.mRightEye = rightEyePosition;
        this.mMouth = mouthPosition;
    }

    public Face(Rect bounds2, int score) {
        this(bounds2, score, -1, null, null, null);
    }

    public Rect getBounds() {
        return this.mBounds;
    }

    public int getScore() {
        return this.mScore;
    }

    public int getId() {
        return this.mId;
    }

    public Point getLeftEyePosition() {
        return this.mLeftEye;
    }

    public Point getRightEyePosition() {
        return this.mRightEye;
    }

    public Point getMouthPosition() {
        return this.mMouth;
    }

    public String toString() {
        return String.format("{ bounds: %s, score: %s, id: %d, leftEyePosition: %s, rightEyePosition: %s, mouthPosition: %s }", this.mBounds, this.mScore, this.mId, this.mLeftEye, this.mRightEye, this.mMouth);
    }

    private static void checkNotNull(String name, Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " was required, but it was null");
        }
    }

    private static void checkNull(String name, Object obj) {
        if (obj != null) {
            throw new IllegalArgumentException(name + " was required to be null, but it wasn't");
        }
    }
}

