/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.params.ReprocessFormatsMap;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.TypeReference;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class MarshalQueryableReprocessFormatsMap
implements MarshalQueryable<ReprocessFormatsMap> {
    @Override
    public Marshaler<ReprocessFormatsMap> createMarshaler(TypeReference<ReprocessFormatsMap> managedType, int nativeType) {
        return new MarshalerReprocessFormatsMap(managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<ReprocessFormatsMap> managedType, int nativeType) {
        return nativeType == 1 && managedType.getType().equals(ReprocessFormatsMap.class);
    }

    private class MarshalerReprocessFormatsMap
    extends Marshaler<ReprocessFormatsMap> {
        protected MarshalerReprocessFormatsMap(TypeReference<ReprocessFormatsMap> typeReference, int nativeType) {
            super(MarshalQueryableReprocessFormatsMap.this, typeReference, nativeType);
        }

        @Override
        public void marshal(ReprocessFormatsMap value2, ByteBuffer buffer) {
            int[] inputs;
            for (int input : inputs = StreamConfigurationMap.imageFormatToInternal(value2.getInputs())) {
                buffer.putInt(input);
                int[] outputs = StreamConfigurationMap.imageFormatToInternal(value2.getOutputs(input));
                buffer.putInt(outputs.length);
                for (int output : outputs) {
                    buffer.putInt(output);
                }
            }
        }

        @Override
        public ReprocessFormatsMap unmarshal(ByteBuffer buffer) {
            int len = buffer.remaining() / 4;
            if (buffer.remaining() % 4 != 0) {
                throw new AssertionError((Object)"ReprocessFormatsMap was not TYPE_INT32");
            }
            int[] entries = new int[len];
            IntBuffer intBuffer = buffer.asIntBuffer();
            intBuffer.get(entries);
            return new ReprocessFormatsMap(entries);
        }

        @Override
        public int getNativeSize() {
            return NATIVE_SIZE_DYNAMIC;
        }

        @Override
        public int calculateMarshalSize(ReprocessFormatsMap value2) {
            int[] inputs;
            int length = 0;
            for (int input : inputs = value2.getInputs()) {
                ++length;
                ++length;
                int[] outputs = value2.getOutputs(input);
                length += outputs.length;
            }
            return length * 4;
        }
    }
}

