/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.annotation.RequiresPermission;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraExtensionCharacteristics;
import android.hardware.camera2.CameraExtensionSession;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.extension.CaptureBundle;
import android.hardware.camera2.extension.CaptureStageImpl;
import android.hardware.camera2.extension.ICaptureProcessorImpl;
import android.hardware.camera2.extension.IImageCaptureExtenderImpl;
import android.hardware.camera2.extension.IInitializeSessionCallback;
import android.hardware.camera2.extension.IPreviewExtenderImpl;
import android.hardware.camera2.extension.IRequestUpdateProcessorImpl;
import android.hardware.camera2.extension.ParcelImage;
import android.hardware.camera2.impl.CameraExtensionForwardProcessor;
import android.hardware.camera2.impl.CameraExtensionJpegProcessor;
import android.hardware.camera2.impl.CameraExtensionUtils;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.ExtensionSessionConfiguration;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.SessionConfiguration;
import android.hardware.camera2.utils.SurfaceUtils;
import android.media.Image;
import android.media.ImageReader;
import android.media.ImageWriter;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class CameraExtensionSessionImpl
extends CameraExtensionSession {
    private static final int PREVIEW_QUEUE_SIZE = 3;
    private static final String TAG = "CameraExtensionSessionImpl";
    private final Executor mExecutor;
    private final CameraDevice mCameraDevice;
    private final long mExtensionClientId;
    private final IImageCaptureExtenderImpl mImageExtender;
    private final IPreviewExtenderImpl mPreviewExtender;
    private final Handler mHandler;
    private final HandlerThread mHandlerThread;
    private final CameraExtensionSession.StateCallback mCallbacks;
    private final List<Size> mSupportedPreviewSizes;
    private final InitializeSessionHandler mInitializeHandler;
    private CameraCaptureSession mCaptureSession = null;
    private Surface mCameraRepeatingSurface;
    private Surface mClientRepeatingRequestSurface;
    private Surface mCameraBurstSurface;
    private Surface mClientCaptureSurface;
    private ImageReader mRepeatingRequestImageReader = null;
    private ImageReader mBurstCaptureImageReader = null;
    private ImageReader mStubCaptureImageReader = null;
    private ImageWriter mRepeatingRequestImageWriter = null;
    private CameraOutputImageCallback mRepeatingRequestImageCallback = null;
    private CameraOutputImageCallback mBurstCaptureImageCallback = null;
    private CameraExtensionJpegProcessor mImageJpegProcessor = null;
    private ICaptureProcessorImpl mImageProcessor = null;
    private CameraExtensionForwardProcessor mPreviewImageProcessor = null;
    private IRequestUpdateProcessorImpl mPreviewRequestUpdateProcessor = null;
    private int mPreviewProcessorType = 2;
    private boolean mInitialized;
    private boolean mInternalRepeatingRequestEnabled = true;
    final Object mInterfaceLock = new Object();

    private static int nativeGetSurfaceFormat(Surface surface2) {
        return SurfaceUtils.getSurfaceFormat(surface2);
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public static CameraExtensionSessionImpl createCameraExtensionSession(CameraDevice cameraDevice, Context ctx, ExtensionSessionConfiguration config) throws CameraAccessException, RemoteException {
        long clientId = CameraExtensionCharacteristics.registerClient(ctx);
        if (clientId < 0L) {
            throw new UnsupportedOperationException("Unsupported extension!");
        }
        String cameraId = cameraDevice.getId();
        CameraManager manager = ctx.getSystemService(CameraManager.class);
        CameraCharacteristics chars = manager.getCameraCharacteristics(cameraId);
        CameraExtensionCharacteristics extensionChars = new CameraExtensionCharacteristics(ctx, cameraId, chars);
        if (!CameraExtensionCharacteristics.isExtensionSupported(cameraDevice.getId(), config.getExtension(), chars)) {
            throw new UnsupportedOperationException("Unsupported extension type: " + config.getExtension());
        }
        if (config.getOutputConfigurations().isEmpty() || config.getOutputConfigurations().size() > 2) {
            throw new IllegalArgumentException("Unexpected amount of output surfaces, received: " + config.getOutputConfigurations().size() + " expected <= 2");
        }
        Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(config.getExtension());
        int suitableSurfaceCount = 0;
        List<Size> supportedPreviewSizes = extensionChars.getExtensionSupportedSizes(config.getExtension(), SurfaceTexture.class);
        Surface repeatingRequestSurface = CameraExtensionUtils.getRepeatingRequestSurface(config.getOutputConfigurations(), supportedPreviewSizes);
        if (repeatingRequestSurface != null) {
            ++suitableSurfaceCount;
        }
        HashMap<Integer, List<Size>> supportedCaptureSizes = new HashMap<Integer, List<Size>>();
        for (int format : CameraExtensionUtils.SUPPORTED_CAPTURE_OUTPUT_FORMATS) {
            List<Size> supportedSizes = extensionChars.getExtensionSupportedSizes(config.getExtension(), format);
            if (supportedSizes == null) continue;
            supportedCaptureSizes.put(format, supportedSizes);
        }
        Surface burstCaptureSurface = CameraExtensionUtils.getBurstCaptureSurface(config.getOutputConfigurations(), supportedCaptureSizes);
        if (burstCaptureSurface != null) {
            ++suitableSurfaceCount;
        }
        if (suitableSurfaceCount != config.getOutputConfigurations().size()) {
            throw new IllegalArgumentException("One or more unsupported output surfaces found!");
        }
        ((IPreviewExtenderImpl)extenders.first).init(cameraId, chars.getNativeMetadata());
        ((IPreviewExtenderImpl)extenders.first).onInit(cameraId, chars.getNativeMetadata());
        ((IImageCaptureExtenderImpl)extenders.second).init(cameraId, chars.getNativeMetadata());
        ((IImageCaptureExtenderImpl)extenders.second).onInit(cameraId, chars.getNativeMetadata());
        CameraExtensionSessionImpl session = new CameraExtensionSessionImpl((IImageCaptureExtenderImpl)extenders.second, (IPreviewExtenderImpl)extenders.first, supportedPreviewSizes, clientId, cameraDevice, repeatingRequestSurface, burstCaptureSurface, config.getStateCallback(), config.getExecutor());
        session.initialize();
        return session;
    }

    public CameraExtensionSessionImpl(IImageCaptureExtenderImpl imageExtender, IPreviewExtenderImpl previewExtender, List<Size> previewSizes, long extensionClientId, CameraDevice cameraDevice, Surface repeatingRequestSurface, Surface burstCaptureSurface, CameraExtensionSession.StateCallback callback2, Executor executor) {
        this.mExtensionClientId = extensionClientId;
        this.mImageExtender = imageExtender;
        this.mPreviewExtender = previewExtender;
        this.mCameraDevice = cameraDevice;
        this.mCallbacks = callback2;
        this.mExecutor = executor;
        this.mClientRepeatingRequestSurface = repeatingRequestSurface;
        this.mClientCaptureSurface = burstCaptureSurface;
        this.mSupportedPreviewSizes = previewSizes;
        this.mHandlerThread = new HandlerThread(TAG);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mInitialized = false;
        this.mInitializeHandler = new InitializeSessionHandler();
    }

    private void initializeRepeatingRequestPipeline() throws RemoteException {
        CameraExtensionUtils.SurfaceInfo repeatingSurfaceInfo = new CameraExtensionUtils.SurfaceInfo();
        this.mPreviewProcessorType = this.mPreviewExtender.getProcessorType();
        if (this.mClientRepeatingRequestSurface != null) {
            repeatingSurfaceInfo = CameraExtensionUtils.querySurface(this.mClientRepeatingRequestSurface);
        } else {
            CameraExtensionUtils.SurfaceInfo captureSurfaceInfo = CameraExtensionUtils.querySurface(this.mClientCaptureSurface);
            Size captureSize = new Size(captureSurfaceInfo.mWidth, captureSurfaceInfo.mHeight);
            Size previewSize = CameraExtensionSessionImpl.findSmallestAspectMatchedSize(this.mSupportedPreviewSizes, captureSize);
            repeatingSurfaceInfo.mWidth = previewSize.getWidth();
            repeatingSurfaceInfo.mHeight = previewSize.getHeight();
            repeatingSurfaceInfo.mUsage = 256L;
        }
        if (this.mPreviewProcessorType == 1) {
            try {
                this.mPreviewImageProcessor = new CameraExtensionForwardProcessor(this.mPreviewExtender.getPreviewImageProcessor(), repeatingSurfaceInfo.mFormat, repeatingSurfaceInfo.mUsage, this.mHandler);
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Failed casting preview processor!");
            }
            this.mPreviewImageProcessor.onImageFormatUpdate(35);
            this.mPreviewImageProcessor.onResolutionUpdate(new Size(repeatingSurfaceInfo.mWidth, repeatingSurfaceInfo.mHeight));
            this.mPreviewImageProcessor.onOutputSurface(null, -1);
            this.mRepeatingRequestImageReader = ImageReader.newInstance(repeatingSurfaceInfo.mWidth, repeatingSurfaceInfo.mHeight, 35, 3, repeatingSurfaceInfo.mUsage);
            this.mCameraRepeatingSurface = this.mRepeatingRequestImageReader.getSurface();
        } else if (this.mPreviewProcessorType == 0) {
            try {
                this.mPreviewRequestUpdateProcessor = this.mPreviewExtender.getRequestUpdateProcessor();
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Failed casting preview processor!");
            }
            this.mRepeatingRequestImageReader = ImageReader.newInstance(repeatingSurfaceInfo.mWidth, repeatingSurfaceInfo.mHeight, 34, 3, repeatingSurfaceInfo.mUsage);
            this.mCameraRepeatingSurface = this.mRepeatingRequestImageReader.getSurface();
            android.hardware.camera2.extension.Size sz = new android.hardware.camera2.extension.Size();
            sz.width = repeatingSurfaceInfo.mWidth;
            sz.height = repeatingSurfaceInfo.mHeight;
            this.mPreviewRequestUpdateProcessor.onResolutionUpdate(sz);
            this.mPreviewRequestUpdateProcessor.onImageFormatUpdate(34);
        } else {
            this.mRepeatingRequestImageReader = ImageReader.newInstance(repeatingSurfaceInfo.mWidth, repeatingSurfaceInfo.mHeight, 34, 3, repeatingSurfaceInfo.mUsage);
            this.mCameraRepeatingSurface = this.mRepeatingRequestImageReader.getSurface();
        }
        this.mRepeatingRequestImageCallback = new CameraOutputImageCallback(this.mRepeatingRequestImageReader);
        this.mRepeatingRequestImageReader.setOnImageAvailableListener(this.mRepeatingRequestImageCallback, this.mHandler);
    }

    private void initializeBurstCapturePipeline() throws RemoteException {
        this.mImageProcessor = this.mImageExtender.getCaptureProcessor();
        if (this.mImageProcessor == null && this.mImageExtender.getMaxCaptureStage() != 1) {
            throw new UnsupportedOperationException("Multiple stages expected without a valid capture processor!");
        }
        if (this.mImageProcessor != null) {
            if (this.mClientCaptureSurface != null) {
                CameraExtensionUtils.SurfaceInfo surfaceInfo = CameraExtensionUtils.querySurface(this.mClientCaptureSurface);
                if (surfaceInfo.mFormat == 256) {
                    this.mImageJpegProcessor = new CameraExtensionJpegProcessor(this.mImageProcessor);
                    this.mImageProcessor = this.mImageJpegProcessor;
                }
                this.mBurstCaptureImageReader = ImageReader.newInstance(surfaceInfo.mWidth, surfaceInfo.mHeight, 35, this.mImageExtender.getMaxCaptureStage());
            } else {
                this.mBurstCaptureImageReader = ImageReader.newInstance(this.mRepeatingRequestImageReader.getWidth(), this.mRepeatingRequestImageReader.getHeight(), 35, 1);
                this.mStubCaptureImageReader = ImageReader.newInstance(this.mRepeatingRequestImageReader.getWidth(), this.mRepeatingRequestImageReader.getHeight(), 35, 1);
                this.mImageProcessor.onOutputSurface(this.mStubCaptureImageReader.getSurface(), 35);
            }
            this.mBurstCaptureImageCallback = new CameraOutputImageCallback(this.mBurstCaptureImageReader);
            this.mBurstCaptureImageReader.setOnImageAvailableListener(this.mBurstCaptureImageCallback, this.mHandler);
            this.mCameraBurstSurface = this.mBurstCaptureImageReader.getSurface();
            android.hardware.camera2.extension.Size sz = new android.hardware.camera2.extension.Size();
            sz.width = this.mBurstCaptureImageReader.getWidth();
            sz.height = this.mBurstCaptureImageReader.getHeight();
            this.mImageProcessor.onResolutionUpdate(sz);
            this.mImageProcessor.onImageFormatUpdate(this.mBurstCaptureImageReader.getImageFormat());
        } else if (this.mClientCaptureSurface != null) {
            this.mCameraBurstSurface = this.mClientCaptureSurface;
        } else {
            this.mBurstCaptureImageReader = ImageReader.newInstance(this.mRepeatingRequestImageReader.getWidth(), this.mRepeatingRequestImageReader.getHeight(), 256, 1);
            this.mCameraBurstSurface = this.mBurstCaptureImageReader.getSurface();
        }
    }

    private void finishPipelineInitialization() throws RemoteException {
        if (this.mClientRepeatingRequestSurface != null) {
            if (this.mPreviewProcessorType == 0) {
                this.mPreviewRequestUpdateProcessor.onOutputSurface(this.mClientRepeatingRequestSurface, CameraExtensionSessionImpl.nativeGetSurfaceFormat(this.mClientRepeatingRequestSurface));
                this.mRepeatingRequestImageWriter = ImageWriter.newInstance(this.mClientRepeatingRequestSurface, 3, 34);
            } else if (this.mPreviewProcessorType == 2) {
                this.mRepeatingRequestImageWriter = ImageWriter.newInstance(this.mClientRepeatingRequestSurface, 3, 34);
            }
        }
        if (this.mImageProcessor != null && this.mClientCaptureSurface != null) {
            CameraExtensionUtils.SurfaceInfo surfaceInfo = CameraExtensionUtils.querySurface(this.mClientCaptureSurface);
            this.mImageProcessor.onOutputSurface(this.mClientCaptureSurface, surfaceInfo.mFormat);
        }
    }

    public synchronized void initialize() throws CameraAccessException, RemoteException {
        if (this.mInitialized) {
            Log.d(TAG, "Session already initialized");
            return;
        }
        ArrayList<CaptureStageImpl> sessionParamsList = new ArrayList<CaptureStageImpl>();
        ArrayList<OutputConfiguration> outputList = new ArrayList<OutputConfiguration>();
        this.initializeRepeatingRequestPipeline();
        outputList.add(new OutputConfiguration(this.mCameraRepeatingSurface));
        CaptureStageImpl previewSessionParams = this.mPreviewExtender.onPresetSession();
        if (previewSessionParams != null) {
            sessionParamsList.add(previewSessionParams);
        }
        this.initializeBurstCapturePipeline();
        outputList.add(new OutputConfiguration(this.mCameraBurstSurface));
        CaptureStageImpl stillCaptureSessionParams = this.mImageExtender.onPresetSession();
        if (stillCaptureSessionParams != null) {
            sessionParamsList.add(stillCaptureSessionParams);
        }
        SessionConfiguration sessionConfig = new SessionConfiguration(0, outputList, new CameraExtensionUtils.HandlerExecutor(this.mHandler), new SessionStateHandler());
        if (!sessionParamsList.isEmpty()) {
            CaptureRequest sessionParamRequest = CameraExtensionSessionImpl.createRequest(this.mCameraDevice, sessionParamsList, null, 1);
            sessionConfig.setSessionParameters(sessionParamRequest);
        }
        this.mCameraDevice.createCaptureSession(sessionConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CameraDevice getDevice() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            return this.mCameraDevice;
        }
    }

    @Override
    public int setRepeatingRequest(CaptureRequest request, Executor executor, CameraExtensionSession.ExtensionCaptureCallback listener2) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (!this.mInitialized) {
                throw new IllegalStateException("Uninitialized component");
            }
            if (this.mClientRepeatingRequestSurface == null) {
                throw new IllegalArgumentException("No registered preview surface");
            }
            if (!request.containsTarget(this.mClientRepeatingRequestSurface) || request.getTargets().size() != 1) {
                throw new IllegalArgumentException("Invalid repeating request output target!");
            }
            this.mInternalRepeatingRequestEnabled = false;
            try {
                return this.setRepeatingRequest(this.mPreviewExtender.getCaptureStage(), new RepeatingRequestHandler(request, executor, listener2, this.mRepeatingRequestImageCallback));
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set repeating request! Extension service does not respond");
                throw new CameraAccessException(3);
            }
        }
    }

    private ArrayList<CaptureStageImpl> compileInitialRequestList() {
        ArrayList<CaptureStageImpl> captureStageList = new ArrayList<CaptureStageImpl>();
        try {
            CaptureStageImpl initialStillCaptureParams;
            CaptureStageImpl initialPreviewParams = this.mPreviewExtender.onEnableSession();
            if (initialPreviewParams != null) {
                captureStageList.add(initialPreviewParams);
            }
            if ((initialStillCaptureParams = this.mImageExtender.onEnableSession()) != null) {
                captureStageList.add(initialStillCaptureParams);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to initialize session parameters! Extension service does not respond!");
        }
        return captureStageList;
    }

    private static List<CaptureRequest> createBurstRequest(CameraDevice cameraDevice, List<CaptureStageImpl> captureStageList, CaptureRequest clientRequest, Surface target, int captureTemplate, Map<CaptureRequest, Integer> captureMap) {
        ArrayList<CaptureRequest> ret = new ArrayList<CaptureRequest>();
        for (CaptureStageImpl captureStage : captureStageList) {
            Byte jpegQuality;
            CaptureRequest.Builder requestBuilder;
            try {
                requestBuilder = cameraDevice.createCaptureRequest(captureTemplate);
            }
            catch (CameraAccessException e) {
                return null;
            }
            Integer jpegRotation = clientRequest.get(CaptureRequest.JPEG_ORIENTATION);
            if (jpegRotation != null) {
                captureStage.parameters.set(CaptureRequest.JPEG_ORIENTATION, jpegRotation);
            }
            if ((jpegQuality = clientRequest.get(CaptureRequest.JPEG_QUALITY)) != null) {
                captureStage.parameters.set(CaptureRequest.JPEG_QUALITY, jpegQuality);
            }
            requestBuilder.addTarget(target);
            CaptureRequest request = requestBuilder.build();
            CameraMetadataNative.update(request.getNativeMetadata(), captureStage.parameters);
            ret.add(request);
            captureMap.put(request, captureStage.id);
        }
        return ret;
    }

    private static CaptureRequest createRequest(CameraDevice cameraDevice, List<CaptureStageImpl> captureStageList, Surface target, int captureTemplate) throws CameraAccessException {
        CaptureRequest.Builder requestBuilder = cameraDevice.createCaptureRequest(captureTemplate);
        if (target != null) {
            requestBuilder.addTarget(target);
        }
        CaptureRequest ret = requestBuilder.build();
        for (CaptureStageImpl captureStage : captureStageList) {
            if (captureStage == null) continue;
            CameraMetadataNative.update(ret.getNativeMetadata(), captureStage.parameters);
        }
        return ret;
    }

    @Override
    public int capture(CaptureRequest request, Executor executor, CameraExtensionSession.ExtensionCaptureCallback listener2) throws CameraAccessException {
        List<CaptureRequest> burstRequest;
        if (!this.mInitialized) {
            throw new IllegalStateException("Uninitialized component");
        }
        if (this.mClientCaptureSurface == null) {
            throw new IllegalArgumentException("No output surface registered for single requests!");
        }
        if (!request.containsTarget(this.mClientCaptureSurface) || request.getTargets().size() != 1) {
            throw new IllegalArgumentException("Invalid single capture output target!");
        }
        HashMap<CaptureRequest, Integer> requestMap = new HashMap<CaptureRequest, Integer>();
        try {
            burstRequest = CameraExtensionSessionImpl.createBurstRequest(this.mCameraDevice, this.mImageExtender.getCaptureStages(), request, this.mCameraBurstSurface, 2, requestMap);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to initialize internal burst request! Extension service does not respond!");
            throw new CameraAccessException(3);
        }
        if (burstRequest == null) {
            throw new UnsupportedOperationException("Failed to create still capture burst request");
        }
        return this.mCaptureSession.captureBurstRequests(burstRequest, new CameraExtensionUtils.HandlerExecutor(this.mHandler), new BurstRequestHandler(request, executor, listener2, requestMap, this.mBurstCaptureImageCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRepeating() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (!this.mInitialized) {
                throw new IllegalStateException("Uninitialized component");
            }
            this.mInternalRepeatingRequestEnabled = true;
            this.mCaptureSession.stopRepeating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInitialized) {
                this.mInternalRepeatingRequestEnabled = false;
                this.mCaptureSession.stopRepeating();
                ArrayList<CaptureStageImpl> captureStageList = new ArrayList<CaptureStageImpl>();
                try {
                    CaptureStageImpl disableStillCaptureParams;
                    CaptureStageImpl disableParams = this.mPreviewExtender.onDisableSession();
                    if (disableParams != null) {
                        captureStageList.add(disableParams);
                    }
                    if ((disableStillCaptureParams = this.mImageExtender.onDisableSession()) != null) {
                        captureStageList.add(disableStillCaptureParams);
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Failed to disable extension! Extension service does not respond!");
                }
                if (!captureStageList.isEmpty()) {
                    CaptureRequest disableRequest = CameraExtensionSessionImpl.createRequest(this.mCameraDevice, captureStageList, this.mCameraRepeatingSurface, 1);
                    this.mCaptureSession.capture(disableRequest, new CloseRequestHandler(this.mRepeatingRequestImageCallback), this.mHandler);
                }
                this.mCaptureSession.close();
            }
        }
    }

    private void setInitialCaptureRequest(List<CaptureStageImpl> captureStageList, InitialRequestHandler requestHandler) throws CameraAccessException {
        CaptureRequest initialRequest = CameraExtensionSessionImpl.createRequest(this.mCameraDevice, captureStageList, this.mCameraRepeatingSurface, 1);
        this.mCaptureSession.capture(initialRequest, requestHandler, this.mHandler);
    }

    private int setRepeatingRequest(CaptureStageImpl captureStage, CameraCaptureSession.CaptureCallback requestHandler) throws CameraAccessException {
        ArrayList<CaptureStageImpl> captureStageList = new ArrayList<CaptureStageImpl>();
        captureStageList.add(captureStage);
        CaptureRequest repeatingRequest = CameraExtensionSessionImpl.createRequest(this.mCameraDevice, captureStageList, this.mCameraRepeatingSurface, 1);
        return this.mCaptureSession.setSingleRepeatingRequest(repeatingRequest, new CameraExtensionUtils.HandlerExecutor(this.mHandler), requestHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(boolean skipCloseNotification) {
        boolean notifyClose = false;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mInternalRepeatingRequestEnabled = false;
            this.mHandlerThread.quitSafely();
            try {
                this.mPreviewExtender.onDeInit();
                this.mImageExtender.onDeInit();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to release extensions! Extension service does not respond!");
            }
            if (this.mExtensionClientId >= 0L) {
                CameraExtensionCharacteristics.unregisterClient(this.mExtensionClientId);
                if (this.mInitialized) {
                    notifyClose = true;
                    CameraExtensionCharacteristics.releaseSession();
                }
            }
            this.mInitialized = false;
            if (this.mRepeatingRequestImageCallback != null) {
                this.mRepeatingRequestImageCallback.close();
                this.mRepeatingRequestImageCallback = null;
            }
            if (this.mRepeatingRequestImageReader != null) {
                this.mRepeatingRequestImageReader.close();
                this.mRepeatingRequestImageReader = null;
            }
            if (this.mBurstCaptureImageCallback != null) {
                this.mBurstCaptureImageCallback.close();
                this.mBurstCaptureImageCallback = null;
            }
            if (this.mBurstCaptureImageReader != null) {
                this.mBurstCaptureImageReader.close();
                this.mBurstCaptureImageReader = null;
            }
            if (this.mStubCaptureImageReader != null) {
                this.mStubCaptureImageReader.close();
                this.mStubCaptureImageReader = null;
            }
            if (this.mRepeatingRequestImageWriter != null) {
                this.mRepeatingRequestImageWriter.close();
                this.mRepeatingRequestImageWriter = null;
            }
            if (this.mPreviewImageProcessor != null) {
                this.mPreviewImageProcessor.close();
                this.mPreviewImageProcessor = null;
            }
            if (this.mImageJpegProcessor != null) {
                this.mImageJpegProcessor.close();
                this.mImageJpegProcessor = null;
            }
            this.mCaptureSession = null;
            this.mImageProcessor = null;
            this.mClientRepeatingRequestSurface = null;
            this.mCameraRepeatingSurface = null;
            this.mClientCaptureSurface = null;
            this.mCameraBurstSurface = null;
        }
        if (notifyClose && !skipCloseNotification) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallbacks.onClosed(this));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConfigurationFailure() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInitialized) {
                return;
            }
        }
        this.release(true);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(() -> this.mCallbacks.onConfigureFailed(this));
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConfigurationSuccess() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInitialized) {
                return;
            }
            this.mInitialized = true;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(() -> this.mCallbacks.onConfigured(this));
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private static Size findSmallestAspectMatchedSize(List<Size> sizes, Size arSize) {
        float TOLL = 0.01f;
        if (arSize.getHeight() == 0) {
            throw new IllegalArgumentException("Invalid input aspect ratio");
        }
        float targetAR = (float)arSize.getWidth() / (float)arSize.getHeight();
        Size ret = null;
        Size fallbackSize = null;
        for (Size sz : sizes) {
            float currentAR;
            if (fallbackSize == null) {
                fallbackSize = sz;
            }
            if (sz.getHeight() <= 0 || ret != null && ret.getWidth() * ret.getHeight() >= sz.getWidth() * sz.getHeight() || !(Math.abs((currentAR = (float)sz.getWidth() / (float)sz.getHeight()) - targetAR) <= 0.01f)) continue;
            ret = sz;
        }
        if (ret == null) {
            Log.e(TAG, "AR matched size not found returning first size in list");
            ret = fallbackSize;
        }
        return ret;
    }

    private static ParcelImage initializeParcelImage(Image img) {
        ParcelImage parcelImage = new ParcelImage();
        parcelImage.buffer = img.getHardwareBuffer();
        if (img.getFenceFd() >= 0) {
            try {
                parcelImage.fence = ParcelFileDescriptor.fromFd(img.getFenceFd());
            }
            catch (IOException e) {
                Log.e(TAG, "Failed to parcel buffer fence!");
            }
        }
        parcelImage.width = img.getWidth();
        parcelImage.height = img.getHeight();
        parcelImage.format = img.getFormat();
        parcelImage.timestamp = img.getTimestamp();
        parcelImage.transform = img.getTransform();
        parcelImage.scalingMode = img.getScalingMode();
        parcelImage.planeCount = img.getPlaneCount();
        parcelImage.crop = img.getCropRect();
        return parcelImage;
    }

    private static List<CaptureBundle> initializeParcelable(HashMap<Integer, Pair<Image, TotalCaptureResult>> captureMap, Integer jpegOrientation, Byte jpegQuality) {
        ArrayList<CaptureBundle> ret = new ArrayList<CaptureBundle>();
        for (Integer stagetId : captureMap.keySet()) {
            Pair<Image, TotalCaptureResult> entry = captureMap.get(stagetId);
            CaptureBundle bundle = new CaptureBundle();
            bundle.stage = stagetId;
            bundle.captureImage = CameraExtensionSessionImpl.initializeParcelImage((Image)entry.first);
            bundle.sequenceId = ((TotalCaptureResult)entry.second).getSequenceId();
            bundle.captureResult = ((TotalCaptureResult)entry.second).getNativeMetadata();
            if (jpegOrientation != null) {
                bundle.captureResult.set(CaptureResult.JPEG_ORIENTATION, jpegOrientation);
            }
            if (jpegQuality != null) {
                bundle.captureResult.set(CaptureResult.JPEG_QUALITY, jpegQuality);
            }
            ret.add(bundle);
        }
        return ret;
    }

    private class RepeatingRequestHandler
    extends CameraCaptureSession.CaptureCallback {
        private final Executor mExecutor;
        private final CameraExtensionSession.ExtensionCaptureCallback mCallbacks;
        private final CaptureRequest mClientRequest;
        private final boolean mClientNotificationsEnabled;
        private final CameraOutputImageCallback mRepeatingImageCallback;
        private OnImageAvailableListener mImageCallback = null;
        private LongSparseArray<Pair<Image, TotalCaptureResult>> mPendingResultMap = new LongSparseArray();
        private boolean mRequestUpdatedNeeded = false;

        public RepeatingRequestHandler(CaptureRequest clientRequest, Executor executor, CameraExtensionSession.ExtensionCaptureCallback listener2, CameraOutputImageCallback imageCallback) {
            this.mClientRequest = clientRequest;
            this.mExecutor = executor;
            this.mCallbacks = listener2;
            this.mClientNotificationsEnabled = this.mClientRequest != null && this.mExecutor != null && this.mCallbacks != null;
            this.mRepeatingImageCallback = imageCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            Object object = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                if (this.mImageCallback == null) {
                    if (CameraExtensionSessionImpl.this.mPreviewProcessorType == 1) {
                        if (this.mClientNotificationsEnabled) {
                            CameraExtensionSessionImpl.this.mPreviewImageProcessor.onOutputSurface(CameraExtensionSessionImpl.this.mClientRepeatingRequestSurface, CameraExtensionSessionImpl.nativeGetSurfaceFormat(CameraExtensionSessionImpl.this.mClientRepeatingRequestSurface));
                        } else {
                            CameraExtensionSessionImpl.this.mPreviewImageProcessor.onOutputSurface(null, -1);
                        }
                        this.mImageCallback = new ImageProcessCallback();
                    } else {
                        this.mImageCallback = this.mClientNotificationsEnabled ? new ImageForwardCallback(CameraExtensionSessionImpl.this.mRepeatingRequestImageWriter) : new ImageLoopbackCallback();
                    }
                }
            }
            if (this.mClientNotificationsEnabled) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallbacks.onCaptureStarted(CameraExtensionSessionImpl.this, this.mClientRequest, timestamp));
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            this.mRepeatingImageCallback.registerListener(timestamp, this.mImageCallback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureSequenceAborted(CameraCaptureSession session, int sequenceId) {
            Object object = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraExtensionSessionImpl.this.mInternalRepeatingRequestEnabled) {
                    this.resumeInternalRepeatingRequest(true);
                }
            }
            if (this.mClientNotificationsEnabled) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallbacks.onCaptureSequenceAborted(CameraExtensionSessionImpl.this, sequenceId));
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            } else {
                CameraExtensionSessionImpl.this.notifyConfigurationFailure();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureSequenceCompleted(CameraCaptureSession session, int sequenceId, long frameNumber) {
            Object object = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                if (this.mRequestUpdatedNeeded) {
                    this.mRequestUpdatedNeeded = false;
                    this.resumeInternalRepeatingRequest(false);
                } else if (CameraExtensionSessionImpl.this.mInternalRepeatingRequestEnabled) {
                    this.resumeInternalRepeatingRequest(true);
                }
            }
            if (this.mClientNotificationsEnabled) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallbacks.onCaptureSequenceCompleted(CameraExtensionSessionImpl.this, sequenceId));
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
            if (this.mClientNotificationsEnabled) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallbacks.onCaptureFailed(CameraExtensionSessionImpl.this, this.mClientRequest));
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            boolean notifyClient = this.mClientNotificationsEnabled;
            boolean processStatus = true;
            Object object = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                Long timestamp = result.get(CaptureResult.SENSOR_TIMESTAMP);
                if (timestamp != null) {
                    if (CameraExtensionSessionImpl.this.mPreviewProcessorType == 0) {
                        CaptureStageImpl captureStage = null;
                        try {
                            captureStage = CameraExtensionSessionImpl.this.mPreviewRequestUpdateProcessor.process(result.getNativeMetadata(), result.getSequenceId());
                        }
                        catch (RemoteException e) {
                            Log.e(CameraExtensionSessionImpl.TAG, "Extension service does not respond during processing!");
                        }
                        if (captureStage != null) {
                            try {
                                CameraExtensionSessionImpl.this.setRepeatingRequest(captureStage, this);
                                this.mRequestUpdatedNeeded = true;
                            }
                            catch (IllegalStateException e) {
                            }
                            catch (CameraAccessException e) {
                                Log.e(CameraExtensionSessionImpl.TAG, "Failed to update repeating request settings!");
                            }
                        } else {
                            this.mRequestUpdatedNeeded = false;
                        }
                    } else if (CameraExtensionSessionImpl.this.mPreviewProcessorType == 1) {
                        int idx = this.mPendingResultMap.indexOfKey(timestamp);
                        if (idx >= 0) {
                            ParcelImage parcelImage = CameraExtensionSessionImpl.initializeParcelImage((Image)this.mPendingResultMap.get((long)timestamp.longValue()).first);
                            try {
                                CameraExtensionSessionImpl.this.mPreviewImageProcessor.process(parcelImage, result);
                            }
                            catch (RemoteException e) {
                                processStatus = false;
                                Log.e(CameraExtensionSessionImpl.TAG, "Extension service does not respond during processing, dropping frame!");
                            }
                            catch (RuntimeException e) {
                                processStatus = false;
                                Log.e(CameraExtensionSessionImpl.TAG, "Runtime exception encountered during buffer processing, dropping frame!");
                            }
                            finally {
                                parcelImage.buffer.close();
                                ((Image)this.mPendingResultMap.get((long)timestamp.longValue()).first).close();
                            }
                            this.discardPendingRepeatingResults(idx, this.mPendingResultMap, false);
                        } else {
                            notifyClient = false;
                            this.mPendingResultMap.put(timestamp, new Pair<Object, TotalCaptureResult>(null, result));
                        }
                    }
                    if (notifyClient) {
                        long ident = Binder.clearCallingIdentity();
                        try {
                            if (processStatus) {
                                this.mExecutor.execute(() -> this.mCallbacks.onCaptureProcessStarted(CameraExtensionSessionImpl.this, this.mClientRequest));
                            }
                            this.mExecutor.execute(() -> this.mCallbacks.onCaptureFailed(CameraExtensionSessionImpl.this, this.mClientRequest));
                        }
                        finally {
                            Binder.restoreCallingIdentity(ident);
                        }
                    }
                } else {
                    Log.e(CameraExtensionSessionImpl.TAG, "Result without valid sensor timestamp!");
                }
            }
            if (!notifyClient) {
                CameraExtensionSessionImpl.this.notifyConfigurationSuccess();
            }
        }

        private void resumeInternalRepeatingRequest(boolean internal) {
            try {
                if (internal) {
                    CameraExtensionSessionImpl.this.setRepeatingRequest(CameraExtensionSessionImpl.this.mPreviewExtender.getCaptureStage(), new RepeatingRequestHandler(null, null, null, this.mRepeatingImageCallback));
                } else {
                    CameraExtensionSessionImpl.this.setRepeatingRequest(CameraExtensionSessionImpl.this.mPreviewExtender.getCaptureStage(), this);
                }
            }
            catch (RemoteException e) {
                Log.e(CameraExtensionSessionImpl.TAG, "Failed to resume internal repeating request, extension service fails to respond!");
            }
            catch (IllegalStateException e) {
                Log.w(CameraExtensionSessionImpl.TAG, "Failed to resume internal repeating request!");
            }
            catch (CameraAccessException e) {
                Log.e(CameraExtensionSessionImpl.TAG, "Failed to resume internal repeating request!");
            }
        }

        private Long calculatePruneThreshold(LongSparseArray<Pair<Image, TotalCaptureResult>> previewMap) {
            long oldestTimestamp = Long.MAX_VALUE;
            for (int idx = 0; idx < previewMap.size(); ++idx) {
                Pair<Image, TotalCaptureResult> entry = previewMap.valueAt(idx);
                long timestamp = previewMap.keyAt(idx);
                if (entry.first == null || timestamp >= oldestTimestamp) continue;
                oldestTimestamp = timestamp;
            }
            return oldestTimestamp == Long.MAX_VALUE ? 0L : oldestTimestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void discardPendingRepeatingResults(int idx, LongSparseArray<Pair<Image, TotalCaptureResult>> previewMap, boolean notifyCurrentIndex) {
            if (idx < 0) {
                return;
            }
            for (int i = idx; i >= 0; --i) {
                if (previewMap.valueAt((int)i).first != null) {
                    ((Image)previewMap.valueAt((int)i).first).close();
                } else if (this.mClientNotificationsEnabled && (i != idx || notifyCurrentIndex)) {
                    Log.w(CameraExtensionSessionImpl.TAG, "Preview frame drop with timestamp: " + previewMap.keyAt(i));
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.mExecutor.execute(() -> this.mCallbacks.onCaptureFailed(CameraExtensionSessionImpl.this, this.mClientRequest));
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                previewMap.removeAt(i);
            }
        }

        private class ImageProcessCallback
        implements OnImageAvailableListener {
            private ImageProcessCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImageAvailable(ImageReader reader, Image img) {
                if (RepeatingRequestHandler.this.mPendingResultMap.size() + 1 >= 3) {
                    RepeatingRequestHandler.this.discardPendingRepeatingResults(RepeatingRequestHandler.this.mPendingResultMap.indexOfKey(RepeatingRequestHandler.this.calculatePruneThreshold(RepeatingRequestHandler.this.mPendingResultMap)), RepeatingRequestHandler.this.mPendingResultMap, true);
                }
                if (img == null) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Invalid preview buffer!");
                    return;
                }
                try {
                    reader.detachImage(img);
                }
                catch (Exception e) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Failed to detach image!");
                    img.close();
                    return;
                }
                long timestamp = img.getTimestamp();
                int idx = RepeatingRequestHandler.this.mPendingResultMap.indexOfKey(timestamp);
                if (idx >= 0) {
                    boolean processStatus = true;
                    ParcelImage parcelImage = CameraExtensionSessionImpl.initializeParcelImage(img);
                    try {
                        CameraExtensionSessionImpl.this.mPreviewImageProcessor.process(parcelImage, (TotalCaptureResult)((Pair)((RepeatingRequestHandler)RepeatingRequestHandler.this).mPendingResultMap.get((long)timestamp)).second);
                    }
                    catch (RemoteException e) {
                        processStatus = false;
                        Log.e(CameraExtensionSessionImpl.TAG, "Extension service does not respond during processing, dropping frame!");
                    }
                    finally {
                        parcelImage.buffer.close();
                        img.close();
                    }
                    RepeatingRequestHandler.this.discardPendingRepeatingResults(idx, RepeatingRequestHandler.this.mPendingResultMap, false);
                    if (RepeatingRequestHandler.this.mClientNotificationsEnabled) {
                        long ident = Binder.clearCallingIdentity();
                        try {
                            if (processStatus) {
                                RepeatingRequestHandler.this.mExecutor.execute(() -> RepeatingRequestHandler.this.mCallbacks.onCaptureProcessStarted(CameraExtensionSessionImpl.this, RepeatingRequestHandler.this.mClientRequest));
                            }
                            RepeatingRequestHandler.this.mExecutor.execute(() -> RepeatingRequestHandler.this.mCallbacks.onCaptureFailed(CameraExtensionSessionImpl.this, RepeatingRequestHandler.this.mClientRequest));
                        }
                        finally {
                            Binder.restoreCallingIdentity(ident);
                        }
                    }
                } else {
                    RepeatingRequestHandler.this.mPendingResultMap.put(timestamp, new Pair<Image, Object>(img, null));
                }
            }
        }

        private class ImageForwardCallback
        implements OnImageAvailableListener {
            private final ImageWriter mOutputWriter;

            public ImageForwardCallback(ImageWriter imageWriter) {
                this.mOutputWriter = imageWriter;
            }

            @Override
            public void onImageAvailable(ImageReader reader, Image img) {
                if (img == null) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Invalid image!");
                    return;
                }
                try {
                    this.mOutputWriter.queueInputImage(img);
                }
                catch (IllegalStateException e) {
                    Log.w(CameraExtensionSessionImpl.TAG, "Output surface likely abandoned, dropping buffer!");
                    img.close();
                }
            }
        }
    }

    private class CloseRequestHandler
    extends CameraCaptureSession.CaptureCallback {
        private final CameraOutputImageCallback mImageCallback;

        public CloseRequestHandler(CameraOutputImageCallback imageCallback) {
            this.mImageCallback = imageCallback;
        }

        @Override
        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            this.mImageCallback.registerListener(timestamp, new ImageLoopbackCallback());
        }
    }

    private class CameraOutputImageCallback
    implements ImageReader.OnImageAvailableListener,
    Closeable {
        private final ImageReader mImageReader;
        private HashMap<Long, Pair<Image, OnImageAvailableListener>> mImageListenerMap = new HashMap();
        private boolean mOutOfBuffers = false;

        CameraOutputImageCallback(ImageReader imageReader) {
            this.mImageReader = imageReader;
        }

        @Override
        public void onImageAvailable(ImageReader reader) {
            Image img;
            try {
                img = reader.acquireNextImage();
            }
            catch (IllegalStateException e) {
                Log.e(CameraExtensionSessionImpl.TAG, "Failed to acquire image, too many images pending!");
                this.mOutOfBuffers = true;
                return;
            }
            if (img == null) {
                Log.e(CameraExtensionSessionImpl.TAG, "Invalid image!");
                return;
            }
            Long timestamp = img.getTimestamp();
            if (this.mImageListenerMap.containsKey(timestamp)) {
                Pair<Image, OnImageAvailableListener> entry = this.mImageListenerMap.remove(timestamp);
                if (entry.second != null) {
                    ((OnImageAvailableListener)entry.second).onImageAvailable(reader, img);
                } else {
                    Log.w(CameraExtensionSessionImpl.TAG, "Invalid image listener, dropping frame!");
                    img.close();
                }
            } else {
                this.mImageListenerMap.put(img.getTimestamp(), new Pair<Image, Object>(img, null));
            }
        }

        public void registerListener(Long timestamp, OnImageAvailableListener listener2) {
            if (this.mImageListenerMap.containsKey(timestamp)) {
                Pair<Image, OnImageAvailableListener> entry = this.mImageListenerMap.remove(timestamp);
                if (entry.first != null) {
                    listener2.onImageAvailable(this.mImageReader, (Image)entry.first);
                    if (this.mOutOfBuffers) {
                        this.mOutOfBuffers = false;
                        Log.w(CameraExtensionSessionImpl.TAG, "Out of buffers, retry!");
                        this.onImageAvailable(this.mImageReader);
                    }
                } else {
                    Log.w(CameraExtensionSessionImpl.TAG, "No valid image for listener with ts: " + timestamp);
                }
            } else {
                this.mImageListenerMap.put(timestamp, new Pair<Object, OnImageAvailableListener>(null, listener2));
            }
        }

        @Override
        public void close() {
            for (Pair<Image, OnImageAvailableListener> entry : this.mImageListenerMap.values()) {
                if (entry.first == null) continue;
                ((Image)entry.first).close();
            }
            this.mImageListenerMap.clear();
        }
    }

    private static interface OnImageAvailableListener {
        public void onImageAvailable(ImageReader var1, Image var2);
    }

    private class InitialRequestHandler
    extends CameraCaptureSession.CaptureCallback {
        private final CameraOutputImageCallback mImageCallback;

        public InitialRequestHandler(CameraOutputImageCallback imageCallback) {
            this.mImageCallback = imageCallback;
        }

        @Override
        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            this.mImageCallback.registerListener(timestamp, new ImageLoopbackCallback());
        }

        @Override
        public void onCaptureSequenceAborted(CameraCaptureSession session, int sequenceId) {
            Log.e(CameraExtensionSessionImpl.TAG, "Initial capture request aborted!");
            CameraExtensionSessionImpl.this.notifyConfigurationFailure();
        }

        @Override
        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
            Log.e(CameraExtensionSessionImpl.TAG, "Initial capture request failed!");
            CameraExtensionSessionImpl.this.notifyConfigurationFailure();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureSequenceCompleted(CameraCaptureSession session, int sequenceId, long frameNumber) {
            boolean status = true;
            Object object = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                try {
                    CameraExtensionSessionImpl.this.setRepeatingRequest(CameraExtensionSessionImpl.this.mPreviewExtender.getCaptureStage(), new RepeatingRequestHandler(null, null, null, this.mImageCallback));
                }
                catch (CameraAccessException | RemoteException e) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Failed to start the internal repeating request!");
                    status = false;
                }
            }
            if (!status) {
                CameraExtensionSessionImpl.this.notifyConfigurationFailure();
            }
        }
    }

    private class ImageLoopbackCallback
    implements OnImageAvailableListener {
        private ImageLoopbackCallback() {
        }

        @Override
        public void onImageAvailable(ImageReader reader, Image img) {
            img.close();
        }
    }

    private class BurstRequestHandler
    extends CameraCaptureSession.CaptureCallback {
        private final Executor mExecutor;
        private final CameraExtensionSession.ExtensionCaptureCallback mCallbacks;
        private final CaptureRequest mClientRequest;
        private final HashMap<CaptureRequest, Integer> mCaptureRequestMap;
        private final CameraOutputImageCallback mBurstImageCallback;
        private HashMap<Integer, Pair<Image, TotalCaptureResult>> mCaptureStageMap = new HashMap();
        private LongSparseArray<Pair<Image, Integer>> mCapturePendingMap = new LongSparseArray();
        private ImageCallback mImageCallback = null;
        private boolean mCaptureFailed = false;

        public BurstRequestHandler(CaptureRequest request, Executor executor, CameraExtensionSession.ExtensionCaptureCallback callbacks, HashMap<CaptureRequest, Integer> requestMap, CameraOutputImageCallback imageCallback) {
            this.mClientRequest = request;
            this.mExecutor = executor;
            this.mCallbacks = callbacks;
            this.mCaptureRequestMap = requestMap;
            this.mBurstImageCallback = imageCallback;
        }

        private void notifyCaptureFailed() {
            if (!this.mCaptureFailed) {
                this.mCaptureFailed = true;
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallbacks.onCaptureFailed(CameraExtensionSessionImpl.this, this.mClientRequest));
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
                for (Pair<Image, TotalCaptureResult> captureStage : this.mCaptureStageMap.values()) {
                    ((Image)captureStage.first).close();
                }
                this.mCaptureStageMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            boolean initialCallback = false;
            Object object = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraExtensionSessionImpl.this.mImageProcessor != null && this.mImageCallback == null) {
                    this.mImageCallback = new ImageCallback();
                    initialCallback = true;
                } else if (CameraExtensionSessionImpl.this.mImageProcessor == null) {
                    initialCallback = true;
                }
            }
            if (initialCallback) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallbacks.onCaptureStarted(CameraExtensionSessionImpl.this, this.mClientRequest, timestamp));
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            if (this.mBurstImageCallback != null && this.mImageCallback != null) {
                this.mBurstImageCallback.registerListener(timestamp, this.mImageCallback);
            }
        }

        @Override
        public void onCaptureBufferLost(CameraCaptureSession session, CaptureRequest request, Surface target, long frameNumber) {
            this.notifyCaptureFailed();
        }

        @Override
        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
            this.notifyCaptureFailed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureSequenceAborted(CameraCaptureSession session, int sequenceId) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallbacks.onCaptureSequenceAborted(CameraExtensionSessionImpl.this, sequenceId));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureSequenceCompleted(CameraCaptureSession session, int sequenceId, long frameNumber) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallbacks.onCaptureSequenceCompleted(CameraExtensionSessionImpl.this, sequenceId));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            if (!this.mCaptureRequestMap.containsKey(request)) {
                Log.e(CameraExtensionSessionImpl.TAG, "Unexpected still capture request received!");
                return;
            }
            Integer stageId = this.mCaptureRequestMap.get(request);
            Long timestamp = result.get(CaptureResult.SENSOR_TIMESTAMP);
            if (timestamp != null) {
                if (CameraExtensionSessionImpl.this.mImageProcessor != null) {
                    if (this.mCapturePendingMap.indexOfKey(timestamp) >= 0) {
                        Image img = (Image)this.mCapturePendingMap.get((long)timestamp.longValue()).first;
                        this.mCaptureStageMap.put(stageId, new Pair<Image, TotalCaptureResult>(img, result));
                        this.checkAndFireBurstProcessing();
                    } else {
                        this.mCapturePendingMap.put(timestamp, new Pair<Object, Integer>(null, stageId));
                        this.mCaptureStageMap.put(stageId, new Pair<Object, TotalCaptureResult>(null, result));
                    }
                } else {
                    this.mCaptureRequestMap.clear();
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.mExecutor.execute(() -> this.mCallbacks.onCaptureProcessStarted(CameraExtensionSessionImpl.this, this.mClientRequest));
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
            } else {
                Log.e(CameraExtensionSessionImpl.TAG, "Capture result without valid sensor timestamp!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkAndFireBurstProcessing() {
            if (this.mCaptureRequestMap.size() == this.mCaptureStageMap.size()) {
                for (Pair<Image, TotalCaptureResult> captureStage : this.mCaptureStageMap.values()) {
                    if (captureStage.first != null && captureStage.second != null) continue;
                    return;
                }
                this.mCaptureRequestMap.clear();
                this.mCapturePendingMap.clear();
                boolean processStatus = true;
                Byte jpegQuality = this.mClientRequest.get(CaptureRequest.JPEG_QUALITY);
                Integer jpegOrientation = this.mClientRequest.get(CaptureRequest.JPEG_ORIENTATION);
                List captureList = CameraExtensionSessionImpl.initializeParcelable(this.mCaptureStageMap, jpegOrientation, jpegQuality);
                try {
                    CameraExtensionSessionImpl.this.mImageProcessor.process(captureList);
                }
                catch (RemoteException e) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Failed to process multi-frame request! Extension service does not respond!");
                    processStatus = false;
                }
                for (CaptureBundle captureBundle : captureList) {
                    captureBundle.captureImage.buffer.close();
                }
                captureList.clear();
                for (Pair pair : this.mCaptureStageMap.values()) {
                    ((Image)pair.first).close();
                }
                this.mCaptureStageMap.clear();
                long ident = Binder.clearCallingIdentity();
                try {
                    if (processStatus) {
                        this.mExecutor.execute(() -> this.mCallbacks.onCaptureProcessStarted(CameraExtensionSessionImpl.this, this.mClientRequest));
                    } else {
                        this.mExecutor.execute(() -> this.mCallbacks.onCaptureFailed(CameraExtensionSessionImpl.this, this.mClientRequest));
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }

        private class ImageCallback
        implements OnImageAvailableListener {
            private ImageCallback() {
            }

            @Override
            public void onImageAvailable(ImageReader reader, Image img) {
                if (BurstRequestHandler.this.mCaptureFailed) {
                    img.close();
                }
                long timestamp = img.getTimestamp();
                reader.detachImage(img);
                if (BurstRequestHandler.this.mCapturePendingMap.indexOfKey(timestamp) >= 0) {
                    Integer stageId = (Integer)((Pair)((BurstRequestHandler)BurstRequestHandler.this).mCapturePendingMap.get((long)timestamp)).second;
                    Pair captureStage = (Pair)BurstRequestHandler.this.mCaptureStageMap.get(stageId);
                    if (captureStage != null) {
                        BurstRequestHandler.this.mCaptureStageMap.put(stageId, new Pair<Image, TotalCaptureResult>(img, (TotalCaptureResult)captureStage.second));
                        BurstRequestHandler.this.checkAndFireBurstProcessing();
                    } else {
                        Log.e(CameraExtensionSessionImpl.TAG, "Capture stage: " + ((Pair)((BurstRequestHandler)BurstRequestHandler.this).mCapturePendingMap.get((long)timestamp)).second + " is absent!");
                    }
                } else {
                    BurstRequestHandler.this.mCapturePendingMap.put(timestamp, new Pair<Image, Integer>(img, -1));
                }
            }
        }
    }

    private class InitializeSessionHandler
    extends IInitializeSessionCallback.Stub {
        private InitializeSessionHandler() {
        }

        @Override
        public void onSuccess() {
            boolean status = true;
            ArrayList initialRequestList = CameraExtensionSessionImpl.this.compileInitialRequestList();
            if (!initialRequestList.isEmpty()) {
                try {
                    CameraExtensionSessionImpl.this.setInitialCaptureRequest(initialRequestList, new InitialRequestHandler(CameraExtensionSessionImpl.this.mRepeatingRequestImageCallback));
                }
                catch (CameraAccessException e) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Failed to initialize the initial capture request!");
                    status = false;
                }
            } else {
                try {
                    CameraExtensionSessionImpl.this.setRepeatingRequest(CameraExtensionSessionImpl.this.mPreviewExtender.getCaptureStage(), new RepeatingRequestHandler(null, null, null, CameraExtensionSessionImpl.this.mRepeatingRequestImageCallback));
                }
                catch (CameraAccessException | RemoteException e) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Failed to initialize internal repeating request!");
                    status = false;
                }
            }
            if (!status) {
                CameraExtensionSessionImpl.this.notifyConfigurationFailure();
            }
        }

        @Override
        public void onFailure() {
            CameraExtensionSessionImpl.this.mCaptureSession.close();
            Log.e(CameraExtensionSessionImpl.TAG, "Failed to initialize proxy service session! This can happen when trying to configure multiple concurrent extension sessions!");
            CameraExtensionSessionImpl.this.notifyConfigurationFailure();
        }
    }

    private class SessionStateHandler
    extends CameraCaptureSession.StateCallback {
        private SessionStateHandler() {
        }

        @Override
        public void onClosed(CameraCaptureSession session) {
            CameraExtensionSessionImpl.this.release(false);
        }

        @Override
        public void onConfigureFailed(CameraCaptureSession session) {
            CameraExtensionSessionImpl.this.notifyConfigurationFailure();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConfigured(CameraCaptureSession session) {
            Object object = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                CameraExtensionSessionImpl.this.mCaptureSession = session;
                try {
                    CameraExtensionSessionImpl.this.finishPipelineInitialization();
                    CameraExtensionCharacteristics.initializeSession(CameraExtensionSessionImpl.this.mInitializeHandler);
                }
                catch (RemoteException e) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Failed to initialize session! Extension service does not respond!");
                    CameraExtensionSessionImpl.this.notifyConfigurationFailure();
                }
            }
        }
    }
}

