/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.extension.IImageProcessorImpl;
import android.hardware.camera2.extension.IRequestCallback;
import android.hardware.camera2.extension.OutputConfigId;
import android.hardware.camera2.extension.Request;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IRequestProcessorImpl
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.IRequestProcessorImpl";

    public void setImageProcessor(OutputConfigId var1, IImageProcessorImpl var2) throws RemoteException;

    public int submit(Request var1, IRequestCallback var2) throws RemoteException;

    public int submitBurst(List<Request> var1, IRequestCallback var2) throws RemoteException;

    public int setRepeating(Request var1, IRequestCallback var2) throws RemoteException;

    public void abortCaptures() throws RemoteException;

    public void stopRepeating() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRequestProcessorImpl {
        static final int TRANSACTION_setImageProcessor = 1;
        static final int TRANSACTION_submit = 2;
        static final int TRANSACTION_submitBurst = 3;
        static final int TRANSACTION_setRepeating = 4;
        static final int TRANSACTION_abortCaptures = 5;
        static final int TRANSACTION_stopRepeating = 6;

        public Stub() {
            this.attachInterface(this, IRequestProcessorImpl.DESCRIPTOR);
        }

        public static IRequestProcessorImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRequestProcessorImpl.DESCRIPTOR);
            if (iin != null && iin instanceof IRequestProcessorImpl) {
                return (IRequestProcessorImpl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setImageProcessor";
                }
                case 2: {
                    return "submit";
                }
                case 3: {
                    return "submitBurst";
                }
                case 4: {
                    return "setRepeating";
                }
                case 5: {
                    return "abortCaptures";
                }
                case 6: {
                    return "stopRepeating";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRequestProcessorImpl.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    OutputConfigId _arg0 = 0 != data.readInt() ? OutputConfigId.CREATOR.createFromParcel(data) : null;
                    IImageProcessorImpl _arg1 = IImageProcessorImpl.Stub.asInterface(data.readStrongBinder());
                    this.setImageProcessor(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    Request _arg0 = 0 != data.readInt() ? Request.CREATOR.createFromParcel(data) : null;
                    IRequestCallback _arg1 = IRequestCallback.Stub.asInterface(data.readStrongBinder());
                    int _result = this.submit(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    ArrayList<Request> _arg0 = data.createTypedArrayList(Request.CREATOR);
                    IRequestCallback _arg1 = IRequestCallback.Stub.asInterface(data.readStrongBinder());
                    int _result = this.submitBurst(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    Request _arg0 = 0 != data.readInt() ? Request.CREATOR.createFromParcel(data) : null;
                    IRequestCallback _arg1 = IRequestCallback.Stub.asInterface(data.readStrongBinder());
                    int _result = this.setRepeating(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.abortCaptures();
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    this.stopRepeating();
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IRequestProcessorImpl impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IRequestProcessorImpl getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IRequestProcessorImpl {
            private IBinder mRemote;
            public static IRequestProcessorImpl sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRequestProcessorImpl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImageProcessor(OutputConfigId outputConfigId, IImageProcessorImpl imageProcessor) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestProcessorImpl.DESCRIPTOR);
                    if (outputConfigId != null) {
                        _data.writeInt(1);
                        outputConfigId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(imageProcessor != null ? imageProcessor.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setImageProcessor(outputConfigId, imageProcessor);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int submit(Request request, IRequestCallback callback2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestProcessorImpl.DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().submit(request, callback2);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int submitBurst(List<Request> requests, IRequestCallback callback2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestProcessorImpl.DESCRIPTOR);
                    _data.writeTypedList(requests);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().submitBurst(requests, callback2);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setRepeating(Request request, IRequestCallback callback2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestProcessorImpl.DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().setRepeating(request, callback2);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abortCaptures() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestProcessorImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().abortCaptures();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopRepeating() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestProcessorImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopRepeating();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRequestProcessorImpl {
        @Override
        public void setImageProcessor(OutputConfigId outputConfigId, IImageProcessorImpl imageProcessor) throws RemoteException {
        }

        @Override
        public int submit(Request request, IRequestCallback callback2) throws RemoteException {
            return 0;
        }

        @Override
        public int submitBurst(List<Request> requests, IRequestCallback callback2) throws RemoteException {
            return 0;
        }

        @Override
        public int setRepeating(Request request, IRequestCallback callback2) throws RemoteException {
            return 0;
        }

        @Override
        public void abortCaptures() throws RemoteException {
        }

        @Override
        public void stopRepeating() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

