/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.extension.CaptureFailure;
import android.hardware.camera2.extension.ParcelCaptureResult;
import android.hardware.camera2.extension.ParcelTotalCaptureResult;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IRequestCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.IRequestCallback";

    public void onCaptureStarted(int var1, long var2, long var4) throws RemoteException;

    public void onCaptureProgressed(int var1, ParcelCaptureResult var2) throws RemoteException;

    public void onCaptureCompleted(int var1, ParcelTotalCaptureResult var2) throws RemoteException;

    public void onCaptureFailed(int var1, CaptureFailure var2) throws RemoteException;

    public void onCaptureBufferLost(int var1, long var2, int var4) throws RemoteException;

    public void onCaptureSequenceCompleted(int var1, long var2) throws RemoteException;

    public void onCaptureSequenceAborted(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRequestCallback {
        static final int TRANSACTION_onCaptureStarted = 1;
        static final int TRANSACTION_onCaptureProgressed = 2;
        static final int TRANSACTION_onCaptureCompleted = 3;
        static final int TRANSACTION_onCaptureFailed = 4;
        static final int TRANSACTION_onCaptureBufferLost = 5;
        static final int TRANSACTION_onCaptureSequenceCompleted = 6;
        static final int TRANSACTION_onCaptureSequenceAborted = 7;

        public Stub() {
            this.attachInterface(this, IRequestCallback.DESCRIPTOR);
        }

        public static IRequestCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRequestCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IRequestCallback) {
                return (IRequestCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCaptureStarted";
                }
                case 2: {
                    return "onCaptureProgressed";
                }
                case 3: {
                    return "onCaptureCompleted";
                }
                case 4: {
                    return "onCaptureFailed";
                }
                case 5: {
                    return "onCaptureBufferLost";
                }
                case 6: {
                    return "onCaptureSequenceCompleted";
                }
                case 7: {
                    return "onCaptureSequenceAborted";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRequestCallback.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    this.onCaptureStarted(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ParcelCaptureResult _arg1 = 0 != data.readInt() ? ParcelCaptureResult.CREATOR.createFromParcel(data) : null;
                    this.onCaptureProgressed(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ParcelTotalCaptureResult _arg1 = 0 != data.readInt() ? ParcelTotalCaptureResult.CREATOR.createFromParcel(data) : null;
                    this.onCaptureCompleted(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    CaptureFailure _arg1 = 0 != data.readInt() ? CaptureFailure.CREATOR.createFromParcel(data) : null;
                    this.onCaptureFailed(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    this.onCaptureBufferLost(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    this.onCaptureSequenceCompleted(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onCaptureSequenceAborted(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IRequestCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IRequestCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IRequestCallback {
            private IBinder mRemote;
            public static IRequestCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRequestCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureStarted(int requestId, long frameNumber, long timestamp) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeLong(frameNumber);
                    _data.writeLong(timestamp);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCaptureStarted(requestId, frameNumber, timestamp);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureProgressed(int requestId, ParcelCaptureResult partialResult) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    if (partialResult != null) {
                        _data.writeInt(1);
                        partialResult.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCaptureProgressed(requestId, partialResult);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureCompleted(int requestId, ParcelTotalCaptureResult totalCaptureResult) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    if (totalCaptureResult != null) {
                        _data.writeInt(1);
                        totalCaptureResult.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCaptureCompleted(requestId, totalCaptureResult);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureFailed(int requestId, CaptureFailure captureFailure) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    if (captureFailure != null) {
                        _data.writeInt(1);
                        captureFailure.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCaptureFailed(requestId, captureFailure);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureBufferLost(int requestId, long frameNumber, int outputStreamId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeLong(frameNumber);
                    _data.writeInt(outputStreamId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCaptureBufferLost(requestId, frameNumber, outputStreamId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureSequenceCompleted(int sequenceId, long frameNumber) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(sequenceId);
                    _data.writeLong(frameNumber);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCaptureSequenceCompleted(sequenceId, frameNumber);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureSequenceAborted(int sequenceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(sequenceId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCaptureSequenceAborted(sequenceId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRequestCallback {
        @Override
        public void onCaptureStarted(int requestId, long frameNumber, long timestamp) throws RemoteException {
        }

        @Override
        public void onCaptureProgressed(int requestId, ParcelCaptureResult partialResult) throws RemoteException {
        }

        @Override
        public void onCaptureCompleted(int requestId, ParcelTotalCaptureResult totalCaptureResult) throws RemoteException {
        }

        @Override
        public void onCaptureFailed(int requestId, CaptureFailure captureFailure) throws RemoteException {
        }

        @Override
        public void onCaptureBufferLost(int requestId, long frameNumber, int outputStreamId) throws RemoteException {
        }

        @Override
        public void onCaptureSequenceCompleted(int sequenceId, long frameNumber) throws RemoteException {
        }

        @Override
        public void onCaptureSequenceAborted(int sequenceId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

