/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.extension.OutputConfigId;
import android.hardware.camera2.extension.ParcelImage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IImageProcessorImpl
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.IImageProcessorImpl";

    public void onNextImageAvailable(OutputConfigId var1, ParcelImage var2, String var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImageProcessorImpl {
        static final int TRANSACTION_onNextImageAvailable = 1;

        public Stub() {
            this.attachInterface(this, IImageProcessorImpl.DESCRIPTOR);
        }

        public static IImageProcessorImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IImageProcessorImpl.DESCRIPTOR);
            if (iin != null && iin instanceof IImageProcessorImpl) {
                return (IImageProcessorImpl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onNextImageAvailable";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IImageProcessorImpl.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    OutputConfigId _arg0 = 0 != data.readInt() ? OutputConfigId.CREATOR.createFromParcel(data) : null;
                    ParcelImage _arg1 = 0 != data.readInt() ? ParcelImage.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    this.onNextImageAvailable(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IImageProcessorImpl impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IImageProcessorImpl getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IImageProcessorImpl {
            private IBinder mRemote;
            public static IImageProcessorImpl sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IImageProcessorImpl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNextImageAvailable(OutputConfigId outputConfigId, ParcelImage image, String physicalCameraId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageProcessorImpl.DESCRIPTOR);
                    if (outputConfigId != null) {
                        _data.writeInt(1);
                        outputConfigId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (image != null) {
                        _data.writeInt(1);
                        image.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(physicalCameraId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNextImageAvailable(outputConfigId, image, physicalCameraId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImageProcessorImpl {
        @Override
        public void onNextImageAvailable(OutputConfigId outputConfigId, ParcelImage image, String physicalCameraId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

