/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import java.util.concurrent.Executor;

public abstract class CameraExtensionSession
implements AutoCloseable {
    public CameraDevice getDevice() {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public int capture(CaptureRequest request, Executor executor, ExtensionCaptureCallback listener2) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public int setRepeatingRequest(CaptureRequest request, Executor executor, ExtensionCaptureCallback listener2) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public void stopRepeating() throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    @Override
    public void close() throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public static abstract class StateCallback {
        public abstract void onConfigured(CameraExtensionSession var1);

        public abstract void onConfigureFailed(CameraExtensionSession var1);

        public void onClosed(CameraExtensionSession session) {
        }
    }

    public static abstract class ExtensionCaptureCallback {
        public void onCaptureStarted(CameraExtensionSession session, CaptureRequest request, long timestamp) {
        }

        public void onCaptureProcessStarted(CameraExtensionSession session, CaptureRequest request) {
        }

        public void onCaptureFailed(CameraExtensionSession session, CaptureRequest request) {
        }

        public void onCaptureSequenceCompleted(CameraExtensionSession session, int sequenceId) {
        }

        public void onCaptureSequenceAborted(CameraExtensionSession session, int sequenceId) {
        }
    }
}

