/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.security.identity.IdentityCredential;
import android.security.keystore2.AndroidKeyStoreProvider;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.Mac;

public class CryptoObject {
    private final Object mCrypto;

    public CryptoObject(Signature signature) {
        this.mCrypto = signature;
    }

    public CryptoObject(Cipher cipher) {
        this.mCrypto = cipher;
    }

    public CryptoObject(Mac mac) {
        this.mCrypto = mac;
    }

    public CryptoObject(IdentityCredential credential) {
        this.mCrypto = credential;
    }

    public Signature getSignature() {
        return this.mCrypto instanceof Signature ? (Signature)this.mCrypto : null;
    }

    public Cipher getCipher() {
        return this.mCrypto instanceof Cipher ? (Cipher)this.mCrypto : null;
    }

    public Mac getMac() {
        return this.mCrypto instanceof Mac ? (Mac)this.mCrypto : null;
    }

    public IdentityCredential getIdentityCredential() {
        return this.mCrypto instanceof IdentityCredential ? (IdentityCredential)this.mCrypto : null;
    }

    public long getOpId() {
        if (this.mCrypto == null) {
            return 0L;
        }
        if (this.mCrypto instanceof IdentityCredential) {
            return ((IdentityCredential)this.mCrypto).getCredstoreOperationHandle();
        }
        return AndroidKeyStoreProvider.getKeyStoreOperationHandle(this.mCrypto);
    }
}

