/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.annotation.RequiresPermission;
import android.content.Context;
import android.hardware.biometrics.ITestSession;
import android.hardware.biometrics.ITestSessionCallback;
import android.os.RemoteException;
import android.util.ArraySet;
import android.util.Log;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BiometricTestSession
implements AutoCloseable {
    private static final String BASE_TAG = "BiometricTestSession";
    private final Context mContext;
    private final int mSensorId;
    private final ITestSession mTestSession;
    private final ArraySet<Integer> mTestedUsers;
    private CountDownLatch mCloseLatch;
    private final ArraySet<Integer> mUsersCleaningUp;
    private final ITestSessionCallback mCallback = new ITestSessionCallback.Stub(){

        @Override
        public void onCleanupStarted(int userId) {
            Log.d(BiometricTestSession.this.getTag(), "onCleanupStarted, sensor: " + BiometricTestSession.this.mSensorId + ", userId: " + userId);
        }

        @Override
        public void onCleanupFinished(int userId) {
            Log.d(BiometricTestSession.this.getTag(), "onCleanupFinished, sensor: " + BiometricTestSession.this.mSensorId + ", userId: " + userId + ", remaining users: " + BiometricTestSession.this.mUsersCleaningUp.size());
            BiometricTestSession.this.mUsersCleaningUp.remove(userId);
            if (BiometricTestSession.this.mUsersCleaningUp.isEmpty() && BiometricTestSession.this.mCloseLatch != null) {
                BiometricTestSession.this.mCloseLatch.countDown();
            }
        }
    };

    public BiometricTestSession(Context context, int sensorId, TestSessionProvider testSessionProvider) throws RemoteException {
        this.mContext = context;
        this.mSensorId = sensorId;
        this.mTestSession = testSessionProvider.createTestSession(context, sensorId, this.mCallback);
        this.mTestedUsers = new ArraySet();
        this.mUsersCleaningUp = new ArraySet();
        this.setTestHalEnabled(true);
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    private void setTestHalEnabled(boolean enabled) {
        try {
            Log.w(this.getTag(), "setTestHalEnabled, sensor: " + this.mSensorId + " enabled: " + enabled);
            this.mTestSession.setTestHalEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void startEnroll(int userId) {
        try {
            this.mTestedUsers.add(userId);
            this.mTestSession.startEnroll(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void finishEnroll(int userId) {
        try {
            this.mTestedUsers.add(userId);
            this.mTestSession.finishEnroll(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void acceptAuthentication(int userId) {
        try {
            this.mTestSession.acceptAuthentication(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void rejectAuthentication(int userId) {
        try {
            this.mTestSession.rejectAuthentication(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void notifyAcquired(int userId, int acquireInfo) {
        try {
            this.mTestSession.notifyAcquired(userId, acquireInfo);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void notifyError(int userId, int errorCode) {
        try {
            this.mTestSession.notifyError(userId, errorCode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void cleanupInternalState(int userId) {
        try {
            if (this.mUsersCleaningUp.contains(userId)) {
                Log.w(this.getTag(), "Cleanup already in progress for user: " + userId);
            }
            this.mUsersCleaningUp.add(userId);
            this.mTestSession.cleanupInternalState(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void close() {
        Log.d(this.getTag(), "Close, mTestedUsers size; " + this.mTestedUsers.size());
        if (!this.mTestedUsers.isEmpty()) {
            this.mCloseLatch = new CountDownLatch(1);
            for (int user : this.mTestedUsers) {
                this.cleanupInternalState(user);
            }
            try {
                Log.d(this.getTag(), "Awaiting latch...");
                this.mCloseLatch.await(3L, TimeUnit.SECONDS);
                Log.d(this.getTag(), "Finished awaiting");
            }
            catch (InterruptedException e) {
                Log.e(this.getTag(), "Latch interrupted", e);
            }
        }
        if (!this.mUsersCleaningUp.isEmpty()) {
            Log.e(this.getTag(), "Cleanup not finished before shutdown - pending: " + this.mUsersCleaningUp.size());
        }
        this.setTestHalEnabled(false);
    }

    private String getTag() {
        return "BiometricTestSession_" + this.mSensorId;
    }

    public static interface TestSessionProvider {
        public ITestSession createTestSession(Context var1, int var2, ITestSessionCallback var3) throws RemoteException;
    }
}

