/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.hardware.ISensorPrivacyListener;
import android.hardware.ISensorPrivacyManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

public class SensorPrivacyManager {
    private static final String LOG_TAG = SensorPrivacyManager.class.getSimpleName();
    private IBinder token = new Binder();
    public static final String EXTRA_SENSOR = SensorPrivacyManager.class.getName() + ".extra.sensor";
    public static final String EXTRA_ALL_SENSORS = SensorPrivacyManager.class.getName() + ".extra.all_sensors";
    private final SparseArray<Boolean> mToggleSupportCache = new SparseArray();
    private static final Object sInstanceLock = new Object();
    @GuardedBy(value={"sInstanceLock"})
    private static SensorPrivacyManager sInstance;
    private final Context mContext;
    private final ISensorPrivacyManager mService;
    private final ArrayMap<OnAllSensorPrivacyChangedListener, ISensorPrivacyListener> mListeners;
    private final ArrayMap<Pair<OnSensorPrivacyChangedListener, Integer>, ISensorPrivacyListener> mIndividualListeners;

    private SensorPrivacyManager(Context context, ISensorPrivacyManager service) {
        this.mContext = context;
        this.mService = service;
        this.mListeners = new ArrayMap();
        this.mIndividualListeners = new ArrayMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SensorPrivacyManager getInstance(Context context) {
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance == null) {
                try {
                    IBinder b = ServiceManager.getServiceOrThrow("sensor_privacy");
                    ISensorPrivacyManager service = ISensorPrivacyManager.Stub.asInterface(b);
                    sInstance = new SensorPrivacyManager(context, service);
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            return sInstance;
        }
    }

    public boolean supportsSensorToggle(int sensor) {
        try {
            Boolean val = this.mToggleSupportCache.get(sensor);
            if (val == null) {
                val = this.mService.supportsSensorToggle(sensor);
                this.mToggleSupportCache.put(sensor, val);
            }
            return val;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void addSensorPrivacyListener(int sensor, OnSensorPrivacyChangedListener listener2) {
        this.addSensorPrivacyListener(sensor, this.mContext.getMainExecutor(), listener2);
    }

    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void addSensorPrivacyListener(int sensor, int userId, OnSensorPrivacyChangedListener listener2) {
        this.addSensorPrivacyListener(sensor, userId, this.mContext.getMainExecutor(), listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void addSensorPrivacyListener(final int sensor, final Executor executor, final OnSensorPrivacyChangedListener listener2) {
        Pair<OnSensorPrivacyChangedListener, Integer> key = new Pair<OnSensorPrivacyChangedListener, Integer>(listener2, sensor);
        ArrayMap<Pair<OnSensorPrivacyChangedListener, Integer>, ISensorPrivacyListener> arrayMap = this.mIndividualListeners;
        synchronized (arrayMap) {
            ISensorPrivacyListener iListener = this.mIndividualListeners.get(key);
            if (iListener == null) {
                iListener = new ISensorPrivacyListener.Stub(){

                    @Override
                    public void onSensorPrivacyChanged(boolean enabled) {
                        executor.execute(() -> listener2.onSensorPrivacyChanged(sensor, enabled));
                    }
                };
                this.mIndividualListeners.put(key, iListener);
            }
            try {
                this.mService.addUserGlobalIndividualSensorPrivacyListener(sensor, iListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void addSensorPrivacyListener(final int sensor, int userId, final Executor executor, final OnSensorPrivacyChangedListener listener2) {
        ArrayMap<Pair<OnSensorPrivacyChangedListener, Integer>, ISensorPrivacyListener> arrayMap = this.mIndividualListeners;
        synchronized (arrayMap) {
            ISensorPrivacyListener iListener = this.mIndividualListeners.get(listener2);
            if (iListener == null) {
                iListener = new ISensorPrivacyListener.Stub(){

                    @Override
                    public void onSensorPrivacyChanged(boolean enabled) {
                        executor.execute(() -> listener2.onSensorPrivacyChanged(sensor, enabled));
                    }
                };
                this.mIndividualListeners.put(new Pair<OnSensorPrivacyChangedListener, Integer>(listener2, sensor), iListener);
            }
            try {
                this.mService.addIndividualSensorPrivacyListener(userId, sensor, iListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void removeSensorPrivacyListener(int sensor, OnSensorPrivacyChangedListener listener2) {
        ArrayMap<OnAllSensorPrivacyChangedListener, ISensorPrivacyListener> arrayMap = this.mListeners;
        synchronized (arrayMap) {
            for (int i = 0; i < this.mIndividualListeners.size(); ++i) {
                Pair<OnSensorPrivacyChangedListener, Integer> pair = this.mIndividualListeners.keyAt(i);
                if ((Integer)pair.second != sensor || !((OnSensorPrivacyChangedListener)pair.first).equals(listener2)) continue;
                try {
                    this.mService.removeIndividualSensorPrivacyListener(sensor, this.mIndividualListeners.valueAt(i));
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                this.mIndividualListeners.removeAt(i--);
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public boolean isSensorPrivacyEnabled(int sensor) {
        return this.isSensorPrivacyEnabled(sensor, -2);
    }

    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public boolean isSensorPrivacyEnabled(int sensor, int userId) {
        try {
            return this.mService.isIndividualSensorPrivacyEnabled(userId, sensor);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void setSensorPrivacy(int source, int sensor, boolean enable) {
        this.setSensorPrivacy(source, sensor, enable, -2);
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void setSensorPrivacy(int source, int sensor, boolean enable, int userId) {
        try {
            this.mService.setIndividualSensorPrivacy(userId, source, sensor, enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void setSensorPrivacyForProfileGroup(int source, int sensor, boolean enable) {
        this.setSensorPrivacyForProfileGroup(source, sensor, enable, -2);
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void setSensorPrivacyForProfileGroup(int source, int sensor, boolean enable, int userId) {
        try {
            this.mService.setIndividualSensorPrivacyForProfileGroup(userId, source, sensor, enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void suppressSensorPrivacyReminders(int sensor, boolean suppress) {
        this.suppressSensorPrivacyReminders(sensor, suppress, -2);
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void suppressSensorPrivacyReminders(int sensor, boolean suppress, int userId) {
        try {
            this.mService.suppressIndividualSensorPrivacyReminders(userId, sensor, this.token, suppress);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void showSensorUseDialog(int sensor) {
        try {
            this.mService.showSensorUseDialog(sensor);
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Received exception while trying to show sensor use dialog", e);
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SENSOR_PRIVACY")
    public void setAllSensorPrivacy(boolean enable) {
        try {
            this.mService.setSensorPrivacy(enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void addAllSensorPrivacyListener(final OnAllSensorPrivacyChangedListener listener2) {
        ArrayMap<OnAllSensorPrivacyChangedListener, ISensorPrivacyListener> arrayMap = this.mListeners;
        synchronized (arrayMap) {
            ISensorPrivacyListener iListener = this.mListeners.get(listener2);
            if (iListener == null) {
                iListener = new ISensorPrivacyListener.Stub(){

                    @Override
                    public void onSensorPrivacyChanged(boolean enabled) {
                        listener2.onAllSensorPrivacyChanged(enabled);
                    }
                };
                this.mListeners.put(listener2, iListener);
            }
            try {
                this.mService.addSensorPrivacyListener(iListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public void removeAllSensorPrivacyListener(OnAllSensorPrivacyChangedListener listener2) {
        ArrayMap<OnAllSensorPrivacyChangedListener, ISensorPrivacyListener> arrayMap = this.mListeners;
        synchronized (arrayMap) {
            ISensorPrivacyListener iListener = this.mListeners.get(listener2);
            if (iListener != null) {
                this.mListeners.remove(iListener);
                try {
                    this.mService.removeSensorPrivacyListener(iListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    @RequiresPermission(value="android.permission.OBSERVE_SENSOR_PRIVACY")
    public boolean isAllSensorPrivacyEnabled() {
        try {
            return this.mService.isSensorPrivacyEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static interface OnAllSensorPrivacyChangedListener {
        public void onAllSensorPrivacyChanged(boolean var1);
    }

    @SystemApi
    public static interface OnSensorPrivacyChangedListener {
        public void onSensorPrivacyChanged(int var1, boolean var2);
    }

    public static class Sources {
        public static final int QS_TILE = 1;
        public static final int SETTINGS = 2;
        public static final int DIALOG = 3;
        public static final int SHELL = 4;
        public static final int OTHER = 5;

        private Sources() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Source {
        }
    }

    public static class Sensors {
        public static final int MICROPHONE = 1;
        public static final int CAMERA = 2;

        private Sensors() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Sensor {
        }
    }
}

