/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.hardware.ISensorPrivacyListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISensorPrivacyManager
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.ISensorPrivacyManager";

    public boolean supportsSensorToggle(int var1) throws RemoteException;

    public void addSensorPrivacyListener(ISensorPrivacyListener var1) throws RemoteException;

    public void addIndividualSensorPrivacyListener(int var1, int var2, ISensorPrivacyListener var3) throws RemoteException;

    public void removeSensorPrivacyListener(ISensorPrivacyListener var1) throws RemoteException;

    public void removeIndividualSensorPrivacyListener(int var1, ISensorPrivacyListener var2) throws RemoteException;

    public boolean isSensorPrivacyEnabled() throws RemoteException;

    public boolean isIndividualSensorPrivacyEnabled(int var1, int var2) throws RemoteException;

    public void setSensorPrivacy(boolean var1) throws RemoteException;

    public void setIndividualSensorPrivacy(int var1, int var2, int var3, boolean var4) throws RemoteException;

    public void setIndividualSensorPrivacyForProfileGroup(int var1, int var2, int var3, boolean var4) throws RemoteException;

    public void suppressIndividualSensorPrivacyReminders(int var1, int var2, IBinder var3, boolean var4) throws RemoteException;

    public void addUserGlobalIndividualSensorPrivacyListener(int var1, ISensorPrivacyListener var2) throws RemoteException;

    public void removeUserGlobalIndividualSensorPrivacyListener(int var1, ISensorPrivacyListener var2) throws RemoteException;

    public void showSensorUseDialog(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISensorPrivacyManager {
        static final int TRANSACTION_supportsSensorToggle = 1;
        static final int TRANSACTION_addSensorPrivacyListener = 2;
        static final int TRANSACTION_addIndividualSensorPrivacyListener = 3;
        static final int TRANSACTION_removeSensorPrivacyListener = 4;
        static final int TRANSACTION_removeIndividualSensorPrivacyListener = 5;
        static final int TRANSACTION_isSensorPrivacyEnabled = 6;
        static final int TRANSACTION_isIndividualSensorPrivacyEnabled = 7;
        static final int TRANSACTION_setSensorPrivacy = 8;
        static final int TRANSACTION_setIndividualSensorPrivacy = 9;
        static final int TRANSACTION_setIndividualSensorPrivacyForProfileGroup = 10;
        static final int TRANSACTION_suppressIndividualSensorPrivacyReminders = 11;
        static final int TRANSACTION_addUserGlobalIndividualSensorPrivacyListener = 12;
        static final int TRANSACTION_removeUserGlobalIndividualSensorPrivacyListener = 13;
        static final int TRANSACTION_showSensorUseDialog = 14;

        public Stub() {
            this.attachInterface(this, ISensorPrivacyManager.DESCRIPTOR);
        }

        public static ISensorPrivacyManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISensorPrivacyManager.DESCRIPTOR);
            if (iin != null && iin instanceof ISensorPrivacyManager) {
                return (ISensorPrivacyManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "supportsSensorToggle";
                }
                case 2: {
                    return "addSensorPrivacyListener";
                }
                case 3: {
                    return "addIndividualSensorPrivacyListener";
                }
                case 4: {
                    return "removeSensorPrivacyListener";
                }
                case 5: {
                    return "removeIndividualSensorPrivacyListener";
                }
                case 6: {
                    return "isSensorPrivacyEnabled";
                }
                case 7: {
                    return "isIndividualSensorPrivacyEnabled";
                }
                case 8: {
                    return "setSensorPrivacy";
                }
                case 9: {
                    return "setIndividualSensorPrivacy";
                }
                case 10: {
                    return "setIndividualSensorPrivacyForProfileGroup";
                }
                case 11: {
                    return "suppressIndividualSensorPrivacyReminders";
                }
                case 12: {
                    return "addUserGlobalIndividualSensorPrivacyListener";
                }
                case 13: {
                    return "removeUserGlobalIndividualSensorPrivacyListener";
                }
                case 14: {
                    return "showSensorUseDialog";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISensorPrivacyManager.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.supportsSensorToggle(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    ISensorPrivacyListener _arg0 = ISensorPrivacyListener.Stub.asInterface(data.readStrongBinder());
                    this.addSensorPrivacyListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ISensorPrivacyListener _arg2 = ISensorPrivacyListener.Stub.asInterface(data.readStrongBinder());
                    this.addIndividualSensorPrivacyListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    ISensorPrivacyListener _arg0 = ISensorPrivacyListener.Stub.asInterface(data.readStrongBinder());
                    this.removeSensorPrivacyListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ISensorPrivacyListener _arg1 = ISensorPrivacyListener.Stub.asInterface(data.readStrongBinder());
                    this.removeIndividualSensorPrivacyListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isSensorPrivacyEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _result = this.isIndividualSensorPrivacyEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setSensorPrivacy(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = 0 != data.readInt();
                    this.setIndividualSensorPrivacy(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = 0 != data.readInt();
                    this.setIndividualSensorPrivacyForProfileGroup(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IBinder _arg2 = data.readStrongBinder();
                    boolean _arg3 = 0 != data.readInt();
                    this.suppressIndividualSensorPrivacyReminders(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ISensorPrivacyListener _arg1 = ISensorPrivacyListener.Stub.asInterface(data.readStrongBinder());
                    this.addUserGlobalIndividualSensorPrivacyListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ISensorPrivacyListener _arg1 = ISensorPrivacyListener.Stub.asInterface(data.readStrongBinder());
                    this.removeUserGlobalIndividualSensorPrivacyListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.showSensorUseDialog(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ISensorPrivacyManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ISensorPrivacyManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ISensorPrivacyManager {
            private IBinder mRemote;
            public static ISensorPrivacyManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISensorPrivacyManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean supportsSensorToggle(int sensor) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(sensor);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().supportsSensorToggle(sensor);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSensorPrivacyListener(ISensorPrivacyListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeStrongBinder(listener2 != null ? listener2.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addSensorPrivacyListener(listener2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addIndividualSensorPrivacyListener(int userId, int sensor, ISensorPrivacyListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(sensor);
                    _data.writeStrongBinder(listener2 != null ? listener2.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addIndividualSensorPrivacyListener(userId, sensor, listener2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSensorPrivacyListener(ISensorPrivacyListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeStrongBinder(listener2 != null ? listener2.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeSensorPrivacyListener(listener2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeIndividualSensorPrivacyListener(int sensor, ISensorPrivacyListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(sensor);
                    _data.writeStrongBinder(listener2 != null ? listener2.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeIndividualSensorPrivacyListener(sensor, listener2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSensorPrivacyEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isSensorPrivacyEnabled();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isIndividualSensorPrivacyEnabled(int userId, int sensor) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(sensor);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isIndividualSensorPrivacyEnabled(userId, sensor);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSensorPrivacy(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSensorPrivacy(enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIndividualSensorPrivacy(int userId, int source, int sensor, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(source);
                    _data.writeInt(sensor);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setIndividualSensorPrivacy(userId, source, sensor, enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIndividualSensorPrivacyForProfileGroup(int userId, int source, int sensor, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(source);
                    _data.writeInt(sensor);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setIndividualSensorPrivacyForProfileGroup(userId, source, sensor, enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suppressIndividualSensorPrivacyReminders(int userId, int sensor, IBinder token, boolean suppress) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(sensor);
                    _data.writeStrongBinder(token);
                    _data.writeInt(suppress ? 1 : 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().suppressIndividualSensorPrivacyReminders(userId, sensor, token, suppress);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addUserGlobalIndividualSensorPrivacyListener(int sensor, ISensorPrivacyListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(sensor);
                    _data.writeStrongBinder(listener2 != null ? listener2.asBinder() : null);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addUserGlobalIndividualSensorPrivacyListener(sensor, listener2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeUserGlobalIndividualSensorPrivacyListener(int sensor, ISensorPrivacyListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(sensor);
                    _data.writeStrongBinder(listener2 != null ? listener2.asBinder() : null);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeUserGlobalIndividualSensorPrivacyListener(sensor, listener2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showSensorUseDialog(int sensor) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISensorPrivacyManager.DESCRIPTOR);
                    _data.writeInt(sensor);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showSensorUseDialog(sensor);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISensorPrivacyManager {
        @Override
        public boolean supportsSensorToggle(int sensor) throws RemoteException {
            return false;
        }

        @Override
        public void addSensorPrivacyListener(ISensorPrivacyListener listener2) throws RemoteException {
        }

        @Override
        public void addIndividualSensorPrivacyListener(int userId, int sensor, ISensorPrivacyListener listener2) throws RemoteException {
        }

        @Override
        public void removeSensorPrivacyListener(ISensorPrivacyListener listener2) throws RemoteException {
        }

        @Override
        public void removeIndividualSensorPrivacyListener(int sensor, ISensorPrivacyListener listener2) throws RemoteException {
        }

        @Override
        public boolean isSensorPrivacyEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean isIndividualSensorPrivacyEnabled(int userId, int sensor) throws RemoteException {
            return false;
        }

        @Override
        public void setSensorPrivacy(boolean enable) throws RemoteException {
        }

        @Override
        public void setIndividualSensorPrivacy(int userId, int source, int sensor, boolean enable) throws RemoteException {
        }

        @Override
        public void setIndividualSensorPrivacyForProfileGroup(int userId, int source, int sensor, boolean enable) throws RemoteException {
        }

        @Override
        public void suppressIndividualSensorPrivacyReminders(int userId, int sensor, IBinder token, boolean suppress) throws RemoteException {
        }

        @Override
        public void addUserGlobalIndividualSensorPrivacyListener(int sensor, ISensorPrivacyListener listener2) throws RemoteException {
        }

        @Override
        public void removeUserGlobalIndividualSensorPrivacyListener(int sensor, ISensorPrivacyListener listener2) throws RemoteException {
        }

        @Override
        public void showSensorUseDialog(int sensor) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

