/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.ValueAnimator;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleAnimationSession;
import android.graphics.drawable.RippleBackground;
import android.graphics.drawable.RippleForeground;
import android.graphics.drawable.RippleShader;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import com.android.internal.R;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RippleDrawable
extends LayerDrawable {
    private static final String TAG = "RippleDrawable";
    public static final int RADIUS_AUTO = -1;
    public static final int STYLE_SOLID = 0;
    public static final int STYLE_PATTERNED = 1;
    private static final int BACKGROUND_OPACITY_DURATION = 80;
    private static final int MASK_UNKNOWN = -1;
    private static final int MASK_NONE = 0;
    private static final int MASK_CONTENT = 1;
    private static final int MASK_EXPLICIT = 2;
    private static final int MAX_RIPPLES = 10;
    private static final LinearInterpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final int DEFAULT_EFFECT_COLOR = -1912602625;
    private static final boolean FORCE_PATTERNED_STYLE = true;
    private final Rect mTempRect = new Rect();
    private final Rect mHotspotBounds = new Rect();
    private final Rect mDrawingBounds = new Rect();
    private final Rect mDirtyBounds = new Rect();
    @UnsupportedAppUsage(trackingBug=175939224L)
    private RippleState mState;
    private Drawable mMask;
    private RippleBackground mBackground;
    private Bitmap mMaskBuffer;
    private BitmapShader mMaskShader;
    private Canvas mMaskCanvas;
    private Matrix mMaskMatrix;
    private PorterDuffColorFilter mMaskColorFilter;
    private PorterDuffColorFilter mFocusColorFilter;
    private boolean mHasValidMask;
    private RippleForeground mRipple;
    private boolean mRippleActive;
    private float mPendingX;
    private float mPendingY;
    private boolean mHasPending;
    private RippleForeground[] mExitingRipples;
    private int mExitingRipplesCount = 0;
    private Paint mRipplePaint;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mDensity;
    private boolean mOverrideBounds;
    private boolean mForceSoftware;
    private boolean mAddRipple = false;
    private float mTargetBackgroundOpacity;
    private ValueAnimator mBackgroundAnimation;
    private float mBackgroundOpacity;
    private boolean mRunBackgroundAnimation;
    private boolean mExitingAnimation;
    private ArrayList<RippleAnimationSession> mRunningAnimations = new ArrayList();

    RippleDrawable() {
        this(new RippleState(null, null, null), null);
    }

    public RippleDrawable(ColorStateList color2, Drawable content2, Drawable mask) {
        this(new RippleState(null, null, null), null);
        if (color2 == null) {
            throw new IllegalArgumentException("RippleDrawable requires a non-null color");
        }
        if (content2 != null) {
            this.addLayer(content2, null, 0, 0, 0, 0, 0);
        }
        if (mask != null) {
            this.addLayer(mask, null, 16908334, 0, 0, 0, 0);
        }
        this.setColor(color2);
        this.ensurePadding();
        this.refreshPadding();
        this.updateLocalState();
    }

    @Override
    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mRipple != null) {
            this.mRipple.end();
        }
        if (this.mBackground != null) {
            this.mBackground.jumpToFinal();
        }
        this.cancelExitingRipples();
        this.endPatternedAnimations();
    }

    private void endPatternedAnimations() {
        for (int i = 0; i < this.mRunningAnimations.size(); ++i) {
            RippleAnimationSession session = this.mRunningAnimations.get(i);
            session.end();
        }
        this.mRunningAnimations.clear();
    }

    private void cancelExitingRipples() {
        int count = this.mExitingRipplesCount;
        Object[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].end();
        }
        if (ripples != null) {
            Arrays.fill(ripples, 0, count, null);
        }
        this.mExitingRipplesCount = 0;
        this.invalidateSelf(false);
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        boolean enabled = false;
        boolean pressed = false;
        boolean focused = false;
        boolean hovered = false;
        for (int state : stateSet) {
            if (state == 16842910) {
                enabled = true;
                continue;
            }
            if (state == 16842908) {
                focused = true;
                continue;
            }
            if (state == 16842919) {
                pressed = true;
                continue;
            }
            if (state != 16843623) continue;
            hovered = true;
        }
        this.setRippleActive(enabled && pressed);
        this.setBackgroundActive(hovered, focused, pressed);
        return changed;
    }

    private void setRippleActive(boolean active) {
        if (this.mRippleActive != active) {
            this.mRippleActive = active;
            if (this.mState.mRippleStyle == 0) {
                if (active) {
                    this.tryRippleEnter();
                } else {
                    this.tryRippleExit();
                }
            } else if (active) {
                this.startPatternedAnimation();
            } else {
                this.exitPatternedAnimation();
            }
        }
    }

    private void setBackgroundActive(boolean hovered, boolean focused, boolean pressed) {
        if (this.mState.mRippleStyle == 0) {
            if (this.mBackground == null && (hovered || focused)) {
                this.mBackground = new RippleBackground(this, this.mHotspotBounds, this.isBounded());
                this.mBackground.setup(this.mState.mMaxRadius, this.mDensity);
            }
            if (this.mBackground != null) {
                this.mBackground.setState(focused, hovered, pressed);
            }
        } else if (focused || hovered) {
            if (!pressed) {
                this.enterPatternedBackgroundAnimation(focused, hovered);
            }
        } else {
            this.exitPatternedBackgroundAnimation();
        }
    }

    @Override
    protected void onBoundsChange(Rect bounds2) {
        super.onBoundsChange(bounds2);
        if (!this.mOverrideBounds) {
            this.mHotspotBounds.set(bounds2);
            this.onHotspotBoundsChanged();
        }
        int count = this.mExitingRipplesCount;
        RippleForeground[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].onBoundsChange();
        }
        if (this.mBackground != null) {
            this.mBackground.onBoundsChange();
        }
        if (this.mRipple != null) {
            this.mRipple.onBoundsChange();
        }
        this.invalidateSelf();
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (!visible) {
            this.clearHotspots();
        } else if (changed) {
            if (this.mRippleActive) {
                if (this.mState.mRippleStyle == 0) {
                    this.tryRippleEnter();
                } else {
                    this.invalidateSelf();
                }
            }
            this.jumpToCurrentState();
        }
        return changed;
    }

    @Override
    public boolean isProjected() {
        if (this.isBounded()) {
            return false;
        }
        int radius = this.mState.mMaxRadius;
        Rect drawableBounds = this.getBounds();
        Rect hotspotBounds = this.mHotspotBounds;
        return radius == -1 || radius > hotspotBounds.width() / 2 || radius > hotspotBounds.height() / 2 || !drawableBounds.equals(hotspotBounds) && !drawableBounds.contains(hotspotBounds);
    }

    private boolean isBounded() {
        return this.getNumberOfLayers() > 0;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return true;
    }

    public void setColor(ColorStateList color2) {
        if (color2 == null) {
            throw new IllegalArgumentException("color cannot be null");
        }
        this.mState.mColor = color2;
        this.invalidateSelf(false);
    }

    public void setEffectColor(ColorStateList color2) {
        if (color2 == null) {
            throw new IllegalArgumentException("color cannot be null");
        }
        this.mState.mEffectColor = color2;
        this.invalidateSelf(false);
    }

    public ColorStateList getEffectColor() {
        return this.mState.mEffectColor;
    }

    public void setRadius(int radius) {
        this.mState.mMaxRadius = radius;
        this.invalidateSelf(false);
    }

    public int getRadius() {
        return this.mState.mMaxRadius;
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = RippleDrawable.obtainAttributes(r, theme, attrs, R.styleable.RippleDrawable);
        this.setPaddingMode(1);
        super.inflate(r, parser, attrs, theme);
        this.updateStateFromTypedArray(a);
        this.verifyRequiredAttributes(a);
        a.recycle();
        this.updateLocalState();
    }

    @Override
    public boolean setDrawableByLayerId(int id2, Drawable drawable2) {
        if (super.setDrawableByLayerId(id2, drawable2)) {
            if (id2 == 16908334) {
                this.mMask = drawable2;
                this.mHasValidMask = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setPaddingMode(int mode) {
        super.setPaddingMode(mode);
    }

    private void updateStateFromTypedArray(TypedArray a) throws XmlPullParserException {
        ColorStateList effectColor;
        RippleState state = this.mState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mTouchThemeAttrs = a.extractThemeAttrs();
        ColorStateList color2 = a.getColorStateList(0);
        if (color2 != null) {
            this.mState.mColor = color2;
        }
        if ((effectColor = a.getColorStateList(2)) != null) {
            this.mState.mEffectColor = effectColor;
        }
        this.mState.mMaxRadius = a.getDimensionPixelSize(1, this.mState.mMaxRadius);
    }

    private void verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.mState.mColor == null && (this.mState.mTouchThemeAttrs == null || this.mState.mTouchThemeAttrs[0] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <ripple> requires a valid color attribute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        RippleState state = this.mState;
        if (state == null) {
            return;
        }
        if (state.mTouchThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mTouchThemeAttrs, R.styleable.RippleDrawable);
            try {
                this.updateStateFromTypedArray(a);
                this.verifyRequiredAttributes(a);
            }
            catch (XmlPullParserException e) {
                RippleDrawable.rethrowAsRuntimeException((Exception)((Object)e));
            }
            finally {
                a.recycle();
            }
        }
        if (state.mColor != null && state.mColor.canApplyTheme()) {
            state.mColor = state.mColor.obtainForTheme(t);
        }
        this.updateLocalState();
    }

    @Override
    public boolean canApplyTheme() {
        return this.mState != null && this.mState.canApplyTheme() || super.canApplyTheme();
    }

    @Override
    public void setHotspot(float x, float y) {
        this.mPendingX = x;
        this.mPendingY = y;
        if (this.mRipple == null || this.mBackground == null) {
            this.mHasPending = true;
        }
        if (this.mRipple != null) {
            this.mRipple.move(x, y);
        }
    }

    private void tryRippleEnter() {
        if (this.mExitingRipplesCount >= 10) {
            return;
        }
        if (this.mRipple == null) {
            float y;
            float x;
            if (this.mHasPending) {
                this.mHasPending = false;
                x = this.mPendingX;
                y = this.mPendingY;
            } else {
                x = this.mHotspotBounds.exactCenterX();
                y = this.mHotspotBounds.exactCenterY();
            }
            this.mRipple = new RippleForeground(this, this.mHotspotBounds, x, y, this.mForceSoftware);
        }
        this.mRipple.setup(this.mState.mMaxRadius, this.mDensity);
        this.mRipple.enter();
    }

    private void tryRippleExit() {
        if (this.mRipple != null) {
            if (this.mExitingRipples == null) {
                this.mExitingRipples = new RippleForeground[10];
            }
            this.mExitingRipples[this.mExitingRipplesCount++] = this.mRipple;
            this.mRipple.exit();
            this.mRipple = null;
        }
    }

    private void clearHotspots() {
        if (this.mRipple != null) {
            this.mRipple.end();
            this.mRipple = null;
            this.mRippleActive = false;
        }
        if (this.mBackground != null) {
            this.mBackground.setState(false, false, false);
        }
        this.cancelExitingRipples();
        this.endPatternedAnimations();
    }

    @Override
    public void setHotspotBounds(int left, int top, int right2, int bottom2) {
        this.mOverrideBounds = true;
        this.mHotspotBounds.set(left, top, right2, bottom2);
        this.onHotspotBoundsChanged();
    }

    @Override
    public void getHotspotBounds(Rect outRect) {
        outRect.set(this.mHotspotBounds);
    }

    private void onHotspotBoundsChanged() {
        int count = this.mExitingRipplesCount;
        RippleForeground[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].onHotspotBoundsChanged();
        }
        if (this.mRipple != null) {
            this.mRipple.onHotspotBoundsChanged();
        }
        if (this.mBackground != null) {
            this.mBackground.onHotspotBoundsChanged();
        }
        float newRadius = Math.round(this.getComputedRadius());
        for (int i = 0; i < this.mRunningAnimations.size(); ++i) {
            RippleAnimationSession s = this.mRunningAnimations.get(i);
            s.setRadius(newRadius);
            s.getProperties().getShader().setResolution(this.mHotspotBounds.width(), this.mHotspotBounds.height());
            float cx = this.mHotspotBounds.centerX();
            float cy = this.mHotspotBounds.centerY();
            s.getProperties().getShader().setOrigin(cx, cy);
            s.getProperties().setOrigin(Float.valueOf(cx), Float.valueOf(cy));
            if (s.isForceSoftware()) continue;
            s.getCanvasProperties().setOrigin(CanvasProperty.createFloat(cx), CanvasProperty.createFloat(cy));
        }
    }

    @Override
    public void getOutline(Outline outline) {
        LayerDrawable.LayerState state = this.mLayerState;
        LayerDrawable.ChildDrawable[] children = state.mChildren;
        int N = state.mNumChildren;
        for (int i = 0; i < N; ++i) {
            if (children[i].mId == 16908334) continue;
            children[i].mDrawable.getOutline(outline);
            if (outline.isEmpty()) continue;
            return;
        }
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mState.mRippleStyle == 0) {
            this.drawSolid(canvas);
        } else {
            this.drawPatterned(canvas);
        }
    }

    private void drawSolid(Canvas canvas) {
        this.pruneRipples();
        Rect bounds2 = this.getDirtyBounds();
        int saveCount = canvas.save(2);
        if (this.isBounded()) {
            canvas.clipRect(bounds2);
        }
        this.drawContent(canvas);
        this.drawBackgroundAndRipples(canvas);
        canvas.restoreToCount(saveCount);
    }

    private void exitPatternedBackgroundAnimation() {
        this.mTargetBackgroundOpacity = 0.0f;
        if (this.mBackgroundAnimation != null) {
            this.mBackgroundAnimation.cancel();
        }
        this.mRunBackgroundAnimation = true;
        this.invalidateSelf(false);
    }

    private void startPatternedAnimation() {
        this.mAddRipple = true;
        this.invalidateSelf(false);
    }

    private void exitPatternedAnimation() {
        this.mExitingAnimation = true;
        this.invalidateSelf(false);
    }

    private void enterPatternedBackgroundAnimation(boolean focused, boolean hovered) {
        this.mBackgroundOpacity = 0.0f;
        float f = focused ? 0.6f : (this.mTargetBackgroundOpacity = hovered ? 0.2f : 0.0f);
        if (this.mBackgroundAnimation != null) {
            this.mBackgroundAnimation.cancel();
        }
        this.mRunBackgroundAnimation = true;
        this.invalidateSelf(false);
    }

    private void startBackgroundAnimation() {
        this.mRunBackgroundAnimation = false;
        if (Looper.myLooper() == null) {
            Log.w(TAG, "Thread doesn't have a looper. Skipping animation.");
            return;
        }
        this.mBackgroundAnimation = ValueAnimator.ofFloat(this.mBackgroundOpacity, this.mTargetBackgroundOpacity);
        this.mBackgroundAnimation.setInterpolator(LINEAR_INTERPOLATOR);
        this.mBackgroundAnimation.setDuration(80L);
        this.mBackgroundAnimation.addUpdateListener(update2 -> {
            this.mBackgroundOpacity = ((Float)update2.getAnimatedValue()).floatValue();
            this.invalidateSelf(false);
        });
        this.mBackgroundAnimation.start();
    }

    private void drawPatterned(Canvas canvas) {
        RippleAnimationSession s;
        Rect bounds2 = this.mHotspotBounds;
        int saveCount = canvas.save(2);
        boolean useCanvasProps = this.shouldUseCanvasProps(canvas);
        if (this.isBounded()) {
            canvas.clipRect(this.getDirtyBounds());
        }
        boolean addRipple = this.mAddRipple;
        float cx = bounds2.centerX();
        float cy = bounds2.centerY();
        boolean shouldExit = this.mExitingAnimation;
        this.mExitingAnimation = false;
        this.mAddRipple = false;
        if (this.mRunningAnimations.size() > 0 && !addRipple) {
            this.getRipplePaint();
        }
        this.drawContent(canvas);
        this.drawPatternedBackground(canvas, cx, cy);
        if (addRipple && this.mRunningAnimations.size() <= 10) {
            float y;
            float x;
            if (this.mHasPending) {
                x = this.mPendingX;
                y = this.mPendingY;
                this.mHasPending = false;
            } else {
                x = bounds2.exactCenterX();
                y = bounds2.exactCenterY();
            }
            float h = bounds2.height();
            float w = bounds2.width();
            RippleAnimationSession.AnimationProperties<Float, Paint> properties = this.createAnimationProperties(x, y, cx, cy, w, h);
            this.mRunningAnimations.add(new RippleAnimationSession(properties, !useCanvasProps).setOnAnimationUpdated(() -> this.invalidateSelf(false)).setOnSessionEnd(session -> this.mRunningAnimations.remove(session)).setForceSoftwareAnimation(!useCanvasProps).enter(canvas));
        }
        if (shouldExit) {
            for (int i = 0; i < this.mRunningAnimations.size(); ++i) {
                s = this.mRunningAnimations.get(i);
                s.exit(canvas);
            }
        }
        for (int i = 0; i < this.mRunningAnimations.size(); ++i) {
            RippleAnimationSession.AnimationProperties<Object, Object> p;
            s = this.mRunningAnimations.get(i);
            if (useCanvasProps) {
                p = s.getCanvasProperties();
                RecordingCanvas can = (RecordingCanvas)canvas;
                can.drawRipple((CanvasProperty)p.getX(), (CanvasProperty)p.getY(), (CanvasProperty)p.getMaxRadius(), (CanvasProperty)p.getPaint(), (CanvasProperty)p.getProgress(), (CanvasProperty)p.getNoisePhase(), p.getColor(), p.getShader());
                continue;
            }
            p = s.getProperties();
            float radius = ((Float)p.getMaxRadius()).floatValue();
            canvas.drawCircle(((Float)p.getX()).floatValue(), ((Float)p.getY()).floatValue(), radius, (Paint)p.getPaint());
        }
        canvas.restoreToCount(saveCount);
    }

    private void drawPatternedBackground(Canvas c, float cx, float cy) {
        if (this.mRunBackgroundAnimation) {
            this.startBackgroundAnimation();
        }
        if (this.mBackgroundOpacity == 0.0f) {
            return;
        }
        Paint p = this.getRipplePaint();
        float newOpacity = this.mBackgroundOpacity;
        int origAlpha = p.getAlpha();
        int alpha = Math.min((int)((float)origAlpha * newOpacity + 0.5f), 255);
        if (alpha > 0) {
            ColorFilter origFilter = p.getColorFilter();
            p.setColorFilter(this.mFocusColorFilter);
            p.setAlpha(alpha);
            c.drawCircle(cx, cy, this.getComputedRadius(), p);
            p.setAlpha(origAlpha);
            p.setColorFilter(origFilter);
        }
    }

    private float computeRadius() {
        float halfWidth = (float)this.mHotspotBounds.width() / 2.0f;
        float halfHeight = (float)this.mHotspotBounds.height() / 2.0f;
        return (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
    }

    private int getComputedRadius() {
        if (this.mState.mMaxRadius >= 0) {
            return this.mState.mMaxRadius;
        }
        return (int)this.computeRadius();
    }

    private RippleAnimationSession.AnimationProperties<Float, Paint> createAnimationProperties(float x, float y, float cx, float cy, float w, float h) {
        Paint p = new Paint(this.getRipplePaint());
        float radius = this.getComputedRadius();
        RippleShader shader = new RippleShader();
        int color2 = this.clampAlpha(this.mMaskColorFilter == null ? this.mState.mColor.getColorForState(this.getState(), -16777216) : this.mMaskColorFilter.getColor());
        int effectColor = this.mState.mEffectColor.getColorForState(this.getState(), -65281);
        float noisePhase = AnimationUtils.currentAnimationTimeMillis();
        shader.setColor(color2, effectColor);
        shader.setOrigin(cx, cy);
        shader.setTouch(x, y);
        shader.setResolution(w, h);
        shader.setNoisePhase(noisePhase);
        shader.setRadius(radius);
        shader.setProgress(0.0f);
        RippleAnimationSession.AnimationProperties<Float, Paint> properties = new RippleAnimationSession.AnimationProperties<Float, Paint>(Float.valueOf(cx), Float.valueOf(cy), Float.valueOf(radius), Float.valueOf(noisePhase), p, Float.valueOf(0.0f), color2, shader);
        if (this.mMaskShader == null) {
            shader.setShader(null);
        } else {
            shader.setShader(this.mMaskShader);
        }
        p.setShader(shader);
        p.setColorFilter(null);
        p.setColor(color2);
        return properties;
    }

    private int clampAlpha(int color2) {
        if (Color.alpha(color2) > 128) {
            return color2 & 0xFFFFFF | Integer.MIN_VALUE;
        }
        return color2;
    }

    private boolean shouldUseCanvasProps(Canvas c) {
        return !this.mForceSoftware && c.isHardwareAccelerated();
    }

    @Override
    public void invalidateSelf() {
        this.invalidateSelf(true);
    }

    void invalidateSelf(boolean invalidateMask) {
        super.invalidateSelf();
        if (invalidateMask) {
            this.mHasValidMask = false;
        }
    }

    private void pruneRipples() {
        int i;
        int remaining = 0;
        RippleForeground[] ripples = this.mExitingRipples;
        int count = this.mExitingRipplesCount;
        for (i = 0; i < count; ++i) {
            if (ripples[i].hasFinishedExit()) continue;
            ripples[remaining++] = ripples[i];
        }
        for (i = remaining; i < count; ++i) {
            ripples[i] = null;
        }
        this.mExitingRipplesCount = remaining;
    }

    private void updateMaskShaderIfNeeded() {
        if (this.mHasValidMask) {
            return;
        }
        int maskType = this.getMaskType();
        if (maskType == -1) {
            return;
        }
        this.mHasValidMask = true;
        Rect bounds2 = this.getBounds();
        if (maskType == 0 || bounds2.isEmpty()) {
            if (this.mMaskBuffer != null) {
                this.mMaskBuffer.recycle();
                this.mMaskBuffer = null;
                this.mMaskShader = null;
                this.mMaskCanvas = null;
            }
            this.mMaskMatrix = null;
            this.mMaskColorFilter = null;
            return;
        }
        if (this.mMaskBuffer == null || this.mMaskBuffer.getWidth() != bounds2.width() || this.mMaskBuffer.getHeight() != bounds2.height()) {
            if (this.mMaskBuffer != null) {
                this.mMaskBuffer.recycle();
            }
            this.mMaskBuffer = Bitmap.createBitmap(bounds2.width(), bounds2.height(), Bitmap.Config.ALPHA_8);
            this.mMaskShader = new BitmapShader(this.mMaskBuffer, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mMaskCanvas = new Canvas(this.mMaskBuffer);
        } else {
            this.mMaskBuffer.eraseColor(0);
        }
        if (this.mMaskMatrix == null) {
            this.mMaskMatrix = new Matrix();
        } else {
            this.mMaskMatrix.reset();
        }
        if (this.mMaskColorFilter == null) {
            this.mMaskColorFilter = new PorterDuffColorFilter(0, PorterDuff.Mode.SRC_IN);
            this.mFocusColorFilter = new PorterDuffColorFilter(0, PorterDuff.Mode.SRC_IN);
        }
        int left = bounds2.left;
        int top = bounds2.top;
        if (this.mState.mRippleStyle == 0) {
            this.mMaskCanvas.translate(-left, -top);
        }
        if (maskType == 2) {
            this.drawMask(this.mMaskCanvas);
        } else if (maskType == 1) {
            this.drawContent(this.mMaskCanvas);
        }
        if (this.mState.mRippleStyle == 0) {
            this.mMaskCanvas.translate(left, top);
        }
        if (this.mState.mRippleStyle == 1) {
            for (int i = 0; i < this.mRunningAnimations.size(); ++i) {
                this.mRunningAnimations.get(i).getProperties().getShader().setShader(this.mMaskShader);
            }
        }
    }

    private int getMaskType() {
        if (!(this.mRipple != null || this.mExitingRipplesCount > 0 || this.mBackground != null && this.mBackground.isVisible() || this.mState.mRippleStyle != 0)) {
            return -1;
        }
        if (this.mMask != null) {
            if (this.mMask.getOpacity() == -1) {
                return 0;
            }
            return 2;
        }
        LayerDrawable.ChildDrawable[] array2 = this.mLayerState.mChildren;
        int count = this.mLayerState.mNumChildren;
        for (int i = 0; i < count; ++i) {
            if (array2[i].mDrawable.getOpacity() == -1) continue;
            return 1;
        }
        return 0;
    }

    private void drawContent(Canvas canvas) {
        LayerDrawable.ChildDrawable[] array2 = this.mLayerState.mChildren;
        int count = this.mLayerState.mNumChildren;
        for (int i = 0; i < count; ++i) {
            if (array2[i].mId == 16908334) continue;
            array2[i].mDrawable.draw(canvas);
        }
    }

    private void drawBackgroundAndRipples(Canvas canvas) {
        RippleForeground active = this.mRipple;
        RippleBackground background = this.mBackground;
        int count = this.mExitingRipplesCount;
        if (!(active != null || count > 0 || background != null && background.isVisible())) {
            return;
        }
        float x = this.mHotspotBounds.exactCenterX();
        float y = this.mHotspotBounds.exactCenterY();
        canvas.translate(x, y);
        Paint p = this.getRipplePaint();
        if (background != null && background.isVisible()) {
            background.draw(canvas, p);
        }
        if (count > 0) {
            RippleForeground[] ripples = this.mExitingRipples;
            for (int i = 0; i < count; ++i) {
                ripples[i].draw(canvas, p);
            }
        }
        if (active != null) {
            active.draw(canvas, p);
        }
        canvas.translate(-x, -y);
    }

    private void drawMask(Canvas canvas) {
        this.mMask.draw(canvas);
    }

    @UnsupportedAppUsage
    Paint getRipplePaint() {
        if (this.mRipplePaint == null) {
            this.mRipplePaint = new Paint();
            this.mRipplePaint.setAntiAlias(true);
            this.mRipplePaint.setStyle(Paint.Style.FILL);
        }
        float x = this.mHotspotBounds.exactCenterX();
        float y = this.mHotspotBounds.exactCenterY();
        this.updateMaskShaderIfNeeded();
        if (this.mMaskShader != null && this.mState.mRippleStyle == 0) {
            Rect bounds2 = this.getBounds();
            this.mMaskMatrix.setTranslate((float)bounds2.left - x, (float)bounds2.top - y);
            this.mMaskShader.setLocalMatrix(this.mMaskMatrix);
        }
        int color2 = this.clampAlpha(this.mState.mColor.getColorForState(this.getState(), -16777216));
        Paint p = this.mRipplePaint;
        if (this.mMaskColorFilter != null) {
            int maskColor;
            int n = maskColor = this.mState.mRippleStyle == 1 ? color2 : color2 | 0xFF000000;
            if (this.mMaskColorFilter.getColor() != maskColor) {
                this.mMaskColorFilter = new PorterDuffColorFilter(maskColor, this.mMaskColorFilter.getMode());
                this.mFocusColorFilter = new PorterDuffColorFilter(color2 | 0xFF000000, this.mFocusColorFilter.getMode());
            }
            p.setColor(color2 & 0xFF000000);
            p.setColorFilter(this.mMaskColorFilter);
            p.setShader(this.mMaskShader);
        } else {
            p.setColor(color2);
            p.setColorFilter(null);
            p.setShader(null);
        }
        return p;
    }

    @Override
    public Rect getDirtyBounds() {
        if (!this.isBounded()) {
            Rect drawingBounds = this.mDrawingBounds;
            Rect dirtyBounds = this.mDirtyBounds;
            dirtyBounds.set(drawingBounds);
            drawingBounds.setEmpty();
            int cX = (int)this.mHotspotBounds.exactCenterX();
            int cY = (int)this.mHotspotBounds.exactCenterY();
            Rect rippleBounds = this.mTempRect;
            RippleForeground[] activeRipples = this.mExitingRipples;
            int N = this.mExitingRipplesCount;
            for (int i = 0; i < N; ++i) {
                activeRipples[i].getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            RippleBackground background = this.mBackground;
            if (background != null) {
                background.getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            dirtyBounds.union(drawingBounds);
            dirtyBounds.union(super.getDirtyBounds());
            return dirtyBounds;
        }
        return this.getBounds();
    }

    @UnsupportedAppUsage
    public void setForceSoftware(boolean forceSoftware) {
        this.mForceSoftware = forceSoftware;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return this.mState;
    }

    @Override
    public Drawable mutate() {
        super.mutate();
        this.mState = (RippleState)this.mLayerState;
        this.mMask = this.findDrawableByLayerId(16908334);
        return this;
    }

    @Override
    RippleState createConstantState(LayerDrawable.LayerState state, Resources res) {
        return new RippleState(state, this, res);
    }

    private RippleDrawable(RippleState state, Resources res) {
        this.mState = new RippleState((LayerDrawable.LayerState)state, this, res);
        this.mLayerState = this.mState;
        this.mDensity = Drawable.resolveDensity(res, this.mState.mDensity);
        if (this.mState.mNumChildren > 0) {
            this.ensurePadding();
            this.refreshPadding();
        }
        this.updateLocalState();
    }

    private void updateLocalState() {
        this.mMask = this.findDrawableByLayerId(16908334);
    }

    static class RippleState
    extends LayerDrawable.LayerState {
        int[] mTouchThemeAttrs;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        ColorStateList mColor = ColorStateList.valueOf(-65281);
        ColorStateList mEffectColor = ColorStateList.valueOf(-1912602625);
        int mMaxRadius = -1;
        int mRippleStyle = 1;

        public RippleState(LayerDrawable.LayerState orig, RippleDrawable owner, Resources res) {
            super(orig, owner, res);
            if (orig != null && orig instanceof RippleState) {
                RippleState origs = (RippleState)orig;
                this.mTouchThemeAttrs = origs.mTouchThemeAttrs;
                this.mColor = origs.mColor;
                this.mMaxRadius = origs.mMaxRadius;
                this.mRippleStyle = origs.mRippleStyle;
                this.mEffectColor = origs.mEffectColor;
                if (origs.mDensity != this.mDensity) {
                    this.applyDensityScaling(orig.mDensity, this.mDensity);
                }
            }
        }

        @Override
        protected void onDensityChanged(int sourceDensity, int targetDensity) {
            super.onDensityChanged(sourceDensity, targetDensity);
            this.applyDensityScaling(sourceDensity, targetDensity);
        }

        private void applyDensityScaling(int sourceDensity, int targetDensity) {
            if (this.mMaxRadius != -1) {
                this.mMaxRadius = Drawable.scaleFromDensity(this.mMaxRadius, sourceDensity, targetDensity, true);
            }
        }

        @Override
        public boolean canApplyTheme() {
            return this.mTouchThemeAttrs != null || this.mColor != null && this.mColor.canApplyTheme() || super.canApplyTheme();
        }

        @Override
        public Drawable newDrawable() {
            return new RippleDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new RippleDrawable(this, res);
        }

        @Override
        public int getChangingConfigurations() {
            return super.getChangingConfigurations() | (this.mColor != null ? this.mColor.getChangingConfigurations() : 0);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.LOCAL_VARIABLE, ElementType.FIELD})
    public static @interface RippleStyle {
    }
}

