/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.graphics.Rect;
import android.graphics.drawable.RippleDrawable;

abstract class RippleComponent {
    protected final RippleDrawable mOwner;
    protected final Rect mBounds;
    private boolean mHasMaxRadius;
    protected float mTargetRadius;
    protected float mDensityScale;

    public RippleComponent(RippleDrawable owner, Rect bounds2) {
        this.mOwner = owner;
        this.mBounds = bounds2;
    }

    public void onBoundsChange() {
        if (!this.mHasMaxRadius) {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
            this.onTargetRadiusChanged(this.mTargetRadius);
        }
    }

    public void setup(float maxRadius, int densityDpi) {
        if (maxRadius >= 0.0f) {
            this.mHasMaxRadius = true;
            this.mTargetRadius = maxRadius;
        } else {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
        }
        this.mDensityScale = (float)densityDpi * 0.00625f;
        this.onTargetRadiusChanged(this.mTargetRadius);
    }

    private static float getTargetRadius(Rect bounds2) {
        float halfWidth = (float)bounds2.width() / 2.0f;
        float halfHeight = (float)bounds2.height() / 2.0f;
        return (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
    }

    public void getBounds(Rect bounds2) {
        int r = (int)Math.ceil(this.mTargetRadius);
        bounds2.set(-r, -r, r, r);
    }

    protected void invalidateSelf() {
        this.mOwner.invalidateSelf(false);
    }

    protected void onHotspotBoundsChanged() {
        if (!this.mHasMaxRadius) {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
            this.onTargetRadiusChanged(this.mTargetRadius);
        }
    }

    protected void onTargetRadiusChanged(float targetRadius) {
    }
}

